/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.util.Silenced;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemUtils {
    public static final int FULL_STACK = -1;
    public static final int HALF_STACK = -2;
    public static final Pattern pattern = Pattern.compile("((?<modid>.*?):)?(?<item>[^@]*)(@(?<damage>\\d+|[*])(x(?<size>\\d+))?)?");

    public static boolean areItemStacksStackable(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77985_e() && stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77960_j() == stack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1);
    }

    public static IBlockState getStateFromItemStack(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block == null) {
            return null;
        }
        if (block instanceof MalisisBlock) {
            return ((MalisisBlock)block).getStateFromItemStack(itemStack);
        }
        if (block instanceof BlockPistonBase) {
            return block.func_176223_P();
        }
        try {
            return block.func_176203_a(itemStack.func_77973_b().func_77647_b(itemStack.func_77960_j()));
        }
        catch (Exception e) {
            return block.func_176223_P();
        }
    }

    public static ItemStack getItemStackFromState(IBlockState state) {
        if (state == null) {
            return null;
        }
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, 1, state.func_177230_c().func_180651_a(state));
    }

    public static ItemStack getItemStack(String str) {
        Item item;
        int size;
        Matcher matcher = pattern.matcher(str);
        if (!matcher.find()) {
            return ItemStack.field_190927_a;
        }
        String itemString = matcher.group("item");
        if (itemString == null) {
            return ItemStack.field_190927_a;
        }
        String modid = matcher.group("modid");
        if (modid == null) {
            modid = "minecraft";
        }
        int damage = 0;
        String strDamage = matcher.group("damage");
        if (strDamage != null) {
            damage = strDamage.equals("*") ? Short.MAX_VALUE : Silenced.get(() -> Integer.parseInt(matcher.group("damage")));
        }
        int n = size = matcher.group("size") == null ? 1 : Silenced.get(() -> Integer.parseInt(matcher.group("size")));
        if (size == 0) {
            size = 1;
        }
        if ((item = Item.func_111206_d((String)(modid + ":" + itemString))) == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, size, damage);
    }

    public static ItemStack copy(ItemStack itemStack) {
        int originalSize = itemStack.func_190916_E();
        itemStack.func_190920_e(1);
        ItemStack copy = itemStack.func_77946_l();
        copy.func_190920_e(originalSize);
        itemStack.func_190920_e(originalSize);
        return copy;
    }

    public static String toString(ItemStack itemStack) {
        if (itemStack == null) {
            return "null";
        }
        if (itemStack == ItemStack.field_190927_a) {
            return "Empty";
        }
        return itemStack.func_190916_E() + "x" + itemStack.field_151002_e.func_77658_a() + "@" + itemStack.func_77952_i();
    }

    public static class ItemStackSplitter {
        public ItemStack source;
        public ItemStack split;
        public int amount = -1;

        public ItemStackSplitter(ItemStack source) {
            this.source = (ItemStack)Preconditions.checkNotNull((Object)source);
        }

        public ItemStack split(int amount) {
            if (this.source.func_190926_b()) {
                this.split = ItemStack.field_190927_a;
                this.amount = 0;
                return this.split;
            }
            if (amount == -1) {
                amount = this.source.func_190916_E();
            } else if (amount == -2) {
                amount = (int)Math.ceil((float)this.source.func_190916_E() / 2.0f);
            }
            this.amount = Math.min(amount, this.source.func_190916_E());
            this.split = this.source.func_77979_a(this.amount);
            if (this.source.func_190926_b()) {
                this.source = ItemStack.field_190927_a;
            }
            return this.split;
        }

        public String toString() {
            return ItemUtils.toString(this.source) + " -> " + ItemUtils.toString(this.split) + " (" + this.amount + ")";
        }
    }

    public static class ItemStacksMerger {
        public ItemStack merge;
        public ItemStack into;
        public int nbMerged = -1;

        public ItemStacksMerger(ItemStack merge, ItemStack into) {
            this.merge = (ItemStack)Preconditions.checkNotNull((Object)merge);
            this.into = (ItemStack)Preconditions.checkNotNull((Object)into);
        }

        public boolean merge() {
            return this.merge(-1);
        }

        public boolean merge(int amount) {
            return this.merge(amount, this.merge.func_77976_d());
        }

        public boolean merge(int amount, int intoMaxStackSize) {
            this.nbMerged = 0;
            if (!this.canMerge()) {
                return false;
            }
            if (this.merge == ItemStack.field_190927_a) {
                return false;
            }
            if (amount == -1) {
                amount = this.merge.func_190916_E();
            }
            amount = Math.min(amount, this.merge.func_190916_E());
            if (this.into.func_190926_b()) {
                this.nbMerged = Math.min(amount, intoMaxStackSize);
                this.into = this.merge.func_77946_l();
                this.into.func_190920_e(this.nbMerged);
                this.merge.func_190918_g(this.into.func_190916_E());
                if (this.merge.func_190926_b()) {
                    this.merge = ItemStack.field_190927_a;
                }
                return true;
            }
            this.nbMerged = Math.min(intoMaxStackSize, this.into.func_77976_d()) - this.into.func_190916_E();
            if (this.nbMerged == 0) {
                return false;
            }
            this.nbMerged = Math.min(this.nbMerged, amount);
            this.merge.func_190918_g(this.nbMerged);
            if (this.merge.func_190926_b()) {
                this.merge = ItemStack.field_190927_a;
            }
            this.into.func_190917_f(this.nbMerged);
            return true;
        }

        public boolean canMerge() {
            return this.merge.func_190926_b() || this.into.func_190926_b() || ItemUtils.areItemStacksStackable(this.merge, this.into);
        }

        public String toString() {
            return ItemUtils.toString(this.merge) + " -> " + ItemUtils.toString(this.into) + " (" + this.nbMerged + ")";
        }
    }
}

