/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import com.google.common.collect.Maps;
import java.awt.Font;
import java.lang.reflect.Field;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.font.CharData;
import net.malisis.core.renderer.font.FontGeneratorOptions;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.font.StringWalker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.StringUtils;

public class MinecraftFont
extends MalisisFont {
    private int[] mcCharWidth;
    private byte[] glyphWidth;
    private ResourceLocation[] unicodePages;
    private ResourceLocation lastFontTexture;
    private FontRenderer fontRenderer;
    protected Map<Character, CharData> unicodeCharData = Maps.newHashMap();
    protected boolean forceUnicode = false;
    private MalisisRenderer<?> renderer;

    public MinecraftFont() {
        super((Font)null);
        this.fontGeneratorOptions = new FontGeneratorOptions();
        this.fontGeneratorOptions.fontSize = 9.0f;
        this.textureRl = new ResourceLocation("textures/font/ascii.png");
        this.size = 256;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.setFields();
        this.fillCharData();
    }

    private void setFields() {
        String srg = "field_78286_d";
        Field charWidthField = AsmUtils.changeFieldAccess(FontRenderer.class, "charWidth", srg, true);
        if (charWidthField == null && FMLClientHandler.instance().hasOptifine()) {
            srg = "d";
            charWidthField = AsmUtils.changeFieldAccess(FontRenderer.class, "charWidth", srg, true);
        }
        Field glyphWidthField = AsmUtils.changeFieldAccess(FontRenderer.class, "glyphWidth", "field_78287_e");
        Field unicodePagesField = AsmUtils.changeFieldAccess(FontRenderer.class, "UNICODE_PAGE_LOCATIONS", "field_111274_c");
        try {
            if (charWidthField == null) {
                throw new IllegalStateException("charWidthField (" + srg + ") is null");
            }
            if (this.fontRenderer == null) {
                throw new IllegalStateException("fontRenderer not initialized");
            }
            this.mcCharWidth = (int[])charWidthField.get(this.fontRenderer);
            this.glyphWidth = (byte[])glyphWidthField.get(this.fontRenderer);
            this.unicodePages = (ResourceLocation[])unicodePagesField.get(this.fontRenderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | IllegalStateException e) {
            MalisisCore.log.error("[MinecraftFont] Failed to gets the FontRenderer fields :", (Throwable)e);
        }
    }

    private void fillCharData() {
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            this.charData[c] = new MCCharData(c);
            this.unicodeCharData.put(Character.valueOf(c), new UnicodeCharData(c));
        }
    }

    private void bindFontTexture(CharData data) {
        ResourceLocation rl = this.textureRl;
        if (data instanceof UnicodeCharData) {
            int i = data.c / 256;
            if (this.unicodePages[i] == null) {
                this.unicodePages[i] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", i));
            }
            rl = this.unicodePages[i];
        }
        if (rl != this.lastFontTexture) {
            this.renderer.next();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
            this.lastFontTexture = rl;
        }
    }

    @Override
    protected void prepare(MalisisRenderer<?> renderer, float x, float y, float z, FontOptions options) {
        super.prepare(renderer, x, y, z, options);
        this.renderer = renderer;
    }

    @Override
    protected void clean(MalisisRenderer<?> renderer, boolean isDrawing) {
        super.clean(renderer, isDrawing);
        this.lastFontTexture = null;
    }

    @Override
    public CharData getCharData(char c) {
        if (c < '\u0000' || c >= '\u0100' || this.fontRenderer.func_82883_a() || this.forceUnicode) {
            if (!this.unicodeCharData.containsKey(Character.valueOf(c))) {
                this.unicodeCharData.put(Character.valueOf(c), new UnicodeCharData(c));
            }
            return this.unicodeCharData.get(Character.valueOf(c));
        }
        return super.getCharData(c);
    }

    @Override
    protected void drawChar(CharData cd, float offsetX, float offsetY, FontOptions options, int color) {
        this.bindFontTexture(cd);
        if (this.drawingShadow && cd instanceof UnicodeCharData) {
            offsetX -= options.getFontScale() / 2.0f;
            offsetY -= options.getFontScale() / 2.0f;
        }
        super.drawChar(cd, offsetX, offsetY, options, color);
    }

    @Override
    public float getStringWidth(String str, FontOptions options, int start, int end) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        str = this.processString(str, options);
        StringWalker walker = new StringWalker(str, (MalisisFont)this, options);
        walker.startIndex(start);
        return walker.walkToCharacter(end);
    }

    @Override
    public float getStringHeight(FontOptions options) {
        return (float)this.fontRenderer.field_78288_b * (options != null ? options.getFontScale() : 1.0f);
    }

    public class UnicodeCharData
    extends CharData {
        float pad;

        public UnicodeCharData(char c) {
            super(c, 0.0f, MinecraftFont.this.glyphWidth[c] & 0xF, ((MinecraftFont)MinecraftFont.this).fontRenderer.field_78288_b);
            this.pad = MinecraftFont.this.glyphWidth[c] >>> 4;
        }

        @Override
        public float u() {
            float col = (float)(this.c % 16 * 16) + this.pad;
            return col / 256.0f;
        }

        @Override
        public float v() {
            float row = (this.c & 0xFF) / 16 * 16;
            return row / 256.0f;
        }

        @Override
        public float U() {
            float col = (float)(this.c % 16 * 16) + this.pad + (this.width + 1.0f - this.pad - 0.02f);
            return col / 256.0f;
        }

        @Override
        public float V() {
            float row = (this.c & 0xFF) / 16 * 16;
            return (row + 15.98f) / 256.0f;
        }

        @Override
        public float getCharWidth() {
            if (this.width == 0.0f && this.pad == 0.0f) {
                return 0.0f;
            }
            if (this.c == ' ') {
                return 4.0f;
            }
            if (this.width > 7.0f) {
                this.width = 15.0f;
                this.pad = 0.0f;
            }
            return (int)(this.width + 1.0f - this.pad) / 2 + 1;
        }

        @Override
        public float getFullWidth(FontGeneratorOptions options) {
            return (this.width + 1.0f - this.pad - 0.02f) / 2.0f;
        }

        @Override
        public float getFullHeight(FontGeneratorOptions options) {
            return this.getCharHeight() - 1.01f;
        }
    }

    public class MCCharData
    extends CharData {
        int pos;

        public MCCharData(char c) {
            super(c == '\u00a7' ? (char)'&' : (char)c, 0.0f, 0.0f, 0.0f);
            this.pos = MalisisFont.CHARLIST.indexOf(c);
        }

        @Override
        public float u() {
            float col = this.pos % 16 * 8;
            return col / 128.0f;
        }

        @Override
        public float v() {
            float row = this.pos / 16 * 8;
            return row / 128.0f;
        }

        @Override
        public float U() {
            float col = this.pos % 16 * 8;
            return (col + this.getCharWidth() - 1.01f) / 128.0f;
        }

        @Override
        public float V() {
            float row = this.pos / 16 * 8;
            return (row + this.getCharHeight() - 1.01f) / 128.0f;
        }

        @Override
        public float getCharWidth() {
            if (this.c == ' ' || this.c < '\u0000' || this.c >= '\u0100' || this.pos == -1) {
                return 4.0f;
            }
            return MinecraftFont.this.mcCharWidth[this.pos];
        }

        @Override
        public float getCharHeight() {
            return ((MinecraftFont)MinecraftFont.this).fontRenderer.field_78288_b;
        }

        @Override
        public float getFullWidth(FontGeneratorOptions options) {
            return this.getCharWidth() - 1.01f;
        }

        @Override
        public float getFullHeight(FontGeneratorOptions options) {
            return this.getCharHeight() - 1.01f;
        }
    }
}

