/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.network;

import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.EntityUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class MalisisNetwork
extends SimpleNetworkWrapper {
    private int discriminator = 0;
    protected String name;

    public MalisisNetwork(String channelName) {
        super(channelName);
        this.name = channelName;
    }

    public MalisisNetwork(IMalisisMod mod) {
        this(mod.getModId());
    }

    public void sendToPlayersWatchingChunk(IMessage message, Chunk chunk) {
        EntityUtils.getPlayersWatchingChunk(chunk).forEach(p -> this.sendTo(message, (EntityPlayerMP)p));
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, Side side) {
        super.registerMessage(messageHandler, requestMessageType, this.discriminator++, side);
        MalisisCore.log.info("Registering " + messageHandler.getSimpleName() + " for " + requestMessageType.getSimpleName() + " with discriminator " + this.discriminator + " in channel " + this.name);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestMessageType, Side side) {
        super.registerMessage(messageHandler, requestMessageType, this.discriminator++, side);
        MalisisCore.log.info("Registering " + messageHandler.getClass().getSimpleName() + " for " + requestMessageType.getSimpleName() + " with discriminator " + this.discriminator + " in channel " + this.name);
    }

    public int getNextDiscriminator() {
        return this.discriminator++;
    }
}

