/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory.cache;

import java.util.List;
import java.util.stream.Collectors;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.cache.CachedSlot;
import net.malisis.core.inventory.message.UpdateInventorySlotsMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class InventoryCache {
    private EntityPlayerMP player;
    private int inventoryId;
    private int windowId;
    private List<CachedSlot> slotCache;

    public InventoryCache(EntityPlayer player, MalisisInventory inventory, int windowId) {
        this.player = (EntityPlayerMP)player;
        this.inventoryId = inventory.getInventoryId();
        this.windowId = windowId;
        this.slotCache = inventory.getSlots().stream().map(CachedSlot::new).collect(Collectors.toList());
    }

    public void update() {
        this.slotCache.forEach(CachedSlot::update);
    }

    public List<MalisisSlot> getSlots(boolean sendAll) {
        return this.slotCache.stream().peek(CachedSlot::update).filter(cs -> sendAll || cs.hasChanged()).map(CachedSlot::getSlot).collect(Collectors.toList());
    }

    private void sendSlots(boolean sendAll) {
        List<MalisisSlot> changedSlots = this.getSlots(sendAll);
        if (changedSlots.size() > 0) {
            UpdateInventorySlotsMessage.updateSlots(this.inventoryId, changedSlots, this.player, this.windowId);
        }
    }

    public void sendAll() {
        this.sendSlots(true);
    }

    public void sendChanges() {
        this.sendSlots(false);
    }
}

