/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.component.SlopedCornerShapeComponent;
import net.malisis.core.util.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SlopedCornerComponent
implements IBlockComponent {
    private static final float[][] FY = new float[][]{{0.0f, 1.0f}, {0.0f, 1.0f}};
    private static final AxisAlignedBB[] BOUNDING_BOXES = AABBUtils.slice(8, new float[][]{{0.0f, 0.5f}, {0.0f, 0.0f}}, FY, new float[][]{{0.0f, 0.5f}, {0.0f, 0.0f}}, true);
    private static final AxisAlignedBB[] BOUNDING_BOXES_DOWN = AABBUtils.slice(8, new float[][]{{0.0f, 0.125f}, {0.0f, 1.125f}}, FY, new float[][]{{0.0f, 0.125f}, {0.0f, 1.125f}}, true);
    private static final AxisAlignedBB[] BOUNDING_BOXES_INVERTED = AABBUtils.slice(8, new float[][]{{0.0f, 1.0f}, {0.0f, 0.25f}}, FY, new float[][]{{0.0f, 1.0f}, {0.0f, 0.25f}}, true);
    private static final AxisAlignedBB[] BOUNDING_BOXES_INVERTED_DOWN = AABBUtils.slice(8, new float[][]{{0.0f, 0.25f}, {0.0f, 1.0f}}, FY, new float[][]{{0.0f, 0.25f}, {0.0f, 1.0f}}, true);
    public static PropertyBool INVERTED = PropertyBool.func_177716_a((String)"inverted");
    public static PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    public PropertyBool getProperty() {
        return null;
    }

    @Override
    public IProperty<?>[] getProperties() {
        return new IProperty[]{INVERTED, DOWN};
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public List<IComponent> getDependencies() {
        ArrayList deps = Lists.newArrayList((Object[])new IComponent[]{new DirectionalComponent()});
        if (MalisisCore.isClient()) {
            deps.add(new SlopedCornerShapeComponent());
        }
        return deps;
    }

    @Override
    public IBlockState getStateForPlacement(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        boolean down = facing == EnumFacing.DOWN || facing != EnumFacing.UP && hitY > 0.5f;
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(down));
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(Block block, IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (type == BoundingBoxType.RAYTRACE || type == BoundingBoxType.SELECTION) {
            return AABBUtils.identities();
        }
        boolean inverted = SlopedCornerComponent.isInverted(state);
        boolean down = SlopedCornerComponent.isDown(state);
        if (inverted) {
            return down ? BOUNDING_BOXES_INVERTED_DOWN : BOUNDING_BOXES_INVERTED;
        }
        return down ? BOUNDING_BOXES_DOWN : BOUNDING_BOXES;
    }

    @Override
    public void getSubBlocks(Block block, CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack(block, 1, 0));
        list.add((Object)new ItemStack(block, 1, 4));
    }

    @Override
    public int damageDropped(Block block, IBlockState state) {
        return SlopedCornerComponent.isInverted(state) ? 1 : 0;
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return (SlopedCornerComponent.isInverted(state) ? 4 : 0) + (SlopedCornerComponent.isDown(state) ? 8 : 0);
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf((meta & 8) != 0)).func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    @Override
    public Boolean isOpaqueCube(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isFullBlock(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isFullCube(Block block, IBlockState state) {
        return false;
    }

    public static boolean isDown(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? SlopedCornerComponent.isInverted(world.func_180495_p(pos)) : false;
    }

    public static boolean isDown(IBlockState state) {
        SlopedCornerComponent sc = IComponent.getComponent(SlopedCornerComponent.class, state.func_177230_c());
        if (sc == null) {
            return false;
        }
        if (!state.func_177228_b().containsKey((Object)DOWN)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)DOWN);
    }

    public static boolean isInverted(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? SlopedCornerComponent.isInverted(world.func_180495_p(pos)) : false;
    }

    public static boolean isInverted(IBlockState state) {
        SlopedCornerComponent sc = IComponent.getComponent(SlopedCornerComponent.class, state.func_177230_c());
        if (sc == null) {
            return false;
        }
        if (!state.func_177228_b().containsKey((Object)INVERTED)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)INVERTED);
    }
}

