/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.crafting.FluidExtract;
import com.mrcrayfish.vehicle.crafting.FluidMixerRecipe;
import com.mrcrayfish.vehicle.crafting.FluidMixerRecipes;
import com.mrcrayfish.vehicle.fluid.FluidTankMixerInput;
import com.mrcrayfish.vehicle.tileentity.TileEntitySynced;
import com.mrcrayfish.vehicle.util.FluidUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityFluidMixer
extends TileEntitySynced
implements IInventory,
ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
    private FluidTank tankBlaze = new FluidTankMixerInput(5000);
    private FluidTank tankEnderSap = new FluidTankMixerInput(5000);
    private FluidTank tankFuelium = new FluidTank(10000);
    public static final int FLUID_MAX_PROGRESS = 100;
    private static final int SLOT_FUEL = 0;
    private static final int SLOT_INGREDIENT = 1;
    private int remainingFuel;
    private int fuelMaxProgress;
    private int extractionProgress;
    private String customName;

    public TileEntityFluidMixer() {
        this.tankFuelium.setCanFill(false);
    }

    public int func_70302_i_() {
        return 7;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
        }
        if (index == 1) {
            Fluid fluidTwo;
            Fluid fluidOne = this.tankBlaze.getFluid() != null ? this.tankBlaze.getFluid().getFluid() : null;
            Fluid fluid = fluidTwo = this.tankEnderSap.getFluid() != null ? this.tankEnderSap.getFluid().getFluid() : null;
            if (fluidOne != null && fluidTwo != null && FluidMixerRecipes.getInstance().getRecipe(fluidOne, fluidTwo, stack) != null) {
                return true;
            }
            return FluidMixerRecipes.getInstance().isIngredient(stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.extractionProgress;
            }
            case 1: {
                return this.remainingFuel;
            }
            case 2: {
                return this.fuelMaxProgress;
            }
            case 3: {
                return this.tankBlaze.getFluidAmount();
            }
            case 4: {
                return this.tankEnderSap.getFluidAmount();
            }
            case 5: {
                return this.tankFuelium.getFluidAmount();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.extractionProgress = value;
                break;
            }
            case 1: {
                this.remainingFuel = value;
                break;
            }
            case 2: {
                this.fuelMaxProgress = value;
                break;
            }
            case 3: {
                if (this.tankBlaze.getFluid() == null) break;
                this.tankBlaze.getFluid().amount = value;
                break;
            }
            case 4: {
                if (this.tankEnderSap.getFluid() == null) break;
                this.tankEnderSap.getFluid().amount = value;
                break;
            }
            case 5: {
                if (this.tankFuelium.getFluid() == null) break;
                this.tankFuelium.getFluid().amount = value;
            }
        }
    }

    public int func_174890_g() {
        return 6;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack ingredient = this.func_70301_a(1);
            if (this.tankBlaze.getFluid() != null && this.tankEnderSap.getFluid() != null && !ingredient.func_190926_b()) {
                FluidMixerRecipe recipe = FluidMixerRecipes.getInstance().getRecipe(this.tankBlaze.getFluid().getFluid(), this.tankEnderSap.getFluid().getFluid(), ingredient);
                if (recipe != null && this.canMix(recipe)) {
                    ItemStack fuel = this.func_70301_a(0);
                    if (!fuel.func_190926_b() && TileEntityFurnace.func_145952_a((ItemStack)fuel) > 0 && this.remainingFuel == 0) {
                        this.remainingFuel = this.fuelMaxProgress = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                        this.shrinkItem(0);
                    }
                    if (this.remainingFuel > 0 && this.canMix(recipe)) {
                        if (this.extractionProgress++ == 100) {
                            FluidExtract extract = FluidMixerRecipes.getInstance().getRecipeResult(recipe);
                            if (extract != null) {
                                this.tankFuelium.fillInternal(extract.createStack(), true);
                                this.tankBlaze.drain(recipe.getFluidAmount(this.tankBlaze.getFluid().getFluid()), true);
                                this.tankEnderSap.drain(recipe.getFluidAmount(this.tankEnderSap.getFluid().getFluid()), true);
                                this.shrinkItem(1);
                            }
                            this.extractionProgress = 0;
                        }
                    } else {
                        this.extractionProgress = 0;
                    }
                } else {
                    this.extractionProgress = 0;
                }
            } else {
                this.extractionProgress = 0;
            }
            if (this.remainingFuel > 0) {
                --this.remainingFuel;
            }
        }
    }

    private void shrinkItem(int index) {
        ItemStack stack = this.func_70301_a(index);
        stack.func_190918_g(1);
        if (stack.func_190926_b()) {
            this.func_70299_a(index, ItemStack.field_190927_a);
        }
    }

    public boolean canMix(FluidMixerRecipe recipe) {
        if (this.tankBlaze.getFluid() == null || this.tankEnderSap.getFluid() == null) {
            return false;
        }
        if (this.tankBlaze.getFluidAmount() < recipe.getFluidAmount(this.tankBlaze.getFluid().getFluid())) {
            return false;
        }
        if (this.tankEnderSap.getFluidAmount() < recipe.getFluidAmount(this.tankEnderSap.getFluid().getFluid())) {
            return false;
        }
        return this.tankFuelium.getFluidAmount() < this.tankFuelium.getCapacity();
    }

    public void func_145839_a(NBTTagCompound tag) {
        NBTTagCompound tagCompound;
        super.func_145839_a(tag);
        if (tag.func_150297_b("Items", 9)) {
            this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.inventory);
        }
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = tag.func_74779_i("CustomName");
        }
        if (tag.func_150297_b("TankBlaze", 10)) {
            tagCompound = tag.func_74775_l("TankBlaze");
            FluidUtils.fixEmptyTag(tagCompound);
            this.tankBlaze.readFromNBT(tagCompound);
        }
        if (tag.func_150297_b("TankEnderSap", 10)) {
            tagCompound = tag.func_74775_l("TankEnderSap");
            FluidUtils.fixEmptyTag(tagCompound);
            this.tankEnderSap.readFromNBT(tagCompound);
        }
        if (tag.func_150297_b("TankFuelium", 10)) {
            tagCompound = tag.func_74775_l("TankFuelium");
            FluidUtils.fixEmptyTag(tagCompound);
            this.tankFuelium.readFromNBT(tagCompound);
        }
        if (tag.func_150297_b("RemainingFuel", 3)) {
            this.remainingFuel = tag.func_74762_e("RemainingFuel");
        }
        if (tag.func_150297_b("FuelMaxProgress", 3)) {
            this.fuelMaxProgress = tag.func_74762_e("FuelMaxProgress");
        }
        if (tag.func_150297_b("ExtractionProgress", 3)) {
            this.extractionProgress = tag.func_74762_e("ExtractionProgress");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.inventory);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
        NBTTagCompound tagTankBlaze = new NBTTagCompound();
        this.tankBlaze.writeToNBT(tagTankBlaze);
        tag.func_74782_a("TankBlaze", (NBTBase)tagTankBlaze);
        NBTTagCompound tagTankEnderSap = new NBTTagCompound();
        this.tankEnderSap.writeToNBT(tagTankEnderSap);
        tag.func_74782_a("TankEnderSap", (NBTBase)tagTankEnderSap);
        NBTTagCompound tagTankFuelium = new NBTTagCompound();
        this.tankFuelium.writeToNBT(tagTankFuelium);
        tag.func_74782_a("TankFuelium", (NBTBase)tagTankFuelium);
        if (tag.func_150297_b("RemainingFuel", 3)) {
            this.remainingFuel = tag.func_74762_e("RemainingFuel");
        }
        if (tag.func_150297_b("FuelMaxProgress", 3)) {
            this.fuelMaxProgress = tag.func_74762_e("FuelMaxProgress");
        }
        if (tag.func_150297_b("ExtractionProgress", 3)) {
            this.extractionProgress = tag.func_74762_e("ExtractionProgress");
        }
        tag.func_74768_a("RemainingFuel", this.remainingFuel);
        tag.func_74768_a("FuelMaxProgress", this.fuelMaxProgress);
        tag.func_74768_a("ExtractionProgress", this.extractionProgress);
        return tag;
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189515_b(new NBTTagCompound());
        NBTTagCompound tagTankBlaze = new NBTTagCompound();
        this.tankBlaze.writeToNBT(tagTankBlaze);
        tag.func_74782_a("TankBlaze", (NBTBase)tagTankBlaze);
        NBTTagCompound tagTankEnderSap = new NBTTagCompound();
        this.tankEnderSap.writeToNBT(tagTankEnderSap);
        tag.func_74782_a("TankEnderSap", (NBTBase)tagTankEnderSap);
        NBTTagCompound tagTankFuelium = new NBTTagCompound();
        this.tankFuelium.writeToNBT(tagTankFuelium);
        tag.func_74782_a("TankFuelium", (NBTBase)tagTankFuelium);
        return tag;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.fluid_mixer";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177227_a().contains(BlockRotatedObject.FACING)) {
                EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)BlockRotatedObject.FACING);
                if (facing == blockFacing.func_176735_f()) {
                    return true;
                }
                if (facing == blockFacing) {
                    return true;
                }
                return facing == blockFacing.func_176746_e();
            }
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177227_a().contains(BlockRotatedObject.FACING)) {
                EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)BlockRotatedObject.FACING);
                if (facing == blockFacing.func_176735_f()) {
                    return (T)this.tankBlaze;
                }
                if (facing == blockFacing) {
                    return (T)this.tankEnderSap;
                }
                if (facing == blockFacing.func_176746_e()) {
                    return (T)this.tankFuelium;
                }
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public FluidStack getBlazeFluidStack() {
        return this.tankBlaze.getFluid();
    }

    @Nullable
    public FluidStack getEnderSapFluidStack() {
        return this.tankEnderSap.getFluid();
    }

    @Nullable
    public FluidStack getFueliumFluidStack() {
        return this.tankFuelium.getFluid();
    }

    public int getExtractionProgress() {
        return this.func_174887_a_(0);
    }

    public int getRemainingFuel() {
        return this.func_174887_a_(1);
    }

    public int getFuelMaxProgress() {
        return this.func_174887_a_(2);
    }

    public int getBlazeLevel() {
        return this.func_174887_a_(3);
    }

    public int getEnderSapLevel() {
        return this.func_174887_a_(4);
    }

    public int getFueliumLevel() {
        return this.func_174887_a_(5);
    }
}

