/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.entity.EntityLandVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityTrailer
extends EntityVehicle {
    public static final DataParameter<Integer> PULLING_ENTITY = EntityDataManager.func_187226_a(EntityTrailer.class, (DataSerializer)DataSerializers.field_187192_b);
    private Entity pullingEntity;
    public float wheelRotation;
    public float prevWheelRotation;

    public EntityTrailer(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 1.5f);
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PULLING_ENTITY, (Object)-1);
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public void onUpdateVehicle() {
        this.prevWheelRotation = this.wheelRotation;
        this.field_70181_x -= 0.08;
        if (this.field_70170_p.field_72995_K) {
            int entityId = (Integer)this.field_70180_af.func_187225_a(PULLING_ENTITY);
            if (entityId != -1) {
                Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(PULLING_ENTITY)).intValue());
                if (entity instanceof EntityPlayer || entity instanceof EntityVehicle && ((EntityVehicle)entity).canTowTrailer()) {
                    this.pullingEntity = entity;
                } else if (this.pullingEntity != null) {
                    this.pullingEntity = null;
                }
            } else if (this.pullingEntity != null) {
                this.pullingEntity = null;
            }
        }
        if (this.pullingEntity != null && !this.field_70170_p.field_72995_K && (double)this.pullingEntity.func_70032_d((Entity)this) > VehicleConfig.SERVER.trailerDetachThreshold) {
            this.field_70170_p.func_184133_a(null, this.pullingEntity.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.pullingEntity = null;
            return;
        }
        if (this.pullingEntity != null) {
            if (this.pullingEntity.field_70128_L || this.pullingEntity instanceof EntityVehicle && ((EntityVehicle)this.pullingEntity).getTrailer() != this) {
                this.pullingEntity = null;
                return;
            }
            this.updatePullingMotion();
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70122_E) {
                this.field_70159_w *= 0.65;
                this.field_70179_y *= 0.65;
            } else {
                this.field_70159_w *= 0.98;
                this.field_70179_y *= 0.98;
            }
        }
        this.func_145775_I();
        float speed = (float)(Math.sqrt(Math.pow(this.field_70165_t - this.field_70169_q, 2.0) + Math.pow(this.field_70163_u - this.field_70167_r, 2.0) + Math.pow(this.field_70161_v - this.field_70166_s, 2.0)) * 20.0);
        this.wheelRotation -= 90.0f * (speed / 10.0f);
    }

    private void updatePullingMotion() {
        Vec3d towBar = this.pullingEntity.func_174791_d();
        if (this.pullingEntity instanceof EntityVehicle) {
            EntityVehicle vehicle = (EntityVehicle)this.pullingEntity;
            Vec3d towBarVec = vehicle.getProperties().getTowBarPosition();
            towBarVec = new Vec3d(towBarVec.field_72450_a * 0.0625, towBarVec.field_72448_b * 0.0625, towBarVec.field_72449_c * 0.0625 + vehicle.getProperties().getBodyPosition().getZ());
            if (vehicle instanceof EntityLandVehicle) {
                EntityLandVehicle landVehicle = (EntityLandVehicle)vehicle;
                towBar = towBar.func_178787_e(towBarVec.func_178785_b((float)Math.toRadians(-vehicle.field_70177_z + landVehicle.additionalYaw)));
            } else {
                towBar = towBar.func_178787_e(towBarVec.func_178785_b((float)Math.toRadians(-vehicle.field_70177_z)));
            }
        }
        this.field_70177_z = (float)Math.toDegrees(Math.atan2(towBar.field_72449_c - this.field_70161_v, towBar.field_72450_a - this.field_70165_t) - Math.toRadians(90.0));
        double deltaRot = this.field_70126_B - this.field_70177_z;
        if (deltaRot < -180.0) {
            this.field_70126_B += 360.0f;
        } else if (deltaRot >= 180.0) {
            this.field_70126_B -= 360.0f;
        }
        Vec3d vec = new Vec3d(0.0, 0.0, this.getHitchOffset() * 0.0625).func_178785_b((float)Math.toRadians(-this.field_70177_z)).func_178787_e(towBar);
        this.field_70159_w = vec.field_72450_a - this.field_70165_t;
        this.field_70179_y = vec.field_72449_c - this.field_70161_v;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean setPullingEntity(Entity pullingEntity) {
        if (pullingEntity instanceof EntityPlayer || pullingEntity instanceof EntityVehicle && pullingEntity.func_184187_bx() == null && ((EntityVehicle)pullingEntity).canTowTrailer()) {
            this.pullingEntity = pullingEntity;
            this.field_70180_af.func_187227_b(PULLING_ENTITY, (Object)pullingEntity.func_145782_y());
            return true;
        }
        this.pullingEntity = null;
        this.field_70180_af.func_187227_b(PULLING_ENTITY, (Object)-1);
        return false;
    }

    @Nullable
    public Entity getPullingEntity() {
        return this.pullingEntity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 1;
    }

    @Override
    public boolean canMountTrailer() {
        return false;
    }

    public abstract double getHitchOffset();
}

