/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.crafting;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class FluidMixerRecipe {
    private Fluid[] fluids;
    private int[] amounts;
    private ItemStack ingredient;

    public FluidMixerRecipe(Fluid fluidOne, int fluidOneAmount, Fluid fluidTwo, int fluidTwoAmount, ItemStack ingredient) {
        this.fluids = new Fluid[]{fluidOne, fluidTwo};
        this.amounts = new int[]{fluidOneAmount, fluidTwoAmount};
        this.ingredient = ingredient;
    }

    public Fluid[] getFluids() {
        return this.fluids;
    }

    public int[] getAmounts() {
        return this.amounts;
    }

    public ItemStack getIngredient() {
        return this.ingredient;
    }

    public int getFluidAmount(Fluid fluid) {
        for (int i = 0; i < 2; ++i) {
            if (!this.fluids[i].equals(fluid)) continue;
            return this.amounts[i];
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FluidMixerRecipe)) {
            return false;
        }
        FluidMixerRecipe other = (FluidMixerRecipe)obj;
        int matchCount = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (!other.fluids[i].equals(this.fluids[j])) continue;
                ++matchCount;
            }
        }
        return matchCount == 2 && FluidMixerRecipe.areItemStacksEqual(other.ingredient, this.ingredient);
    }

    public int hashCode() {
        return this.fluids[0].hashCode() + this.fluids[1].hashCode() + this.ingredient.func_77973_b().hashCode() + this.ingredient.func_77952_i();
    }

    public static boolean areItemStacksEqual(ItemStack stack, ItemStack other) {
        if (stack.func_77973_b() != other.func_77973_b()) {
            return false;
        }
        if (stack.func_77952_i() != other.func_77952_i()) {
            return false;
        }
        if (stack.func_77978_p() == null && other.func_77978_p() != null) {
            return false;
        }
        return stack.func_77978_p() == null || stack.func_77978_p().equals((Object)other.func_77978_p());
    }

    public boolean requiresFluid(Fluid fluid) {
        for (Fluid f : this.fluids) {
            if (!f.equals(fluid)) continue;
            return true;
        }
        return false;
    }
}

