/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMiniBike;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;

public class RenderMiniBike
extends AbstractRenderVehicle<EntityMiniBike> {
    @Override
    public void render(EntityMiniBike entity, float partialTicks) {
        this.renderDamagedPart(entity, SpecialModels.MINI_BIKE_BODY.getModel());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.65625);
        GlStateManager.func_179114_b((float)-22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        float wheelScale = 1.65f;
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 25.0f;
        GlStateManager.func_179114_b((float)turnRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.65625);
        this.renderDamagedPart(entity, SpecialModels.MINI_BIKE_HANDLE_BAR.getModel());
        if (entity.hasWheels()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)-0.39375, (double)0.8125);
            float frontWheelSpin = entity.prevFrontWheelRotation + (entity.frontWheelRotation - entity.prevFrontWheelRotation) * partialTicks;
            if (entity.isMoving()) {
                GlStateManager.func_179114_b((float)(-frontWheelSpin), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)wheelScale, (float)wheelScale, (float)wheelScale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            IBakedModel model = RenderUtil.getWheelModel(entity);
            if (model != null) {
                RenderUtil.renderColoredModel(model, ItemCameraTransforms.TransformType.NONE, entity.getWheelColor());
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void applyPlayerModel(EntityMiniBike entity, EntityPlayer player, ModelPlayer model, float partialTicks) {
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 8.0f;
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-55.0f - turnRotation);
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-55.0f + turnRotation);
        model.field_178723_h.field_82907_q = -0.1f * wheelAngleNormal;
        model.field_178724_i.field_82907_q = 0.1f * wheelAngleNormal;
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-65.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(30.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-65.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-30.0);
    }

    @Override
    public void applyPlayerRender(EntityMiniBike entity, EntityPlayer player, float partialTicks) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale());
            seatVec = new Vec3d(-seatVec.field_72450_a, seatVec.field_72448_b, seatVec.field_72449_c);
            seatVec = seatVec.func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W()) * scale + 1.5;
            double offsetZ = -seatVec.field_72449_c * scale;
            GlStateManager.func_179137_b((double)offsetX, (double)offsetY, (double)offsetZ);
            float currentSpeedNormal = (entity.prevCurrentSpeed + (entity.currentSpeed - entity.prevCurrentSpeed) * partialTicks) / entity.getMaxSpeed();
            float turnAngleNormal = (entity.prevTurnAngle + (entity.turnAngle - entity.prevTurnAngle) * partialTicks) / 45.0f;
            GlStateManager.func_179114_b((float)(turnAngleNormal * currentSpeedNormal * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
        }
    }
}

