/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.EntityDirtBike;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;

public class RenderDirtBike
extends AbstractRenderVehicle<EntityDirtBike> {
    @Override
    public void render(EntityDirtBike entity, float partialTicks) {
        Wheel wheel;
        this.renderDamagedPart(entity, SpecialModels.DIRT_BIKE_BODY.getModel());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.65625);
        GlStateManager.func_179114_b((float)-22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 25.0f;
        GlStateManager.func_179114_b((float)turnRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.65625);
        this.renderDamagedPart(entity, SpecialModels.DIRT_BIKE_HANDLES.getModel());
        if (entity.hasWheels() && (wheel = (Wheel)entity.getProperties().getWheels().stream().filter(wheel1 -> wheel1.getPosition() == Wheel.Position.FRONT).findFirst().orElse(null)) != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
            GlStateManager.func_179137_b((double)((double)wheel.getOffsetX() * 0.0625), (double)((double)wheel.getOffsetY() * 0.0625), (double)((double)wheel.getOffsetZ() * 0.0625));
            float frontWheelSpin = entity.prevFrontWheelRotation + (entity.frontWheelRotation - entity.prevFrontWheelRotation) * partialTicks;
            if (entity.isMoving()) {
                GlStateManager.func_179114_b((float)(-frontWheelSpin), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)wheel.getScaleX(), (float)wheel.getScaleY(), (float)wheel.getScaleZ());
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderDamagedPart(entity, RenderUtil.getWheelModel(entity));
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void applyPlayerModel(EntityDirtBike entity, EntityPlayer player, ModelPlayer model, float partialTicks) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index == 0) {
            float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
            float wheelAngleNormal = wheelAngle / 45.0f;
            float turnRotation = wheelAngleNormal * 8.0f;
            model.field_178723_h.field_78795_f = (float)Math.toRadians(-55.0f - turnRotation);
            model.field_178724_i.field_78795_f = (float)Math.toRadians(-55.0f + turnRotation);
        } else if (index == 1) {
            model.field_178723_h.field_78795_f = (float)Math.toRadians(-45.0);
            model.field_178723_h.field_78808_h = (float)Math.toRadians(-10.0);
            model.field_178724_i.field_78795_f = (float)Math.toRadians(-45.0);
            model.field_178724_i.field_78808_h = (float)Math.toRadians(10.0);
        }
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-45.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(30.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-45.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-30.0);
    }

    @Override
    public void applyPlayerRender(EntityDirtBike entity, EntityPlayer player, float partialTicks) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W()) * scale + 1.5;
            double offsetZ = -seatVec.field_72449_c * scale;
            GlStateManager.func_179137_b((double)offsetX, (double)offsetY, (double)offsetZ);
            float currentSpeedNormal = (entity.prevCurrentSpeed + (entity.currentSpeed - entity.prevCurrentSpeed) * partialTicks) / entity.getMaxSpeed();
            float turnAngleNormal = (entity.prevTurnAngle + (entity.turnAngle - entity.prevTurnAngle) * partialTicks) / 45.0f;
            GlStateManager.func_179114_b((float)(turnAngleNormal * currentSpeedNormal * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
        }
    }
}

