/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.tileentity.TileEntityFluidExtractor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class FluidExtractorRenderer
extends TileEntitySpecialRenderer<TileEntityFluidExtractor> {
    public void render(TileEntityFluidExtractor te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() != ModBlocks.FLUID_EXTRACTOR) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockRotatedObject.FACING);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179114_b((float)((float)facing.func_176736_b() * -90.0f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        double height = 12.0 * ((double)te.getFluidLevel() / 5000.0);
        if (height > 0.0) {
            this.drawFluid(te, 0.625, 0.125, 6.25E-4, 0.374375, height * 0.0625, 0.99875);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void drawFluid(TileEntityFluidExtractor te, double x, double y, double z, double width, double height, double depth) {
        if (te.getFluidStackTank() == null) {
            return;
        }
        ResourceLocation resource = te.getFluidStackTank().getFluid().getStill();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(resource.toString());
        if (sprite != null) {
            double minU = sprite.func_94209_e();
            double maxU = Math.min(minU + ((double)sprite.func_94212_f() - minU) * width, (double)sprite.func_94212_f());
            double minV = sprite.func_94206_g();
            double maxV = Math.min(minV + ((double)sprite.func_94210_h() - minV) * height, (double)sprite.func_94210_h());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            int light = this.func_178459_a().func_175626_b(te.func_174877_v(), ModFluids.FUELIUM.getLuminosity());
            int lightX = light >> 16 & 0xFFFF;
            int lightY = light & 0xFFFF;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            buffer.func_181662_b(x + width, y, z).func_187315_a(maxU, minV).func_187314_a(lightX, lightY).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(minU, minV).func_187314_a(lightX, lightY).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y + height, z).func_187315_a(minU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z).func_187315_a(maxU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            buffer.func_181662_b(x, y, z + depth).func_187315_a(maxU, minV).func_187314_a(lightX, lightY).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y, z + depth).func_187315_a(minU, minV).func_187314_a(lightX, lightY).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z + depth).func_187315_a(minU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y + height, z + depth).func_187315_a(maxU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            maxU = Math.min(minU + ((double)sprite.func_94212_f() - minU) * depth, (double)sprite.func_94212_f());
            buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            buffer.func_181662_b(x + width, y, z + depth).func_187315_a(maxU, minV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y, z).func_187315_a(minU, minV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z).func_187315_a(minU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z + depth).func_187315_a(maxU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            maxV = Math.min(minV + ((double)sprite.func_94210_h() - minV) * width, (double)sprite.func_94210_h());
            buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            buffer.func_181662_b(x, y + height, z).func_187315_a(maxU, minV).func_187314_a(lightX, lightY).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y + height, z + depth).func_187315_a(minU, minV).func_187314_a(lightX, lightY).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z + depth).func_187315_a(minU, maxV).func_187314_a(lightX, lightY).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(x + width, y + height, z).func_187315_a(maxU, maxV).func_187314_a(lightX, lightY).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

