/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.gui;

import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.VehicleRenderRegistry;
import com.mrcrayfish.vehicle.common.container.ContainerVehicle;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.MouseHelper;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiEditVehicle
extends GuiContainer {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("vehicle:textures/gui/edit_vehicle.png");
    private final IInventory playerInventory;
    private final IInventory vehicleInventory;
    private final EntityPoweredVehicle vehicle;
    private boolean showHelp = true;
    private int windowZoom = 10;
    private int windowX;
    private int windowY;
    private float windowRotationX;
    private float windowRotationY;
    private boolean mouseGrabbed;
    private int mouseGrabbedButton;
    private int mouseClickedX;
    private int mouseClickedY;

    public GuiEditVehicle(IInventory vehicleInventory, EntityPoweredVehicle vehicle, EntityPlayer player) {
        super((Container)new ContainerVehicle(vehicleInventory, vehicle, player));
        this.playerInventory = player.field_71071_by;
        this.vehicleInventory = vehicleInventory;
        this.vehicle = vehicle;
        this.field_147000_g = 184;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.vehicle.getEngineType() != EngineType.NONE) {
            if (this.vehicleInventory.func_70301_a(0).func_190926_b()) {
                this.func_73729_b(i + 8, j + 17, 176, 0, 16, 16);
            }
        } else if (this.vehicleInventory.func_70301_a(0).func_190926_b()) {
            this.func_73729_b(i + 8, j + 17, 176, 32, 16, 16);
        }
        if (this.vehicle.canChangeWheels()) {
            if (this.vehicleInventory.func_70301_a(1).func_190926_b()) {
                this.func_73729_b(i + 8, j + 35, 176, 16, 16, 16);
            }
        } else if (this.vehicleInventory.func_70301_a(1).func_190926_b()) {
            this.func_73729_b(i + 8, j + 35, 176, 32, 16, 16);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.vehicleInventory.func_145748_c_().func_150260_c(), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
        RenderVehicleWrapper<?, ?> wrapper = VehicleRenderRegistry.getRenderWrapper(((Object)((Object)this.vehicle)).getClass());
        if (wrapper != null) {
            int i = (this.field_146294_l - this.field_146999_f) / 2;
            int j = (this.field_146295_m - this.field_147000_g) / 2;
            GL11.glEnable((int)3089);
            RenderUtil.scissor(i + 26, j + 17, 142, 70);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)96.0f, (float)78.0f, (float)100.0f);
            GlStateManager.func_179109_b((float)(this.windowX + (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseX - this.mouseClickedX : 0)), (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(this.windowY + (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseY - this.mouseClickedY : 0)), (float)0.0f);
            GlStateManager.func_179114_b((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.windowRotationY - (float)(this.mouseGrabbed && this.mouseGrabbedButton == 1 ? mouseY - this.mouseClickedY : 0)), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.windowRotationX + (float)(this.mouseGrabbed && this.mouseGrabbedButton == 1 ? mouseX - this.mouseClickedX : 0)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)((float)this.windowZoom / 10.0f), (float)((float)this.windowZoom / 10.0f), (float)((float)this.windowZoom / 10.0f));
            GlStateManager.func_179152_a((float)-22.0f, (float)-22.0f, (float)-22.0f);
            PartPosition position = VehicleProperties.getProperties(((Object)((Object)this.vehicle)).getClass()).getDisplayPosition();
            if (position != null) {
                GlStateManager.func_179139_a((double)position.getScale(), (double)position.getScale(), (double)position.getScale());
                GlStateManager.func_179114_b((float)((float)position.getRotX()), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)position.getRotY()), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)position.getRotZ()), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)position.getX(), (double)position.getY(), (double)position.getZ());
            }
            wrapper.render(this.vehicle, Minecraft.func_71410_x().func_184121_ak());
            GlStateManager.func_179121_F();
            GL11.glDisable((int)3089);
        }
        if (this.showHelp) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.edit_vehicle.window_help", (Object[])new Object[0]), 56, 38, Color.WHITE.getRGB());
            GlStateManager.func_179121_F();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        if (MouseHelper.isMouseWithin(mouseX, mouseY, startX + 26, startY + 17, 142, 70)) {
            int mouseWheelDelta = Mouse.getDWheel();
            if (mouseWheelDelta < 0 && this.windowZoom > 0) {
                this.showHelp = false;
                --this.windowZoom;
            } else if (mouseWheelDelta > 0) {
                this.showHelp = false;
                ++this.windowZoom;
            }
            if (!this.mouseGrabbed && (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1))) {
                this.mouseGrabbed = true;
                this.mouseGrabbedButton = Mouse.isButtonDown((int)1) ? 1 : 0;
                this.mouseClickedX = mouseX;
                this.mouseClickedY = mouseY;
                this.showHelp = false;
            }
        }
        if (this.mouseGrabbed) {
            if (this.mouseGrabbedButton == 0 && !Mouse.isButtonDown((int)0)) {
                this.mouseGrabbed = false;
                this.windowX += mouseX - this.mouseClickedX;
                this.windowY += mouseY - this.mouseClickedY;
            } else if (this.mouseGrabbedButton == 1 && !Mouse.isButtonDown((int)1)) {
                this.mouseGrabbed = false;
                this.windowRotationX += (float)(mouseX - this.mouseClickedX);
                this.windowRotationY -= (float)(mouseY - this.mouseClickedY);
            }
        }
        if (this.vehicleInventory.func_70301_a(0).func_190926_b() && MouseHelper.isMouseWithin(mouseX, mouseY, startX + 7, startY + 16, 18, 18)) {
            if (this.vehicle.getEngineType() != EngineType.NONE) {
                this.drawHoveringText(Collections.singletonList("Engine"), mouseX, mouseY, this.field_146297_k.field_71466_p);
            } else {
                this.drawHoveringText(Arrays.asList("Engine", TextFormatting.GRAY + "Not applicable"), mouseX, mouseY, this.field_146297_k.field_71466_p);
            }
        }
        if (this.vehicleInventory.func_70301_a(1).func_190926_b() && MouseHelper.isMouseWithin(mouseX, mouseY, startX + 7, startY + 34, 18, 18)) {
            if (this.vehicle.canChangeWheels()) {
                this.drawHoveringText(Collections.singletonList("Wheels"), mouseX, mouseY, this.field_146297_k.field_71466_p);
            } else {
                this.drawHoveringText(Arrays.asList("Wheels", TextFormatting.GRAY + "Not applicable"), mouseX, mouseY, this.field_146297_k.field_71466_p);
            }
        }
    }
}

