/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.item.ItemJerryCan;
import com.mrcrayfish.vehicle.tileentity.TileEntityFuelDrum;
import com.mrcrayfish.vehicle.util.Bounds;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockFuelDrum
extends BlockRotatedObject {
    private static final AxisAlignedBB BOUNDING_BOX = new Bounds(1, 0, 1, 15, 16, 15).toAABB();
    private int capacity;

    public BlockFuelDrum(String id, int capacity) {
        super(Material.field_151573_f, id);
        this.capacity = capacity;
        this.func_149711_c(1.0f);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (GuiScreen.func_146272_n()) {
            String info = I18n.func_135052_a((String)"tile.vehicle.fuel_drum.info", (Object[])new Object[0]);
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
        } else {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0]));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing)) {
                return true;
            }
            if (stack.func_77973_b() instanceof ItemJerryCan) {
                IFluidHandler handler;
                ItemJerryCan jerryCan = (ItemJerryCan)stack.func_77973_b();
                if (jerryCan.isFull(stack)) {
                    return false;
                }
                TileEntity tileEntity = worldIn.func_175625_s(pos);
                if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null && handler instanceof FluidTank) {
                    int remaining;
                    FluidTank tank = (FluidTank)handler;
                    if (tank.getFluid() != null && tank.getFluid().getFluid() != ModFluids.FUELIUM) {
                        return false;
                    }
                    FluidStack fluidStack = handler.drain(50, true);
                    if (fluidStack != null && (remaining = jerryCan.fill(stack, fluidStack.amount)) > 0) {
                        fluidStack.amount = remaining;
                        handler.fill(fluidStack, true);
                    }
                }
            }
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFuelDrum(this.capacity);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tileEntity;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityFuelDrum) {
            ItemStack drop = new ItemStack(Item.func_150898_a((Block)this));
            if (((TileEntityFuelDrum)tileEntity).getAmount() > 0) {
                NBTTagCompound tileEntityTag = new NBTTagCompound();
                tileEntity.func_189515_b(tileEntityTag);
                tileEntityTag.func_82580_o("x");
                tileEntityTag.func_82580_o("y");
                tileEntityTag.func_82580_o("z");
                tileEntityTag.func_82580_o("id");
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74782_a("BlockEntityTag", (NBTBase)tileEntityTag);
                drop.func_77982_d(compound);
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop));
            return world.func_175698_g(pos);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }
}

