/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.network;

import com.mrcrayfish.obfuscate.network.handshake.ObfuscateRuntimeCodec;
import com.mrcrayfish.obfuscate.network.handshake.S2CConnectionEstablishedHandler;
import com.mrcrayfish.obfuscate.network.handshake.SyncedPlayerDataHandler;
import com.mrcrayfish.obfuscate.network.message.MessageSyncPlayerData;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketHandler {
    private static EnumMap<Side, FMLEmbeddedChannel> handshakeChannels;
    private static SimpleNetworkWrapper playChannel;

    public static SimpleNetworkWrapper getPlayChannel() {
        return playChannel;
    }

    public static void register(Side side) {
        playChannel = NetworkRegistry.INSTANCE.newSimpleChannel("OBFUSCATE|PLAY");
        handshakeChannels = NetworkRegistry.INSTANCE.newChannel("OBFUSCATE|HS", new ChannelHandler[]{new ObfuscateRuntimeCodec()});
        if (side == Side.CLIENT) {
            PacketHandler.addClientHandlers();
        }
        FMLEmbeddedChannel serverChannel = handshakeChannels.get(Side.SERVER);
        serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.NOWHERE);
        String handlerName = serverChannel.findChannelHandlerNameForType(ObfuscateRuntimeCodec.class);
        serverChannel.pipeline().addAfter(handlerName, "ServerToClientConnection", (ChannelHandler)new S2CConnectionEstablishedHandler());
        PacketHandler.registerPlayMessages();
    }

    @SideOnly(value=Side.CLIENT)
    private static void addClientHandlers() {
        FMLEmbeddedChannel clientChannel = handshakeChannels.get(Side.CLIENT);
        String handlerName = clientChannel.findChannelHandlerNameForType(ObfuscateRuntimeCodec.class);
        clientChannel.pipeline().addAfter(handlerName, "SyncedPlayerData", (ChannelHandler)new SyncedPlayerDataHandler());
    }

    private static void registerPlayMessages() {
        playChannel.registerMessage(MessageSyncPlayerData.class, MessageSyncPlayerData.class, 0, Side.CLIENT);
    }
}

