/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.weather.volcano;

import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.Vec3;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.util.WeatherUtilBlock;
import net.mrbt0907.weather2.weather.WeatherManager;

public class VolcanoObject {
    public UUID ID;
    public WeatherManager manager;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesSmoke = new ArrayList<EntityRotFX>();
    @SideOnly(value=Side.CLIENT)
    public ParticleBehaviors particleBehaviors;
    public int sizeMaxParticles = 300;
    public static int staticYPos = 200;
    public Vec3 pos = new Vec3(0.0, (double)staticYPos, 0.0);
    public int processRateDelay = 20;
    public Block topBlockID = Blocks.field_150350_a;
    public int startYPos = -1;
    public int curRadius = 5;
    public int curHeight = 3;
    public int state = 0;
    public int size = 0;
    public int maxSize = 20;
    public int step = 0;
    public int stepsBuildupMax = 20;
    public int ticksToErupt = 600;
    public int ticksPerformedErupt = 0;
    public int ticksToCooldown = 600;
    public int ticksPerformedCooldown = 0;
    public int growthStage = 0;

    public VolcanoObject(WeatherManager parManager) {
        this.manager = parManager;
        this.init();
    }

    public void init() {
        this.ID = UUID.randomUUID();
    }

    public void resetEruption() {
        this.step = 0;
        this.ticksPerformedErupt = 0;
        this.ticksPerformedCooldown = 0;
        this.state = 2;
        this.ticksPerformedErupt = 0;
        this.ticksPerformedCooldown = 0;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.ID = data.func_186857_a("ID");
        this.pos = new Vec3((double)data.func_74762_e("posX"), (double)data.func_74762_e("posY"), (double)data.func_74762_e("posZ"));
        this.size = data.func_74762_e("size");
        this.maxSize = data.func_74762_e("maxSize");
        this.state = data.func_74762_e("state");
        this.curRadius = data.func_74762_e("curRadius");
        this.curHeight = data.func_74762_e("curHeight");
        this.topBlockID = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(data.func_74779_i("topBlockID")));
        this.startYPos = data.func_74762_e("startYPos");
        this.step = data.func_74762_e("step");
        this.ticksPerformedErupt = data.func_74762_e("ticksPerformedErupt");
        this.ticksPerformedCooldown = data.func_74762_e("ticksPerformedCooldown");
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_186854_a("ID", this.ID);
        data.func_74768_a("posX", (int)this.pos.xCoord);
        data.func_74768_a("posY", (int)this.pos.yCoord);
        data.func_74768_a("posZ", (int)this.pos.zCoord);
        data.func_74768_a("size", this.size);
        data.func_74768_a("maxSize", this.maxSize);
        data.func_74768_a("state", this.state);
        data.func_74768_a("curRadius", this.curRadius);
        data.func_74768_a("curHeight", this.curHeight);
        data.func_74778_a("topBlockID", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.topBlockID)).toString());
        data.func_74768_a("startYPos", this.startYPos);
        data.func_74768_a("step", this.step);
        data.func_74768_a("ticksPerformedErupt", this.ticksPerformedErupt);
        data.func_74768_a("ticksPerformedCooldown", this.ticksPerformedCooldown);
    }

    public void nbtSyncFromServer(NBTTagCompound parNBT) {
        this.ID = parNBT.func_186857_a("ID");
        Weather2.debug("VolcanoObject " + this.ID + " receiving sync");
        this.pos = new Vec3((double)parNBT.func_74762_e("posX"), (double)parNBT.func_74762_e("posY"), (double)parNBT.func_74762_e("posZ"));
        this.size = parNBT.func_74762_e("size");
        this.maxSize = parNBT.func_74762_e("maxSize");
        this.state = parNBT.func_74762_e("state");
    }

    public NBTTagCompound nbtSyncForClient() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("posX", (int)this.pos.xCoord);
        data.func_74768_a("posY", (int)this.pos.yCoord);
        data.func_74768_a("posZ", (int)this.pos.zCoord);
        data.func_186854_a("ID", this.ID);
        data.func_74768_a("size", this.size);
        data.func_74768_a("maxSize", this.maxSize);
        data.func_74768_a("state", this.state);
        return data;
    }

    public void tick() {
        this.processRateDelay = 10;
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            if (!WeatherUtil.isPaused()) {
                this.tickClient();
            }
        } else {
            World world = this.manager.getWorld();
            float res = 5.0f;
            if (this.state == 0) {
                this.pos.xCoord = Math.floor(this.pos.xCoord);
                this.pos.zCoord = Math.floor(this.pos.zCoord);
                this.pos.yCoord = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos((int)this.pos.xCoord, 0, (int)this.pos.zCoord)).func_177956_o();
                this.startYPos = (int)this.pos.yCoord;
                IBlockState statez = world.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), MathHelper.func_76128_c((double)(this.pos.yCoord - 1.0)), MathHelper.func_76128_c((double)this.pos.zCoord)));
                this.topBlockID = statez.func_177230_c();
                if (CoroUtilBlock.isAir((Block)this.topBlockID) || !statez.func_185904_a().func_76220_a()) {
                    this.topBlockID = world.func_180495_p(new BlockPos((int)this.pos.xCoord, (int)this.pos.yCoord - 1, (int)this.pos.zCoord)).func_177230_c();
                }
                for (int yy = this.startYPos + this.curHeight; yy > 2; --yy) {
                    for (int dist = 0; dist <= this.curRadius; ++dist) {
                        double vecX = dist;
                        double vecZ = 0.0;
                        if (yy > this.startYPos) {
                            vecX = dist + (this.startYPos - yy);
                        }
                        for (double angle = 0.0; angle <= 360.0; angle += (double)res) {
                            Block idScan;
                            Vec3 vec = new Vec3(vecX, 0.0, vecZ);
                            vec.rotateAroundY((float)angle);
                            int posX = (int)Math.floor(this.pos.xCoord + vec.xCoord + 0.5);
                            int posZ = (int)Math.floor(this.pos.zCoord + vec.zCoord + 0.5);
                            Block blockID = Blocks.field_150343_Z;
                            if (yy >= this.startYPos) {
                                blockID = this.topBlockID;
                            } else if (dist < this.curRadius) {
                                blockID = Blocks.field_150353_l;
                            }
                            if (yy == this.startYPos + this.curHeight || !CoroUtilBlock.isAir((Block)(idScan = world.func_180495_p(new BlockPos(posX, yy, posZ)).func_177230_c())) && idScan.func_149688_o(idScan.func_176223_P()) != Material.field_151586_h) continue;
                            world.func_175656_a(new BlockPos(posX, yy, posZ), blockID.func_176223_P());
                        }
                    }
                }
                ++this.state;
                System.out.println("initial volcano created");
            } else if (this.state == 1) {
                if (this.manager.getWorld().func_82737_E() % (long)this.processRateDelay == 0L) {
                    ++this.size;
                    ++this.curHeight;
                    ++this.curRadius;
                    if (this.size >= this.maxSize) {
                        ++this.state;
                    }
                    res = 1.0f;
                    for (int yy = 0; yy <= this.curHeight; ++yy) {
                        int radiusForLayer = Math.max(0, this.curRadius - yy - 2);
                        double vecX = radiusForLayer;
                        double vecZ = 0.0;
                        for (double angle = 0.0; angle <= 360.0; angle += (double)res) {
                            Vec3 vec = new Vec3(vecX, 0.0, vecZ);
                            vec.rotateAroundY((float)angle);
                            int posX = (int)Math.floor(this.pos.xCoord + vec.xCoord + 0.5);
                            int posZ = (int)Math.floor(this.pos.zCoord + vec.zCoord + 0.5);
                            Block blockID = this.topBlockID;
                            Random rand = new Random();
                            if (rand.nextInt(4) != 0) continue;
                            if (yy != this.curHeight && CoroUtilBlock.isAir((Block)world.func_180495_p(new BlockPos(posX, this.startYPos + yy, posZ)).func_177230_c())) {
                                world.func_175656_a(new BlockPos(posX, this.startYPos + yy, posZ), blockID.func_176223_P());
                            }
                            int underY = this.startYPos + yy - 1;
                            Block underBlockID = world.func_180495_p(new BlockPos(posX, underY, posZ)).func_177230_c();
                            while ((CoroUtilBlock.isAir((Block)underBlockID) || underBlockID.func_149688_o(underBlockID.func_176223_P()) == Material.field_151586_h) && underY > 1) {
                                world.func_175656_a(new BlockPos(posX, underY, posZ), Blocks.field_150346_d.func_176223_P());
                                underBlockID = world.func_180495_p(new BlockPos(posX, --underY, posZ)).func_177230_c();
                            }
                        }
                    }
                    System.out.println("cur size: " + this.size + " - " + this.curHeight + " - " + this.curRadius);
                }
            } else if (this.state == 2) {
                if (this.manager.getWorld().func_82737_E() % (long)this.processRateDelay == 0L) {
                    if (this.step <= this.maxSize) {
                        int posX = (int)Math.floor(this.pos.xCoord);
                        int posY = (int)Math.floor(this.startYPos) + this.step;
                        int posZ = (int)Math.floor(this.pos.zCoord);
                        world.func_175656_a(new BlockPos(posX, posY, posZ), Blocks.field_150353_l.func_176223_P());
                        world.func_175656_a(new BlockPos(posX + 1, posY, posZ), Blocks.field_150353_l.func_176223_P());
                        world.func_175656_a(new BlockPos(posX - 1, posY, posZ), Blocks.field_150353_l.func_176223_P());
                        world.func_175656_a(new BlockPos(posX, posY, posZ + 1), Blocks.field_150353_l.func_176223_P());
                        world.func_175656_a(new BlockPos(posX, posY, posZ - 1), Blocks.field_150353_l.func_176223_P());
                    } else {
                        this.step = 0;
                        ++this.state;
                    }
                    ++this.step;
                }
            } else if (this.state == 3) {
                if (this.manager.getWorld().func_82737_E() % (long)this.processRateDelay == 0L) {
                    ++this.step;
                    if (this.step > this.stepsBuildupMax) {
                        this.step = 0;
                        ++this.state;
                    }
                }
            } else if (this.state == 4) {
                if (this.ticksPerformedErupt == 0) {
                    Weather2.debug("volcano " + this.ID + " is erupting");
                    for (int i = 0; i < 3; ++i) {
                        int posX = (int)Math.floor(this.pos.xCoord);
                        int posY = (int)Math.floor(this.startYPos) + this.maxSize + i;
                        int posZ = (int)Math.floor(this.pos.zCoord);
                        BlockStaticLiquid blockID = Blocks.field_150353_l;
                        world.func_175656_a(new BlockPos(posX, posY, posZ), blockID.func_176223_P());
                        world.func_175656_a(new BlockPos(posX + 1, posY, posZ), blockID.func_176223_P());
                        world.func_175656_a(new BlockPos(posX - 1, posY, posZ), blockID.func_176223_P());
                        world.func_175656_a(new BlockPos(posX, posY, posZ + 1), blockID.func_176223_P());
                        world.func_175656_a(new BlockPos(posX, posY, posZ - 1), blockID.func_176223_P());
                        world.func_175656_a(new BlockPos(posX + 1, posY, posZ + 1), blockID.func_176223_P());
                        world.func_175656_a(new BlockPos(posX - 1, posY, posZ - 1), blockID.func_176223_P());
                        world.func_175656_a(new BlockPos(posX - 1, posY, posZ + 1), blockID.func_176223_P());
                        world.func_175656_a(new BlockPos(posX + 1, posY, posZ - 1), blockID.func_176223_P());
                    }
                }
                ++this.ticksPerformedErupt;
                if (this.ticksPerformedErupt > this.ticksToErupt) {
                    ++this.state;
                }
            } else if (this.state == 5) {
                if (this.ticksPerformedCooldown == 0) {
                    Weather2.debug("volcano " + this.ID + " is cooling");
                }
                if (this.ticksPerformedCooldown % this.processRateDelay == 0) {
                    int posX = (int)Math.floor(this.pos.xCoord);
                    int posY = (int)Math.floor(this.startYPos) + this.maxSize - this.step + 2;
                    int posZ = (int)Math.floor(this.pos.zCoord);
                    Block blockID = Blocks.field_150348_b;
                    world.func_175656_a(new BlockPos(posX, posY, posZ), blockID.func_176223_P());
                    world.func_175656_a(new BlockPos(posX + 1, posY, posZ), blockID.func_176223_P());
                    world.func_175656_a(new BlockPos(posX - 1, posY, posZ), blockID.func_176223_P());
                    world.func_175656_a(new BlockPos(posX, posY, posZ + 1), blockID.func_176223_P());
                    world.func_175656_a(new BlockPos(posX, posY, posZ - 1), blockID.func_176223_P());
                    world.func_175656_a(new BlockPos(posX + 1, posY, posZ + 1), blockID.func_176223_P());
                    world.func_175656_a(new BlockPos(posX - 1, posY, posZ - 1), blockID.func_176223_P());
                    world.func_175656_a(new BlockPos(posX - 1, posY, posZ + 1), blockID.func_176223_P());
                    world.func_175656_a(new BlockPos(posX + 1, posY, posZ - 1), blockID.func_176223_P());
                    ++this.step;
                }
                ++this.ticksPerformedCooldown;
                if (this.ticksPerformedCooldown > this.ticksToCooldown) {
                    ++this.state;
                }
            } else if (this.state == 6) {
                Weather2.debug("volcano " + this.ID + " has reset!");
                this.resetEruption();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        int i;
        if (this.particleBehaviors == null) {
            this.particleBehaviors = new ParticleBehaviors(new Vec3(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord));
        } else if (!Minecraft.func_71410_x().func_71356_B() || !(Minecraft.func_71410_x().field_71462_r instanceof GuiIngameMenu)) {
            this.particleBehaviors.tickUpdateList();
        }
        int delay = 1;
        int loopSize = 1;
        Random rand = new Random();
        if (this.manager.getWorld().func_82737_E() % (long)delay == 0L) {
            for (i = 0; i < loopSize; ++i) {
                if (this.listParticlesSmoke.size() >= 500) continue;
                double spawnRad = this.size / 48;
                EntityRotFX particle = this.spawnSmokeParticle(this.pos.xCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, this.pos.yCoord + (double)this.size + 2.0, this.pos.zCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad);
                this.listParticlesSmoke.add(particle);
            }
        }
        delay = 1;
        loopSize = 2;
        for (i = 0; i < this.listParticlesSmoke.size(); ++i) {
            EntityRotFX ent = this.listParticlesSmoke.get(i);
            if (!ent.func_187113_k()) {
                this.listParticlesSmoke.remove(ent);
                continue;
            }
            double distt = 300.0;
            double curDist = ent.getDistance(this.pos.xCoord, (double)staticYPos, this.pos.zCoord);
            double vecX = ent.getPosX() - this.pos.xCoord;
            double vecZ = ent.getPosZ() - this.pos.zCoord;
            float angle = (float)(Maths.fastATan2(vecZ, vecX) * 180.0 / Math.PI);
            angle += 50.0f;
            angle = (float)((double)angle - (double)(ent.getEntityId() % 10) * 3.0);
            angle += (float)(rand.nextInt(10) - rand.nextInt(10));
            if (!(curDist > distt)) continue;
            angle += 20.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EntityRotFX spawnSmokeParticle(double x, double y, double z) {
        double speed = 0.0;
        Random rand = new Random();
        EntityRotFX entityfx = this.particleBehaviors.spawnNewParticleIconFX((World)Minecraft.func_71410_x().field_71441_e, ParticleRegistry.cloud256, x, y, z, (rand.nextDouble() - rand.nextDouble()) * speed, 0.0, (rand.nextDouble() - rand.nextDouble()) * speed);
        this.particleBehaviors.initParticle(entityfx);
        ParticleBehaviors.setParticleRandoms((EntityRotFX)entityfx, (boolean)true, (boolean)true);
        ParticleBehaviors.setParticleFire((EntityRotFX)entityfx);
        entityfx.setCanCollide(false);
        entityfx.callUpdatePB = false;
        entityfx.func_187114_a(400 + rand.nextInt(200));
        entityfx.setScale(50.0f);
        float randFloat = rand.nextFloat() * 0.6f;
        float baseBright = 0.1f;
        float finalBright = Math.min(1.0f, baseBright + randFloat);
        entityfx.func_70538_b(finalBright, finalBright, finalBright);
        ExtendedRenderer.rotEffRenderer.addEffect((Particle)entityfx);
        this.particleBehaviors.particles.add(entityfx);
        return entityfx;
    }

    public void reset() {
        this.setDead();
    }

    public void setDead() {
        Weather2.debug("volcano... killed? NO ONE KILLS A VOLCANO!");
    }

    public UUID getUUID() {
        return this.ID;
    }
}

