/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.weather.storm;

import java.util.UUID;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.api.weather.IWeatherDetectable;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.util.CachedNBTTagCompound;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.WeatherManager;
import net.mrbt0907.weather2.weather.storm.FrontObject;

public abstract class WeatherObject
implements IWeatherDetectable {
    private UUID id;
    public FrontObject front;
    public WeatherManager manager;
    public CachedNBTTagCompound nbt;
    public WeatherEnum.Type type = WeatherEnum.Type.CLOUD;
    public Maths.Vec3 pos = new Maths.Vec3(0, 0, 0);
    public Maths.Vec3 posGround = new Maths.Vec3(0, 0, 0);
    public Maths.Vec3 motion = new Maths.Vec3(0, 0, 0);
    public boolean isDying = false;
    public boolean isDead = false;
    public long ticks = 0L;
    public int size = ConfigStorm.min_storm_size;
    protected World world;
    public int ticksSinceNoNearPlayer = 0;

    public WeatherObject(FrontObject front) {
        this.front = front;
        this.manager = front.getWeatherManager();
        this.nbt = new CachedNBTTagCompound();
        this.world = front.world;
        this.init();
    }

    public void init() {
        this.id = UUID.randomUUID();
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks < 0L) {
            this.ticks = 0L;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickRender(float partialTick) {
    }

    public void setDead() {
        this.isDead = true;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.cleanupClient(true);
        }
        this.cleanup();
    }

    public void reset() {
        this.setDead();
    }

    public void cleanup() {
        this.manager = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void cleanupClient(boolean wipe) {
    }

    public void readFromNBT() {
        this.id = this.nbt.getUUID("ID");
        this.pos = new Maths.Vec3(this.nbt.getDouble("posX"), this.nbt.getDouble("posY"), this.nbt.getDouble("posZ"));
        this.motion = new Maths.Vec3(this.nbt.getDouble("vecX"), this.nbt.getDouble("vecY"), this.nbt.getDouble("vecZ"));
        this.size = this.nbt.getInteger("size");
        this.type = WeatherEnum.Type.get(this.nbt.getInteger("weatherType"));
        this.isDying = this.nbt.getBoolean("isDying");
        this.isDead = this.nbt.getBoolean("isDead");
    }

    public CachedNBTTagCompound writeToNBT() {
        this.nbt.setDouble("posX", this.pos.posX);
        this.nbt.setDouble("posY", this.pos.posY);
        this.nbt.setDouble("posZ", this.pos.posZ);
        this.nbt.setDouble("vecX", this.motion.posX);
        this.nbt.setDouble("vecY", this.motion.posY);
        this.nbt.setDouble("vecZ", this.motion.posZ);
        this.nbt.setUUID("ID", this.id);
        this.nbt.setUUID("frontUUID", this.front.getUUID());
        this.nbt.getNewNBT().func_186854_a("ID", this.id);
        this.nbt.setInteger("size", this.size);
        this.nbt.setInteger("weatherType", this.type.ordinal());
        this.nbt.setBoolean("isDying", this.isDying);
        this.nbt.setBoolean("isDead", this.isDead);
        return this.nbt;
    }

    public int getNetRate() {
        return 40;
    }

    public boolean isDangerous() {
        return this.type.isDangerous();
    }

    @Override
    public UUID getUUID() {
        return this.id;
    }

    @Override
    public Maths.Vec3 getPos() {
        return this.pos;
    }

    @Override
    public boolean isDying() {
        return this.isDying;
    }
}

