/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.weather.storm;

import CoroUtil.block.TileEntityRepairingBlock;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.UtilMining;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.WeatherAPI;
import net.mrbt0907.weather2.api.weather.IWeatherStaged;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.config.ConfigGrab;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.entity.EntityMovingBlock;
import net.mrbt0907.weather2.util.BlockReplaceSnapshot;
import net.mrbt0907.weather2.util.ChunkUtils;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtilBlock;
import net.mrbt0907.weather2.util.WeatherUtilEntity;
import net.mrbt0907.weather2.weather.WeatherManager;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class TornadoHelper {
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    public static final List<BlockReplaceSnapshot> snapshots = new ArrayList<BlockReplaceSnapshot>();
    public static HashMap<Integer, Long> grabbedLastQueryTime = new HashMap();
    public static HashMap<Integer, Integer> grabbedCache = new HashMap();
    public static HashMap<Integer, Integer> replacedCache = new HashMap();
    public static int maxGrabs;
    public static int maxReplaces;
    public StormObject storm;
    private boolean isBlockGrabbingBlockedCached = true;
    private long isBlockGrabbingBlockedCached_LastCheck = 0L;

    public TornadoHelper(StormObject storm) {
        this.storm = storm;
    }

    public float getTornadoBaseSize() {
        if (this.storm.stage > WeatherEnum.Stage.TORNADO.getStage() || this.storm.stormType == StormObject.StormType.WATER.ordinal()) {
            return (float)Math.min((double)(this.storm.funnelSize * 1.15f), ConfigStorm.max_storm_damage_size);
        }
        return 14.0f;
    }

    public static void tickProcess(World world) {
        WeatherManager manager;
        ChunkUtils util = Weather2.getChunkUtil(world);
        if (!snapshots.isEmpty()) {
            snapshots.forEach(snapshot -> {
                if (snapshot.newState == null) {
                    if (ConfigGrab.enable_repair_block_mode) {
                        TornadoHelper.placeDamageBlock(world, snapshot.pos, snapshot.state);
                    } else {
                        util.setBlockState(world, snapshot.pos.func_177958_n(), snapshot.pos.func_177956_o(), snapshot.pos.func_177952_p(), AIR, snapshot.state);
                        EntityMovingBlock entity = new EntityMovingBlock(world, snapshot.pos.func_177958_n(), snapshot.pos.func_177956_o(), snapshot.pos.func_177952_p(), snapshot.state, snapshot.storm);
                        entity.field_70159_w += (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 1.0;
                        entity.field_70179_y += (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 1.0;
                        entity.field_70181_x = 1.0;
                        world.func_72838_d((Entity)entity);
                    }
                    TornadoHelper.putToCache(world, -1, false);
                } else {
                    util.setBlockState(world, snapshot.pos.func_177958_n(), snapshot.pos.func_177956_o(), snapshot.pos.func_177952_p(), snapshot.newState, snapshot.state);
                    TornadoHelper.putToCache(world, -1, true);
                }
            });
            snapshots.clear();
        }
        if (world.func_82737_E() % 200L == 0L && (manager = WeatherAPI.getManager(world)) != null) {
            List<WeatherObject> systems = manager.getWeatherObjects();
            int storms = 0;
            for (WeatherObject system : systems) {
                if (!(system instanceof IWeatherStaged) || system.getStage() < WeatherEnum.Stage.TORNADO.getStage()) continue;
                ++storms;
            }
            int n = ConfigGrab.max_grabbed_blocks_per_tick < 0 ? Integer.MAX_VALUE : (maxGrabs = storms < 2 ? ConfigGrab.max_grabbed_blocks_per_tick : ConfigGrab.max_grabbed_blocks_per_tick / storms);
            maxReplaces = ConfigGrab.max_replaced_blocks_per_tick < 0 ? Integer.MAX_VALUE : (storms < 2 ? ConfigGrab.max_replaced_blocks_per_tick : ConfigGrab.max_replaced_blocks_per_tick / storms);
        }
    }

    public void tick(World world) {
        if (this.storm == null) {
            return;
        }
        float size = this.getTornadoBaseSize();
        this.forceRotate(world, size * 0.85f + 32.0f);
        if (!world.field_72995_K) {
            IBlockState state;
            BlockPos pos;
            int firesPerTickMax = 1;
            boolean shouldGrab = true;
            boolean shouldReplace = true;
            boolean shouldContinue = true;
            ChunkUtils util = Weather2.getChunkUtil(world);
            if (ConfigGrab.grab_blocks && world.func_82737_E() % (long)(ConfigGrab.grab_process_delay > 0 ? ConfigGrab.grab_process_delay : 1) == 0L) {
                int x = 0;
                int z = 0;
                int grabbed = 0;
                int replaced = 0;
                for (int y = 0; shouldContinue && (double)y < this.storm.pos.posY && y < 256; ++y) {
                    int loopAmount = (int)(5.0f + (float)y * 0.25f + this.storm.funnelSize);
                    double loopSize = (double)size * 0.25 + (double)y * 0.25;
                    for (int i = 0; shouldContinue && i < loopAmount; ++i) {
                        x = (int)(this.storm.pos_funnel_base.posX + Maths.random(-loopSize, loopSize));
                        z = (int)(this.storm.pos_funnel_base.posZ + Maths.random(-loopSize, loopSize));
                        pos = new BlockPos(x, y, z);
                        state = util.getBlockState(world, x, y, z);
                        if (this.isBlockGrabbingBlocked(world, state, pos)) continue;
                        shouldGrab = grabbed < maxGrabs && TornadoHelper.getGrabbed(world) < ConfigGrab.max_flying_blocks;
                        boolean bl = shouldReplace = replaced < maxReplaces && TornadoHelper.getReplaced(world) < ConfigGrab.max_replaced_blocks;
                        if (shouldGrab && this.grabBlock(world, pos, state)) {
                            ++grabbed;
                            shouldReplace = false;
                        }
                        if (shouldReplace && this.replaceBlock(world, pos, state)) {
                            ++replaced;
                        }
                        shouldContinue = shouldGrab || shouldReplace;
                    }
                }
            }
            if (this.storm.isFirenado) {
                if (this.storm.stage >= WeatherEnum.Stage.TORNADO.getStage() + 1) {
                    for (int i = 0; i < firesPerTickMax; ++i) {
                        BlockPos posUp = new BlockPos(this.storm.posGround.posX, this.storm.posGround.posY + (double)Maths.random(30), this.storm.posGround.posZ);
                        state = util.getBlockState(world, posUp);
                        if (!CoroUtilBlock.isAir((Block)state.func_177230_c())) continue;
                        EntityMovingBlock mBlock = new EntityMovingBlock(world, posUp.func_177958_n(), posUp.func_177956_o(), posUp.func_177952_p(), Blocks.field_150480_ab.func_176223_P(), this.storm);
                        mBlock.metadata = 15;
                        double speed = 2.0;
                        mBlock.field_70159_w += (Maths.random(1.0) - Maths.random(1.0)) * speed;
                        mBlock.field_70179_y += (Maths.random(1.0) - Maths.random(1.0)) * speed;
                        mBlock.field_70181_x = 1.0;
                        mBlock.mode = 0;
                        world.func_72838_d((Entity)mBlock);
                    }
                }
                int randSize = 10;
                int tryX = (int)this.storm.pos.posX + Maths.random(randSize) - randSize / 2;
                int tryZ = (int)this.storm.pos.posZ + Maths.random(randSize) - randSize / 2;
                int tryY = world.func_189649_b(tryX, tryZ) - 1;
                double d0 = this.storm.pos.posX - (double)tryX;
                double d2 = this.storm.pos.posZ - (double)tryZ;
                double dist = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                if (dist < (double)(size / 2.0f + (float)(randSize / 2)) && TornadoHelper.getGrabbed(world) < 300) {
                    pos = new BlockPos(tryX, tryY, tryZ);
                    Block block = util.getBlockState(world, pos).func_177230_c();
                    BlockPos posUp = new BlockPos(tryX, tryY + 1, tryZ);
                    Block blockUp = util.getBlockState(world, posUp).func_177230_c();
                    if (!CoroUtilBlock.isAir((Block)block) && CoroUtilBlock.isAir((Block)blockUp)) {
                        util.setBlockState(world, posUp, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
            TornadoHelper.getBlockCountForDim(this.storm.manager.getWorld());
        }
    }

    public boolean grabBlock(World world, BlockPos pos, IBlockState state) {
        if (ConfigGrab.enable_grab_list && WeatherUtilBlock.canGrabBlock(this.storm, pos, state)) {
            String id = state.func_177230_c().getRegistryName().toString();
            if (ConfigGrab.enable_grab_list && WeatherAPI.getGrabList().exists(id) || !ConfigGrab.enable_grab_list && !ConfigGrab.enable_replace_list) {
                if (ConfigGrab.enable_repair_block_mode) {
                    if (state != AIR && UtilMining.canConvertToRepairingBlock((World)world, (IBlockState)state)) {
                        TornadoHelper.putToCache(world, 1, false);
                        snapshots.add(new BlockReplaceSnapshot(this.storm, null, state, pos));
                        return true;
                    }
                    return false;
                }
                if ((ConfigGrab.enable_list_sharing && Maths.chance(50) || !ConfigGrab.enable_list_sharing) && (ConfigGrab.grab_list_strength_match && WeatherUtilBlock.checkResistance(this.storm, id) || !ConfigGrab.grab_list_strength_match)) {
                    snapshots.add(new BlockReplaceSnapshot(this.storm, null, state, pos));
                    return true;
                }
            }
        }
        return false;
    }

    public boolean replaceBlock(World world, BlockPos pos, IBlockState state) {
        if (ConfigGrab.enable_replace_list && WeatherUtilBlock.canGrabBlock(this.storm, pos, state)) {
            boolean shouldReplace;
            String id = state.func_177230_c().getRegistryName().toString();
            Object[] list = WeatherAPI.getReplaceList().getValues(id);
            boolean bl = shouldReplace = list != null && list.length > 0;
            if (shouldReplace && (ConfigGrab.replace_list_strength_matches && WeatherUtilBlock.checkResistance(this.storm, id) || !ConfigGrab.replace_list_strength_matches)) {
                TornadoHelper.putToCache(world, 1, true);
                snapshots.add(new BlockReplaceSnapshot(this.storm, Block.func_149684_b((String)((String)list[Maths.random(0, list.length - 1)])).func_176223_P(), state, pos));
                return true;
            }
        }
        return false;
    }

    public static int getGrabbed(World world) {
        int dimension = world.field_73011_w.getDimension();
        return grabbedCache.containsKey(dimension) ? grabbedCache.get(dimension) : 0;
    }

    public static int getReplaced(World world) {
        int dimension = world.field_73011_w.getDimension();
        return replacedCache.containsKey(dimension) ? replacedCache.get(dimension) : 0;
    }

    private static void putToCache(World world, int value, boolean isReplaceCache) {
        int dimension = world.field_73011_w.getDimension();
        if (isReplaceCache) {
            if (!replacedCache.containsKey(dimension)) {
                replacedCache.put(dimension, value);
            } else {
                replacedCache.put(dimension, replacedCache.get(dimension) + value);
            }
        } else if (!grabbedCache.containsKey(dimension)) {
            grabbedCache.put(dimension, value);
        } else {
            grabbedCache.put(dimension, grabbedCache.get(dimension) + value);
        }
    }

    public static boolean placeDamageBlock(World world, BlockPos pos, IBlockState state) {
        if (state != AIR && UtilMining.canConvertToRepairingBlock((World)world, (IBlockState)state)) {
            TileEntityRepairingBlock.replaceBlockAndBackup((World)world, (BlockPos)pos, (int)ConfigGrab.Storm_Tornado_TicksToRepairBlock);
            return true;
        }
        Weather2.warn("Unable to use repairing block on" + state.func_177230_c().func_149732_F());
        return false;
    }

    public boolean canGrabEntity(Entity ent) {
        if (ent == null) {
            return false;
        }
        EntityEntry entry = EntityRegistry.getEntry(ent.getClass());
        if (entry != null && WeatherAPI.getEntityGrabList().containsKey(entry.getRegistryName().toString())) {
            return false;
        }
        if (ent instanceof EntityPlayer) {
            return ConfigGrab.grab_players;
        }
        if (ent instanceof INpc) {
            return ConfigGrab.grab_villagers;
        }
        if (ent instanceof EntityItem) {
            return ConfigGrab.grab_items;
        }
        if (ent instanceof IMob) {
            return ConfigGrab.grab_mobs;
        }
        if (ent instanceof EntityAnimal) {
            return ConfigGrab.grab_animals;
        }
        return true;
    }

    public boolean forceRotate(World parWorld, float size) {
        boolean foundEnt = false;
        ArrayList entities = new ArrayList(parWorld.field_72996_f);
        for (Entity entity : entities) {
            if (parWorld.field_72995_K && !(entity instanceof EntityPlayer) || !this.canGrabEntity(entity) || !(this.getDistanceXZ(this.storm.pos_funnel_base, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) < (double)size) || (!(entity instanceof EntityMovingBlock) || ((EntityMovingBlock)entity).collideFalling) && !WeatherUtilEntity.isEntityOutside(entity, !(entity instanceof EntityPlayer))) continue;
            this.storm.spinEntity(entity);
            foundEnt = true;
        }
        return foundEnt;
    }

    public double getDistanceXZ(Maths.Vec3 parVec, double var1, double var3, double var5) {
        double var7 = parVec.posX - var1;
        double var11 = parVec.posZ - var5;
        return MathHelper.func_76133_a((double)(var7 * var7 + var11 * var11));
    }

    public double getDistanceXZ(Entity ent, double var1, double var3, double var5) {
        double var7 = ent.field_70165_t - var1;
        double var11 = ent.field_70161_v - var5;
        return MathHelper.func_76133_a((double)(var7 * var7 + var11 * var11));
    }

    public static int getBlockCountForDim(World world) {
        int queryRate = 20;
        boolean perform = false;
        int flyingBlockCount = 0;
        int dimID = world.field_73011_w.getDimension();
        if (!grabbedCache.containsKey(dimID) || !grabbedLastQueryTime.containsKey(dimID)) {
            perform = true;
        } else if (grabbedLastQueryTime.get(dimID) + (long)queryRate < world.func_82737_E()) {
            perform = true;
        }
        if (perform) {
            Entity ent;
            ArrayList entities = new ArrayList(world.field_72996_f);
            for (int i = 0; !(i >= entities.size() || (ent = (Entity)entities.get(i)) instanceof EntityMovingBlock && ++flyingBlockCount > ConfigGrab.max_flying_blocks); ++i) {
            }
            grabbedLastQueryTime.put(dimID, world.func_82737_E());
            grabbedCache.put(dimID, flyingBlockCount);
        }
        return grabbedCache.get(dimID);
    }

    public boolean isBlockGrabbingBlocked(World world, IBlockState state, BlockPos pos) {
        int queryRate = 40;
        if (this.isBlockGrabbingBlockedCached_LastCheck + (long)queryRate < world.func_82737_E()) {
            this.isBlockGrabbingBlockedCached_LastCheck = world.func_82737_E();
            this.isBlockGrabbingBlockedCached = false;
            for (Long hash : this.storm.manager.getListWeatherBlockDamageDeflector()) {
                BlockPos posDeflect = BlockPos.func_177969_a((long)hash);
                if (!(pos.func_177951_i((Vec3i)posDeflect) < (double)(ConfigStorm.storm_deflector_range * ConfigStorm.storm_deflector_range))) continue;
                this.isBlockGrabbingBlockedCached = true;
                break;
            }
        }
        return this.isBlockGrabbingBlockedCached;
    }

    public void cleanup() {
        this.storm = null;
    }
}

