/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.weather.storm;

import CoroUtil.util.ChunkCoordinatesBlock;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilCompatibility;
import CoroUtil.util.CoroUtilEntOrParticle;
import CoroUtil.util.CoroUtilEntity;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.WeatherAPI;
import net.mrbt0907.weather2.api.weather.AbstractWeatherRenderer;
import net.mrbt0907.weather2.api.weather.IWeatherLayered;
import net.mrbt0907.weather2.api.weather.IWeatherRain;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.client.weather.StormNames;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.ConfigSnow;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.entity.EntityIceBall;
import net.mrbt0907.weather2.entity.EntityLightningBolt;
import net.mrbt0907.weather2.network.packets.PacketLightning;
import net.mrbt0907.weather2.util.CachedNBTTagCompound;
import net.mrbt0907.weather2.util.ConfigList;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.util.WeatherUtilBlock;
import net.mrbt0907.weather2.util.WeatherUtilEntity;
import net.mrbt0907.weather2.weather.WindManager;
import net.mrbt0907.weather2.weather.storm.FrontObject;
import net.mrbt0907.weather2.weather.storm.TornadoHelper;
import net.mrbt0907.weather2.weather.storm.WeatherEntityConfig;
import net.mrbt0907.weather2.weather.storm.WeatherObject;
import net.mrbt0907.weather2.weather.storm.WeatherTypes;

public class StormObject
extends WeatherObject
implements IWeatherRain,
IWeatherLayered {
    public AbstractWeatherRenderer particleRenderer;
    public ResourceLocation particleRendererId;
    public float angle = 0.0f;
    public int layer = 0;
    public boolean overrideAngle = false;
    public boolean overrideMotion = false;
    public boolean isNatural = true;
    public boolean alwaysProgresses = false;
    public boolean neverDissipate = false;
    public boolean isViolent = false;
    public boolean canProgress;
    public boolean isFirenado = false;
    public boolean isSpout = false;
    public boolean shouldConvert = true;
    public float rain = 0.0f;
    public float rainRate = 0.0f;
    public float hail = 0.0f;
    public float hailRate = 0.0f;
    public boolean shouldBuildHumidity = false;
    public float windSpeed = 0.0f;
    public float temperature = 0.0f;
    public int stageMax = WeatherEnum.Stage.NORMAL.getStage();
    public int stormType = StormType.LAND.ordinal();
    public int stage = WeatherEnum.Stage.NORMAL.getStage();
    public float intensity = 0.0f;
    public float intensityRate = 0.03f;
    public int revives = 0;
    public int maxRevives = 0;
    public float lightning = 0.5f;
    public float intensityMax = 0.0f;
    public float funnelSize = 0.0f;
    public float sizeRate = -1.0f;
    public double spin = 0.02;
    public float formingStrength = 0.0f;
    public float strength = 100.0f;
    public int maxHeight = 60;
    public String name = "";
    public int currentTopYBlock = -1;
    public TornadoHelper tornadoHelper = new TornadoHelper(this);
    public int updateLCG = new Random().nextInt();
    public Maths.Vec3 pos_funnel_base;

    public StormObject(FrontObject front) {
        super(front);
        this.pos_funnel_base = new Maths.Vec3(this.pos.posX, this.pos.posY, this.pos.posZ);
        this.pos = new Maths.Vec3(0, this.getLayerHeight(), 0);
        this.size = Maths.random(100, 200) + this.size;
    }

    @Override
    public void init() {
        super.init();
        if (this.isNatural) {
            this.temperature = 0.0f;
        }
        this.windSpeed = 0.0f;
    }

    public boolean isStorm() {
        return this.canProgress;
    }

    public boolean isSevere() {
        return this.stage > WeatherEnum.Stage.THUNDER.getStage();
    }

    public boolean isDeadly() {
        return this.stormType == StormType.LAND.ordinal() ? this.stage > WeatherEnum.Stage.SEVERE.getStage() : this.stage > WeatherEnum.Stage.TROPICAL_DISTURBANCE.getStage();
    }

    public boolean isTornado() {
        return this.stormType == StormType.LAND.ordinal();
    }

    public boolean isCyclone() {
        return this.stormType == StormType.WATER.ordinal();
    }

    @Override
    public void readFromNBT() {
        super.readFromNBT();
        this.stormType = this.nbt.getInteger("stormType");
        this.stage = this.nbt.getInteger("levelCurIntensityStage");
        this.isSpout = this.nbt.getBoolean("attrib_waterSpout");
        this.currentTopYBlock = this.nbt.getInteger("currentTopYBlock");
        this.temperature = this.nbt.getFloat("levelTemperature");
        this.rain = this.nbt.getInteger("levelWater");
        this.hail = this.nbt.getInteger("hail");
        this.hailRate = this.nbt.getInteger("hailRate");
        this.layer = this.nbt.getInteger("layer");
        this.stageMax = this.nbt.getInteger("levelStormIntensityMax");
        this.intensity = this.nbt.getFloat("levelCurStagesIntensity");
        this.intensityRate = this.nbt.getFloat("intensityRate");
        this.funnelSize = this.nbt.getFloat("levelCurStageSize");
        this.windSpeed = this.nbt.getFloat("levelCurStageWind");
        this.sizeRate = this.nbt.getFloat("levelCurStageSizeRate");
        this.lightning = this.nbt.getFloat("lightning");
        this.isViolent = this.nbt.getBoolean("isViolent");
        this.isFirenado = this.nbt.getBoolean("isFirenado");
        this.name = this.nbt.getString("stormName");
        this.shouldConvert = this.nbt.getBoolean("shouldConvert");
        this.shouldBuildHumidity = this.nbt.getBoolean("shouldBuildHumidity");
        this.canProgress = this.nbt.getBoolean("canProgress");
        this.neverDissipate = this.nbt.getBoolean("neverDissipate");
        this.alwaysProgresses = this.nbt.getBoolean("alwaysProgresses");
        this.overrideAngle = this.nbt.getBoolean("overrideAngle");
        this.overrideMotion = this.nbt.getBoolean("overrideMotion");
        this.maxRevives = this.nbt.getInteger("maxRevives");
    }

    @Override
    public CachedNBTTagCompound writeToNBT() {
        super.writeToNBT();
        this.nbt.setBoolean("attrib_waterSpout", this.isSpout);
        this.nbt.setInteger("currentTopYBlock", this.currentTopYBlock);
        this.nbt.setFloat("levelTemperature", this.temperature);
        this.nbt.setFloat("levelWater", this.rain);
        this.nbt.setFloat("hail", this.hail);
        this.nbt.setFloat("hailRate", this.hailRate);
        this.nbt.setInteger("layer", this.layer);
        this.nbt.setInteger("levelCurIntensityStage", this.stage);
        this.nbt.setFloat("levelCurStagesIntensity", this.intensity);
        this.nbt.setFloat("intensityRate", this.intensityRate);
        this.nbt.setFloat("levelStormIntensityMax", this.stageMax);
        this.nbt.setFloat("levelCurStageSize", this.funnelSize);
        this.nbt.setFloat("levelCurStageWind", this.windSpeed);
        this.nbt.setFloat("levelCurStageSizeRate", this.sizeRate);
        this.nbt.setInteger("stormType", this.stormType);
        this.nbt.setString("stormName", this.name);
        this.nbt.setFloat("lightning", this.lightning);
        this.nbt.setBoolean("isViolent", this.isViolent);
        this.nbt.setBoolean("shouldConvert", this.shouldConvert);
        this.nbt.setBoolean("shouldBuildHumidity", this.shouldBuildHumidity);
        this.nbt.setBoolean("isFirenado", this.isFirenado);
        this.nbt.setBoolean("canProgress", this.canProgress);
        this.nbt.setBoolean("neverDissipate", this.neverDissipate);
        this.nbt.setBoolean("alwaysProgresses", this.alwaysProgresses);
        this.nbt.setBoolean("overrideAngle", this.overrideAngle);
        this.nbt.setBoolean("overrideMotion", this.overrideMotion);
        this.nbt.setInteger("maxRevives", this.maxRevives);
        return this.nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tickRender(float partialTick) {
        super.tickRender(partialTick);
    }

    @Override
    public void tick() {
        super.tick();
        this.posGround = new Maths.Vec3(this.pos.posX, this.pos.posY, this.pos.posZ);
        this.posGround.posY = this.currentTopYBlock;
        if (this.manager.getWorld().field_72995_K) {
            if (!WeatherUtil.isPaused()) {
                this.tickClient();
                if (this.isDeadly()) {
                    this.tornadoHelper.tick(this.manager.getWorld());
                }
                this.tickMovementClient();
            }
        } else {
            if (this.isDeadly()) {
                this.tornadoHelper.tick(this.manager.getWorld());
            }
            this.tickMovement();
            this.tickWeatherEvents();
            this.tickProgressionNormal();
            this.tickSnowFall();
        }
        if (this.layer == 0) {
            this.pos_funnel_base = new Maths.Vec3(this.pos.posX, this.pos.posY, this.pos.posZ);
            if (this.stage >= WeatherEnum.Stage.TORNADO.getStage()) {
                if (this.stage > WeatherEnum.Stage.TORNADO.getStage()) {
                    this.formingStrength = 1.0f;
                    this.pos_funnel_base.posY = this.posGround.posY;
                } else {
                    float val;
                    float intensityAdj = Math.min(1.0f, this.intensity - (float)WeatherEnum.Stage.SEVERE.getStage());
                    this.formingStrength = val = (float)this.stage + intensityAdj - (float)WeatherEnum.Stage.TORNADO.getStage();
                    double yDiff = this.pos.posY - this.posGround.posY;
                    this.pos_funnel_base.posY = this.pos.posY - yDiff * (double)this.formingStrength;
                }
            } else if (this.stage == WeatherEnum.Stage.SEVERE.getStage()) {
                this.formingStrength = 0.0f;
                this.pos_funnel_base.posY = this.posGround.posY;
            } else {
                this.formingStrength = 0.0f;
                this.pos_funnel_base.posY = this.pos.posY;
            }
        }
    }

    public void tickMovement() {
        if (this.front.equals(this.manager.getGlobalFront())) {
            if (!this.overrideAngle) {
                Random rand = new Random();
                this.angle += (rand.nextFloat() - rand.nextFloat()) * 0.15f;
                double scanDist = 50.0;
                double scanX = this.pos.posX + -Maths.fastSin(Math.toRadians(this.angle)) * scanDist;
                double scanZ = this.pos.posZ + Maths.fastCos(Math.toRadians(this.angle)) * scanDist;
                int height = WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), new BlockPos(scanX, 0.0, scanZ)).func_177956_o();
                if (this.pos.posY < (double)height) {
                    float angleAdj = 45.0f;
                    this.angle += angleAdj;
                }
            }
            if (!this.overrideMotion) {
                double vecX = -Maths.fastSin(Math.toRadians(this.angle));
                double vecZ = Maths.fastCos(Math.toRadians(this.angle));
                float cloudSpeedAmp = 0.2f;
                float finalSpeed = this.stage > WeatherEnum.Stage.SEVERE.getStage() + 1 ? 0.2f : (this.stage > WeatherEnum.Stage.NORMAL.getStage() ? 0.05f : this.getSpeed() * cloudSpeedAmp);
                if (this.stage > WeatherEnum.Stage.SEVERE.getStage() + 1) {
                    finalSpeed /= (float)(this.stage - WeatherEnum.Stage.TORNADO.getStage()) + 1.0f;
                }
                this.motion.posX = vecX * (double)finalSpeed;
                this.motion.posZ = vecZ * (double)finalSpeed;
            }
            this.pos.posX += this.motion.posX;
            this.pos.posZ += this.motion.posZ;
        } else {
            if (!this.overrideMotion) {
                this.motion = this.front.motion;
            }
            this.pos.posX += this.motion.posX;
            this.pos.posZ += this.motion.posZ;
        }
    }

    public void tickMovementClient() {
        this.pos.posX += this.motion.posX;
        this.pos.posZ += this.motion.posZ;
    }

    public void tickWeatherEvents() {
        World world = this.manager.getWorld();
        int amount = (int)Maths.clamp((float)ConfigStorm.hail_stones_per_tick * this.hail * 1.0E-4f, 1.0f, (float)ConfigStorm.hail_stones_per_tick);
        this.currentTopYBlock = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(MathHelper.func_76128_c((double)this.pos.posX), 0, MathHelper.func_76128_c((double)this.pos.posZ))).func_177956_o();
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            int z;
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(Maths.random(0, world.field_73010_i.size() - 1));
            if (!(this.pos.distanceSq(player.field_70165_t, this.pos.posY, player.field_70161_v) < (double)this.size)) continue;
            if (this.isHailing()) {
                for (int ii = 0; ii < amount; ++ii) {
                    int x = (int)(player.field_70165_t + (double)Maths.random(-128, 128));
                    int z2 = (int)(player.field_70161_v + (double)Maths.random(-128, 128));
                    if (!world.func_175667_e(new BlockPos(x, this.getLayerHeight(), z2))) continue;
                    EntityIceBall hail = new EntityIceBall(world);
                    hail.func_70107_b(x, this.getLayerHeight(), z2);
                    world.func_72838_d((Entity)hail);
                }
            }
            if (this.stage <= WeatherEnum.Stage.RAIN.getStage() || Maths.random(0, ConfigStorm.lightning_bolt_1_in_x - (int)((float)ConfigStorm.lightning_bolt_1_in_x * this.lightning)) != 0) continue;
            int x = (int)(player.field_70165_t + (double)Maths.random(-ConfigStorm.max_lightning_bolt_distance, ConfigStorm.max_lightning_bolt_distance));
            if (world.func_175667_e(new BlockPos(x, 0, z = (int)(player.field_70161_v + (double)Maths.random(-ConfigStorm.max_lightning_bolt_distance, ConfigStorm.max_lightning_bolt_distance))))) {
                this.addWeatherEffectLightning(new EntityLightningBolt(world, x, world.func_175725_q(new BlockPos(x, 0, z)).func_177956_o(), z), false);
                continue;
            }
            PacketLightning.spawnInvisibleLightning(this.manager.getDimension(), x, this.getLayerHeight(), z);
        }
        this.trackAndExtinguishEntities();
    }

    public void trackAndExtinguishEntities() {
        if (ConfigStorm.storm_rain_extinguish_delay <= 0) {
            return;
        }
        if (this.isRaining() && this.manager.getWorld().func_82737_E() % (long)ConfigStorm.storm_rain_extinguish_delay == 0L) {
            BlockPos posBP = new BlockPos(this.posGround.posX, this.posGround.posY, this.posGround.posZ);
            List listEnts = this.manager.getWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(posBP).func_186662_g((double)this.size));
            for (EntityLivingBase ent : listEnts) {
                if (!ent.field_70170_p.func_175710_j(ent.func_180425_c())) continue;
                ent.func_70066_B();
            }
        }
    }

    public void tickSnowFall() {
        if (!ConfigSnow.Snow_PerformSnowfall || !this.hasDownfall()) {
            return;
        }
        World world = this.manager.getWorld();
        int xx = 0;
        int zz = 0;
        xx = (int)(this.pos.posX - (double)(this.size / 2));
        while ((double)xx < this.pos.posX + (double)(this.size / 2)) {
            zz = (int)(this.pos.posZ - (double)(this.size / 2));
            while ((double)zz < this.pos.posZ + (double)(this.size / 2)) {
                Chunk chunk;
                int chunkX = xx / 16;
                int x = chunkX * 16;
                int chunkZ = zz / 16;
                int z = chunkZ * 16;
                if (world.func_175667_e(new BlockPos(x, 128, z)) && world.field_73011_w.canDoRainSnowIce(chunk = world.func_72964_e(chunkX, chunkZ)) && (ConfigSnow.Snow_RarityOfBuildup == 0 || world.field_73012_v.nextInt(ConfigSnow.Snow_RarityOfBuildup) == 0)) {
                    boolean betterBuildup;
                    int setBlockHeight;
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int i1 = this.updateLCG >> 2;
                    int xxx = i1 & 0xF;
                    double d0 = this.pos.posX - (double)(xx + xxx);
                    int zzz = i1 >> 8 & 0xF;
                    double d2 = this.pos.posZ - (double)(zz + zzz);
                    if (!((double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) > (double)this.size) && this.canSnowAtBody(xxx + x, setBlockHeight = world.func_175725_q(new BlockPos(xxx + x, 0, zzz + z)).func_177956_o(), zzz + z) && Blocks.field_150433_aE.func_176196_c(world, new BlockPos(xxx + x, setBlockHeight, zzz + z)) && (betterBuildup = true)) {
                        WindManager windMan = this.manager.windManager;
                        float angle = windMan.windAngle;
                        Maths.Vec3 vecPos = new Maths.Vec3(xxx + x, setBlockHeight, zzz + z);
                        if (world.func_175667_e(vecPos.toBlockPos())) {
                            if (!ConfigMisc.overcast_mode && world.func_175623_d(vecPos.toBlockPos())) {
                                world.func_175656_a(vecPos.toBlockPos(), Blocks.field_150431_aC.func_176223_P());
                            }
                            WeatherUtilBlock.fillAgainstWallSmoothly(world, vecPos, angle, 15.0f, 2.0f, Blocks.field_150431_aC);
                        }
                    }
                }
                zz += 16;
            }
            xx += 16;
        }
    }

    public ChunkCoordinatesBlock getSnowfallEvenOutAdjustCheck(int x, int y, int z, int sourceMeta) {
        ChunkCoordinatesBlock attempt = this.getSnowfallEvenOutAdjust(x - 1, y, z, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x + 1, y, z, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x, y, z - 1, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x, y, z + 1, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
    }

    public ChunkCoordinatesBlock getSnowfallEvenOutAdjust(int x, int y, int z, int sourceMeta) {
        World world = this.manager.getWorld();
        Block checkID = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (CoroUtilBlock.isAir((Block)checkID)) {
            Block checkID2 = world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            if (CoroUtilBlock.isAir((Block)checkID2)) {
                return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
            }
            return new ChunkCoordinatesBlock(x, y, z, Blocks.field_150350_a, 0);
        }
        if (checkID == Blocks.field_150433_aE) {
            IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
            int checkMeta = state.func_177230_c().func_176201_c(state);
            if (checkMeta < sourceMeta) {
                return new ChunkCoordinatesBlock(x, y, z, checkID, checkMeta);
            }
        } else {
            return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
        }
        return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
    }

    public boolean canSnowAtBody(int par1, int par2, int par3) {
        IBlockState iblockstate1;
        World world = this.manager.getWorld();
        Biome biomegenbase = world.func_180494_b(new BlockPos(par1, 0, par3));
        BlockPos pos = new BlockPos(par1, par2, par3);
        if (biomegenbase == null) {
            return false;
        }
        float temperature = WeatherUtil.getTemperature(world, pos);
        if (temperature > 0.15f) {
            return false;
        }
        return par2 >= 0 && par2 < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && ((iblockstate1 = Weather2.getChunkUtil(world).getBlockState(world, pos)).func_177230_c().isAir(iblockstate1, (IBlockAccess)world, pos) || iblockstate1.func_177230_c() == Blocks.field_150431_aC) && Blocks.field_150431_aC.func_176196_c(world, pos);
    }

    public void tickProgressionNormal() {
        World world = this.manager.getWorld();
        if (this.ticks % (long)ConfigStorm.storm_tick_delay == 0L) {
            Biome biome = world.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)this.pos.posX), 0, MathHelper.func_76128_c((double)this.pos.posZ)));
            float tempAdjustRate = (float)ConfigStorm.temperature_adjust_rate;
            boolean hasOcean = false;
            if (this.stage > WeatherEnum.Stage.TORNADO.getStage() || this.stormType == StormType.WATER.ordinal() && this.stage > WeatherEnum.Stage.TROPICAL_DEPRESSION.getStage()) {
                this.funnelSize = (float)Math.min(Math.pow((this.intensity - 3.0f) * 14.0f, ConfigStorm.storm_size_curve_mult) * (double)(this.stormType == StormType.LAND.ordinal() ? this.sizeRate : this.sizeRate * 1.5f), (double)ConfigStorm.max_storm_size);
            } else if (this.funnelSize != 14.0f) {
                this.funnelSize = 14.0f;
            }
            this.size = (int)Maths.clamp((this.funnelSize + (float)ConfigStorm.min_storm_size) * (this.stormType == StormType.LAND.ordinal() ? 1.5f : 3.0f), (float)ConfigStorm.min_storm_size, (float)ConfigStorm.max_storm_size);
            this.windSpeed = Math.max(6.73f + (this.stormType == StormType.WATER.ordinal() ? 1.7f : 2.8f) * (this.intensity - 3.0f), 0.0f);
            if (biome != null) {
                hasOcean = biome.field_76791_y.toLowerCase().contains("ocean");
                float biomeTempAdj = this.getTemperatureMCToWeatherSys(CoroUtilCompatibility.getAdjustedTemperature((World)this.manager.getWorld(), (Biome)biome, (BlockPos)new BlockPos(MathHelper.func_76128_c((double)this.pos.posX), 64, MathHelper.func_76128_c((double)this.pos.posZ))));
                if (this.temperature > biomeTempAdj) {
                    this.temperature -= tempAdjustRate;
                } else if (this.temperature < biomeTempAdj) {
                    this.temperature += tempAdjustRate;
                }
            }
            IBlockState blockID = world.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.pos.posX), this.currentTopYBlock - 1, MathHelper.func_76128_c((double)this.pos.posZ)));
            boolean hasWater = blockID.func_185904_a() instanceof MaterialLiquid;
            if (this.isStorm()) {
                boolean intensify;
                if (this.shouldBuildHumidity) {
                    if (!this.isDying) {
                        this.rain += (float)ConfigStorm.humidity_buildup_rate * WeatherUtil.getHumidity(world, this.pos.toBlockPos());
                        if (this.hailRate > 0.0f && this.hailRate < 200.0f) {
                            this.hail += this.hailRate * WeatherUtil.getHumidity(world, this.pos.toBlockPos()) * 2.5f;
                        }
                    } else {
                        if (this.rain > 0.0f) {
                            this.rain -= (float)ConfigStorm.humidity_spend_rate * WeatherUtil.getHumidity(world, this.pos.toBlockPos());
                        }
                        if (this.hailRate > 0.0f) {
                            this.hail -= this.hailRate * WeatherUtil.getHumidity(world, this.pos.toBlockPos()) * 2.0f;
                        }
                    }
                    if (this.stage < WeatherEnum.Stage.SEVERE.getStage() && this.hail > 125.0f) {
                        this.hail = 125.0f;
                    }
                    if (this.rain < 0.0f) {
                        Weather2.debug("Storm " + this.getUUID().toString() + " has stopped raining");
                        this.rain = 0.0f;
                        this.shouldBuildHumidity = false;
                    }
                }
                if (this.rain < 100.0f && this.stage > 0) {
                    this.rain = 100.0f;
                }
                if (!this.isDying) {
                    if (ConfigMisc.overcast_mode && this.isNatural && !this.neverDissipate && !this.manager.getWorld().func_72896_J()) {
                        Weather2.debug("Storm " + this.getUUID().toString() + " was forced to dissipate because of overcast mode at stage " + this.stage + " and is now dying");
                        this.isDying = true;
                    } else if (ConfigStorm.disable_tornados && this.stormType == StormType.LAND.ordinal() || ConfigStorm.disable_cyclones && this.stormType == StormType.WATER.ordinal()) {
                        Weather2.debug("Storm " + this.getUUID().toString() + " was forced to dissipate because it was disabled at stage " + this.stage + " and is now dying");
                        this.isDying = true;
                    }
                }
                if (this.stage == WeatherEnum.Stage.SEVERE.getStage() && hasWater) {
                    if (ConfigStorm.high_wind_waterspout_10_in_x != 0 && Maths.random(ConfigStorm.high_wind_waterspout_10_in_x) == 0) {
                        this.isSpout = true;
                    }
                } else {
                    this.isSpout = false;
                }
                float intensityRate = this.isDeadly() ? this.intensityRate : 0.03f;
                boolean bl = intensify = this.intensity - (float)(this.stage - 1) > 1.0f;
                if (this.stage >= WeatherEnum.Stage.TORNADO.getStage()) {
                    intensityRate *= 3.0f;
                }
                if (!this.isDying) {
                    if (this.neverDissipate && (!intensify && this.stage <= this.stageMax || this.alwaysProgresses) || !this.neverDissipate) {
                        this.intensity += intensityRate;
                    }
                    if (intensify && (this.stage < this.stageMax || this.alwaysProgresses)) {
                        this.stageNext();
                        Weather2.debug("Storm " + this.getUUID().toString() + " has intensified to stage " + this.stage);
                        if (ConfigStorm.storms_aim_at_player && this.front.isGlobal() && this.stage == WeatherEnum.Stage.TORNADO.getStage()) {
                            this.lightning = Math.max(Maths.random(0.01f, 0.95f), this.lightning);
                            this.aimStormAtPlayer(null);
                        }
                        if (this.shouldConvert && !ConfigStorm.disable_cyclones && (this.stage < WeatherEnum.Stage.SEVERE.getStage() && hasOcean || ConfigStorm.disable_tornados)) {
                            Weather2.debug("Storm " + this.getUUID().toString() + " was converted into a tropical cyclone");
                            this.lightning = Maths.random(0.01f, 0.3f);
                            this.stormType = StormType.WATER.ordinal();
                            this.updateType();
                        }
                    } else if (!this.neverDissipate && !this.alwaysProgresses && this.stage >= this.stageMax && intensify) {
                        Weather2.debug("Storm " + this.getUUID().toString() + " has peaked at stage " + this.stage + " and is now dying");
                        this.isDying = true;
                    }
                } else {
                    this.intensity = ConfigMisc.overcast_mode && this.manager.getWorld().func_72896_J() ? (this.intensity -= intensityRate * 0.5f) : (this.intensity -= intensityRate * 0.2f);
                    if (this.intensity - (float)(this.stage - 1) <= 0.0f) {
                        this.stagePrev();
                        Weather2.debug("Storm " + this.getUUID().toString() + " has weakened to stage " + this.stage);
                        if (this.stage == 2 && this.revives < this.maxRevives) {
                            this.isDying = false;
                            ++this.revives;
                            this.resetStorm();
                        } else if (this.stage <= 0) {
                            this.setNoStorm();
                        }
                    }
                }
            }
        }
    }

    public WeatherEntityConfig getWeatherEntityConfigForStorm() {
        return WeatherTypes.weatherEntTypes.get(Maths.clamp(this.stage - WeatherEnum.Stage.TORNADO.getStage(), 0, 6));
    }

    public void updateType() {
        switch (this.stage) {
            case 0: {
                this.type = WeatherEnum.Type.CLOUD;
                break;
            }
            case 1: {
                this.type = WeatherEnum.Type.RAIN;
                break;
            }
            case 2: {
                if (this.stormType == 1) {
                    this.type = WeatherEnum.Type.TROPICAL_DISTURBANCE;
                    break;
                }
                this.type = WeatherEnum.Type.THUNDER;
                break;
            }
            case 3: {
                if (this.stormType == 1) {
                    this.type = WeatherEnum.Type.TROPICAL_DEPRESSION;
                    break;
                }
                this.type = WeatherEnum.Type.SUPERCELL;
                break;
            }
            default: {
                this.type = this.stormType == 1 ? (this.stage == WeatherEnum.Stage.TROPICAL_STORM.getStage() ? WeatherEnum.Type.TROPICAL_STORM : WeatherEnum.Type.HURRICANE) : WeatherEnum.Type.TORNADO;
            }
        }
        if (this.stormType == 1 && this.name.length() == 0) {
            this.name = StormNames.get();
        }
    }

    public void stageNext() {
        ++this.stage;
        this.updateType();
    }

    public void stagePrev() {
        --this.stage;
        this.updateType();
    }

    public void resetStorm() {
        this.shouldBuildHumidity = true;
        this.sizeRate = Maths.random(0.75f, 1.35f);
        this.isViolent = Maths.chance(ConfigStorm.chance_for_violent_storm * 0.01 * 0.25);
        this.stageMax = Math.max(this.rollDiceOnMaxIntensity(), WeatherEnum.Stage.TORNADO.getStage());
        this.intensityRate = Maths.random(ConfigStorm.storm_lifespan_min <= 0.0 ? 0.003f : (float)ConfigStorm.storm_lifespan_min, ConfigStorm.storm_lifespan_max <= 0.0 ? 0.06f : (float)ConfigStorm.storm_lifespan_max);
        Biome biome = this.world.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)this.pos.posX), 0, MathHelper.func_76128_c((double)this.pos.posZ)));
        if (this.shouldConvert) {
            int n = this.stormType = biome != null && biome.field_76791_y.toLowerCase().contains("ocean") ? StormType.WATER.ordinal() : StormType.LAND.ordinal();
        }
        if (this.isViolent) {
            this.sizeRate += Maths.random(0.25f, 1.65f);
            if (this.stageMax < 9) {
                ++this.stageMax;
            }
        }
        this.updateType();
        Weather2.debug("Revived Into Deadly Storm: \nIs Violent: " + this.isViolent + "\nMax Stage: " + this.stageMax + " (EF" + (this.stageMax - 4) + ")\nSize Multiplier: " + this.sizeRate * 100.0f + "%");
    }

    public void initRealStorm() {
        this.shouldBuildHumidity = true;
        if (this.stage != WeatherEnum.Stage.RAIN.getStage()) {
            this.stage = WeatherEnum.Stage.RAIN.getStage();
            this.intensity = 0.0f;
        }
        this.lightning = Maths.random(0.01f, 0.5f);
        if (this.stageMax < 1) {
            this.stageMax = this.rollDiceOnMaxIntensity();
        }
        if (this.sizeRate < 0.0f) {
            this.sizeRate = (float)Maths.random(ConfigStorm.min_size_growth, ConfigStorm.max_size_growth);
        }
        if (this.isViolent || Maths.chance(ConfigStorm.chance_for_violent_storm / 100.0)) {
            this.isViolent = true;
            this.sizeRate = (float)((double)this.sizeRate + Maths.random(ConfigStorm.min_violent_size_growth, ConfigStorm.max_violent_size_growth));
            if (this.stageMax < WeatherEnum.Stage.TORNADO.getStage() + 4) {
                ++this.stageMax;
            }
        }
        while (Maths.chance(ConfigStorm.chance_for_storm_revival * 0.01) && this.revives < ConfigStorm.max_storm_revives) {
            ++this.revives;
        }
        if (Maths.chance(ConfigStorm.chance_for_hail * 0.01)) {
            this.hailRate = (float)Maths.random(ConfigStorm.hail_max_buildup_rate);
        }
        if (this.stageMax > WeatherEnum.Stage.SEVERE.getStage()) {
            this.intensityRate = Maths.random(ConfigStorm.storm_lifespan_min <= 0.0 ? 0.003f : (float)ConfigStorm.storm_lifespan_min, ConfigStorm.storm_lifespan_max <= 0.0 ? 0.06f : (float)ConfigStorm.storm_lifespan_max);
            Weather2.debug("New Deadly Storm: \nIs Violent: " + this.isViolent + "\nMax Stage: " + this.stageMax + " (EF" + (this.stageMax - 4) + ")\nSize Multiplier: " + this.sizeRate * 100.0f + "%\nLifespan Multiplier: " + this.intensityRate * 100.0f);
        } else {
            Weather2.debug("New Normal Storm: \nIs Violent: " + this.isViolent + "\nMax Stage: " + this.stageMax + "\nSize Multiplier: " + this.sizeRate * 100.0f + "%");
        }
        this.canProgress = true;
        this.updateType();
    }

    public int rollDiceOnMaxIntensity() {
        if (!Maths.chance(ConfigStorm.chance_for_thunderstorm * 0.01)) {
            return WeatherEnum.Stage.RAIN.getStage();
        }
        if (!Maths.chance(ConfigStorm.chance_for_supercell * 0.01)) {
            return WeatherEnum.Stage.THUNDER.getStage();
        }
        ConfigList list = new ConfigList();
        if (this.stormType == StormType.LAND.ordinal()) {
            if (!ConfigStorm.disable_tornados) {
                list = WeatherAPI.getTornadoStageList();
            }
        } else if (!ConfigStorm.disable_cyclones) {
            list = WeatherAPI.getHurricaneStageList();
        }
        for (Map.Entry<String, Object[]> entry : list.toMap().entrySet()) {
            String key = entry.getKey();
            if (entry.getValue().length <= 0) continue;
            double value = entry.getValue()[0] instanceof String && ((String)entry.getValue()[0]).matches("^[\\d\\.]+$") ? Double.parseDouble((String)entry.getValue()[0]) : (entry.getValue()[0] instanceof Double ? (Double)entry.getValue()[0] : 0.0);
            boolean chance = Maths.chance(value * 0.01);
            if (!key.matches("^\\d+$") || !chance) continue;
            return Integer.parseInt(key) + 4;
        }
        return WeatherEnum.Stage.SEVERE.getStage();
    }

    public void setNoStorm() {
        Weather2.debug("Storm " + this.getUUID().toString() + " was terminated");
        this.stage = WeatherEnum.Stage.NORMAL.getStage();
        this.intensity = 0.0f;
        this.isDead = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        ResourceLocation id;
        double spinSpeedMax = 0.4;
        this.spin = Math.min(spinSpeedMax, Math.max(0.007 * (double)this.stage, 0.03));
        if (this.stormType == StormType.WATER.ordinal()) {
            this.spin += 0.025;
        }
        if (this.size == 0) {
            this.size = 1;
        }
        if (this.particleRendererId != (id = WeatherAPI.getParticleRendererId())) {
            if (this.particleRenderer != null) {
                this.particleRenderer.cleanup();
                this.particleRenderer = null;
            }
            this.particleRendererId = id;
            this.particleRenderer = WeatherAPI.getParticleRenderer(this);
        }
        if (this.particleRenderer != null) {
            this.particleRenderer.tick();
        }
    }

    @Override
    public float getSpeed() {
        return this.overrideMotion ? (float)this.motion.speedSq() : this.manager.windManager.windSpeed;
    }

    @Override
    public float getAngle() {
        if (this.overrideAngle) {
            return this.angle;
        }
        float angle = this.manager.windManager.windAngle;
        float angleAdjust = Math.max(10.0f, Math.min(45.0f, 45.0f * this.temperature * 0.2f));
        float targetYaw = 0.0f;
        targetYaw = this.temperature > 0.0f ? 180.0f : 0.0f;
        float bestMove = Maths.wrapDegrees(targetYaw - angle);
        if (Math.abs(bestMove) < 180.0f) {
            if (bestMove > 0.0f) {
                angle -= angleAdjust;
            }
            if (bestMove < 0.0f) {
                angle += angleAdjust;
            }
        }
        return angle;
    }

    public float getAvoidAngleIfTerrainAtOrAheadOfPosition(float angle, Maths.Vec3 pos) {
        double scanDistMax = 120.0;
        for (int scanAngle = -20; scanAngle < 20; scanAngle += 10) {
            for (double scanDistRange = 20.0; scanDistRange < scanDistMax; scanDistRange += 10.0) {
                double scanX = pos.posX + -Maths.fastSin(Math.toRadians(angle + (float)scanAngle)) * scanDistRange;
                double scanZ = pos.posZ + Maths.fastCos(Math.toRadians(angle + (float)scanAngle)) * scanDistRange;
                int height = WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), new BlockPos(scanX, 0.0, scanZ)).func_177956_o();
                if (!(pos.posY < (double)height)) continue;
                if (scanAngle <= 0) {
                    return 90.0f;
                }
                return -90.0f;
            }
        }
        return 0.0f;
    }

    public void spinEntity(Object obj) {
        float f;
        float weight = WeatherUtilEntity.getWeight(obj);
        if (weight < 0.0f) {
            return;
        }
        WeatherEntityConfig conf = this.getWeatherEntityConfigForStorm();
        float heightMult = (float)this.getLayerHeight() * (this.world.field_72995_K && obj instanceof Particle ? 0.004f : 0.0034f);
        float rotationMult = heightMult * 0.5f * ((this.isViolent ? 3.1f : 1.55f) + Math.min(((float)this.stage - 5.0f) / 3.0f, 2.0f));
        World world = CoroUtilEntOrParticle.getWorld((Object)obj);
        long worldTime = world.func_82737_E();
        Entity ent = null;
        if (obj instanceof Entity) {
            ent = (Entity)obj;
        }
        double radius = 10.0;
        double scale = (double)conf.tornadoWidthScale * (world.field_72995_K && obj instanceof Particle ? 1.0 : 8.0);
        double d1 = this.pos.posX - CoroUtilEntOrParticle.getPosX((Object)obj);
        double d2 = this.pos.posZ - CoroUtilEntOrParticle.getPosZ((Object)obj);
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT) {
            float range = 30.0f * (float)Maths.fastSin(Math.toRadians((float)worldTime * 0.5f % 360.0f));
            float heightPercent = (float)(1.0 - (CoroUtilEntOrParticle.getPosY((Object)obj) - this.posGround.posY) / (this.pos.posY - this.posGround.posY));
            float posOffsetX = (float)Maths.fastSin(Math.toRadians(heightPercent * 360.0f));
            float posOffsetZ = (float)(-Maths.fastCos(Math.toRadians(heightPercent * 360.0f)));
            d1 += (double)(range * posOffsetX);
            d2 += (double)(range * posOffsetZ);
        }
        for (f = (float)(Maths.fastATan2(d2, d1) * 180.0 / Math.PI) - 90.0f; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        double distY = this.pos.posY - CoroUtilEntOrParticle.getPosY((Object)obj);
        double distXZ = Math.sqrt(Math.abs(d1)) + Math.sqrt(Math.abs(d2));
        distY = CoroUtilEntOrParticle.getPosY((Object)obj) - this.pos.posY < 0.0 ? 1.0 : CoroUtilEntOrParticle.getPosY((Object)obj) - this.pos.posY;
        if (distY > (double)this.maxHeight) {
            distY = this.maxHeight;
        }
        double grab = 10.0 / (double)weight * (Math.abs((double)this.maxHeight - distY) / (double)this.maxHeight);
        float pullY = 0.0f;
        if (distXZ > 5.0) {
            grab *= radius / distXZ;
        }
        pullY += conf.tornadoLiftRate / (weight * 0.5f);
        double adjPull = 0.005 / ((double)weight * ((distXZ + 1.0) / radius));
        double airTime = 0.0;
        pullY = (float)((double)pullY + adjPull);
        if (obj instanceof EntityPlayer) {
            airTime = (double)WeatherUtilEntity.playerInAirTime + 1.0;
            if (CoroUtilEntOrParticle.getMotionY((Object)obj) > 0.0) {
                ent.field_70143_R = 0.0f;
            }
        } else if (obj instanceof EntityLivingBase) {
            airTime = (double)ent.getEntityData().func_74762_e("timeInAir") + 1.0;
            if (ent.field_70181_x > 0.0) {
                ent.field_70143_R = 0.0f;
            }
            ent.field_70122_E = false;
        }
        if (airTime > 0.0) {
            grab -= Maths.clamp(10.0 * (double)((float)(airTime / 400.0)), -50.0, 50.0);
        }
        double profileAngle = Math.max(1.0, 75.0 + (grab += (double)conf.relTornadoSize) - 10.0 * scale);
        f = (float)((double)f + profileAngle);
        float f3 = (float)Maths.fastCos(-f * 0.01745329f - (float)Math.PI);
        float f4 = (float)Maths.fastSin(-f * 0.01745329f - (float)Math.PI);
        float f5 = conf.tornadoPullRate * 1.5f;
        if (conf.type != 0 && obj instanceof EntityLivingBase) {
            f5 *= ent.field_70122_E ? 2.0f : 7.0f;
        }
        if (obj instanceof EntityLivingBase) {
            switch (conf.type) {
                case 0: {
                    f5 *= 0.3f;
                    break;
                }
                case 2: {
                    f5 *= 4.0f;
                }
            }
        }
        float moveX = f3 * f5;
        float moveZ = f4 * f5;
        float str = this.strength * 1.25f;
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT) {
            str *= 0.3f;
        }
        if (this.stormType == StormType.WATER.ordinal()) {
            str *= 0.55f;
            pullY = Math.min(pullY, 0.0275f);
        }
        pullY = world.field_72995_K && obj instanceof Particle ? (pullY *= str * 0.01f) : (pullY *= str * 0.085f);
        if (obj instanceof Entity) {
            long lastPullTime = ent.getEntityData().func_74763_f("lastPullTime");
            if (lastPullTime == worldTime) {
                pullY = 0.0f;
            }
            ent.getEntityData().func_74772_a("lastPullTime", worldTime);
        }
        this.setVel(obj, -moveX * rotationMult, pullY * heightMult, moveZ * rotationMult);
    }

    public void setVel(Object entity, float f, float f1, float f2) {
        CoroUtilEntOrParticle.setMotionX((Object)entity, (double)(CoroUtilEntOrParticle.getMotionX((Object)entity) + (double)f));
        CoroUtilEntOrParticle.setMotionY((Object)entity, (double)(CoroUtilEntOrParticle.getMotionY((Object)entity) + (double)f1));
        CoroUtilEntOrParticle.setMotionZ((Object)entity, (double)(CoroUtilEntOrParticle.getMotionZ((Object)entity) + (double)f2));
        if (entity instanceof EntitySquid) {
            Entity ent = (Entity)entity;
            ent.func_70107_b(ent.field_70165_t + ent.field_70159_w * 5.0, ent.field_70163_u, ent.field_70161_v + ent.field_70179_y * 5.0);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.tornadoHelper != null) {
            this.tornadoHelper.cleanup();
        }
        this.tornadoHelper = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void cleanupClient(boolean wipe) {
        if (wipe && this.particleRenderer != null) {
            this.particleRenderer.cleanup();
            this.particleRenderer = null;
        }
    }

    public void aimStormAtPlayer(EntityPlayer entP) {
        if (entP == null) {
            entP = this.manager.getWorld().func_184137_a(this.pos.posX, this.pos.posY, this.pos.posZ, -1.0, false);
        }
        if (entP != null) {
            float yaw = -((float)(Maths.fastATan2(entP.field_70165_t - this.pos.posX, entP.field_70161_v - this.pos.posZ) * 180.0 / Math.PI));
            int size = ConfigStorm.storm_aim_accuracy_in_angle;
            if (size > 0) {
                yaw += (float)(Maths.random(size) - size / 2);
            }
            this.overrideAngle = true;
            this.angle = yaw;
            Weather2.debug("Storm " + this.getUUID() + " was aimed at player " + CoroUtilEntity.getName((Entity)entP));
        }
    }

    public float getTemperatureMCToWeatherSys(float parOrigVal) {
        return parOrigVal - 0.3f;
    }

    public void addWeatherEffectLightning(EntityLightningBolt parEnt, boolean custom) {
        this.manager.getWorld().field_73007_j.add(parEnt);
        PacketLightning.spawnLightning(this.manager.getDimension(), (Entity)parEnt, custom);
    }

    @Override
    public int getNetRate() {
        if (this.stage >= WeatherEnum.Stage.SEVERE.getStage()) {
            return 2;
        }
        return super.getNetRate();
    }

    public void setAngle(float angle) {
        this.overrideAngle = true;
        this.angle = angle % 360.0f;
    }

    public void setSpeed(float speed) {
        this.overrideMotion = true;
        this.motion.posX = -Maths.fastSin(Math.toRadians(this.angle)) * (double)speed;
        this.motion.posZ = Maths.fastCos(Math.toRadians(this.angle)) * (double)speed;
    }

    @Override
    public void setStage(int stage) {
        this.stage = stage;
        this.updateType();
    }

    public boolean isDrizzling() {
        return this.rain >= 100.0f && this.rain < 200.0f;
    }

    public boolean isRaining() {
        return this.rain >= 200.0f;
    }

    @Override
    public boolean hasDownfall() {
        return this.rain >= 100.0f;
    }

    @Override
    public int getStage() {
        return this.stage;
    }

    @Override
    public int getLayer() {
        return this.layer;
    }

    @Override
    public int getLayerHeight() {
        switch (this.layer) {
            case 1: {
                return ConfigStorm.cloud_layer_1_height;
            }
            case 2: {
                return ConfigStorm.cloud_layer_2_height;
            }
        }
        return ConfigStorm.cloud_layer_0_height;
    }

    public boolean isHailing() {
        return this.hail > 100.0f;
    }

    @Override
    public float getDownfall() {
        return this.rain;
    }

    @Override
    public float getDownfall(Maths.Vec3 pos) {
        return this.rain;
    }

    @Override
    public float getDownfall(BlockPos pos) {
        return this.rain;
    }

    @Override
    public boolean hasDownfall(Maths.Vec3 pos) {
        return this.hasDownfall();
    }

    @Override
    public boolean hasDownfall(BlockPos pos) {
        return this.hasDownfall();
    }

    @Override
    public float getWindSpeed() {
        return this.windSpeed;
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean getEF) {
        boolean truth = this.name.length() == 0;
        boolean isHailing = this.isHailing();
        switch (this.type) {
            case CLOUD: {
                return (truth ? "" : this.name + " ") + (isHailing ? "Hailing " : "") + "Cloud";
            }
            case RAIN: {
                return (truth ? "" : this.name + " ") + (isHailing ? "Hailing " : "") + (this.hasDownfall() ? (this.temperature <= 0.0f ? "Snowstorm" : "Rainstorm") : "Cloud");
            }
            case THUNDER: {
                return (truth ? "" : this.name + " ") + (isHailing ? "Hailing " : "") + "Thunderstorm";
            }
            case SUPERCELL: {
                return (truth ? "" : this.name + " ") + (isHailing ? "Hailing " : "") + "Supercell";
            }
            case TROPICAL_DISTURBANCE: {
                return (isHailing ? "Hailing " : "") + "Tropical Disturbance" + (truth ? "" : " " + this.name);
            }
            case TROPICAL_DEPRESSION: {
                return (isHailing ? "Hailing " : "") + "Tropical Depression" + (truth ? "" : " " + this.name);
            }
            case TROPICAL_STORM: {
                return (isHailing ? "Hailing " : "") + "Tropical Storm " + this.name;
            }
            case TORNADO: {
                return (truth ? "" : this.name + " ") + (ConfigStorm.enable_ef_scale || getEF ? "EF" + (this.stage - WeatherEnum.Stage.TORNADO.getStage()) : "F" + (int)Maths.clamp(Math.floor(this.funnelSize * 0.020661157f), 0.0, 2.147483647E9)) + " " + (isHailing ? "Hailing " : "") + "Tornado";
            }
            case HURRICANE: {
                return (isHailing ? "Hailing " : "") + "Hurricane " + this.name + " - Category " + (this.stage - WeatherEnum.Stage.TORNADO.getStage());
            }
        }
        return (isHailing ? "Hailing " : "") + "Unknown Storm";
    }

    @Override
    public String getTypeName() {
        boolean truth = this.name.length() == 0;
        switch (this.type) {
            case TORNADO: {
                return (truth ? "" : this.name + " ") + (ConfigStorm.enable_ef_scale ? "EF" + (this.stage - WeatherEnum.Stage.TORNADO.getStage()) : "F" + (int)Maths.clamp(Math.floor(this.funnelSize * 0.020661157f), 0.0, (double)(this.stageMax - WeatherEnum.Stage.TORNADO.getStage())));
            }
            case HURRICANE: {
                return this.name + " C" + (this.stage - WeatherEnum.Stage.TORNADO.getStage());
            }
            case TROPICAL_DISTURBANCE: {
                return "TD1";
            }
            case TROPICAL_DEPRESSION: {
                return "TD2";
            }
            case TROPICAL_STORM: {
                return "TS";
            }
        }
        return "";
    }

    public static enum StormType {
        LAND,
        WATER;

    }
}

