/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.weather.storm;

import CoroUtil.util.Vec3;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorSandstorm;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.client.entity.particle.ParticleSandstorm;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.config.ConfigSand;
import net.mrbt0907.weather2.registry.BlockRegistry;
import net.mrbt0907.weather2.util.CachedNBTTagCompound;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.util.WeatherUtilBlock;
import net.mrbt0907.weather2.weather.WeatherManager;
import net.mrbt0907.weather2.weather.WindManager;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class SandstormObject
extends WeatherObject {
    public int height = 0;
    public Maths.Vec3 posSpawn = new Maths.Vec3(0, 0, 0);
    public float angle = 0.0f;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesCloud;
    public ParticleBehaviorSandstorm particleBehavior;
    public int age = 0;
    private float maxSize = 100.0f;
    public int sizePeak = 1;
    public int ageFadeout = 0;
    public int ageFadeoutMax = 6000;
    public boolean isFrontGrowing = true;
    public Random rand = new Random();

    public SandstormObject(WeatherManager parManager) {
        super(parManager.getGlobalFront());
        this.type = WeatherEnum.Type.SANDSTORM;
        if (parManager.getWorld().field_72995_K) {
            this.listParticlesCloud = new ArrayList<EntityRotFX>();
        }
    }

    public void initSandstormSpawn(Maths.Vec3 pos) {
        this.pos = pos.copy();
        this.size = 1;
        this.sizePeak = 1;
        this.maxSize = 100.0f;
        World world = this.manager.getWorld();
        int yy = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(pos.posX, 0.0, pos.posZ)).func_177956_o();
        pos.posY = yy;
        this.posGround = pos.copy();
        this.posSpawn = this.pos.copy();
    }

    public float getSandstormScale() {
        if (this.isFrontGrowing) {
            return (float)this.size / this.maxSize;
        }
        return 1.0f - (float)this.ageFadeout / (float)this.ageFadeoutMax;
    }

    public static boolean isDesert(Biome biome) {
        return SandstormObject.isDesert(biome, false);
    }

    public static boolean isDesert(Biome biome, boolean forSpawn) {
        return biome == Biomes.field_76769_d || biome == Biomes.field_76786_s || !forSpawn && biome == Biomes.field_76781_i || biome.field_76791_y.contains("desert") && biome.func_185353_n() >= 2.0f;
    }

    public void tickProgressionAndMovement() {
        World world = this.manager.getWorld();
        WindManager windMan = this.manager.windManager;
        this.angle = windMan.windAngle;
        float speedWind = windMan.windSpeed;
        if (!world.field_72995_K) {
            Biome biomeIn;
            ++this.age;
            BlockPos posBlock = this.pos.toBlockPos();
            this.isFrontGrowing = this.isFrontGrowing && world.func_175667_e(posBlock) ? SandstormObject.isDesert(biomeIn = world.getBiomeForCoordsBody(posBlock)) : false;
            int sizeAdjRate = 10;
            if (this.isFrontGrowing) {
                if (world.func_82737_E() % (long)sizeAdjRate == 0L && (float)this.size < this.maxSize) {
                    ++this.size;
                }
            } else {
                if (world.func_82737_E() % (long)sizeAdjRate == 0L && this.size > 0) {
                    --this.size;
                }
                if (this.ageFadeout < this.ageFadeoutMax) {
                    ++this.ageFadeout;
                } else {
                    this.setDead();
                }
            }
            if (this.size > this.sizePeak) {
                this.sizePeak = this.size;
            }
        }
        double vecX = -Maths.fastSin(Math.toRadians(this.angle));
        double vecZ = Maths.fastCos(Math.toRadians(this.angle));
        double speed = (double)speedWind * 0.3;
        if (this.size > 0) {
            this.pos.posX += vecX * speed;
            this.pos.posZ += vecZ * speed;
        }
        int yy = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(this.pos.posX, 0.0, this.pos.posZ)).func_177956_o();
        this.pos.posY = yy + 1;
    }

    public void tickBlockSandBuildup() {
        World world = this.manager.getWorld();
        WindManager windMan = this.manager.windManager;
        float angle = windMan.windAngle;
        int delay = ConfigSand.buildup_tick_delay;
        int loop = (int)((float)ConfigSand.max_buildup_loop_ammount * this.getSandstormScale());
        int count = 0;
        if (!world.field_72995_K && world.func_82737_E() % (long)delay == 0L) {
            for (int i = 0; i < loop; ++i) {
                if (this.rand.nextDouble() >= (double)this.getSandstormScale()) continue;
                Maths.Vec3 vecPos = this.getRandomPosInSandstorm();
                int y = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(vecPos.posX, 0.0, vecPos.posZ)).func_177956_o();
                vecPos.posY = y;
                if (!world.func_175667_e(vecPos.toBlockPos())) continue;
                Biome biomeIn = world.getBiomeForCoordsBody(vecPos.toBlockPos());
                if (ConfigSand.enable_buildup_outside_desert || SandstormObject.isDesert(biomeIn)) {
                    WeatherUtilBlock.fillAgainstWallSmoothly(world, vecPos, angle, 15.0f, 2.0f, BlockRegistry.sand_layer);
                }
                ++count;
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.manager == null) {
            System.out.println("WeatherManager is null for " + this + ", why!!!");
            return;
        }
        World world = this.manager.getWorld();
        if (world == null) {
            System.out.println("world is null for " + this + ", why!!!");
            return;
        }
        if (WeatherUtil.isPausedSideSafe(world)) {
            return;
        }
        this.tickProgressionAndMovement();
        int yy = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(this.pos.posX, 0.0, this.pos.posZ)).func_177956_o();
        if (world.field_72995_K) {
            this.tickClient();
        }
        if ((double)this.getSandstormScale() > 0.2) {
            this.tickBlockSandBuildup();
        }
        this.posGround.posX = this.pos.posX;
        this.posGround.posY = yy;
        this.posGround.posZ = this.pos.posZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        Minecraft mc = Minecraft.func_71410_x();
        World world = this.manager.getWorld();
        WindManager windMan = this.manager.windManager;
        if (this.particleBehavior == null) {
            this.particleBehavior = new ParticleBehaviorSandstorm(this.pos.toVec3Coro());
        }
        double distBetweenParticles = 3.0;
        Random rand = mc.field_71441_e.field_73012_v;
        this.height = this.size / 4;
        int heightLayers = Math.max(1, this.height / (int)distBetweenParticles);
        double distFromSpawn = this.posSpawn.distanceSq(this.pos);
        double xVec = this.posSpawn.posX - this.pos.posX;
        double zVec = this.posSpawn.posZ - this.pos.posZ;
        double directionAngle = Maths.fastATan2(zVec, xVec);
        double directionAngleDeg = Math.toDegrees(directionAngle);
        int spawnedThisTick = 0;
        float sandstormScale = this.getSandstormScale();
        double sandstormParticleRateDust = ConfigParticle.sandstorm_dust_particle_rate;
        if (this.size > 0) {
            for (int heightLayer = 0; heightLayer < heightLayers && spawnedThisTick < 500; ++heightLayer) {
                double i = directionAngleDeg + rand.nextDouble() * 180.0;
                if (mc.field_71441_e.func_82737_E() % 2L != 0L || rand.nextDouble() >= sandstormParticleRateDust) continue;
                double sizeSub = (double)heightLayer * 2.0;
                double sizeDyn = (double)this.size - sizeSub;
                double inwardsAdj = rand.nextDouble() * 5.0;
                double sizeRand = sizeDyn + -inwardsAdj;
                double x = this.pos.posX + -Maths.fastSin(Math.toRadians(i)) * sizeRand;
                double z = this.pos.posZ + Maths.fastCos(Math.toRadians(i)) * sizeRand;
                double y = this.pos.posY + (double)heightLayer * distBetweenParticles * 2.0;
                TextureAtlasSprite sprite = ParticleRegistry.cloud256;
                if (WeatherUtil.isAprilFoolsDay()) {
                    sprite = ParticleRegistry.chicken;
                }
                ParticleSandstorm part = new ParticleSandstorm((World)mc.field_71441_e, x, y, z, 0.0, 0.0, 0.0, sprite);
                this.particleBehavior.initParticle((EntityRotFX)part);
                part.angleToStorm = i;
                part.distAdj = sizeRand;
                part.heightLayer = heightLayer;
                part.lockPosition = true;
                part.setFacePlayer(false);
                part.isTransparent = true;
                part.rotationYaw = (float)i + (float)rand.nextInt(20) - 10.0f;
                part.rotationPitch = 0.0f;
                part.func_187114_a(300);
                part.setGravity(0.09f);
                part.func_82338_g(1.0f);
                float brightnessMulti = 1.0f - rand.nextFloat() * 0.5f;
                part.func_70538_b(0.65f * brightnessMulti, 0.6f * brightnessMulti, 0.3f * brightnessMulti);
                part.setScale(100.0f);
                part.setKillOnCollide(true);
                part.renderOrder = 0;
                this.particleBehavior.particles.add(part);
                part.spawnAsWeatherEffect();
                ++spawnedThisTick;
            }
        }
        if (spawnedThisTick > 0) {
            spawnedThisTick = 0;
        }
        if (mc.field_71441_e.func_82737_E() % 20L == 0L) {
            // empty if block
        }
        double spawnAngle = Maths.fastATan2(this.sizePeak, distFromSpawn);
        spawnAngle *= 1.2;
        double spawnDistInc = 10.0;
        double extraDistSpawnIntoWall = (double)this.sizePeak / 2.0;
        if (mc.field_71441_e.func_82737_E() % 3L == 0L) {
            for (double spawnDistTick = 0.0; spawnDistTick < distFromSpawn + extraDistSpawnIntoWall && spawnedThisTick < 500; spawnDistTick += spawnDistInc) {
                if (rand.nextDouble() >= (double)sandstormScale || rand.nextDouble() >= sandstormParticleRateDust) continue;
                double randAngle = directionAngle + 1.5707963267948966 - spawnAngle + rand.nextDouble() * spawnAngle * 2.0;
                double randHeight = spawnDistTick / distFromSpawn * (double)this.height * 1.2 * rand.nextDouble();
                double x = this.posSpawn.posX + -Maths.fastSin(randAngle) * spawnDistTick;
                double z = this.posSpawn.posZ + Maths.fastCos(randAngle) * spawnDistTick;
                int yy = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(x += (rand.nextDouble() - rand.nextDouble()) * 30.0, 0.0, z += (rand.nextDouble() - rand.nextDouble()) * 30.0)).func_177956_o();
                double y = (double)(yy + 2) + randHeight;
                TextureAtlasSprite sprite = ParticleRegistry.cloud256;
                if (WeatherUtil.isAprilFoolsDay()) {
                    sprite = ParticleRegistry.chicken;
                }
                ParticleSandstorm part = new ParticleSandstorm((World)mc.field_71441_e, x, y, z, 0.0, 0.0, 0.0, sprite);
                this.particleBehavior.initParticle((EntityRotFX)part);
                part.setFacePlayer(false);
                part.isTransparent = true;
                part.rotationYaw = rand.nextInt(360);
                part.rotationPitch = rand.nextInt(360);
                part.func_187114_a(100);
                part.setGravity(0.09f);
                part.func_82338_g(1.0f);
                float brightnessMulti = 1.0f - rand.nextFloat() * 0.5f;
                part.func_70538_b(0.65f * brightnessMulti, 0.6f * brightnessMulti, 0.3f * brightnessMulti);
                part.setScale(100.0f);
                part.renderOrder = 0;
                part.setKillOnCollide(true);
                part.windWeight = 1.0f;
                this.particleBehavior.particles.add(part);
                part.spawnAsWeatherEffect();
                ++spawnedThisTick;
            }
        }
        if (spawnedThisTick > 0) {
            // empty if block
        }
        float angle = windMan.windAngle;
        float speedWind = windMan.windSpeed;
        double vecX = -Maths.fastSin(Math.toRadians(angle));
        double vecZ = Maths.fastCos(Math.toRadians(angle));
        double speed = 0.8;
        this.particleBehavior.coordSource = this.pos.toVec3Coro();
        this.particleBehavior.tickUpdateList();
        for (int i = 0; i < this.particleBehavior.particles.size(); ++i) {
            ParticleSandstorm particle = (ParticleSandstorm)((Object)this.particleBehavior.particles.get(i));
            if (particle.lockPosition) {
                if (this.size > 0) {
                    double x = this.pos.posX + -Maths.fastSin(Math.toRadians(particle.angleToStorm)) * particle.distAdj;
                    double z = this.pos.posZ + Maths.fastCos(Math.toRadians(particle.angleToStorm)) * particle.distAdj;
                    double y = this.pos.posY + (double)particle.heightLayer * distBetweenParticles;
                    this.moveToPosition(particle, x, y, z, 0.01);
                    continue;
                }
                particle.setMotionX(vecX * (double)speedWind * (double)0.3f);
                particle.setMotionZ(vecZ * (double)speedWind * (double)0.3f);
                continue;
            }
            particle.setMotionX(vecX * speed);
            particle.setMotionZ(vecZ * speed);
        }
    }

    public Maths.Vec3 getRandomPosInSandstorm() {
        double extraDistSpawnIntoWall = (double)this.sizePeak / 2.0;
        double distFromSpawn = this.posSpawn.distanceSq(this.pos);
        double randDist = this.rand.nextDouble() * (distFromSpawn + extraDistSpawnIntoWall);
        double xVec = this.posSpawn.posX - this.pos.posX;
        double zVec = this.posSpawn.posZ - this.pos.posZ;
        double spawnAngle = Maths.fastATan2(this.sizePeak, distFromSpawn);
        double directionAngle = Maths.fastATan2(zVec, xVec);
        double randAngle = directionAngle + 1.5707963267948966 - spawnAngle + this.rand.nextDouble() * spawnAngle * 2.0;
        double x = this.posSpawn.posX + -Maths.fastSin(randAngle) * randDist;
        double z = this.posSpawn.posZ + Maths.fastCos(randAngle) * randDist;
        return new Maths.Vec3(x, 0.0, z);
    }

    public List<Vec3> getSandstormAsShape() {
        ArrayList<Vec3> listPoints = new ArrayList<Vec3>();
        double extraDistSpawnIntoWall = (double)this.sizePeak / 2.0;
        double distFromSpawn = this.posSpawn.distanceSq(this.pos);
        listPoints.add(new Vec3(this.posSpawn.posX, 0.0, this.posSpawn.posZ));
        double xVec = this.posSpawn.posX - this.pos.posX;
        double zVec = this.posSpawn.posZ - this.pos.posZ;
        double spawnAngle = Maths.fastATan2(this.sizePeak, distFromSpawn);
        double directionAngle = Maths.fastATan2(zVec, xVec);
        double angleLeft = directionAngle + 1.5707963267948966 - spawnAngle;
        double angleRight = directionAngle + 1.5707963267948966 - spawnAngle + spawnAngle * 2.0;
        double xLeft = this.posSpawn.posX + -Maths.fastSin(angleLeft) * (distFromSpawn + extraDistSpawnIntoWall);
        double zLeft = this.posSpawn.posZ + Maths.fastCos(angleLeft) * (distFromSpawn + extraDistSpawnIntoWall);
        double xRight = this.posSpawn.posX + -Maths.fastSin(angleRight) * (distFromSpawn + extraDistSpawnIntoWall);
        double zRight = this.posSpawn.posZ + Maths.fastCos(angleRight) * (distFromSpawn + extraDistSpawnIntoWall);
        listPoints.add(new Vec3(xLeft, 0.0, zLeft));
        listPoints.add(new Vec3(xRight, 0.0, zRight));
        return listPoints;
    }

    public void moveToPosition(ParticleSandstorm particle, double x, double y, double z, double maxSpeed) {
        if (particle.getPosX() > x) {
            particle.setMotionX(particle.getMotionX() + -maxSpeed);
        } else {
            particle.setMotionX(particle.getMotionX() + maxSpeed);
        }
        if (particle.getPosZ() > z) {
            particle.setMotionZ(particle.getMotionZ() + -maxSpeed);
        } else {
            particle.setMotionZ(particle.getMotionZ() + maxSpeed);
        }
        double distXZ = Math.sqrt((particle.getPosX() - x) * 2.0 + (particle.getPosZ() - z) * 2.0);
        if (distXZ < 5.0) {
            particle.setMotionX(particle.getMotionX() * 0.8);
            particle.setMotionZ(particle.getMotionZ() * 0.8);
        }
    }

    @Override
    public int getNetRate() {
        return 1;
    }

    @Override
    public void readFromNBT() {
        super.readFromNBT();
        this.posSpawn = new Maths.Vec3(this.nbt.getDouble("posSpawnX"), this.nbt.getDouble("posSpawnY"), this.nbt.getDouble("posSpawnZ"));
        this.ageFadeout = this.nbt.getInteger("ageFadeout");
        this.ageFadeoutMax = this.nbt.getInteger("ageFadeoutMax");
        this.sizePeak = this.nbt.getInteger("sizePeak");
        this.age = this.nbt.getInteger("age");
        this.isFrontGrowing = this.nbt.getBoolean("isFrontGrowing");
        this.motion = new Maths.Vec3(this.nbt.getDouble("vecX"), this.nbt.getDouble("vecY"), this.nbt.getDouble("vecZ"));
    }

    @Override
    public CachedNBTTagCompound writeToNBT() {
        super.writeToNBT();
        this.nbt.setDouble("posSpawnX", this.posSpawn.posX);
        this.nbt.setDouble("posSpawnY", this.posSpawn.posY);
        this.nbt.setDouble("posSpawnZ", this.posSpawn.posZ);
        this.nbt.setInteger("ageFadeout", this.ageFadeout);
        this.nbt.setInteger("ageFadeoutMax", this.ageFadeoutMax);
        this.nbt.setInteger("sizePeak", this.sizePeak);
        this.nbt.setInteger("age", this.age);
        this.nbt.setBoolean("isFrontGrowing", this.isFrontGrowing);
        this.nbt.setDouble("vecX", this.motion.posX);
        this.nbt.setDouble("vecY", this.motion.posY);
        this.nbt.setDouble("vecZ", this.motion.posZ);
        return this.nbt;
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void cleanupClient(boolean wipe) {
        this.listParticlesCloud.forEach(particle -> particle.func_187112_i());
        this.listParticlesCloud.clear();
        if (this.particleBehavior != null) {
            this.particleBehavior.particles.clear();
        }
        this.particleBehavior = null;
    }

    @Override
    public float getWindSpeed() {
        return 7.0f;
    }

    @Override
    public int getStage() {
        return 1;
    }

    @Override
    public void setStage(int stage) {
    }

    @Override
    public String getName() {
        return "Sandstorm";
    }

    @Override
    public String getTypeName() {
        return "SS";
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public float getSpeed() {
        return (float)this.motion.speedSq();
    }

    public int getParticleCount() {
        return this.particleBehavior == null ? 0 : this.particleBehavior.particles.size();
    }

    public boolean canSpawnParticle() {
        return ConfigParticle.max_particles < 0 || ClientTickHandler.weatherManager.getParticleCount() < ConfigParticle.max_particles;
    }
}

