/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.weather.storm;

import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilMisc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.weather.IWeatherDetectable;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.config.ConfigFront;
import net.mrbt0907.weather2.config.ConfigSimulation;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.weather.WeatherManager;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class FrontObject
implements IWeatherDetectable {
    protected final Map<UUID, WeatherObject> systems = new HashMap<UUID, WeatherObject>();
    private UUID uuid = UUID.randomUUID();
    protected World world;
    private WeatherManager manager;
    public NBTTagCompound nbt;
    public Maths.Vec3 pos;
    public Maths.Vec3 motion;
    public boolean overrideAngle;
    public float angle;
    public float size;
    public boolean isDying;
    public boolean isDead;
    private boolean isGlobal;
    public float temperature;
    public float humidity;
    public float pressure;
    public float frontMultiplier;
    public int type;
    public int layer;
    public int maxStorms;
    public int storms;
    public int activeStorms;
    public int deathTicks;

    public FrontObject(WeatherManager manager, Maths.Vec3 pos, int layer) {
        this.manager = manager;
        this.world = manager.getWorld();
        this.pos = pos;
        this.layer = layer;
        this.size = Maths.random(ConfigStorm.min_storm_size, ConfigFront.max_front_size);
        this.angle = manager.windManager.windAngle;
        float vecX = (float)(-Maths.fastSin(Math.toRadians(this.angle)));
        float vecZ = (float)Maths.fastCos(Math.toRadians(this.angle));
        float speed = manager.windManager.windSpeed * 0.1f + 0.02f;
        this.motion = new Maths.Vec3((double)(vecX * speed), 0.0, (double)(vecZ * speed));
        if (pos == null) {
            this.maxStorms = -1;
            this.isGlobal = true;
        } else {
            this.maxStorms = Maths.random(1, 35);
            this.temperature = WeatherUtil.getTemperature(this.world, pos.toBlockPos());
            this.humidity = WeatherUtil.getTemperature(this.world, pos.toBlockPos());
            this.pressure = WeatherUtil.getPressure(this.world, pos.toBlockPos());
            this.type = (double)this.temperature > 0.5 || Maths.chance(25) ? 1 : 2;
        }
        this.frontMultiplier = Maths.random(0.5f, 2.0f);
        this.nbt = new NBTTagCompound();
    }

    public void tick() {
        if (this.maxStorms > -1 && this.storms >= this.maxStorms) {
            if (!this.isDying) {
                this.isDying = true;
            }
            ++this.deathTicks;
            if ((this.systems.size() == 0 || this.activeStorms == 0) && this.deathTicks > 2000) {
                this.isDead = true;
                return;
            }
        }
        this.tickMovement();
        if (!this.manager.getWorld().field_72995_K) {
            this.tickProgressionNormal();
        }
        this.systems.forEach((uuid, system) -> {
            if (!system.isDead) {
                system.tick();
            }
        });
    }

    public void tickMovement() {
        if (this.pos != null) {
            if (this.world.field_72995_K) {
                this.pos.posX += this.motion.posX;
                this.pos.posZ += this.motion.posZ;
            } else {
                float mult = (this.type == 0 ? 0.25f : (this.type == 1 ? 1.25f : 1.0f)) * this.frontMultiplier;
                this.angle = CoroUtilMisc.adjVal((float)this.angle, (float)this.manager.windManager.windAngle, (float)(0.001f * (float)ConfigFront.angle_change_mult * mult));
                float vecX = (float)(-Maths.fastSin(Math.toRadians(this.angle)));
                float vecZ = (float)Maths.fastCos(Math.toRadians(this.angle));
                float cloudSpeed = 0.2f;
                float speed = (this.manager.windManager.windSpeed * cloudSpeed + (this.type == 1 ? 0.2f : 0.02f)) * (this.type == 0 ? 0.1f : 1.0f);
                this.motion.posX = CoroUtilMisc.adjVal((float)((float)this.motion.posX), (float)(vecX * speed), (float)((float)ConfigFront.speed_change_mult * mult));
                this.motion.posZ = CoroUtilMisc.adjVal((float)((float)this.motion.posZ), (float)(vecZ * speed), (float)((float)ConfigFront.speed_change_mult * mult));
                this.pos.posX += this.motion.posX;
                this.pos.posZ += this.motion.posZ;
            }
        }
    }

    public void tickProgressionNormal() {
        if (this.world.func_82737_E() % Math.max((long)ConfigFront.tick_rate, 1L) == 0L && this.pos != null) {
            BlockPos pos = this.pos.toBlockPos();
            float temperature = WeatherUtil.getTemperature(this.world, pos);
            float humidity = WeatherUtil.getHumidity(this.world, pos);
            float pressure = WeatherUtil.getPressure(this.world, pos);
            if (this.type == 2 && temperature < 0.5f) {
                temperature = 0.5f;
            }
            this.temperature = CoroUtilMisc.adjVal((float)this.temperature, (float)temperature, (float)(1.0E-4f * (float)ConfigFront.environment_change_mult));
            this.humidity = CoroUtilMisc.adjVal((float)this.humidity, (float)humidity, (float)(5.0E-4f * (float)ConfigFront.environment_change_mult));
            this.pressure = CoroUtilMisc.adjVal((float)this.pressure, (float)pressure, (float)(2.0E-4f * (float)ConfigFront.environment_change_mult));
            if (this.type == 1) {
                for (FrontObject front : this.manager.getFronts()) {
                    if (front.equals(this) || front.type != 2 || !(front.pos.distanceSq(this.pos) - (double)(front.size * 0.25f) <= 0.0)) continue;
                    this.activeStorms += front.activeStorms;
                    this.maxStorms += front.maxStorms;
                    this.storms += front.storms;
                    for (WeatherObject weather : front.getWeatherObjects()) {
                        weather.front = this;
                        front.systems.remove(weather.getUUID());
                    }
                    front.isDead = true;
                    this.type = 0;
                    this.motion = new Maths.Vec3(0.0, 0.0, 0.0);
                }
            }
        }
    }

    public StormObject createStorm(double posX, double posZ, int stage, Map<String, Boolean> flags) {
        if (this.isDying) {
            return null;
        }
        StormObject storm = new StormObject(this);
        storm.layer = this.layer;
        storm.isNatural = false;
        storm.temperature = 0.1f;
        storm.pos = new Maths.Vec3(posX, (double)storm.getLayerHeight(), posZ);
        storm.rain = (float)stage * 50.0f;
        storm.intensity = stage;
        storm.sizeRate = 1.0f;
        storm.stageMax = storm.stage = stage;
        if (flags != null) {
            for (Map.Entry<String, Boolean> flag : flags.entrySet()) {
                switch (flag.getKey().toLowerCase()) {
                    case "alwaysprogress": {
                        storm.alwaysProgresses = flag.getValue();
                    }
                    case "neverDissipate": {
                        storm.neverDissipate = flag.getValue();
                    }
                    case "isFirenado": {
                        storm.isFirenado = flag.getValue();
                    }
                    case "shouldConvert": {
                        storm.shouldConvert = flag.getValue();
                    }
                    case "isViolent": {
                        storm.isViolent = flag.getValue();
                    }
                    case "shouldBuildHumidity": {
                        storm.shouldBuildHumidity = flag.getValue();
                    }
                }
            }
        }
        this.addWeatherObject(storm);
        return storm;
    }

    public StormObject createNaturalStorm() {
        return this.createNaturalStorm(null);
    }

    public StormObject createNaturalStorm(Entity target) {
        if (ConfigStorm.isLayerValid(this.layer) && !this.isDying) {
            StormObject storm = new StormObject(this);
            storm.layer = this.layer;
            storm.isNatural = true;
            if (this.isGlobal) {
                if (target == null) {
                    return null;
                }
                storm.pos = new Maths.Vec3(target.field_70165_t + (double)Maths.random(-ConfigSimulation.max_storm_spawning_distance, ConfigSimulation.max_storm_spawning_distance), (double)storm.getLayerHeight(), target.field_70161_v + (double)Maths.random(-ConfigSimulation.max_storm_spawning_distance, ConfigSimulation.max_storm_spawning_distance));
            } else {
                storm.pos = new Maths.Vec3(this.pos.posX + (double)Maths.random(-this.size, this.size), (double)storm.getLayerHeight(), this.pos.posZ + (double)Maths.random(-this.size, this.size));
            }
            if (this.layer == 0 && Maths.chance((double)ConfigStorm.storm_spawn_chance * 0.01)) {
                storm.initRealStorm();
            }
            this.addWeatherObject(storm);
            return storm;
        }
        return null;
    }

    public WeatherObject createWeatherObject(Class<? extends WeatherObject> clazz) {
        if (clazz != null && !this.isDying) {
            try {
                WeatherObject system = clazz.getConstructor(WeatherManager.class).newInstance(this.manager);
                this.addWeatherObject(system);
                return system;
            }
            catch (Exception e) {
                Weather2.error(e.getMessage());
            }
        }
        Weather2.error("Cannot create a weather object; clazz returned null");
        return null;
    }

    public void removeWeatherObject(UUID uuid) {
        WeatherObject system = this.systems.get(uuid);
        if (system == null) {
            return;
        }
        system.reset();
        this.manager.removeWeatherObject(uuid);
        if (!system.type.equals((Object)WeatherEnum.Type.CLOUD)) {
            --this.activeStorms;
        }
        system.reset();
        this.systems.remove(uuid);
        Weather2.debug("Weather " + uuid + " was removed from front " + this.uuid);
    }

    @SideOnly(value=Side.CLIENT)
    public void cleanupClient(boolean wipe) {
        this.systems.forEach((uuid, system) -> system.cleanupClient(wipe));
    }

    public void reset() {
        int size = this.systems.size();
        UUID[] keys = new UUID[this.systems.size()];
        keys = this.systems.keySet().toArray(keys);
        for (int i = 0; i < size; ++i) {
            this.removeWeatherObject(keys[i]);
        }
    }

    public void aimStormAtPlayer(EntityPlayer entP) {
        Maths.Vec3 pos = this.pos;
        if (this.isGlobal) {
            pos = new Maths.Vec3(0, 0, 0);
        }
        if (entP == null) {
            entP = this.manager.getWorld().func_184137_a(pos.posX, pos.posY, pos.posZ, -1.0, false);
        }
        if (entP != null) {
            float yaw = -((float)(Maths.fastATan2(entP.field_70165_t - pos.posX, entP.field_70161_v - pos.posZ) * 180.0 / Math.PI));
            int size = ConfigStorm.storm_aim_accuracy_in_angle;
            if (size > 0) {
                yaw += (float)(Maths.random(size) - size / 2);
            }
            this.angle = yaw;
            Weather2.debug("Front " + this.uuid + " was aimed at player " + CoroUtilEntity.getName((Entity)entP));
        }
    }

    public void readNBT(NBTTagCompound nbt) {
        this.uuid = nbt.func_186857_a("uuid");
        if (this.pos != null) {
            this.pos.posX = nbt.func_74769_h("posX");
            this.pos.posY = nbt.func_74769_h("posY");
            this.pos.posZ = nbt.func_74769_h("posZ");
            this.motion.posX = nbt.func_74769_h("motionX");
            this.motion.posY = nbt.func_74769_h("motionY");
            this.motion.posZ = nbt.func_74769_h("motionZ");
            this.temperature = nbt.func_74760_g("temperature");
            this.humidity = nbt.func_74760_g("humidity");
            this.pressure = nbt.func_74760_g("pressure");
            this.type = nbt.func_74762_e("type");
            this.frontMultiplier = nbt.func_74760_g("frontMultiplier");
        }
        this.angle = nbt.func_74760_g("angle");
        this.layer = nbt.func_74762_e("layer");
        this.maxStorms = nbt.func_74762_e("maxStorms");
        this.storms = nbt.func_74762_e("storms");
        this.size = nbt.func_74760_g("size");
    }

    public NBTTagCompound writeNBT() {
        this.nbt.func_186854_a("uuid", this.uuid);
        if (this.pos != null) {
            this.nbt.func_74780_a("posX", this.pos.posX);
            this.nbt.func_74780_a("posY", this.pos.posY);
            this.nbt.func_74780_a("posZ", this.pos.posZ);
            this.nbt.func_74780_a("motionX", this.motion.posX);
            this.nbt.func_74780_a("motionY", this.motion.posY);
            this.nbt.func_74780_a("motionZ", this.motion.posZ);
            this.nbt.func_74776_a("temperature", this.temperature);
            this.nbt.func_74776_a("humidity", this.humidity);
            this.nbt.func_74776_a("pressure", this.pressure);
            this.nbt.func_74768_a("type", this.type);
            this.nbt.func_74776_a("frontMultiplier", this.frontMultiplier);
        }
        this.nbt.func_74776_a("angle", this.angle);
        this.nbt.func_74768_a("layer", this.layer);
        this.nbt.func_74768_a("maxStorms", this.maxStorms);
        this.nbt.func_74768_a("storms", this.storms);
        this.nbt.func_74776_a("size", this.size);
        return this.nbt;
    }

    public WeatherManager getWeatherManager() {
        return this.manager;
    }

    public WeatherObject getWeatherObject(UUID uuid) {
        return this.systems.get(uuid);
    }

    public List<WeatherObject> getWeatherObjects() {
        return new ArrayList<WeatherObject>(this.systems.values());
    }

    public World getWorld() {
        return this.manager.getWorld();
    }

    public int size() {
        return this.systems.size();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void addWeatherObject(WeatherObject weather) {
        if (weather != null && weather.front.equals(this)) {
            ++this.storms;
            if (!weather.type.equals((Object)WeatherEnum.Type.CLOUD)) {
                ++this.activeStorms;
            }
            this.systems.put(weather.getUUID(), weather);
            if (ConfigStorm.storms_aim_at_player && !this.overrideAngle && weather instanceof StormObject && ((StormObject)weather).stageMax >= WeatherEnum.Stage.SEVERE.getStage()) {
                this.aimStormAtPlayer(null);
            }
            this.manager.addWeatherObject(weather);
        }
    }

    public boolean contains(UUID uuid) {
        return this.systems.containsKey(uuid);
    }

    @Override
    public float getWindSpeed() {
        return 0.0f;
    }

    @Override
    public int getStage() {
        return 0;
    }

    @Override
    public void setStage(int stage) {
    }

    @Override
    public Maths.Vec3 getPos() {
        return this.pos;
    }

    @Override
    public boolean isDying() {
        return this.isDying;
    }

    @Override
    public String getName() {
        switch (this.type) {
            case 1: {
                return "Cold Front";
            }
            case 2: {
                return "Warm Front";
            }
            case 3: {
                return "Occluded Front";
            }
        }
        return "Stationary Front";
    }

    @Override
    public String getTypeName() {
        switch (this.type) {
            case 1: {
                return "CF";
            }
            case 2: {
                return "WF";
            }
            case 3: {
                return "OF";
            }
        }
        return "SF";
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public float getSpeed() {
        return (float)this.motion.speedSq();
    }
}

