/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.weather;

import CoroUtil.util.CoroUtilEntOrParticle;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.config.ConfigWind;
import net.mrbt0907.weather2.network.packets.PacketWind;
import net.mrbt0907.weather2.server.weather.WeatherManagerServer;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.util.WeatherUtilEntity;
import net.mrbt0907.weather2.weather.WeatherManager;
import net.mrbt0907.weather2.weather.storm.SandstormObject;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class WindManager {
    public WeatherManager manager;
    public float windAngle = 0.0f;
    public float windSpeed = 0.0f;
    public float windAngleTarget = 0.0f;
    public float windSpeedTarget = 0.0f;
    public float windAngleGust = 0.0f;
    public float windSpeedGust = 0.0f;
    public int windTimeGust = 0;
    private final Map<Maths.Vec3, WeatherObject> cache = new HashMap<Maths.Vec3, WeatherObject>();
    private long nextWindRefresh;

    public WindManager(WeatherManager parManager) {
        this.manager = parManager;
        this.windAngle = Maths.random(360);
        this.nextWindRefresh = 0L;
    }

    public void tick() {
        if (!this.manager.isClient()) {
            if (!ConfigWind.enable) {
                this.windSpeed = 0.0f;
                this.windSpeedTarget = 0.0f;
                this.windSpeedGust = 0.0f;
                this.windTimeGust = 0;
            } else {
                if (this.manager.world.func_82737_E() % 200L == 0L) {
                    this.cache.clear();
                }
                if (this.manager.getWorld().func_82737_E() >= this.nextWindRefresh) {
                    this.nextWindRefresh = this.manager.getWorld().func_82737_E() + (long)Maths.random(ConfigWind.windRefreshMin, ConfigWind.windRefreshMax);
                    this.windSpeedTarget = (float)Maths.random(ConfigWind.windSpeedMin, ConfigWind.windSpeedMax);
                    this.windAngleTarget += (float)Maths.random(-ConfigWind.windAngleChangeMax, ConfigWind.windAngleChangeMax);
                    this.windAngleTarget = this.windAngle % 360.0f;
                }
                this.tickWindChange();
                if (ConfigWind.enableWindAffectsEntities) {
                    Entity[] entities = new Entity[]{};
                    for (Entity entity : this.manager.getWorld().field_72996_f.toArray(entities)) {
                        if (entity.field_70128_L || !(entity instanceof EntityLivingBase) || !WeatherUtilEntity.isEntityOutside(entity, true)) continue;
                        Maths.Vec3 a = this.getWindVectors(new Maths.Vec3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), new Maths.Vec3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y), (float)((double)(WeatherUtilEntity.getWeight(entity) * 8.0f) * ConfigWind.windEntityWeightMult * (entity.func_70090_H() ? ConfigWind.windSwimmingWeightMult : 1.0)), 0.05f, 5.0f);
                        entity.field_70159_w = a.posX;
                        entity.field_70181_x = a.posY;
                        entity.field_70179_y = a.posZ;
                    }
                }
            }
        } else if (!WeatherUtil.isPaused()) {
            if (ConfigWind.enable) {
                this.tickClient();
            } else {
                this.windSpeed = 0.0f;
                this.windSpeedTarget = 0.0f;
                this.windSpeedGust = 0.0f;
                this.windTimeGust = 0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        Minecraft mc = Minecraft.func_71410_x();
        this.tickWindChangeClient();
        if (this.manager.world.func_82737_E() % 200L == 0L) {
            this.cache.clear();
        }
        if (ConfigWind.enableWindAffectsEntities && mc.field_71439_g != null && WeatherUtilEntity.isEntityOutside((Entity)mc.field_71439_g, true)) {
            Maths.Vec3 a = this.getWindVectors(new Maths.Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v), new Maths.Vec3(mc.field_71439_g.field_70159_w, mc.field_71439_g.field_70181_x, mc.field_71439_g.field_70179_y), (float)((double)(WeatherUtilEntity.getWeight(mc.field_71439_g) * 8.0f) * ConfigWind.windPlayerWeightMult * (mc.field_71439_g.func_70090_H() ? ConfigWind.windSwimmingWeightMult : 1.0)), 0.05f, 5.0f);
            mc.field_71439_g.func_70016_h(a.posX, a.posY, a.posZ);
        }
    }

    public void tickWindChange() {
        float change;
        float difference;
        if (this.windAngle != this.windAngleTarget) {
            difference = this.windAngle + -(this.windAngle > 180.0f && this.windAngleTarget <= 180.0f ? this.windAngleTarget + 360.0f : (this.windAngle <= 180.0f && this.windAngleTarget > 180.0f ? this.windAngleTarget + -360.0f : this.windAngleTarget));
            change = (float)((double)1.95f * ConfigWind.windChangeMult);
            this.windAngle = Math.abs(difference) > change ? (difference > 0.0f ? (this.windAngle -= change) : (this.windAngle += change)) : this.windAngleTarget;
            this.windAngle %= 360.0f;
        }
        if (this.windSpeed != this.windSpeedTarget) {
            difference = this.windSpeed - this.windSpeedTarget;
            change = (float)((double)0.015f * ConfigWind.windChangeMult);
            this.windSpeed = Math.abs(difference) > change ? (this.windSpeed > this.windSpeedTarget ? (this.windSpeed -= change) : (this.windSpeed += change)) : this.windSpeedTarget;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickWindChangeClient() {
        float change;
        float difference;
        if (this.windAngle != this.windAngleTarget) {
            difference = this.windAngle + -(this.windAngle > 180.0f && this.windAngleTarget <= 180.0f ? this.windAngleTarget + 360.0f : (this.windAngle <= 180.0f && this.windAngleTarget > 180.0f ? this.windAngleTarget + -360.0f : this.windAngleTarget));
            change = (float)((double)1.95f * ConfigWind.windChangeMult);
            this.windAngle = Math.abs(difference) > change ? (difference > 0.0f ? (this.windAngle -= change) : (this.windAngle += change)) : this.windAngleTarget;
            this.windAngle %= 360.0f;
        }
        if (this.windSpeed != this.windSpeedTarget) {
            difference = this.windSpeed - this.windSpeedTarget;
            change = (float)((double)0.015f * ConfigWind.windChangeMult);
            this.windSpeed = Math.abs(difference) > change ? (this.windSpeed > this.windSpeedTarget ? (this.windSpeed -= change) : (this.windSpeed += change)) : this.windSpeedTarget;
        }
    }

    public NBTTagCompound nbtSyncForClient() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74776_a("windSpeedTarget", this.windSpeedTarget);
        data.func_74776_a("windAngleTarget", this.windAngleTarget);
        data.func_74776_a("windSpeedGust", this.windSpeedGust);
        data.func_74776_a("windAngleGust", this.windAngleGust);
        data.func_74768_a("windTimeGust", this.windTimeGust);
        return data;
    }

    public void nbtSyncFromServer(NBTTagCompound parNBT) {
        this.windSpeedTarget = parNBT.func_74760_g("windSpeedTarget");
        this.windAngleTarget = parNBT.func_74760_g("windAngleTarget");
        this.windSpeedGust = parNBT.func_74760_g("windSpeedGust");
        this.windAngleGust = parNBT.func_74760_g("windAngleGust");
        this.windTimeGust = parNBT.func_74762_e("windTimeGust");
    }

    public void syncData() {
        if (this.manager instanceof WeatherManagerServer) {
            PacketWind.update(this.manager.dim, this);
        }
    }

    public void reset() {
        this.manager = null;
    }

    public void getEntityWindVectors(Object ent) {
        this.getEntityWindVectors(ent, 0.1f, 0.5f);
    }

    public void getEntityWindVectors(Object ent, float multiplier, float maxSpeed) {
        Maths.Vec3 pos = this.manager.world.field_72995_K ? new Maths.Vec3(FMLClientHandler.instance().getClientPlayerEntity().func_180425_c()) : new Maths.Vec3(CoroUtilEntOrParticle.getPosX((Object)ent), CoroUtilEntOrParticle.getPosY((Object)ent), CoroUtilEntOrParticle.getPosZ((Object)ent));
        Maths.Vec3 motion = this.getWindVectors(pos, new Maths.Vec3(CoroUtilEntOrParticle.getMotionX((Object)ent), CoroUtilEntOrParticle.getMotionY((Object)ent), CoroUtilEntOrParticle.getMotionZ((Object)ent)), WeatherUtilEntity.getWeight(ent), multiplier, maxSpeed);
        CoroUtilEntOrParticle.setMotionX((Object)ent, (double)motion.posX);
        CoroUtilEntOrParticle.setMotionZ((Object)ent, (double)motion.posZ);
    }

    public Maths.Vec3 applyWindForceImpl(Maths.Vec3 pos, Maths.Vec3 motion, float weight) {
        return this.getWindVectors(pos, motion, weight, 0.05f, 0.5f);
    }

    public Maths.Vec3 getWindVectors(Maths.Vec3 pos, Maths.Vec3 motion, float weight, float multiplier, float maxSpeed) {
        float windAngle = this.getWindAngle(pos);
        float windSpeed = this.getWindSpeed(pos);
        float windX = (float)(-Maths.fastSin(Math.toRadians(windAngle))) * windSpeed;
        float windZ = (float)Maths.fastCos(Math.toRadians(windAngle)) * windSpeed;
        float objX = (float)motion.posX;
        float objZ = (float)motion.posZ;
        float windWeight = 1.0f;
        float objWeight = weight;
        if (objWeight == 0.0f) {
            objWeight = 0.001f;
        } else if (objWeight < 0.0f) {
            return motion;
        }
        float weightDiff = windWeight / objWeight;
        float vecX = (objX - windX) * weightDiff;
        float vecZ = (objZ - windZ) * weightDiff;
        Maths.Vec3 newMotion = motion.copy();
        newMotion.posX = Maths.clamp(objX - (vecX *= multiplier), -maxSpeed, maxSpeed);
        newMotion.posZ = Maths.clamp(objZ - (vecZ *= multiplier), -maxSpeed, maxSpeed);
        return newMotion;
    }

    public float getWindSpeed(Maths.Vec3 pos) {
        if (pos == null) {
            return this.manager.windManager.windSpeed;
        }
        WeatherObject wo = this.getWeatherObject(pos);
        if (wo != null) {
            float size = (float)wo.size * 0.9f;
            return Math.max(this.manager.windManager.windSpeed, (float)((double)(wo instanceof SandstormObject ? 7.5f : ((StormObject)wo).windSpeed) * Math.min(((double)size - wo.pos.distanceSq(pos) + (double)(wo instanceof SandstormObject ? size : ((StormObject)wo).funnelSize)) / (double)size, 1.0)));
        }
        return this.manager.windManager.windSpeed;
    }

    public float getWindAngle(Maths.Vec3 pos) {
        if (pos == null) {
            return this.manager.windManager.windAngle;
        }
        WeatherObject wo = this.getWeatherObject(pos);
        if (wo != null) {
            float yaw = -((float)Maths.fastATan2(wo.posGround.posX - pos.posX, wo.posGround.posZ - pos.posZ)) * 180.0f / (float)Math.PI + 360.0f;
            return yaw % 360.0f;
        }
        return this.manager.windManager.windAngle;
    }

    public Maths.Vec3 getWindForce() {
        float windX = (float)(-Maths.fastSin(Math.toRadians(this.windAngle))) * this.windSpeed;
        float windZ = (float)Maths.fastCos(Math.toRadians(this.windAngle)) * this.windSpeed;
        return new Maths.Vec3(windX, 0.0f, windZ);
    }

    private WeatherObject getWeatherObject(Maths.Vec3 pos) {
        for (Map.Entry<Maths.Vec3, WeatherObject> entry : this.cache.entrySet()) {
            if (!(pos.distanceSq(entry.getKey()) < 300.0)) continue;
            return entry.getValue();
        }
        WeatherObject wo = this.manager.getClosestWeather(pos, (double)ConfigStorm.max_storm_size + 50.0, 0, Integer.MAX_VALUE, WeatherEnum.Type.CLOUD);
        this.cache.put(pos, wo);
        return wo;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.windSpeedTarget = data.func_74760_g("windSpeedTarget");
        this.windAngleTarget = data.func_74760_g("windAngleTarget");
        this.windSpeedGust = data.func_74760_g("windSpeedGust");
        this.windAngleGust = data.func_74760_g("windAngleGust");
        this.windTimeGust = data.func_74762_e("windTimeGust");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74776_a("windSpeedTarget", this.windSpeedTarget);
        data.func_74776_a("windAngleTarget", this.windAngleTarget);
        data.func_74776_a("windSpeedGust", this.windSpeedGust);
        data.func_74776_a("windAngleGust", this.windAngleGust);
        data.func_74768_a("windTimeGust", this.windTimeGust);
        return data;
    }
}

