/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.weather;

import CoroUtil.util.CoroUtilPhysics;
import CoroUtil.util.Vec3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.weather.IWeatherRain;
import net.mrbt0907.weather2.api.weather.IWeatherStaged;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.config.ConfigSimulation;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.WindManager;
import net.mrbt0907.weather2.weather.storm.FrontObject;
import net.mrbt0907.weather2.weather.storm.SandstormObject;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;
import net.mrbt0907.weather2.weather.volcano.VolcanoObject;

public class WeatherManager {
    public long ticks;
    protected int dim;
    protected World world;
    public WindManager windManager;
    public float cloudIntensity = 1.0f;
    protected HashSet<Long> listWeatherBlockDamageDeflector = new HashSet();
    protected FrontObject globalFront;
    protected Map<UUID, FrontObject> fronts = new LinkedHashMap<UUID, FrontObject>();
    protected Map<UUID, WeatherObject> systems = new LinkedHashMap<UUID, WeatherObject>();
    protected List<VolcanoObject> volcanoObjects = new ArrayList<VolcanoObject>();
    protected List<UUID> volcanoUUIDS = new ArrayList<UUID>();

    public WeatherManager(World world) {
        if (world == null) {
            Weather2.error("WeatherSystem recieved a null world. Game may crash");
        } else {
            Weather2.debug("Creating new WeatherSystem for dimension #" + world.field_73011_w.getDimension());
        }
        this.world = world;
        this.dim = world.field_73011_w.getDimension();
        this.windManager = new WindManager(this);
    }

    public void reset(boolean fullReset) {
        this.fronts.forEach((uuid, front) -> front.reset());
        this.fronts.clear();
        this.globalFront = null;
        this.volcanoObjects.forEach(vo -> vo.reset());
        this.volcanoObjects.clear();
        this.volcanoUUIDS.clear();
        if (fullReset) {
            this.windManager.reset();
        }
    }

    public void tick() {
        if (this.world != null) {
            this.fronts.forEach((uuid, front) -> {
                if (!front.isDead) {
                    front.tick();
                }
            });
            this.volcanoObjects.forEach(vo -> vo.tick());
            this.windManager.tick();
            ++this.ticks;
        }
    }

    public StormObject createStorm(double posX, double posZ, int layer, int stage, Map<String, Boolean> flags) {
        return this.globalFront.createStorm(posX, posZ, stage, flags);
    }

    public StormObject createNaturalStorm(int layer) {
        return this.globalFront.createNaturalStorm();
    }

    public WeatherObject createWeatherObject(Class<? extends WeatherObject> clazz) {
        return this.globalFront.createWeatherObject(clazz);
    }

    public WeatherObject addWeatherObject(WeatherObject wo) {
        if (!this.systems.containsKey(wo.getUUID())) {
            this.systems.put(wo.getUUID(), wo);
        }
        return wo;
    }

    public void removeWeatherObject(UUID uuid) {
        WeatherObject system = this.systems.get(uuid);
        if (system != null) {
            this.systems.remove(uuid);
            Weather2.debug("Weather " + uuid + " was removed from manager #" + this.world.field_73011_w.getDimension());
        } else {
            Weather2.error("Manager for dimension #" + this.world.field_73011_w.getDimension() + " tried to remove a non-existent weather object with uuid " + uuid);
        }
    }

    public FrontObject createNaturalFront(int layer, EntityPlayer player) {
        FrontObject front = this.createFront(layer, player.field_70165_t + (double)Maths.random(-ConfigSimulation.max_storm_spawning_distance, ConfigSimulation.max_storm_spawning_distance), player.field_70161_v + (double)Maths.random(-ConfigSimulation.max_storm_spawning_distance, ConfigSimulation.max_storm_spawning_distance));
        this.fronts.put(front.getUUID(), front);
        return front;
    }

    public FrontObject createFront(int layer, double posX, double posZ) {
        FrontObject front = new FrontObject(this, new Maths.Vec3(posX, 0.0, posZ), layer);
        return front;
    }

    public void removeFront(FrontObject front) {
        this.removeFront(front.getUUID());
    }

    public void removeFront(UUID uuid) {
        FrontObject front = this.fronts.get(uuid);
        if (front != null) {
            front.reset();
            this.fronts.remove(uuid);
            Weather2.debug("Front " + uuid.toString() + " was removed from manager #" + this.world.field_73011_w.getDimension());
        } else {
            Weather2.error("Front " + uuid.toString() + " does not exist on this side. Skipping...");
        }
    }

    public FrontObject getFront(UUID uuid) {
        return this.fronts.get(uuid);
    }

    public List<FrontObject> getFronts() {
        return new ArrayList<FrontObject>(this.fronts.values());
    }

    public List<FrontObject> getFronts(int layer) {
        ArrayList<FrontObject> fronts = new ArrayList<FrontObject>();
        for (FrontObject front : this.fronts.values()) {
            if (front.layer != layer) continue;
            fronts.add(front);
        }
        return fronts;
    }

    public Map<Integer, List<FrontObject>> getLayeredFronts() {
        HashMap<Integer, List<FrontObject>> fronts = new HashMap<Integer, List<FrontObject>>();
        for (FrontObject front : this.fronts.values()) {
            ((List)fronts.get(front.layer)).add(front);
        }
        return fronts;
    }

    public List<VolcanoObject> getVolcanoObjects() {
        return this.volcanoObjects;
    }

    public VolcanoObject getVolcanoObjectByID(UUID ID) {
        int size = this.volcanoUUIDS.size();
        for (int i = 0; i < size; ++i) {
            if (!this.volcanoUUIDS.get(i).equals(ID)) continue;
            return this.volcanoObjects.get(i);
        }
        return null;
    }

    public void addVolcanoObject(VolcanoObject so) {
        if (!this.volcanoUUIDS.contains(so.getUUID())) {
            this.volcanoObjects.add(so);
            this.volcanoUUIDS.add(so.getUUID());
        } else {
            Weather2.warn("Client received new volcano create for an ID that is already active! design bug");
        }
    }

    public void removeVolcanoObject(UUID ID) {
        VolcanoObject vo = this.getVolcanoObjectByID(ID);
        if (vo != null) {
            vo.setDead();
            this.volcanoObjects.remove(vo);
            this.volcanoUUIDS.remove(ID);
            Weather2.debug("removing volcano");
        }
    }

    public boolean hasDownfall(BlockPos pos) {
        return this.hasDownfall(new Maths.Vec3(pos));
    }

    public boolean hasDownfall(Maths.Vec3 pos) {
        List<WeatherObject> systems = this.getWeatherObjects();
        for (WeatherObject system : systems) {
            if (!(system instanceof IWeatherRain) || !((IWeatherRain)((Object)system)).hasDownfall(pos)) continue;
            return true;
        }
        return false;
    }

    public WeatherObject getClosestWeather(Maths.Vec3 pos, double distance) {
        return this.getClosestWeather(pos, distance, 0, Integer.MAX_VALUE, WeatherEnum.Type.BLIZZARD, WeatherEnum.Type.CLOUD, WeatherEnum.Type.SANDSTORM);
    }

    public WeatherObject getClosestWeather(Maths.Vec3 pos, double distance, int minStage, int maxStage, WeatherEnum.Type ... excludedTypes) {
        Map<WeatherObject, Integer> list = this.getWeatherSystems(pos, distance, minStage, maxStage, excludedTypes);
        WeatherObject result = null;
        double dist = Double.MAX_VALUE;
        for (WeatherObject weather : list.keySet()) {
            double curDist = weather.pos.distanceSq(pos) - (double)weather.size;
            if (!(curDist < dist)) continue;
            dist = curDist;
            result = weather;
        }
        return result;
    }

    public WeatherObject getWorstWeather(Maths.Vec3 pos, double distance) {
        return this.getWorstWeather(pos, distance, 0, Integer.MAX_VALUE, WeatherEnum.Type.BLIZZARD, WeatherEnum.Type.CLOUD, WeatherEnum.Type.SANDSTORM);
    }

    public WeatherObject getWorstWeather(Maths.Vec3 pos, double distance, int minStage, int maxStage, WeatherEnum.Type ... excludedTypes) {
        Map<WeatherObject, Integer> list = this.getWeatherSystems(pos, distance, minStage, maxStage, excludedTypes);
        WeatherObject result = null;
        int stage = -1;
        for (Map.Entry<WeatherObject, Integer> entry : list.entrySet()) {
            int curStage = entry.getValue();
            if (curStage <= stage) continue;
            stage = curStage;
            result = entry.getKey();
        }
        return result;
    }

    public Map<WeatherObject, Integer> getWeatherSystems(Maths.Vec3 pos, double distance) {
        return this.getWeatherSystems(pos, distance, 0, Integer.MAX_VALUE, WeatherEnum.Type.BLIZZARD, WeatherEnum.Type.CLOUD, WeatherEnum.Type.SANDSTORM);
    }

    public Map<WeatherObject, Integer> getWeatherSystems(Maths.Vec3 pos, double distance, int minStage, int maxStage, WeatherEnum.Type ... excludedTypes) {
        HashMap<WeatherObject, Integer> list = new HashMap<WeatherObject, Integer>();
        ArrayList<WeatherObject> curList = new ArrayList<WeatherObject>(this.systems.values());
        for (WeatherObject weather : curList) {
            boolean truth = true;
            int stage = 0;
            for (WeatherEnum.Type type : excludedTypes) {
                if (!weather.type.equals((Object)type)) continue;
                truth = false;
                break;
            }
            if (!truth || !(weather.pos.distanceSq(pos) - (double)weather.size < distance)) continue;
            if (weather instanceof IWeatherStaged) {
                stage = weather.getStage();
            }
            if (stage < minStage || stage > maxStage) continue;
            list.put(weather, stage);
        }
        return list;
    }

    public SandstormObject getClosestSandstorm(Maths.Vec3 parPos, double maxDist) {
        SandstormObject closestStorm = null;
        double closestDist = 9999999.0;
        List<WeatherObject> listStorms = this.getWeatherObjects();
        for (int i = 0; i < listStorms.size(); ++i) {
            double dist;
            SandstormObject storm;
            WeatherObject wo = listStorms.get(i);
            if (!(wo instanceof SandstormObject) || (storm = (SandstormObject)wo) == null || storm.isDead || !((dist = storm.pos.distanceSq(parPos)) < closestDist) || !(dist <= maxDist)) continue;
            closestStorm = storm;
            closestDist = dist;
        }
        return closestStorm;
    }

    public SandstormObject getClosestSandstormByIntensity(Maths.Vec3 parPos) {
        SandstormObject bestStorm = null;
        double closestDist = 9999999.0;
        double mostIntense = 0.0;
        List<WeatherObject> listStorms = this.getWeatherObjects();
        for (int i = 0; i < listStorms.size(); ++i) {
            SandstormObject sandstorm;
            WeatherObject wo = listStorms.get(i);
            if (!(wo instanceof SandstormObject) || (sandstorm = (SandstormObject)wo) == null || sandstorm.isDead) continue;
            List<Vec3> points = sandstorm.getSandstormAsShape();
            double scale = sandstorm.getSandstormScale();
            boolean inStorm = CoroUtilPhysics.isInConvexShape((Vec3)parPos.toVec3Coro(), points);
            double dist = CoroUtilPhysics.getDistanceToShape((Vec3)parPos.toVec3Coro(), points);
            if (inStorm) {
                closestDist = 0.0;
                if (!(scale > mostIntense)) continue;
                mostIntense = scale;
                bestStorm = sandstorm;
                continue;
            }
            if (!(closestDist > 0.0) || !(dist < closestDist)) continue;
            closestDist = dist;
            bestStorm = sandstorm;
        }
        return bestStorm;
    }

    public List<SandstormObject> getSandstormsAround(Maths.Vec3 parPos, double maxDist) {
        List<WeatherObject> systems = this.getWeatherObjects();
        ArrayList<SandstormObject> sandstorms = new ArrayList<SandstormObject>();
        for (WeatherObject system : systems) {
            if (!(system instanceof SandstormObject)) continue;
            SandstormObject storm = (SandstormObject)system;
            if (storm.isDead || !(storm.pos.distanceSq(parPos) <= maxDist)) continue;
            sandstorms.add(storm);
        }
        return sandstorms;
    }

    public List<WeatherObject> getWeatherObjects() {
        return new ArrayList<WeatherObject>(this.systems.values());
    }

    public HashSet<Long> getListWeatherBlockDamageDeflector() {
        return this.listWeatherBlockDamageDeflector;
    }

    public void setListWeatherBlockDamageDeflector(HashSet<Long> listWeatherBlockDamageDeflector) {
        this.listWeatherBlockDamageDeflector = listWeatherBlockDamageDeflector;
    }

    public World getWorld() {
        return this.world;
    }

    public FrontObject getGlobalFront() {
        return this.globalFront;
    }

    public int getDimension() {
        return this.dim;
    }

    public boolean isClient() {
        return this.world.field_72995_K;
    }
}

