/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.client.sound.MovingSoundEX;

public class WeatherUtilSound {
    private static final List<MovingSoundEX> allSounds = new ArrayList<MovingSoundEX>();
    private static final Map<Integer, MovingSoundEX> sounds = new HashMap<Integer, MovingSoundEX>();

    @SideOnly(value=Side.CLIENT)
    public static void tick() {
        if (sounds.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Iterator<MovingSoundEX> soundList = allSounds.iterator();
        while (soundList.hasNext()) {
            Integer key = null;
            MovingSoundEX sound = soundList.next();
            if ((!sound.func_147657_c() || !sound.func_147667_k() || sound.ticksExisted <= 20L) && (sound.func_147657_c() || mc.func_147118_V().func_147692_c((ISound)sound) || sound.func_147667_k() || sound.ticksExisted <= 20L)) continue;
            sound.setDone();
            for (Map.Entry<Integer, MovingSoundEX> entry : sounds.entrySet()) {
                if (!((Object)((Object)entry.getValue())).equals((Object)sound)) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                sounds.remove(key);
            }
            soundList.remove();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isSoundActive(int index) {
        boolean truth = sounds.containsKey(index);
        if (truth && sounds.get(index).func_147667_k()) {
            sounds.remove(index);
            truth = false;
        }
        return truth;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isSoundActive(int index, SoundEvent sound) {
        boolean truth = sounds.containsKey(index);
        if (truth && sounds.get(index).func_147667_k()) {
            sounds.remove(index);
            truth = false;
        }
        return truth && sounds.get(index).func_147650_b().equals((Object)sound.func_187503_a());
    }

    @SideOnly(value=Side.CLIENT)
    public static void reset() {
        allSounds.forEach(sound -> sound.setDone());
        allSounds.clear();
        sounds.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean stopSound(int index) {
        boolean truth = sounds.containsKey(index);
        if (truth) {
            sounds.get(index).setDone();
            sounds.remove(index);
        }
        return truth;
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingSoundEX getActiveSound(int index) {
        if (sounds.containsKey(index) && sounds.get(index).func_147667_k()) {
            sounds.remove(index);
        }
        return sounds.get(index);
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingSoundEX playForcedSound(SoundEvent soundEvent, SoundCategory category, Object obj, float volume, float pitch, float range, boolean useY, boolean repeat) {
        MovingSoundEX sound = new MovingSoundEX(obj, soundEvent, SoundCategory.WEATHER, volume, pitch, range, useY);
        sound.setRepeat(repeat);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        allSounds.add(sound);
        return sound;
    }

    @SideOnly(value=Side.CLIENT)
    private static MovingSoundEX playSound(SoundEvent soundEvent, SoundCategory category, Object obj, int index, float volume, float pitch, float range, boolean useY, boolean repeat) {
        boolean truth = sounds.containsKey(index);
        if (truth && sounds.get(index).func_147667_k()) {
            sounds.remove(index);
            truth = false;
        }
        if (!truth) {
            MovingSoundEX sound = new MovingSoundEX(obj, soundEvent, SoundCategory.WEATHER, volume, pitch, range, useY);
            sound.setRepeat(repeat);
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)sound);
            allSounds.add(sound);
            sounds.put(index, sound);
            return sound;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingSoundEX playSound(SoundEvent sound, SoundCategory category, int index, float volume, float pitch, boolean repeat) {
        return WeatherUtilSound.playSound(sound, category, null, index, volume, pitch, -1.0f, false, repeat);
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingSoundEX play2DSound(SoundEvent sound, SoundCategory category, Object obj, int index, float volume, float pitch, float range, boolean repeat) {
        return WeatherUtilSound.playSound(sound, category, obj, index, volume, pitch, range, false, repeat);
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingSoundEX play3DSound(SoundEvent sound, SoundCategory category, int index, Object obj, float volume, float pitch, float range, boolean repeat) {
        return WeatherUtilSound.playSound(sound, category, obj, index, volume, pitch, range, true, repeat);
    }
}

