/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.util;

import CoroUtil.api.weather.IWindHandler;
import CoroUtil.util.CoroUtilEntOrParticle;
import extendedrenderer.particle.entity.EntityRotFX;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.mrbt0907.weather2.api.WeatherUtilData;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.entity.EntityMovingBlock;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtilBlock;
import net.mrbt0907.weather2.util.WeatherUtilParticle;
import net.mrbt0907.weather2.weather.WindManager;

public class WeatherUtilEntity {
    public static int playerInAirTime = 0;

    public static float getWeight(Object entity) {
        Entity ent;
        World world = CoroUtilEntOrParticle.getWorld((Object)entity);
        if (world == null) {
            return -1.0f;
        }
        if (entity instanceof IWindHandler) {
            return ((IWindHandler)entity).getWindWeight();
        }
        if (world.field_72995_K && entity instanceof Particle) {
            return WeatherUtilParticle.getParticleWeight((Particle)entity);
        }
        if (entity instanceof EntityMovingBlock) {
            return 7.5f + (float)((EntityMovingBlock)((Object)entity)).age * 0.05f;
        }
        if (entity instanceof EntitySquid) {
            return 400.0f;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            playerInAirTime = player.field_70122_E || player.func_70072_I() ? 0 : ++playerInAirTime;
            if (player.func_184812_l_() || player.func_175149_v()) {
                return -1.0f;
            }
            float extraWeight = 0.0f;
            if (player.field_71071_by != null) {
                for (ItemStack stack : player.field_71071_by.field_70460_b) {
                    if (stack.func_190926_b() || stack.func_77958_k() <= 0) continue;
                    extraWeight += (float)stack.func_77958_k() * 0.0025f;
                }
            }
            return 5.0f + extraWeight + (float)playerInAirTime * 0.0025f;
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase livingEnt = (EntityLivingBase)entity;
            int airTime = livingEnt.getEntityData().func_74762_e("timeInAir");
            airTime = livingEnt.field_70122_E || livingEnt.func_70072_I() ? 0 : ++airTime;
            livingEnt.getEntityData().func_74768_a("timeInAir", airTime);
            return 5.0f + (float)airTime * 0.0025f;
        }
        if (entity instanceof EntityBoat || entity instanceof EntityItem || entity instanceof EntityFishHook) {
            return 4000.0f;
        }
        if (entity instanceof EntityMinecart) {
            return 80.0f;
        }
        if (entity instanceof Entity && WeatherUtilData.isWindWeightSet(ent = (Entity)entity)) {
            return WeatherUtilData.getWindWeight(ent);
        }
        return 1.0f;
    }

    public static boolean isParticleRotServerSafe(World world, Object obj) {
        return world.field_72995_K && WeatherUtilEntity.isParticleRotClientCheck(obj);
    }

    public static boolean isParticleRotClientCheck(Object obj) {
        return obj instanceof EntityRotFX;
    }

    public static boolean canPushEntity(Entity ent) {
        WindManager windMan = ClientTickHandler.weatherManager.windManager;
        double speed = 10.0;
        int startX = (int)(ent.field_70165_t - speed * (-Maths.fastSin(windMan.windAngle / 180.0f * (float)Math.PI) * Maths.fastCos(0.0)));
        int startZ = (int)(ent.field_70161_v - speed * (Maths.fastCos(windMan.windAngle / 180.0f * (float)Math.PI) * Maths.fastCos(0.0)));
        return ent.field_70170_p.func_72933_a(new Maths.Vec3(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v).toVec3MC(), new Maths.Vec3((double)startX, ent.field_70163_u + (double)ent.func_70047_e(), (double)startZ).toVec3MC()) == null;
    }

    public static boolean isEntityOutside(Entity parEnt) {
        return WeatherUtilEntity.isEntityOutside(parEnt, false);
    }

    public static boolean isEntityOutside(Entity parEnt, boolean cheapCheck) {
        return WeatherUtilEntity.isPosOutside(parEnt.field_70170_p, new Maths.Vec3(parEnt.field_70165_t, parEnt.field_70163_u, parEnt.field_70161_v), cheapCheck);
    }

    public static boolean isPosOutside(World parWorld, Maths.Vec3 parPos) {
        return WeatherUtilEntity.isPosOutside(parWorld, parPos, false);
    }

    public static boolean isPosOutside(World parWorld, Maths.Vec3 parPos, boolean cheapCheck) {
        int rangeCheck = 5;
        boolean yOffset = true;
        BlockPos blockPos = new BlockPos(MathHelper.func_76128_c((double)parPos.posX), 0, MathHelper.func_76128_c((double)parPos.posZ));
        if ((double)WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, blockPos).func_177956_o() < parPos.posY + 1.0) {
            return true;
        }
        if (cheapCheck) {
            return false;
        }
        Maths.Vec3 vecTry = new Maths.Vec3(parPos.posX + (double)(EnumFacing.NORTH.func_82601_c() * rangeCheck), parPos.posY + (double)yOffset, parPos.posZ + (double)(EnumFacing.NORTH.func_82599_e() * rangeCheck));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry)) {
            return true;
        }
        vecTry = new Maths.Vec3(parPos.posX + (double)(EnumFacing.SOUTH.func_82601_c() * rangeCheck), parPos.posY + (double)yOffset, parPos.posZ + (double)(EnumFacing.SOUTH.func_82599_e() * rangeCheck));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry)) {
            return true;
        }
        vecTry = new Maths.Vec3(parPos.posX + (double)(EnumFacing.EAST.func_82601_c() * rangeCheck), parPos.posY + (double)yOffset, parPos.posZ + (double)(EnumFacing.EAST.func_82599_e() * rangeCheck));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry)) {
            return true;
        }
        vecTry = new Maths.Vec3(parPos.posX + (double)(EnumFacing.WEST.func_82601_c() * rangeCheck), parPos.posY + (double)yOffset, parPos.posZ + (double)(EnumFacing.WEST.func_82599_e() * rangeCheck));
        return WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkVecOutside(World parWorld, Maths.Vec3 parPos, Maths.Vec3 parCheckPos) {
        if (parWorld.func_72933_a(parPos.toVec3MC(), parCheckPos.toVec3MC()) != null) return false;
        BlockPos blockPos = new BlockPos(MathHelper.func_76128_c((double)parCheckPos.posX), 0, MathHelper.func_76128_c((double)parCheckPos.posZ));
        if (!((double)WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, blockPos).func_177956_o() < parCheckPos.posY)) return false;
        return true;
    }

    public static EntityPlayer getClosestPlayer(World world, double posX, double posY, double posZ, double distance) {
        double r = 0.0;
        EntityPlayer player = null;
        for (EntityPlayer entity : world.field_73010_i) {
            double player_distance = entity.func_70092_e(posX, posY, posZ);
            if (!(player_distance < distance * distance) || !(player_distance < r) && player != null) continue;
            r = player_distance;
            player = entity;
        }
        return player;
    }
}

