/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.util;

import CoroUtil.block.BlockRepairingBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.WeatherAPI;
import net.mrbt0907.weather2.block.BlockSandLayer;
import net.mrbt0907.weather2.config.ConfigGrab;
import net.mrbt0907.weather2.registry.BlockRegistry;
import net.mrbt0907.weather2.util.ConfigList;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.storm.StormObject;

public class WeatherUtilBlock {
    public static int layerableHeightPropMax = 8;

    public static boolean safeReplaceCheck(IBlockState state, World world, BlockPos pos) {
        try {
            return state.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void fillAgainstWallSmoothly(World world, Maths.Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable) {
        WeatherUtilBlock.fillAgainstWallSmoothly(world, posSource, directionYaw, scanDistance, fillRadius, blockLayerable, 4);
    }

    public static void fillAgainstWallSmoothly(World world, Maths.Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable, int heightDiff) {
        int heightTest;
        IBlockState stateTest = Weather2.getChunkUtil(world).getBlockState(world, posSource.toBlockPos());
        if (stateTest.func_177230_c() != blockLayerable || (heightTest = WeatherUtilBlock.getHeightForAnyBlock(stateTest)) < 8) {
            // empty if block
        }
        BlockPos posSourcei = posSource.toBlockPos();
        int y = posSourcei.func_177956_o();
        float tickStep = 0.75f;
        Maths.Vec3 posLastNonWall = posSource.copy();
        Maths.Vec3 posWall = null;
        BlockPos lastScannedPosXZ = null;
        int previousBlockHeight = 0;
        for (float i = 0.0f; i < scanDistance; i += tickStep) {
            double vecX = -Maths.fastSin(Math.toRadians(directionYaw)) * (double)i;
            double vecZ = Maths.fastCos(Math.toRadians(directionYaw)) * (double)i;
            int x = MathHelper.func_76128_c((double)(posSource.posX + vecX));
            int z = MathHelper.func_76128_c((double)(posSource.posZ + vecZ));
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos posXZ = new BlockPos(x, 0, z);
            IBlockState state = Weather2.getChunkUtil(world).getBlockState(world, pos);
            if (lastScannedPosXZ != null && posXZ.equals(lastScannedPosXZ)) continue;
            lastScannedPosXZ = new BlockPos((Vec3i)posXZ);
            AxisAlignedBB aabbCompare = new AxisAlignedBB(pos);
            ArrayList listAABBCollision = new ArrayList();
            state.func_185908_a(world, pos, aabbCompare, listAABBCollision, null, false);
            if (state.func_185904_a() != Material.field_151579_a && state.func_185904_a() != Material.field_151585_k && !WeatherUtilBlock.safeReplaceCheck(state, world, pos) && !listAABBCollision.isEmpty()) {
                BlockPos posUp = new BlockPos(x, y + 1, z);
                IBlockState stateUp = Weather2.getChunkUtil(world).getBlockState(world, posUp);
                if (stateUp.func_185904_a() == Material.field_151579_a) {
                    int height = WeatherUtilBlock.getHeightForAnyBlock(state);
                    if (height - previousBlockHeight <= heightDiff) {
                        if (height == 8) {
                            previousBlockHeight = 0;
                            ++y;
                        } else {
                            previousBlockHeight = height;
                        }
                        posLastNonWall = new Maths.Vec3(posSource.posX + vecX, (double)y, posSource.posZ + vecZ);
                        continue;
                    }
                    posWall = new Maths.Vec3(posSource.posX + vecX, (double)y, posSource.posZ + vecZ);
                    break;
                }
                posWall = new Maths.Vec3(posSource.posX + vecX, (double)y, posSource.posZ + vecZ);
                break;
            }
            posLastNonWall = new Maths.Vec3(posSource.posX + vecX, (double)y, posSource.posZ + vecZ);
        }
        if (posWall != null) {
            int amountWeHave = 1;
            int amountToAddPerXZ = 1;
            IBlockState state = Weather2.getChunkUtil(world).getBlockState(world, posWall.toBlockPos());
            IBlockState state1 = Weather2.getChunkUtil(world).getBlockState(world, posLastNonWall.toBlockPos().func_177982_a(1, 0, 0));
            IBlockState state22 = Weather2.getChunkUtil(world).getBlockState(world, posLastNonWall.toBlockPos().func_177982_a(-1, 0, 0));
            IBlockState state3 = Weather2.getChunkUtil(world).getBlockState(world, posLastNonWall.toBlockPos().func_177982_a(0, 0, 1));
            IBlockState state4 = Weather2.getChunkUtil(world).getBlockState(world, posLastNonWall.toBlockPos().func_177982_a(0, 0, -1));
            if (state.func_177230_c() == Blocks.field_150434_aF || state1.func_177230_c() == Blocks.field_150434_aF || state22.func_177230_c() == Blocks.field_150434_aF || state3.func_177230_c() == Blocks.field_150434_aF || state4.func_177230_c() == Blocks.field_150434_aF) {
                return;
            }
            BlockPos pos2 = new BlockPos(posLastNonWall.posX, posLastNonWall.posY, posLastNonWall.posZ);
            IBlockState state2 = Weather2.getChunkUtil(world).getBlockState(world, pos2);
            if (state2.func_185904_a() == Material.field_151586_h || state2.func_185904_a() == Material.field_151587_i) {
                return;
            }
            amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, new BlockPos(posLastNonWall.posX, posLastNonWall.posY, posLastNonWall.posZ), amountWeHave, amountToAddPerXZ, 10, blockLayerable);
        }
    }

    public static void fillAgainstWall(World world, Maths.Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable) {
        int ySource;
        float tickStep = 0.75f;
        BlockPos posSourcei = posSource.toBlockPos();
        int y = ySource = WeatherUtilBlock.getPrecipitationHeightSafe(world, posSourcei).func_177956_o();
        y = (int)posSource.posY;
        float startScan = scanDistance;
        Maths.Vec3 posLastNonWall = posSource.copy();
        Maths.Vec3 posWall = null;
        for (float i = 0.0f; i < scanDistance; i += tickStep) {
            double vecX = -Maths.fastSin(Math.toRadians(directionYaw)) * (double)i;
            double vecZ = Maths.fastCos(Math.toRadians(directionYaw)) * (double)i;
            int x = MathHelper.func_76128_c((double)(posSource.posX + vecX));
            int z = MathHelper.func_76128_c((double)(posSource.posZ + vecZ));
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = Weather2.getChunkUtil(world).getBlockState(world, pos);
            if (state.func_185904_a() != Material.field_151579_a) {
                startScan = i;
                posWall = new Maths.Vec3(posSource.posX + vecX, (double)y, posSource.posZ + vecZ);
                break;
            }
            posLastNonWall = new Maths.Vec3(posSource.posX + vecX, (double)y, posSource.posZ + vecZ);
        }
        if (posWall != null) {
            BlockPos posCheck = new BlockPos((Vec3i)posWall.toBlockPos());
            int heightOfWall = 0;
            int heightNeeded = 2;
            while (heightOfWall++ < heightNeeded) {
                posCheck = posCheck.func_177982_a(0, 1, 0);
                IBlockState stateCheck = Weather2.getChunkUtil(world).getBlockState(world, posCheck);
                if (stateCheck.isSideSolid((IBlockAccess)world, posCheck, EnumFacing.UP)) continue;
                break;
            }
            if (heightOfWall >= heightNeeded) {
                int amountWeHave = 4;
                int amountToAddPerXZ = 2;
                amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, new BlockPos(posLastNonWall.posX, posLastNonWall.posY, posLastNonWall.posZ), amountWeHave, amountToAddPerXZ, 10, blockLayerable);
            }
        }
    }

    public static void floodAreaWithLayerableBlock(World world, Maths.Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable, int amountToTakeOrFill) {
        WeatherUtilBlock.floodAreaWithLayerableBlock(world, posSource, directionYaw, scanDistance, fillRadius, -1.0f, blockLayerable, amountToTakeOrFill);
    }

    public static void floodAreaWithLayerableBlock(World world, Maths.Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, float takeRadius, Block blockLayerable, int amountToTakeOrRelocate) {
        float i;
        int ySource;
        float tickStep = 0.75f;
        BlockPos posSourcei = posSource.toBlockPos();
        int y = ySource = WeatherUtilBlock.getPrecipitationHeightSafe(world, posSourcei).func_177956_o();
        y = (int)posSource.posY;
        float startScan = scanDistance;
        Maths.Vec3 posLastNonWall = posSource.copy();
        Maths.Vec3 posWall = null;
        for (float i2 = 0.0f; i2 < scanDistance; i2 += tickStep) {
            double vecX = -Maths.fastSin(Math.toRadians(directionYaw)) * (double)i2;
            double vecZ = Maths.fastCos(Math.toRadians(directionYaw)) * (double)i2;
            int x = MathHelper.func_76128_c((double)(posSource.posX + vecX));
            int z = MathHelper.func_76128_c((double)(posSource.posZ + vecZ));
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = Weather2.getChunkUtil(world).getBlockState(world, pos);
            if (state.func_185904_a() != Material.field_151579_a) {
                startScan = i2;
                posWall = new Maths.Vec3(posSource.posX + vecX, (double)y, posSource.posZ + vecZ);
                break;
            }
            posLastNonWall = new Maths.Vec3(posSource.posX + vecX, (double)y, posSource.posZ + vecZ);
        }
        double distFromSourceToWall = posSource.distanceSq(posLastNonWall);
        boolean doRadius = true;
        if (takeRadius != -1.0f && distFromSourceToWall <= 2.0) {
            doRadius = false;
        }
        float angleScanResolution = 1.0f;
        float spreadDist = fillRadius;
        int maxFallDist = 20;
        int amountToTakePerXZ = 2;
        int amountToAddPerXZ = 2;
        int amountWeHave = 0;
        amountWeHave = takeRadius != -1.0f ? WeatherUtilBlock.tryTakeFromPos(world, posSourcei, amountWeHave, amountToTakePerXZ, maxFallDist, blockLayerable) : amountToTakeOrRelocate;
        ArrayList<BlockPos> listProcessedFilter = new ArrayList<BlockPos>();
        if (doRadius) {
            for (i = 1.0f; i < takeRadius; i += 0.75f) {
                for (float angle = 0.0f; angle <= 180.0f; angle += angleScanResolution) {
                    for (int mode = 0; mode <= 1; ++mode) {
                        int z;
                        float orientationMulti = 1.0f;
                        if (mode == 1) {
                            orientationMulti = -1.0f;
                        }
                        double vecX = -Maths.fastSin(Math.toRadians(directionYaw - angle * orientationMulti)) * (double)i;
                        double vecZ = Maths.fastCos(Math.toRadians(directionYaw - angle * orientationMulti)) * (double)i;
                        int x = MathHelper.func_76128_c((double)(posSource.posX + vecX));
                        BlockPos pos = new BlockPos(x, y = (int)posSource.posY, z = MathHelper.func_76128_c((double)(posSource.posZ + vecZ)));
                        if (listProcessedFilter.contains(pos)) continue;
                        listProcessedFilter.add(pos);
                        amountWeHave = WeatherUtilBlock.tryTakeFromPos(world, pos, amountWeHave, amountToTakePerXZ, maxFallDist, blockLayerable);
                    }
                }
            }
        }
        listProcessedFilter.clear();
        amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, new BlockPos(posLastNonWall.posX, posLastNonWall.posY, posLastNonWall.posZ), amountWeHave, amountToAddPerXZ, maxFallDist, blockLayerable);
        if (doRadius) {
            for (i = 1.0f; i < spreadDist && amountWeHave > 0; i += 0.75f) {
                int amountToAddBasedOnDist = (int)((float)layerableHeightPropMax + 1.0f - i * 1.5f);
                if (amountToAddBasedOnDist < 1) {
                    amountToAddBasedOnDist = 1;
                }
                amountToAddBasedOnDist = 2;
                for (float angle = 0.0f; angle <= 180.0f && amountWeHave > 0; angle += angleScanResolution) {
                    for (int mode = 0; mode <= 1 && amountWeHave > 0; ++mode) {
                        Vec3d destTest;
                        float orientationMulti = 1.0f;
                        if (mode == 1) {
                            orientationMulti = -1.0f;
                        }
                        double vecX = -Maths.fastSin(Math.toRadians(directionYaw - angle * orientationMulti)) * (double)i;
                        double vecZ = Maths.fastCos(Math.toRadians(directionYaw - angle * orientationMulti)) * (double)i;
                        int x = MathHelper.func_76128_c((double)(posLastNonWall.posX + vecX));
                        int z = MathHelper.func_76128_c((double)(posLastNonWall.posZ + vecZ));
                        y = (int)posLastNonWall.posY;
                        BlockPos pos = new BlockPos(x, y, z);
                        Vec3d sourceTest = posSource.addVector(0.0, 1.0, 0.0).toVec3MC();
                        RayTraceResult destFound = world.func_72901_a(sourceTest, destTest = new Vec3d((double)((float)x + 0.5f), (double)((float)y + 1.5f), (double)((float)z + 0.5f)), false);
                        if (destFound != null || listProcessedFilter.contains(pos)) continue;
                        listProcessedFilter.add(pos);
                        amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, pos, amountWeHave, amountToAddBasedOnDist, maxFallDist, blockLayerable);
                    }
                }
            }
        }
        Weather2.debug("leftover: " + amountWeHave);
    }

    public static int tryTakeFromPos(World world, BlockPos posTakeFrom, int amount, int amountAllowedToTakeForXZ, int maxDropAllowed, Block blockLayerable) {
        int amountTaken = 0;
        IBlockState statePos = Weather2.getChunkUtil(world).getBlockState(world, posTakeFrom);
        if (!WeatherUtilBlock.isLayeredOrVanillaVersionOfBlock(statePos, blockLayerable) && statePos.func_177230_c() != Blocks.field_150350_a) {
            return amount;
        }
        int dropDist = 0;
        BlockPos posScan = new BlockPos((Vec3i)posTakeFrom);
        while (statePos.func_177230_c() == Blocks.field_150350_a && dropDist++ < maxDropAllowed) {
            posScan = posScan.func_177982_a(0, -1, 0);
            statePos = Weather2.getChunkUtil(world).getBlockState(world, posScan);
            if (WeatherUtilBlock.isLayeredOrVanillaVersionOfBlock(statePos, blockLayerable) || statePos.func_177230_c() == Blocks.field_150350_a) continue;
            return amount;
        }
        int amountLeftToTake = amountAllowedToTakeForXZ;
        while (amountTaken < amountAllowedToTakeForXZ) {
            int amountReturn = WeatherUtilBlock.takeHeightFromLayerableBlock(world, posScan, blockLayerable, amountLeftToTake);
            amountTaken += amountReturn;
            posScan = posScan.func_177982_a(0, -1, 0);
            statePos = Weather2.getChunkUtil(world).getBlockState(world, posScan);
            if (WeatherUtilBlock.isLayeredOrVanillaVersionOfBlock(statePos, blockLayerable)) continue;
            break;
        }
        return amount + amountTaken;
    }

    public static int trySpreadOnPos2(World world, BlockPos posSpreadTo, int amount, int amountAllowedToAdd, int maxDropAllowed, Block blockLayerable) {
        int distForPlaceableBlocks;
        if (amount <= 0) {
            return amount;
        }
        if (Weather2.getChunkUtil(world).getBlockState(world, posSpreadTo.func_177982_a(0, 1, 0)).func_185904_a() != Material.field_151579_a) {
            return amount;
        }
        BlockPos posCheckNonAir = new BlockPos((Vec3i)posSpreadTo);
        IBlockState stateCheckNonAir = Weather2.getChunkUtil(world).getBlockState(world, posCheckNonAir);
        int depth = 0;
        while (stateCheckNonAir.func_185904_a() == Material.field_151579_a) {
            posCheckNonAir = posCheckNonAir.func_177982_a(0, -1, 0);
            stateCheckNonAir = Weather2.getChunkUtil(world).getBlockState(world, posCheckNonAir);
            if (++depth <= maxDropAllowed) continue;
            return amount;
        }
        BlockPos posCheckPlaceable = new BlockPos((Vec3i)posCheckNonAir);
        IBlockState stateCheckPlaceable = Weather2.getChunkUtil(world).getBlockState(world, posCheckPlaceable);
        for (distForPlaceableBlocks = 0; distForPlaceableBlocks < 10; ++distForPlaceableBlocks) {
            AxisAlignedBB aabbCompare = new AxisAlignedBB(posCheckPlaceable);
            ArrayList listAABBCollision = new ArrayList();
            stateCheckPlaceable.func_185908_a(world, posCheckPlaceable, aabbCompare, listAABBCollision, null, false);
            if (stateCheckPlaceable.func_177230_c() != blockLayerable && WeatherUtilBlock.safeReplaceCheck(stateCheckPlaceable, world, posCheckPlaceable) && listAABBCollision.isEmpty()) {
                posCheckPlaceable = posCheckPlaceable.func_177982_a(0, -1, 0);
                stateCheckPlaceable = Weather2.getChunkUtil(world).getBlockState(world, posCheckPlaceable);
                continue;
            }
            if (stateCheckPlaceable.isSideSolid((IBlockAccess)world, posCheckPlaceable, EnumFacing.UP) || stateCheckPlaceable.func_177230_c() == blockLayerable) break;
            return amount;
        }
        if (distForPlaceableBlocks >= 10) {
            return amount;
        }
        if (!stateCheckPlaceable.isSideSolid((IBlockAccess)world, posCheckPlaceable, EnumFacing.UP) && stateCheckPlaceable.func_177230_c() != blockLayerable) {
            Weather2.error("sandstorm: shouldnt be, failed a check somewhere!");
            return amount;
        }
        for (int i = 0; i < distForPlaceableBlocks; ++i) {
            Weather2.getChunkUtil(world).setBlockState(world, posCheckNonAir.func_177982_a(0, -i, 0), Blocks.field_150350_a.func_176223_P());
        }
        BlockPos posPlaceLayerable = new BlockPos((Vec3i)posCheckPlaceable);
        IBlockState statePlaceLayerable = Weather2.getChunkUtil(world).getBlockState(world, posPlaceLayerable);
        int amountToAdd = amountAllowedToAdd;
        while (amountAllowedToAdd > 0 && Weather2.getChunkUtil(world).getBlockState(world, posPlaceLayerable.func_177982_a(0, 1, 0)).func_185904_a() == Material.field_151579_a && amountAllowedToAdd > 0) {
            int height;
            if (statePlaceLayerable.func_177230_c() == blockLayerable && WeatherUtilBlock.getHeightForLayeredBlock(statePlaceLayerable) < layerableHeightPropMax) {
                height = WeatherUtilBlock.getHeightForLayeredBlock(statePlaceLayerable);
                if ((height += amountAllowedToAdd) > layerableHeightPropMax) {
                    amountAllowedToAdd = height - layerableHeightPropMax;
                    height = layerableHeightPropMax;
                } else {
                    amountAllowedToAdd = 0;
                }
                try {
                    Weather2.getChunkUtil(world).setBlockState(world, posPlaceLayerable, WeatherUtilBlock.setBlockWithLayerState(blockLayerable, height));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (height != layerableHeightPropMax) continue;
                posPlaceLayerable = posPlaceLayerable.func_177982_a(0, 1, 0);
                statePlaceLayerable = Weather2.getChunkUtil(world).getBlockState(world, posPlaceLayerable);
                continue;
            }
            if (statePlaceLayerable.isSideSolid((IBlockAccess)world, posPlaceLayerable, EnumFacing.UP)) {
                posPlaceLayerable = posPlaceLayerable.func_177982_a(0, 1, 0);
                statePlaceLayerable = Weather2.getChunkUtil(world).getBlockState(world, posPlaceLayerable);
                continue;
            }
            if (statePlaceLayerable.func_185904_a() == Material.field_151579_a) {
                height = amountAllowedToAdd;
                if (height > layerableHeightPropMax) {
                    amountAllowedToAdd = height - layerableHeightPropMax;
                    height = layerableHeightPropMax;
                } else {
                    amountAllowedToAdd = 0;
                }
                try {
                    Weather2.getChunkUtil(world).setBlockState(world, posPlaceLayerable, WeatherUtilBlock.setBlockWithLayerState(blockLayerable, height));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (height != layerableHeightPropMax) continue;
                posPlaceLayerable = posPlaceLayerable.func_177982_a(0, 1, 0);
                statePlaceLayerable = Weather2.getChunkUtil(world).getBlockState(world, posPlaceLayerable);
                continue;
            }
            Weather2.debug("wat! - " + statePlaceLayerable);
        }
        if (amountAllowedToAdd < 0) {
            Weather2.debug("wat");
        }
        int amountAdded = amountToAdd - amountAllowedToAdd;
        return amount -= amountAdded;
    }

    public static boolean isLayeredOrVanillaVersionOfBlock(IBlockState state, Block blockLayerable) {
        Block block = state.func_177230_c();
        if (block == blockLayerable) {
            return true;
        }
        if (blockLayerable == BlockRegistry.sand_layer && block == Blocks.field_150354_m) {
            return true;
        }
        return blockLayerable == Blocks.field_150431_aC && block == Blocks.field_150433_aE;
    }

    public static int getHeightForAnyBlock(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150431_aC) {
            return (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
        }
        if (block == BlockRegistry.sand_layer) {
            return (Integer)state.func_177229_b((IProperty)BlockSandLayer.LAYERS);
        }
        if (block == Blocks.field_150354_m || block == Blocks.field_150433_aE) {
            return 8;
        }
        if (block instanceof BlockSlab) {
            return 4;
        }
        if (block == Blocks.field_150350_a) {
            return 0;
        }
        return 8;
    }

    public static int getHeightForLayeredBlock(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150431_aC) {
            return (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
        }
        if (state.func_177230_c() == BlockRegistry.sand_layer) {
            return (Integer)state.func_177229_b((IProperty)BlockSandLayer.LAYERS);
        }
        if (state.func_177230_c() == Blocks.field_150354_m || state.func_177230_c() == Blocks.field_150433_aE) {
            return 8;
        }
        return 0;
    }

    public static IBlockState setBlockWithLayerState(Block block, int height) {
        if (block == Blocks.field_150431_aC) {
            if (height == layerableHeightPropMax) {
                return Blocks.field_150433_aE.func_176223_P();
            }
            return block.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(height));
        }
        if (block == BlockRegistry.sand_layer) {
            if (height == layerableHeightPropMax) {
                return Blocks.field_150354_m.func_176223_P();
            }
            return block.func_176223_P().func_177226_a((IProperty)BlockSandLayer.LAYERS, (Comparable)Integer.valueOf(height));
        }
        return null;
    }

    public static boolean divideToNeighborCheck(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean foundSpotToSpread = false;
        int heightToUse = WeatherUtilBlock.getHeightForLayeredBlock(state);
        if (heightToUse > 2) {
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                int heightCheck;
                if (heightToUse <= 2) continue;
                BlockPos posCheck = pos.func_177972_a(enumfacing);
                IBlockState stateCheck = worldIn.func_180495_p(posCheck);
                int addAmount = 1;
                if (stateCheck.func_177230_c() != state.func_177230_c() || (heightCheck = WeatherUtilBlock.getHeightForLayeredBlock(stateCheck)) + 2 > heightToUse) continue;
                heightToUse -= addAmount;
                WeatherUtilBlock.addHeightToLayerableBLock(worldIn, posCheck, stateCheck.func_177230_c(), heightCheck, addAmount);
                foundSpotToSpread = true;
            }
        }
        if (foundSpotToSpread) {
            worldIn.func_175656_a(pos, WeatherUtilBlock.setBlockWithLayerState(state.func_177230_c(), heightToUse));
        }
        return foundSpotToSpread;
    }

    public static int addHeightToLayerableBLock(World world, BlockPos pos, Block block, int sourceAmount, int amount) {
        int curAmount = sourceAmount;
        int leftOver = 0;
        if ((curAmount += amount) > layerableHeightPropMax) {
            leftOver = curAmount - layerableHeightPropMax;
            curAmount = layerableHeightPropMax;
        } else {
            leftOver = 0;
        }
        try {
            Weather2.getChunkUtil(world).setBlockState(world, pos, WeatherUtilBlock.setBlockWithLayerState(block, curAmount));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return leftOver;
    }

    public static int takeHeightFromLayerableBlock(World world, BlockPos pos, Block block, int amount) {
        IBlockState state = Weather2.getChunkUtil(world).getBlockState(world, pos);
        int height = WeatherUtilBlock.getHeightForLayeredBlock(state);
        int amountReceived = 0;
        int newHeight = 0;
        if (height <= amount) {
            newHeight = 0;
            amountReceived = height;
        } else {
            newHeight = height - amount;
            amountReceived = amount;
        }
        if (newHeight > 0) {
            try {
                Weather2.getChunkUtil(world).setBlockState(world, pos, WeatherUtilBlock.setBlockWithLayerState(block, newHeight));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            world.func_175698_g(pos);
        }
        return amountReceived;
    }

    public static BlockPos grabBlockPos(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_175667_e(pos)) {
            return pos;
        }
        return null;
    }

    public static boolean canReachBlock(World world, BlockPos pos) {
        return WeatherUtilBlock.canReachBlock(world, pos, 1);
    }

    public static boolean canReachBlock(World world, BlockPos pos, int range) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        if (world.func_175725_q(pos).func_177956_o() - 1 == pos.func_177956_o()) {
            return true;
        }
        for (int i = 1; i <= range; ++i) {
            if (world.func_175725_q(pos.func_177964_d(i)).func_177956_o() > pos.func_177956_o() && world.func_175725_q(pos.func_177965_g(i)).func_177956_o() > pos.func_177956_o() && world.func_175725_q(pos.func_177970_e(i)).func_177956_o() > pos.func_177956_o() && world.func_175725_q(pos.func_177985_f(i)).func_177956_o() > pos.func_177956_o()) continue;
            return true;
        }
        return false;
    }

    public static boolean canGrabBlock(StormObject storm, BlockPos pos, IBlockState state) {
        if (!ConfigGrab.grab_blocks || pos == null) {
            return false;
        }
        World world = storm.manager.getWorld();
        if (world == null || !WeatherUtilBlock.canReachBlock(world, pos)) {
            return false;
        }
        return WeatherUtilBlock.checkIllegalList(state);
    }

    public static boolean checkIllegalList(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return !(block instanceof BlockAir) && !material.func_76224_d() && !(block instanceof BlockRepairingBlock) && (material.func_76220_a() || block instanceof BlockBush);
    }

    public static boolean checkResistance(StormObject storm, String blockID) {
        ConfigList list = WeatherAPI.getWRList();
        float resistance = list.exists(blockID) ? ((Float)list.get(blockID)).floatValue() / 9.657718f : -1.0f;
        return resistance > -1.0f && storm.windSpeed >= resistance;
    }

    public static BlockPos getPrecipitationHeightSafe(World world, BlockPos pos) {
        if (world.func_175667_e(pos)) {
            return world.func_175725_q(pos);
        }
        return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
    }
}

