/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.util;

import CoroUtil.util.CoroUtilCompatibility;
import java.util.Calendar;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.mrbt0907.weather2.util.Maths;

public class WeatherUtil {
    public static boolean isPaused() {
        return FMLClientHandler.instance().getClient().func_147113_T();
    }

    public static boolean isPausedSideSafe(World world) {
        return world.field_72995_K ? WeatherUtil.isPaused() : false;
    }

    public static boolean isAprilFoolsDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar.get(2) == 3 && calendar.get(5) == 1;
    }

    public static float toFahrenheit(float temperature) {
        return temperature * 80.0f;
    }

    public static float toCelsius(float temperature) {
        return (temperature * 80.0f - 32.0f) * 5.0f / 9.0f;
    }

    public static float toMph(float windSpeed) {
        return windSpeed * 9.657718f;
    }

    public static float toKph(float windSpeed) {
        return windSpeed * 15.5412f;
    }

    public static float toMps(float windSpeed) {
        return windSpeed * 4.317f;
    }

    public static float getDewpoint(World world, BlockPos pos) {
        float a = WeatherUtil.toCelsius(WeatherUtil.getTemperature(world, pos)) - (100.0f - WeatherUtil.getHumidity(world, pos) * 100.0f) * 0.2f;
        return a;
    }

    public static float getPressure(World world, BlockPos pos) {
        return 1031.0f - 51.0f * WeatherUtil.getTemperature(world, pos) * 0.5f;
    }

    public static float getTemperature(World world, BlockPos pos) {
        float temp = CoroUtilCompatibility.getAdjustedTemperature((World)world, (Biome)world.func_180494_b(pos), (BlockPos)pos);
        float time_bonus = 0.0f;
        float[] time_table = new float[]{0.18f, 0.16f, 0.14f, 0.12f, 0.09f, 0.07f, 0.05f, 0.02f, 0.0f, 0.01f, 0.015f, 0.2f, 0.3f, 0.5f, 0.75f, 0.9f, 0.12f, 0.14f, 0.16f, 0.175f, 0.2f, 0.215f, 0.2f, 0.19f};
        long time = world.func_72820_D() % 24000L;
        time_bonus = time_table[(int)((double)time * 1.0E-4)];
        return temp - time_bonus;
    }

    public static float getHumidity(World world, BlockPos pos) {
        float a = WeatherUtil.getTemperature(world, pos);
        float b = CoroUtilCompatibility.getAdjustedTemperature((World)world, (Biome)world.func_180494_b(pos), (BlockPos)pos);
        return Math.max(a / b - Maths.clamp(a - 1.0f, 0.0f, 1.0f), 0.0f);
    }
}

