/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.util;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.mrbt0907.weather2.config.ConfigGrab;

public class Maths {
    private static final double[] SIN_TABLE;
    private static final double[] ASIN_TABLE;
    public static final double QTR_PI = 0.7853981633974483;
    public static final double THREE_QTR_PI = 2.356194490192345;
    private static Random random;

    public static int clamp(int input, int min, int max) {
        return min > max ? min : (input > min ? (input < max ? input : max) : min);
    }

    public static float clamp(float input, float min, float max) {
        return min > max ? min : (input > min ? (input < max ? input : max) : min);
    }

    public static double clamp(double input, double min, double max) {
        return min > max ? min : (input > min ? (input < max ? input : max) : min);
    }

    public static boolean chance() {
        return Maths.random(1) == 0;
    }

    public static boolean chance(int chance) {
        return Maths.random(0, 100) <= chance;
    }

    public static boolean chance(float chance) {
        return Maths.random(0.0f, 1.0f) <= chance;
    }

    public static boolean chance(double chance) {
        return Maths.random(0.0, 1.0) <= chance;
    }

    public static int random(int integerA) {
        return Maths.random(0, integerA);
    }

    public static int random(int integerA, int integerB) {
        return integerA >= integerB ? integerA : random.nextInt(integerB + 1 - integerA) + integerA;
    }

    public static float random(float floatA) {
        return Maths.random(0.0f, floatA);
    }

    public static float random(float floatA, float floatB) {
        return floatA >= floatB ? floatA : random.nextFloat() * (floatB - floatA) + floatA;
    }

    public static double random(double doubleA) {
        return Maths.random(0.0, doubleA);
    }

    public static double random(double doubleA, double doubleB) {
        return doubleA >= doubleB ? doubleA : random.nextDouble() * (doubleB - doubleA) + doubleA;
    }

    public static double distance(double posX, double posY, double posZ, Vec3 vector) {
        return Maths.distance(posX, posY, posZ, vector.posX, vector.posY, vector.posZ);
    }

    public static double distance(double posXA, double posYA, double posZA, double posXB, double posYB, double posZB) {
        return (posXA - posXB) * (posXA - posXB) + (posYA - posYB) * (posYA - posYB) + (posZA - posZB) * (posZA - posZB);
    }

    public static double distance(double posXA, double posZA, double posXB, double posZB) {
        return (posXA - posXB) * (posXA - posXB) + (posZA - posZB) * (posZA - posZB);
    }

    public static double distance(double posX, double posZ, Vec vector) {
        return Maths.distance(posX, posZ, vector.posX, vector.posZ);
    }

    public static double distanceSq(double posX, double posY, double posZ, Vec3 vector) {
        return Maths.distanceSq(posX, posY, posZ, vector.posX, vector.posY, vector.posZ);
    }

    public static double distanceSq(double posXA, double posYA, double posZA, double posXB, double posYB, double posZB) {
        return Math.sqrt(Maths.distance(posXA, posYA, posZA, posXB, posYB, posZB));
    }

    public static double distanceSq(double posXA, double posZA, double posXB, double posZB) {
        return Math.sqrt(Maths.distance(posXA, posZA, posXB, posZB));
    }

    public static double distanceSq(double posX, double posZ, Vec vector) {
        return Maths.distanceSq(posX, posZ, vector.posX, vector.posZ);
    }

    public static double speed(double motionX, double motionZ) {
        return motionX * motionX + motionZ * motionZ;
    }

    public static double speed(double motionX, double motionY, double motionZ) {
        return motionX * motionX + motionY * motionY + motionZ * motionZ;
    }

    public static double speedSq(double motionX, double motionZ) {
        return Math.sqrt(Maths.speed(motionX, motionZ));
    }

    public static double speedSq(double motionX, double motionY, double motionZ) {
        return Math.sqrt(Maths.speed(motionX, motionY, motionZ));
    }

    public static int adjust(int current, int target, int adjustment) {
        if (current > target ? (current -= adjustment) < target : current < target && (current += adjustment) > target) {
            return target;
        }
        return current;
    }

    public static float adjust(float current, float target, float adjustment) {
        if (current > target ? (current -= adjustment) < target : current < target && (current += adjustment) > target) {
            return target;
        }
        return current;
    }

    public static double adjust(double current, double target, double adjustment) {
        if (current > target ? (current -= adjustment) < target : current < target && (current += adjustment) > target) {
            return target;
        }
        return current;
    }

    public static int wrapDegrees(int degrees) {
        return degrees < 0 || degrees > 359 ? degrees % 360 : degrees;
    }

    public static float wrapDegrees(float degrees) {
        return degrees < 0.0f || degrees > 359.0f ? degrees % 360.0f : degrees;
    }

    public static double wrapDegrees(double degrees) {
        return degrees < 0.0 || degrees > 359.0 ? degrees % 360.0 : degrees;
    }

    public static double fastATan2(double y, double x) {
        double angle;
        double radius;
        if (ConfigGrab.disableCheapOptimizations) {
            return Math.atan2(y, x);
        }
        double abs = Math.abs(y) + Double.MIN_VALUE;
        if (x < 0.0) {
            radius = (x + abs) / (abs - x);
            angle = 2.356194490192345;
        } else {
            radius = (x - abs) / (x + abs);
            angle = 0.7853981633974483;
        }
        return y < 0.0 ? -angle : (angle += (0.1963 * radius * radius - 0.9817) * radius);
    }

    public static final double fastCos(double x) {
        return ConfigGrab.disableCheapOptimizations ? Math.cos(x) : SIN_TABLE[(int)(x * 10430.378 + 16384.0) & 0xFFFF];
    }

    public static double fastSin(double x) {
        return ConfigGrab.disableCheapOptimizations ? Math.sin(x) : SIN_TABLE[(int)(x * 10430.378) & 0xFFFF];
    }

    public static double fastASin(double x) {
        return ConfigGrab.disableCheapOptimizations ? Math.asin(x) : ASIN_TABLE[(int)((x + 1.0) * 32767.5) & 0xFFFF];
    }

    public static double fastACos(double x) {
        return ConfigGrab.disableCheapOptimizations ? Math.acos(x) : 1.5707964 - ASIN_TABLE[(int)((x + 1.0) * 32767.5) & 0xFFFF];
    }

    static {
        int i;
        SIN_TABLE = new double[65536];
        ASIN_TABLE = new double[65536];
        random = new Random();
        for (i = 0; i < 65536; ++i) {
            Maths.ASIN_TABLE[i] = (float)Math.asin((double)i / 32767.5 - 1.0);
        }
        for (i = -1; i < 2; ++i) {
            Maths.ASIN_TABLE[(int)(((double)i + 1.0) * 32767.5) & 0xFFFF] = (float)Math.asin(i);
        }
        for (i = 0; i < 65536; ++i) {
            Maths.SIN_TABLE[i] = Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    }

    public static class Vec3 {
        public double posX = 0.0;
        public double posY = 0.0;
        public double posZ = 0.0;

        public Vec3() {
        }

        public Vec3(Vec3d pos) {
            this.posX = pos.field_72450_a;
            this.posY = pos.field_72448_b;
            this.posZ = pos.field_72449_c;
        }

        public Vec3(CoroUtil.util.Vec3 pos) {
            this.posX = pos.xCoord;
            this.posY = pos.yCoord;
            this.posZ = pos.zCoord;
        }

        public Vec3(BlockPos pos) {
            this.posX = pos.func_177958_n();
            this.posY = pos.func_177956_o();
            this.posZ = pos.func_177952_p();
        }

        public Vec3(int posX, int posY, int posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
        }

        public Vec3(float posX, float posY, float posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
        }

        public Vec3(double posX, double posY, double posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
        }

        public BlockPos toBlockPos() {
            return new BlockPos(this.posX, this.posY, this.posZ);
        }

        public CoroUtil.util.Vec3 toVec3Coro() {
            return new CoroUtil.util.Vec3(this.posX, this.posY, this.posZ);
        }

        public Vec3d toVec3MC() {
            return new Vec3d(this.posX, this.posY, this.posZ);
        }

        public Vec3 copy() {
            return new Vec3(this.posX, this.posY, this.posZ);
        }

        public Vec3 addVector(double x, double y, double z) {
            this.posX += x;
            this.posY += y;
            this.posZ += z;
            return this;
        }

        public double distance(double posX, double posY, double posZ) {
            return Maths.distance(this.posX, this.posY, this.posZ, posX, posY, posZ);
        }

        public double distance(Vec vector) {
            return this.distance(vector.posX, this.posY, vector.posZ);
        }

        public double distance(Vec3 vector) {
            return this.distance(vector.posX, vector.posY, vector.posZ);
        }

        public double distanceSq(double posX, double posY, double posZ) {
            return Maths.distanceSq(this.posX, this.posY, this.posZ, posX, posY, posZ);
        }

        public double distanceSq(Vec vector) {
            return this.distanceSq(vector.posX, this.posY, vector.posZ);
        }

        public double distanceSq(Vec3 vector) {
            return this.distanceSq(vector.posX, vector.posY, vector.posZ);
        }

        public double distanceSq(Vec3d vector) {
            return this.distanceSq(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c);
        }

        public double speed() {
            return Maths.speed(this.posX, this.posY, this.posZ);
        }

        public double speedSq() {
            return Maths.speedSq(this.posX, this.posY, this.posZ);
        }
    }

    public static class Vec {
        public double posX = 0.0;
        public double posZ = 0.0;

        public Vec() {
        }

        public Vec(CoroUtil.util.Vec3 pos) {
            this.posX = pos.xCoord;
            this.posZ = pos.zCoord;
        }

        public Vec(BlockPos pos) {
            this.posX = pos.func_177958_n();
            this.posZ = pos.func_177952_p();
        }

        public Vec(int posX, int posZ) {
            this.posX = posX;
            this.posZ = posZ;
        }

        public Vec(float posX, float posZ) {
            this.posX = posX;
            this.posZ = posZ;
        }

        public Vec(double posX, double posZ) {
            this.posX = posX;
            this.posZ = posZ;
        }

        public Vec copy() {
            return new Vec(this.posX, this.posZ);
        }

        public BlockPos toBlockPos(double posY) {
            return new BlockPos(this.posX, posY, this.posZ);
        }

        public CoroUtil.util.Vec3 toVec3Coro() {
            return new CoroUtil.util.Vec3(this.posX, 0.0, this.posZ);
        }

        public Vec3d toVec3MC() {
            return new Vec3d(this.posX, 0.0, this.posZ);
        }

        public Vec addVector(double x, double z) {
            this.posX += x;
            this.posZ += z;
            return this;
        }

        public double distance(double posX, double posZ) {
            return Maths.distance(this.posX, this.posZ, posX, posZ);
        }

        public double distance(Vec vector) {
            return this.distance(vector.posX, vector.posZ);
        }

        public double distance(Vec3 vector) {
            return this.distance(vector.posX, vector.posZ);
        }

        public double distanceSq(double posX, double posZ) {
            return Maths.distanceSq(this.posX, this.posZ, posX, posZ);
        }

        public double distanceSq(Vec vector) {
            return this.distanceSq(vector.posX, vector.posZ);
        }

        public double distanceSq(Vec3 vector) {
            return this.distanceSq(vector.posX, vector.posZ);
        }

        public double speed() {
            return Maths.speed(this.posX, this.posZ);
        }

        public double speedSq() {
            return Maths.speedSq(this.posX, this.posZ);
        }
    }
}

