/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.mrbt0907.weather2.util.Maths;

public class MapEX<A, B> {
    private int index;
    private List<A> keys;
    private Map<A, B> map;

    public MapEX() {
        this.keys = new ArrayList<A>();
        this.map = new HashMap<A, B>();
    }

    public MapEX(Map<A, B> map) {
        this.keys = new ArrayList<A>(map.keySet());
        map = new HashMap<A, B>(map);
    }

    public B get(A key) {
        if (this.map.containsKey(key)) {
            this.index = this.keys.indexOf(key);
            return this.map.get(key);
        }
        return null;
    }

    public B getCurrent() {
        return this.map.get(this.keys.get(this.index));
    }

    public A nextKey() {
        ++this.index;
        if (this.index >= this.keys.size()) {
            this.index = 0;
        }
        return this.keys.get(this.index);
    }

    public B nextValue() {
        ++this.index;
        if (this.index >= this.keys.size()) {
            this.index = 0;
        }
        return this.map.get(this.keys.get(this.index));
    }

    public int indexOf(A key) {
        return this.keys.indexOf(key);
    }

    public A randomKey() {
        int index;
        this.index = index = Maths.random(this.keys.size() - 1);
        return this.keys.get(index);
    }

    public B randomValue() {
        int index;
        this.index = index = Maths.random(this.keys.size() - 1);
        return this.map.get(this.keys.get(index));
    }

    public void put(A key, B value) {
        this.keys.add(key);
        this.map.put(key, value);
    }

    public void remove(A key) {
        this.keys.remove(this.keys.indexOf(key));
        this.map.remove(key);
    }

    public int size() {
        return this.keys.size();
    }

    public List<A> keys() {
        return this.keys;
    }

    public List<B> values() {
        return new ArrayList<B>(this.map.values());
    }

    public void clear() {
        this.keys.clear();
        this.map.clear();
    }

    public boolean containsKey(A key) {
        return this.keys.contains(key);
    }

    public void forEach(BiConsumer<? super A, ? super B> action) {
        this.map.forEach(action);
    }
}

