/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigList {
    private Map<String, Object[]> map = new LinkedHashMap<String, Object[]>();
    private boolean replace = false;

    public ConfigList() {
    }

    public ConfigList(String ... entries) {
        for (String entry : entries) {
            this.parse(entry);
        }
    }

    public ConfigList addAll(ConfigList list) {
        if (list != null) {
            this.map.putAll(list.toMap());
        }
        return this;
    }

    public ConfigList add(String id, Object ... values) {
        if (this.map.containsKey(id)) {
            Object[] oldTable = this.map.get(id);
            Object[] table = null;
            int sizeA = oldTable.length;
            if (this.replace) {
                table = values;
            } else {
                int sizeB = sizeA + values.length;
                table = new Object[sizeB];
                for (int i = 0; i < sizeB; ++i) {
                    table[i] = i < sizeA ? oldTable[i] : values[i - sizeA];
                }
            }
            this.map.put(id, table);
        } else {
            this.map.put(id, values);
        }
        return this;
    }

    public ConfigList remove(String ... ids) {
        for (String id : ids) {
            this.map.remove(id);
        }
        return this;
    }

    public Object get(String id) {
        return this.get(id, 0);
    }

    public Object get(String id, int index) {
        Object[] a = this.map.get(id);
        return a != null && a.length > index ? a[index] : null;
    }

    public Object[] getValues(String id) {
        return this.map.get(id);
    }

    public boolean exists(String id) {
        return this.map.containsKey(id);
    }

    public void clear() {
        this.map.clear();
    }

    public Map<String, Object[]> toMap() {
        return this.map;
    }

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object[] value) {
        return this.map.containsValue(value);
    }

    public boolean isReplaceOnly() {
        return this.replace;
    }

    public ConfigList setReplaceOnly() {
        this.replace = true;
        return this;
    }

    public void parse(String str) {
        String[] entries;
        for (String entry : entries = str.split("[\\s\\,\\;\\\\]+")) {
            String id = "";
            ArrayList<String> values = new ArrayList<String>();
            String[] items = entry.split("\\=");
            int size = items.length;
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    id = items[i];
                    if (!id.contains("!")) continue;
                    this.remove(id);
                    id = "";
                    break;
                }
                values.add(items[i]);
            }
            if (id == "") continue;
            this.add(id, values.toArray());
        }
    }
}

