/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.mrbt0907.weather2.config.ConfigGrab;

public class ChunkUtils {
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final List<ChunkPosEX> chunks = new ArrayList<ChunkPosEX>();

    public void tick() {
        if (!this.chunks.isEmpty()) {
            Iterator<ChunkPosEX> iterator = this.chunks.iterator();
            while (iterator.hasNext()) {
                ChunkPosEX pos = iterator.next();
                ++pos.ticksExisted;
                if (pos.ticksExisted <= ConfigGrab.chunk_cache_lifetime) continue;
                iterator.remove();
            }
        }
    }

    public boolean isValidPos(World world, int y) {
        return world != null && y > -1 && y < 256;
    }

    public IBlockState getBlockState(World world, BlockPos pos) {
        return ConfigGrab.disableGrabOptimizations ? world.func_180495_p(pos) : this.getBlockState(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public IBlockState getBlockState(World world, int x, int y, int z) {
        if (ConfigGrab.disableGrabOptimizations) {
            return world.func_180495_p(new BlockPos(x, y, z));
        }
        if (!this.isValidPos(world, y)) {
            return AIR;
        }
        IChunkProvider provider = world.func_72863_F();
        ChunkPosEX pos = this.getChunkPos(x, z);
        if (pos.chunk == null) {
            pos.chunk = provider.func_186025_d(pos.cX, pos.cZ);
            this.chunks.add(pos);
            return pos.chunk.func_186032_a(z, y, z);
        }
        pos.ticksExisted = 0;
        return pos.chunk.func_186032_a(x, y, z);
    }

    public boolean setBlockState(World world, BlockPos pos, IBlockState state) {
        return ConfigGrab.disableGrabOptimizations ? world.func_180501_a(pos, state, 3) : this.setBlockState(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state, this.getBlockState(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
    }

    public boolean setBlockState(World world, int x, int y, int z, IBlockState state) {
        return ConfigGrab.disableGrabOptimizations ? world.func_180501_a(new BlockPos(x, y, z), state, 3) : this.setBlockState(world, x, y, z, state, this.getBlockState(world, x, y, z));
    }

    public boolean setBlockState(World world, int x, int y, int z, IBlockState state, IBlockState oldState) {
        if (ConfigGrab.disableGrabOptimizations) {
            return world.func_180501_a(new BlockPos(x, y, z), state, 3);
        }
        if (!this.isValidPos(world, y) || state == null) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        return this.updateBlockState(world, pos, state, oldState);
    }

    public void clearCache() {
        this.chunks.clear();
    }

    private boolean updateBlockState(World world, BlockPos pos, IBlockState state, IBlockState oldState) {
        Object cachedChunk = null;
        if (cachedChunk.func_177436_a(pos, state) != null) {
            if (state.getLightOpacity((IBlockAccess)world, pos) != oldState.getLightOpacity((IBlockAccess)world, pos) || state.getLightValue((IBlockAccess)world, pos) != oldState.getLightValue((IBlockAccess)world, pos)) {
                world.func_175664_x(pos);
            }
            if (!world.field_72995_K) {
                if (cachedChunk == null || cachedChunk.func_150802_k()) {
                    world.func_184138_a(pos, oldState, state, 3);
                }
                world.func_175722_b(pos, oldState.func_177230_c(), true);
                if (state.func_185912_n()) {
                    world.func_175666_e(pos, state.func_177230_c());
                }
            }
            return true;
        }
        return false;
    }

    public ChunkPosEX getChunkPos(int x, int z) {
        int cX = x >> 4;
        int cZ = z >> 4;
        for (ChunkPosEX pos : this.chunks) {
            if (cX != pos.cX || cZ != pos.cZ) continue;
            return pos;
        }
        return new ChunkPosEX(x, z);
    }

    public static class ChunkPosEX {
        public final int cX;
        public final int cZ;
        public Chunk chunk;
        public int ticksExisted;

        public ChunkPosEX(BlockPos pos) {
            this(pos.func_177958_n(), pos.func_177952_p());
        }

        public ChunkPosEX(int x, int z) {
            this.cX = x >> 4;
            this.cZ = z >> 4;
        }

        public int hashCode() {
            return 1664525 * this.cX + 1013904223 ^ 1664525 * (this.cZ ^ 0xDEADBEEF) + 1013904223;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ChunkPosEX && ((ChunkPosEX)obj).cX == this.cX && ((ChunkPosEX)obj).cZ == this.cZ;
        }

        public String toString() {
            return "[" + this.cX + ", " + this.cZ + "]";
        }
    }
}

