/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.util;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.mrbt0907.weather2.util.Maths;

public class BlockSnapshot {
    public final IBlockState state;
    public final Block block;
    public final BlockPos pos;
    public final int meta;
    public final int x;
    public final int y;
    public final int z;

    public BlockSnapshot(@Nonnull IBlockState state, BlockPos pos) {
        this.state = state;
        this.pos = pos;
        this.block = state.func_177230_c();
        this.meta = this.block.func_176201_c(state);
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public double distance(BlockSnapshot snapshot) {
        return this.distance(snapshot.x, snapshot.y, snapshot.z);
    }

    public double distance(double x, double y, double z) {
        return Maths.distanceSq(this.x, this.y, this.z, x, y, z);
    }

    public int hashCode() {
        return this.x + this.z << 8 + this.y << 16;
    }

    public boolean equals(Object object) {
        return object instanceof BlockSnapshot && ((BlockSnapshot)object).hashCode() == this.hashCode();
    }

    public String toString() {
        return "BlockSnapshot{block=" + this.block.getRegistryName() + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }
}

