/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.server.weather;

import CoroUtil.util.CoroUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.weather.IWeatherRain;
import net.mrbt0907.weather2.api.weather.IWeatherStaged;
import net.mrbt0907.weather2.config.ConfigFront;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.config.ConfigSand;
import net.mrbt0907.weather2.config.ConfigSimulation;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.network.packets.PacketFrontObject;
import net.mrbt0907.weather2.network.packets.PacketVanillaWeather;
import net.mrbt0907.weather2.network.packets.PacketVolcanoObject;
import net.mrbt0907.weather2.network.packets.PacketWeatherObject;
import net.mrbt0907.weather2.network.packets.PacketWind;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtilBlock;
import net.mrbt0907.weather2.util.WeatherUtilEntity;
import net.mrbt0907.weather2.weather.WeatherManager;
import net.mrbt0907.weather2.weather.storm.FrontObject;
import net.mrbt0907.weather2.weather.storm.SandstormObject;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.TornadoHelper;
import net.mrbt0907.weather2.weather.storm.WeatherObject;
import net.mrbt0907.weather2.weather.volcano.VolcanoObject;
import org.apache.commons.io.FileUtils;

public class WeatherManagerServer
extends WeatherManager {
    private long ticksFrontFormed = 0L;
    private long ticksSandstormFormed = 0L;
    private long ticksStormFormed = 0L;

    public WeatherManagerServer(World world) {
        super(world);
    }

    @Override
    public World getWorld() {
        return DimensionManager.getWorld((int)this.dim);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.world != null) {
            int i;
            this.tickWeatherCoverage(this.ticks);
            ArrayList fronts = new ArrayList(this.fronts.values());
            List<WeatherObject> systems = this.getWeatherObjects();
            StormObject spawn = null;
            boolean spawned = false;
            boolean spawnInFront = Maths.chance(ConfigFront.chance_to_spawn_storm_in_front * 0.01);
            for (i = 0; i < fronts.size(); ++i) {
                FrontObject front = (FrontObject)fronts.get(i);
                if (front.isDead) {
                    if (front.isGlobal()) {
                        front.reset();
                        systems.forEach(weather -> PacketWeatherObject.remove(this.dim, weather));
                        systems.clear();
                        front.isDead = false;
                        continue;
                    }
                    PacketFrontObject.remove(this.dim, front);
                    this.removeFront(front.getUUID());
                    continue;
                }
                if (!front.equals(this.globalFront) && spawnInFront && this.canSpawnWeather(1) && (spawn = front.createNaturalStorm()) != null) {
                    spawned = true;
                    PacketWeatherObject.create(this.dim, spawn);
                }
                if (this.ticks % 40L != 0L) continue;
                PacketFrontObject.update(this.dim, front);
            }
            if (spawned) {
                this.ticksStormFormed = this.world.func_82737_E() + (long)ConfigStorm.storm_spawn_delay;
            }
            for (i = 0; i < systems.size(); ++i) {
                WeatherObject system = systems.get(i);
                if (this.ticks % 20L == 0L) {
                    system.ticksSinceNoNearPlayer = ConfigMisc.remove_storms_if_no_players && this.world.field_73010_i.size() == 0 || WeatherUtilEntity.getClosestPlayer(this.world, system.posGround.posX, system.posGround.posY, system.posGround.posZ, ConfigSimulation.max_storm_distance) == null ? (system.ticksSinceNoNearPlayer += 20) : 0;
                }
                if (system.isDead || system.ticksSinceNoNearPlayer > 600 || ConfigMisc.aesthetic_mode) {
                    PacketWeatherObject.remove(this.dim, system);
                    system.front.removeWeatherObject(system.getUUID());
                    continue;
                }
                if (this.ticks % (long)system.getNetRate() != 0L) continue;
                PacketWeatherObject.update(this.dim, system);
            }
            if (this.ticks % 40L == 0L) {
                this.volcanoObjects.forEach(vo -> PacketVolcanoObject.update(this.dim, vo));
            }
            if (this.ticks % 60L == 0L) {
                PacketWind.update(this.dim, this.windManager);
                this.nbtStormsForIMC();
            }
            if (!ConfigMisc.aesthetic_mode && EZConfigParser.isWeatherEnabled(this.dim) && this.world.func_82737_E() % (long)ConfigStorm.spawningTickRate == 0L) {
                List players = this.world.field_73010_i;
                int frontCount = fronts.size() + 1;
                for (EntityPlayer player : players) {
                    int layer = Maths.random(2);
                    if (this.canSpawnWeather(0) && ConfigStorm.isLayerValid(layer)) {
                        this.ticksFrontFormed = this.world.func_82737_E() + (long)ConfigStorm.storm_spawn_delay;
                        PacketFrontObject.create(this.dim, this.createNaturalFront(layer, player));
                        if (!ConfigStorm.enable_spawn_per_player) break;
                    }
                    for (int i2 = 0; i2 < frontCount; ++i2) {
                        if (spawnInFront || !this.canSpawnWeather(1) || (spawn = this.globalFront.createNaturalStorm((Entity)player)) == null) continue;
                        spawned = true;
                        PacketWeatherObject.create(this.dim, spawn);
                    }
                }
                if (!spawnInFront && spawned) {
                    this.ticksStormFormed = this.world.func_82737_E() + (long)ConfigStorm.storm_spawn_delay;
                }
                if (this.canSpawnWeather(2) && this.world.field_73010_i.size() > 0) {
                    EntityPlayer player = (EntityPlayer)this.world.field_73010_i.get(Maths.random(this.world.field_73010_i.size() - 1));
                    this.ticksSandstormFormed = this.world.func_82737_E() + (long)ConfigSand.sandstorm_spawn_delay;
                    this.spawnSandstorm(new Maths.Vec3(player.field_70165_t, player.field_70163_u, player.field_70161_v));
                }
            }
            TornadoHelper.tickProcess(this.world);
        }
    }

    public void tickWeatherCoverage(long ticks) {
        WorldInfo worldInfo = this.world.func_72912_H();
        boolean isRaining = worldInfo.func_76059_o();
        boolean isThundering = worldInfo.func_76061_m();
        if (EZConfigParser.isWeatherEnabled(this.dim)) {
            if (!ConfigMisc.overcast_mode && ConfigMisc.server_weather_mode != -1) {
                worldInfo.func_76084_b(ConfigMisc.server_weather_mode == 1);
                worldInfo.func_76069_a(ConfigMisc.server_weather_mode == 1);
            }
            if (isThundering && ConfigStorm.prevent_vanilla_thunderstorms) {
                worldInfo.func_76069_a(false);
            }
        }
        if (ticks % 40L == 0L) {
            PacketVanillaWeather.send(this.dim, isRaining ? (isThundering ? 2 : 1) : 0, this.getWorld().func_72912_H().func_76083_p());
        }
        if (ticks % 200L == 0L) {
            this.cloudIntensity = ConfigMisc.overcast_mode && isRaining ? 1.0f : this.cloudIntensity + (float)Maths.clamp(Maths.random(ConfigParticle.cloud_coverage_change_amount) - Maths.random(ConfigParticle.cloud_coverage_change_amount), ConfigParticle.min_cloud_coverage_perc * 0.01, ConfigParticle.max_cloud_coverage_perc * 0.01);
        }
    }

    public void writeToFile() {
        Weather2.debug("Saving weather2 data...");
        NBTTagCompound mainNBT = new NBTTagCompound();
        NBTTagCompound volcanoesNBT = new NBTTagCompound();
        this.volcanoObjects.forEach(vo -> {
            NBTTagCompound nbt = new NBTTagCompound();
            vo.writeToNBT(nbt);
            volcanoesNBT.func_74782_a("volcano_" + vo.ID, (NBTBase)nbt);
        });
        mainNBT.func_74782_a("volcanoData", (NBTBase)volcanoesNBT);
        NBTTagCompound frontNBT = new NBTTagCompound();
        NBTTagCompound weatherNBT = new NBTTagCompound();
        frontNBT.func_74782_a("front_global", (NBTBase)this.globalFront.writeNBT());
        this.globalFront.getWeatherObjects().forEach(weatherObject -> {
            weatherObject.nbt.setUpdateForced(true);
            weatherObject.nbt.setUUID("frontUUID", this.globalFront.getUUID());
            weatherNBT.func_74782_a("storm_" + weatherObject.getUUID().toString(), (NBTBase)weatherObject.writeToNBT().getNewNBT());
            weatherObject.nbt.setUpdateForced(false);
            Weather2.debug("Saved storm_" + weatherObject.getUUID().toString());
        });
        Weather2.debug("Saved front_global");
        this.fronts.forEach((uuid, front) -> {
            if (!front.equals(this.globalFront)) {
                frontNBT.func_74782_a("front_" + uuid.toString(), (NBTBase)front.writeNBT());
                front.getWeatherObjects().forEach(weatherObject -> {
                    weatherObject.nbt.setUpdateForced(true);
                    weatherObject.nbt.setUUID("frontUUID", (UUID)uuid);
                    weatherNBT.func_74782_a("storm_" + weatherObject.getUUID().toString(), (NBTBase)weatherObject.writeToNBT().getNewNBT());
                    weatherObject.nbt.setUpdateForced(false);
                    Weather2.debug("Saved storm_" + weatherObject.getUUID().toString());
                });
                Weather2.debug("Saved front_" + uuid.toString());
            }
        });
        mainNBT.func_74782_a("frontData", (NBTBase)frontNBT);
        mainNBT.func_74782_a("stormData", (NBTBase)weatherNBT);
        mainNBT.func_74776_a("cloudIntensity", this.cloudIntensity);
        mainNBT.func_74776_a("ticksFrontFormed", (float)this.ticksFrontFormed);
        mainNBT.func_74776_a("ticksSandstormFormed", (float)this.ticksSandstormFormed);
        mainNBT.func_74776_a("ticksStormFormed", (float)this.ticksStormFormed);
        mainNBT.func_74782_a("windMan", (NBTBase)this.windManager.writeToNBT(new NBTTagCompound()));
        String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "weather2" + File.separator;
        try {
            if (!new File(saveFolder).exists()) {
                new File(saveFolder).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(saveFolder + "WeatherData_" + this.dim + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)mainNBT, (OutputStream)fos);
            fos.close();
            Weather2.debug("Save successful!");
        }
        catch (Exception ex) {
            Weather2.debug("Save failed.");
            ex.printStackTrace();
        }
    }

    public void readFromFile() {
        Weather2.debug("Loading weather2 data...");
        NBTTagCompound mainNBT = new NBTTagCompound();
        String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "weather2" + File.separator;
        try {
            if (new File(saveFolder + "WeatherData_" + this.dim + ".dat").exists()) {
                mainNBT = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "WeatherData_" + this.dim + ".dat"));
                File tmp = new File(saveFolder + "WeatherData_" + this.dim + "_BACKUP0.dat");
                if (tmp.exists()) {
                    FileUtils.copyFile((File)tmp, (File)new File(saveFolder + "WeatherData_" + this.dim + "_BACKUP1.dat"));
                }
                if (new File(saveFolder + "WeatherData_" + this.dim + ".dat").exists()) {
                    FileUtils.copyFile((File)new File(saveFolder + "WeatherData_" + this.dim + ".dat"), (File)new File(saveFolder + "WeatherData_" + this.dim + "_BACKUP0.dat"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Weather2.warn("Weather2 File: WeatherData.dat failed to load, automatically restoring to backup from previous game run");
            try {
                if (new File(saveFolder + "WeatherData_" + this.dim + "_BACKUP0.dat").exists()) {
                    mainNBT = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "WeatherData_" + this.dim + "_BACKUP0.dat"));
                } else {
                    Weather2.warn("Failed to find backup file WeatherData_BACKUP0.dat, nothing loaded");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Weather2.warn("Completely failed to find backup file WeatherData_BACKUP0.dat, nothing loaded");
            }
        }
        if (mainNBT.func_74764_b("cloudIntensity")) {
            this.cloudIntensity = mainNBT.func_74760_g("cloudIntensity");
        }
        if (mainNBT.func_74764_b("ticksFrontFormed")) {
            this.ticksFrontFormed = mainNBT.func_74763_f("ticksFrontFormed");
        }
        if (mainNBT.func_74764_b("ticksSandstormFormed")) {
            this.ticksSandstormFormed = mainNBT.func_74763_f("ticksSandstormFormed");
        }
        if (mainNBT.func_74764_b("ticksStormFormed")) {
            this.ticksStormFormed = mainNBT.func_74763_f("ticksStormFormed");
        }
        this.windManager.readFromNBT(mainNBT.func_74775_l("windMan"));
        NBTTagCompound volcanosNBT = mainNBT.func_74775_l("volcanoData");
        volcanosNBT.func_150296_c().forEach(name -> {
            NBTTagCompound nbt = volcanosNBT.func_74775_l(name);
            VolcanoObject vo = new VolcanoObject(this);
            try {
                vo.readFromNBT(nbt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.addVolcanoObject(vo);
            PacketVolcanoObject.create(this.dim, vo);
        });
        NBTTagCompound frontNBT = mainNBT.func_74775_l("frontData");
        frontNBT.func_150296_c().forEach(name -> {
            NBTTagCompound nbt = frontNBT.func_74775_l(name);
            Weather2.debug("Front name: " + name);
            if (name.equals("front_global")) {
                this.globalFront = new FrontObject(this, null, 0);
                this.globalFront.readNBT(nbt);
                this.fronts.put(this.globalFront.getUUID(), this.globalFront);
                Weather2.debug("Loaded global front " + this.globalFront.getUUID().toString());
                PacketFrontObject.create(this.world.field_73011_w.getDimension(), this.globalFront);
            } else {
                FrontObject front = new FrontObject(this, new Maths.Vec3((double)nbt.func_74762_e("layer"), nbt.func_74769_h("posX"), nbt.func_74769_h("posZ")), nbt.func_74762_e("layer"));
                front.readNBT(nbt);
                this.fronts.put(front.getUUID(), front);
                Weather2.debug("Loaded front " + front.getUUID().toString());
                PacketFrontObject.create(this.world.field_73011_w.getDimension(), front);
            }
        });
        if (this.globalFront == null) {
            this.globalFront = new FrontObject(this, null, 0);
            this.fronts.put(this.globalFront.getUUID(), this.globalFront);
            Weather2.debug("Created a new global front " + this.globalFront.getUUID().toString());
            PacketFrontObject.create(this.world.field_73011_w.getDimension(), this.globalFront);
        }
        NBTTagCompound weatherNBT = mainNBT.func_74775_l("stormData");
        weatherNBT.func_150296_c().forEach(name -> {
            NBTTagCompound nbt = weatherNBT.func_74775_l(name);
            FrontObject front = this.getFront(nbt.func_186857_a("frontUUID"));
            WeatherObject wo = null;
            if (front == null) {
                front = this.globalFront;
            }
            switch (nbt.func_74762_e("weatherObjectType")) {
                case 0: {
                    wo = new StormObject(front);
                    break;
                }
                case 1: {
                    wo = new SandstormObject(this);
                    break;
                }
                default: {
                    Weather2.warn("Non-existant type attempted to load into the weather system. Skipping...");
                }
            }
            if (wo != null) {
                try {
                    wo.nbt.setNewNBT(nbt);
                    wo.nbt.updateCacheFromNew();
                    wo.readFromNBT();
                    front.addWeatherObject(wo);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Weather2.debug("Loaded storm " + wo.getUUID().toString());
                PacketWeatherObject.create(this.world.field_73011_w.getDimension(), wo);
            }
        });
        Weather2.debug("Loading Weather2 data successful!");
    }

    public boolean spawnSandstorm(Maths.Vec3 posIn) {
        int searchRadius = 512;
        double angle = this.windManager.windAngle;
        double dirX = -Maths.fastSin(Math.toRadians(angle));
        double dirZ = Maths.fastCos(Math.toRadians(angle));
        double vecX = dirX * (double)searchRadius / 2.0 * -1.0;
        double vecZ = dirZ * (double)searchRadius / 2.0 * -1.0;
        Random rand = new Random();
        BlockPos foundPos = null;
        int findTriesMax = 30;
        for (int i = 0; i < findTriesMax; ++i) {
            int zz;
            int xx;
            BlockPos posRight;
            Biome biomeIn;
            int z;
            int x = MathHelper.func_76128_c((double)(posIn.posX + vecX + (double)rand.nextInt(searchRadius * 2) - (double)searchRadius));
            BlockPos pos = new BlockPos(x, 0, z = MathHelper.func_76128_c((double)(posIn.posZ + vecZ + (double)rand.nextInt(searchRadius * 2) - (double)searchRadius)));
            if (!this.world.func_175667_e(pos) || !SandstormObject.isDesert(biomeIn = this.world.getBiomeForCoordsBody(pos), true)) continue;
            foundPos = pos;
            double dirXLeft = -Maths.fastSin(Math.toRadians(angle - 90.0));
            double dirZLeft = Maths.fastCos(Math.toRadians(angle - 90.0));
            double dirXRight = -Maths.fastSin(Math.toRadians(angle + 90.0));
            double dirZRight = Maths.fastCos(Math.toRadians(angle + 90.0));
            double distLeftRight = 20.0;
            BlockPos posLeft = new BlockPos((double)foundPos.func_177958_n() + dirXLeft * distLeftRight, 0.0, (double)foundPos.func_177952_p() + dirZLeft * distLeftRight);
            if (!this.world.func_175667_e(posLeft) || !SandstormObject.isDesert(this.world.getBiomeForCoordsBody(posLeft)) || !this.world.func_175667_e(posRight = new BlockPos((double)foundPos.func_177958_n() + dirXRight * distLeftRight, 0.0, (double)foundPos.func_177952_p() + dirZRight * distLeftRight)) || !SandstormObject.isDesert(this.world.getBiomeForCoordsBody(posRight))) continue;
            BlockPos posFind = new BlockPos((Vec3i)foundPos);
            BlockPos posFindLastGoodUpwind = new BlockPos((Vec3i)foundPos);
            BlockPos posFindLastGoodDownwind = new BlockPos((Vec3i)foundPos);
            double tickDist = 10.0;
            while (this.world.func_175667_e(posFind) && SandstormObject.isDesert(this.world.getBiomeForCoordsBody(posFind))) {
                posFindLastGoodUpwind = new BlockPos((Vec3i)posFind);
                xx = MathHelper.func_76128_c((double)((double)posFind.func_177958_n() + dirX * -1.0 * tickDist));
                zz = MathHelper.func_76128_c((double)((double)posFind.func_177952_p() + dirZ * -1.0 * tickDist));
                posFind = new BlockPos(xx, 0, zz);
            }
            posFind = new BlockPos((Vec3i)foundPos);
            while (this.world.func_175667_e(posFind) && SandstormObject.isDesert(this.world.getBiomeForCoordsBody(posFind))) {
                posFindLastGoodDownwind = new BlockPos((Vec3i)posFind);
                xx = MathHelper.func_76128_c((double)((double)posFind.func_177958_n() + dirX * 1.0 * tickDist));
                zz = MathHelper.func_76128_c((double)((double)posFind.func_177952_p() + dirZ * 1.0 * tickDist));
                posFind = new BlockPos(xx, 0, zz);
            }
            int minDistanceOfDesertStretchNeeded = 200;
            double dist = posFindLastGoodUpwind.func_185332_f(posFindLastGoodDownwind.func_177958_n(), posFindLastGoodDownwind.func_177956_o(), posFindLastGoodDownwind.func_177952_p());
            if (!(dist >= (double)minDistanceOfDesertStretchNeeded)) continue;
            SandstormObject sandstorm = new SandstormObject(this);
            sandstorm.init();
            BlockPos posSpawn = new BlockPos((Vec3i)WeatherUtilBlock.getPrecipitationHeightSafe(this.world, posFindLastGoodUpwind)).func_177982_a(0, 1, 0);
            sandstorm.initSandstormSpawn(new Maths.Vec3(posSpawn));
            this.globalFront.addWeatherObject(sandstorm);
            PacketWeatherObject.create(this.dim, sandstorm);
            Weather2.debug("found decent spot and stretch for sandstorm, stretch: " + dist);
            return true;
        }
        Weather2.debug("couldnt spawn sandstorm");
        return false;
    }

    public void playerJoinedWorldSyncFull(EntityPlayerMP entP) {
        Weather2.debug(entP == null ? "An unknown player " : "Player " + entP.getDisplayNameString() + "'s client requested for a full sync");
        this.fronts.forEach((uuid, front) -> {
            PacketFrontObject.create(entP, front);
            front.getWeatherObjects().forEach(wo -> PacketWeatherObject.create(entP, wo));
        });
        this.volcanoObjects.forEach(vo -> PacketVolcanoObject.create(entP, vo));
    }

    public void nbtStormsForIMC() {
        NBTTagCompound nbt = new NBTTagCompound();
        List<WeatherObject> list = this.getWeatherObjects();
        for (WeatherObject wo : list) {
            if ((!(wo instanceof IWeatherRain) || !((IWeatherRain)((Object)wo)).hasDownfall()) && (!(wo instanceof IWeatherStaged) || wo.getStage() <= 0)) continue;
            wo.writeToNBT();
            nbt.func_74782_a("storm_" + wo.getUUID().toString(), (NBTBase)wo.nbt.getNewNBT());
        }
        if (!nbt.func_82582_d()) {
            FMLInterModComms.sendRuntimeMessage((Object)Weather2.instance, (String)"weather2remaster", (String)"weather.storms", (NBTTagCompound)nbt);
        }
    }

    protected boolean canSpawnWeather(int type) {
        if (!EZConfigParser.isWeatherEnabled(this.world.field_73011_w.getDimension())) {
            return false;
        }
        switch (type) {
            case 0: {
                long ticks = this.ticksFrontFormed - this.world.func_82737_E();
                if (ticks > (long)ConfigStorm.storm_spawn_delay) {
                    this.ticksFrontFormed = this.world.func_82737_E() + (long)ConfigStorm.storm_spawn_delay;
                }
                return (!ConfigStorm.disable_tornados || !ConfigStorm.disable_cyclones) && this.ticksFrontFormed < this.world.func_82737_E() && this.fronts.size() - 1 < ConfigFront.max_front_objects;
            }
            case 1: {
                long ticks = this.ticksStormFormed - this.world.func_82737_E();
                if (ticks > (long)ConfigStorm.storm_spawn_delay) {
                    this.ticksStormFormed = this.world.func_82737_E() + (long)ConfigStorm.storm_spawn_delay;
                }
                return (!ConfigStorm.disable_tornados || !ConfigStorm.disable_cyclones) && this.ticksStormFormed < this.world.func_82737_E() && this.systems.size() < ConfigStorm.max_weather_objects;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }
}

