/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.server.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import modconfig.ConfigMod;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.network.packets.PacketEZGUI;
import net.mrbt0907.weather2.server.weather.WeatherManagerServer;

public class ServerTickHandler {
    public static Map<Integer, WeatherManagerServer> dimensionSystems = new HashMap<Integer, WeatherManagerServer>();
    public static World lastWorld;
    public static NBTTagCompound worldNBT;

    public static void onTickInGame() {
        if (FMLCommonHandler.instance() == null || FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer world = server.func_71218_a(0);
        if (world != null && lastWorld != world) {
            lastWorld = world;
        }
        if (world != null) {
            if (world.func_82737_E() % (long)ConfigMisc.auto_save_interval == 0L) {
                Weather2.writeOutData(false);
            }
            Weather2.serverChunkUtil.tick();
        }
        WorldServer[] worlds = DimensionManager.getWorlds();
        ArrayList<Integer> removedManagers = new ArrayList<Integer>();
        int size = worlds.length;
        int dimension = 0;
        for (int i = 0; i < size; ++i) {
            WorldServer dim = worlds[i];
            dimension = dim.field_73011_w.getDimension();
            if (!dimensionSystems.containsKey(dimension)) {
                if (EZConfigParser.isWeatherEnabled(dimension)) {
                    ServerTickHandler.addWeatherSystem((World)dim);
                }
                if (!EZConfigParser.dimNames.containsKey(dimension)) {
                    EZConfigParser.dimNames.put(dimension, dimension + ":>  " + dim.field_73011_w.func_186058_p().func_186065_b());
                    EZConfigParser.nbtServerData.func_74775_l("dimData").func_74778_a("dima_" + dimension, dimension + ":>  " + dim.field_73011_w.func_186058_p().func_186065_b());
                    EZConfigParser.nbtSaveDataServer();
                }
            }
            if (!dimensionSystems.containsKey(dimension)) continue;
            if (EZConfigParser.isWeatherEnabled(dimension)) {
                dimensionSystems.get(dimension).tick();
                continue;
            }
            removedManagers.add(dimension);
        }
        Iterator iterator = removedManagers.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ServerTickHandler.removeWeatherSystem(i);
        }
        if (ConfigMisc.aesthetic_mode && !ConfigMisc.overcast_mode) {
            ConfigMisc.overcast_mode = true;
            Weather2.debug("detected Aesthetic_Only_Mode on, setting overcast mode on");
            EZConfigParser.setOvercastModeServerSide(ConfigMisc.overcast_mode);
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            ServerTickHandler.syncServerConfigToClient();
        }
        if (world.func_82737_E() % 200L == 0L) {
            ServerTickHandler.syncServerConfigToClient();
        }
    }

    public static void addWeatherSystem(World world) {
        int dim = world.field_73011_w.getDimension();
        Weather2.debug("Registering Weather2 manager for dim: " + dim);
        WeatherManagerServer wm = new WeatherManagerServer(world);
        dimensionSystems.put(dim, wm);
        wm.readFromFile();
    }

    public static void removeWeatherSystem(int dim) {
        Weather2.debug("Weather2: Unregistering manager for dim: " + dim);
        WeatherManagerServer wm = dimensionSystems.get(dim);
        try {
            if (wm != null) {
                dimensionSystems.remove(dim);
                wm.writeToFile();
                wm.reset(true);
            }
        }
        catch (Exception e) {
            Weather2.error(e);
        }
    }

    public static void playerClientRequestsFullSync(EntityPlayerMP entP) {
        WeatherManagerServer wm = dimensionSystems.get(entP.field_70170_p.field_73011_w.getDimension());
        if (wm != null) {
            wm.playerJoinedWorldSyncFull(entP);
        }
    }

    public static void reset() {
        Weather2.debug("Weather2: ServerTickHandler resetting");
        int size = dimensionSystems.size();
        Object[] set = dimensionSystems.keySet().toArray();
        for (int i = 0; i < size; ++i) {
            ServerTickHandler.removeWeatherSystem((Integer)set[i]);
        }
        if (dimensionSystems.size() > 0) {
            Weather2.debug("Weather2: reset state failed to manually clear lists, dimensionSystems.size(): " + dimensionSystems.size() + " - forcing a full clear of lists");
            dimensionSystems.clear();
        }
    }

    public static WeatherManagerServer getWeatherSystemForDim(int dimID) {
        return dimensionSystems.get(dimID);
    }

    public static void syncServerConfigToClient() {
        NBTTagCompound data = new NBTTagCompound();
        PacketEZGUI.apply(data);
    }

    public static void syncServerConfigToClientPlayer(EntityPlayerMP player) {
        NBTTagCompound data = new NBTTagCompound();
        PacketEZGUI.apply(data, player);
    }

    static {
        worldNBT = new NBTTagCompound();
    }
}

