/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.server.command;

import CoroUtil.util.Vec3;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.WeatherAPI;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.config.ConfigGrab;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.network.packets.PacketRefresh;
import net.mrbt0907.weather2.network.packets.PacketVolcanoObject;
import net.mrbt0907.weather2.network.packets.PacketWeatherObject;
import net.mrbt0907.weather2.server.event.ServerTickHandler;
import net.mrbt0907.weather2.server.weather.WeatherManagerServer;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.ReflectionHelper;
import net.mrbt0907.weather2.weather.storm.FrontObject;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.volcano.VolcanoObject;

public class CommandWeather2
extends CommandBase {
    public String func_71517_b() {
        return "storm";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.storm.usage";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean hasPermission(ICommandSender sender, int level) {
        return sender instanceof EntityPlayerMP ? ConfigManager.getPermissionLevel(((EntityPlayerMP)sender).getPersistentID()) >= level : sender.func_70003_b(level, this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length - 1) {
            case 0: {
                return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"config", "create", "kill", "view", "test"});
            }
            case 1: {
                switch (args[0]) {
                    case "config": {
                        return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"refresh", "grablist"});
                    }
                    case "create": {
                        return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"random", "clouds", "rainstorm", "thunderstorm", "supercell", "tropicaldisturbance", "tropicaldepression", "tropicalstorm", "sandstorm", "ef#", "f#", "c#"});
                    }
                    case "kill": {
                        return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"all", "particles"});
                    }
                    case "test": {
                        return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"class", "volcano"});
                    }
                }
                return Collections.emptyList();
            }
            case 2: {
                switch (args[0]) {
                    case "config": {
                        return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"all", "dimensionlist", "grablist", "replacelist", "stagelist", "windlist", "sounds", "scene"});
                    }
                    case "create": {
                        return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"~"});
                    }
                }
                return Collections.emptyList();
            }
            case 3: {
                switch (args[0]) {
                    case "config": {
                        switch (args[1]) {
                            case "grablist": {
                                return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"addGrabEntry", "addReplaceEntry"});
                            }
                        }
                        return Collections.emptyList();
                    }
                    case "create": {
                        return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"~"});
                    }
                }
                return Collections.emptyList();
            }
        }
        switch (args[0]) {
            case "create": {
                return CommandWeather2.func_71530_a((String[])args, (String[])new String[]{"alwaysprogress", "ishailing", "isviolent", "isnatural", "isfirenado", "neverdissipate", "dontconvert", "revives=#", "direction=<#/north/south/east/west>", "speed=#", "size=#", "name=<Word>"});
            }
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        World world = sender.func_130014_f_();
        Vec3d pos = sender.func_174791_d();
        int size = args.length;
        if (size > 0) {
            switch (args[0].toLowerCase()) {
                case "config": {
                    if (size > 1) {
                        switch (args[1].toLowerCase()) {
                            case "grablist": {
                                String entryMain;
                                if (size <= 2) return;
                                boolean isPlayer = sender instanceof EntityPlayer;
                                Item itemMain = isPlayer ? ((EntityPlayer)sender).func_184614_ca().func_77973_b() : null;
                                Block blockMain = isPlayer && itemMain != Items.field_190931_a ? Block.func_149634_a((Item)itemMain) : null;
                                String string = entryMain = blockMain == null ? "" : blockMain.getRegistryName().toString();
                                if (blockMain == null && size > 3) {
                                    entryMain = args[3];
                                }
                                switch (args[2].toLowerCase()) {
                                    case "addgrabentry": {
                                        if (entryMain.isEmpty()) {
                                            this.say(sender, "config.grablist.addgrabentry.fail", new Object[0]);
                                            return;
                                        }
                                        ConfigGrab.grab_list_entries = ConfigGrab.grab_list_entries.isEmpty() ? ConfigGrab.grab_list_entries + entryMain : ConfigGrab.grab_list_entries + ", " + entryMain;
                                        this.say(sender, "config.grablist.addgrabentry.success", new Object[0]);
                                        ConfigManager.save("Weather2 Remastered - Grab");
                                        return;
                                    }
                                    case "addreplaceentry": {
                                        String entrySecondary;
                                        Item itemSecondary = isPlayer ? ((EntityPlayer)sender).func_184592_cb().func_77973_b() : null;
                                        Block blockSecondary = isPlayer && itemSecondary != Items.field_190931_a ? Block.func_149634_a((Item)itemSecondary) : null;
                                        String string2 = entrySecondary = blockSecondary == null ? "" : blockSecondary.getRegistryName().toString();
                                        if (blockSecondary == null && size > 4) {
                                            entrySecondary = args[4];
                                        }
                                        if (entryMain.isEmpty() || entrySecondary.isEmpty()) {
                                            this.say(sender, "config.grablist.addreplaceentry.fail", new Object[0]);
                                            return;
                                        }
                                        ConfigGrab.replace_list_entries = ConfigGrab.replace_list_entries.isEmpty() ? ConfigGrab.replace_list_entries + entryMain + "=" + entrySecondary : ConfigGrab.replace_list_entries + ", " + entryMain + "=" + entrySecondary;
                                        this.say(sender, "config.grablist.addreplaceentry.success", new Object[0]);
                                        ConfigManager.save("Weather2 Remastered - Grab");
                                        return;
                                    }
                                    case "addwindentry": {
                                        if (entryMain.isEmpty() || args.length <= 3) {
                                            this.say(sender, "config.grablist.addwindentry.fail", new Object[0]);
                                            return;
                                        }
                                        int index = size > 4 ? 4 : 3;
                                        ConfigGrab.wind_resistance_entries = ConfigGrab.wind_resistance_entries.isEmpty() ? ConfigGrab.wind_resistance_entries + entryMain + "=" + args[index].replaceAll("[^\\d\\.]", "") : ConfigGrab.wind_resistance_entries + ", " + entryMain + "=" + args[index].replaceAll("[^\\d\\.]", "");
                                        this.say(sender, "config.grablist.addwindentry.success", new Object[0]);
                                        ConfigManager.save("Weather2 Remastered - Grab");
                                    }
                                }
                                return;
                            }
                            case "refresh": {
                                if (size > 2) {
                                    switch (args[2].toLowerCase()) {
                                        case "all": {
                                            WeatherAPI.refreshDimensionRules();
                                            WeatherAPI.refreshGrabRules();
                                            PacketRefresh.resetSounds((EntityPlayerMP)sender);
                                            this.say(sender, "config.refresh.all.success", new Object[0]);
                                            return;
                                        }
                                        case "dimensionlist": {
                                            WeatherAPI.refreshDimensionRules();
                                            this.say(sender, "config.refresh.dimensionlist.success", new Object[0]);
                                            return;
                                        }
                                        case "grablist": {
                                            WeatherAPI.refreshGrabRules();
                                            this.say(sender, "config.refresh.grablist.success", new Object[0]);
                                            return;
                                        }
                                        case "replacelist": {
                                            WeatherAPI.refreshGrabRules();
                                            this.say(sender, "config.refresh.replacelist.success", new Object[0]);
                                            return;
                                        }
                                        case "stagelist": {
                                            WeatherAPI.refreshStages();
                                            this.say(sender, "config.refresh.stagelist.success", new Object[0]);
                                            return;
                                        }
                                        case "windlist": {
                                            WeatherAPI.refreshGrabRules();
                                            this.say(sender, "config.refresh.windlist.success", new Object[0]);
                                            return;
                                        }
                                        case "sounds": 
                                        case "sound": {
                                            if (sender instanceof EntityPlayerMP) {
                                                PacketRefresh.resetSounds((EntityPlayerMP)sender);
                                                this.say(sender, "config.refresh.sounds.success", new Object[0]);
                                                return;
                                            }
                                            this.say(sender, "config.refresh.sounds.fail", new Object[0]);
                                            return;
                                        }
                                        case "scene": 
                                        case "sceneenhancer": {
                                            if (sender instanceof EntityPlayerMP) {
                                                PacketRefresh.resetSceneEnhancer((EntityPlayerMP)sender);
                                                this.say(sender, "config.refresh.sceneenhancer.success", new Object[0]);
                                                return;
                                            }
                                            this.say(sender, "config.refresh.sceneenhancer.fail", new Object[0]);
                                            return;
                                        }
                                    }
                                    this.say(sender, "config.refresh.usage", new Object[0]);
                                    return;
                                }
                                this.say(sender, "config.refresh.usage", new Object[0]);
                                return;
                            }
                            default: {
                                this.say(sender, "config.usage", new Object[0]);
                                return;
                            }
                        }
                    }
                    this.say(sender, "config.usage", new Object[0]);
                    return;
                }
                case "create": {
                    if (!this.hasPermission(sender, 4)) {
                        this.say(sender, "nopermission", new Object[0]);
                        return;
                    }
                    if (size > 1) {
                        String type;
                        int stage = -1;
                        boolean isRaining = false;
                        boolean isSandstorm = false;
                        boolean isCyclone = false;
                        boolean isRandom = false;
                        switch (type = args[1].toLowerCase()) {
                            case "random": {
                                isRandom = true;
                                stage = WeatherEnum.Stage.NORMAL.getStage();
                                break;
                            }
                            case "cloud": 
                            case "clouds": {
                                stage = WeatherEnum.Stage.NORMAL.getStage();
                                break;
                            }
                            case "rain": 
                            case "rainstorm": {
                                isRaining = true;
                                stage = WeatherEnum.Stage.RAIN.getStage();
                                break;
                            }
                            case "thunder": 
                            case "thunderstorm": 
                            case "lightning": 
                            case "lightningstorm": {
                                isRaining = true;
                                stage = WeatherEnum.Stage.THUNDER.getStage();
                                break;
                            }
                            case "supercell": 
                            case "cell": 
                            case "severe": 
                            case "severethunder": 
                            case "severethunderstorm": 
                            case "severelightning": 
                            case "severelightningstorm": {
                                isRaining = true;
                                stage = WeatherEnum.Stage.SEVERE.getStage();
                                break;
                            }
                            case "tropicaldisturbance": 
                            case "td1": {
                                isRaining = true;
                                isCyclone = true;
                                stage = WeatherEnum.Stage.TROPICAL_DISTURBANCE.getStage();
                                break;
                            }
                            case "tropicaldepression": 
                            case "td2": {
                                isRaining = true;
                                isCyclone = true;
                                stage = WeatherEnum.Stage.TROPICAL_DEPRESSION.getStage();
                                break;
                            }
                            case "tropicalstorm": 
                            case "ts": {
                                isRaining = true;
                                isCyclone = true;
                                stage = WeatherEnum.Stage.TROPICAL_STORM.getStage();
                                break;
                            }
                            case "sandstorm": {
                                isSandstorm = true;
                                stage = WeatherEnum.Stage.NORMAL.getStage();
                                break;
                            }
                            default: {
                                isRaining = true;
                                if (type.matches("(ef|f)\\d+")) {
                                    stage = WeatherEnum.Stage.TORNADO.getStage() + Integer.parseInt(type.replaceAll("\\D*", ""));
                                    break;
                                }
                                if (!type.matches("(category|c)\\d+")) break;
                                isCyclone = true;
                                stage = WeatherEnum.Stage.TROPICAL_STORM.getStage() + Integer.parseInt(type.replaceAll("\\D*", ""));
                            }
                        }
                        if (stage > -1) {
                            if (isSandstorm) {
                                boolean spawned;
                                int dimension = world.field_73011_w.getDimension();
                                WeatherManagerServer wm = ServerTickHandler.dimensionSystems.get(dimension);
                                if (wm == null || !EZConfigParser.isWeatherEnabled(dimension)) {
                                    this.say(sender, "fail.nomanager", new Object[0]);
                                    return;
                                }
                                if (size > 3) {
                                    BlockPos temp;
                                    try {
                                        temp = CommandWeather2.parseBlockPos2(sender, args, 2, true);
                                    }
                                    catch (NumberInvalidException e) {
                                        Weather2.error((Object)e);
                                        this.say(sender, "create.sandstorm.fail.a", new Object[0]);
                                        return;
                                    }
                                    pos = new Vec3d((double)temp.func_177958_n(), 0.0, (double)temp.func_177956_o());
                                }
                                if (!(spawned = wm.spawnSandstorm(new Maths.Vec3(pos)))) {
                                    this.say(sender, "create.sandstorm.fail.b", new Object[0]);
                                    return;
                                }
                                this.say(sender, "create.sandstorm.success", Math.round(pos.field_72450_a), Math.round(pos.field_72449_c));
                                return;
                            }
                            boolean isViolent = false;
                            boolean isNatural = false;
                            boolean isFirenado = false;
                            boolean neverDissipate = false;
                            boolean shouldConvert = true;
                            boolean alwaysProgress = false;
                            boolean isHailing = false;
                            float sizeMultiplier = -1.0f;
                            float angle = -1.0f;
                            float speed = -1.0f;
                            int revives = -1;
                            int dimension = world.field_73011_w.getDimension();
                            String flags = "";
                            String name = "";
                            if (size > 3) {
                                try {
                                    BlockPos temp = CommandWeather2.parseBlockPos2(sender, args, 2, true);
                                    pos = new Vec3d((double)temp.func_177958_n(), (double)temp.func_177956_o(), (double)temp.func_177952_p());
                                }
                                catch (NumberInvalidException e) {
                                    Weather2.error((Object)e);
                                    this.say(sender, "create.fail", new Object[0]);
                                    return;
                                }
                            }
                            block139: for (int i = 4; i < size; ++i) {
                                String flag;
                                switch (flag = args[i].toLowerCase()) {
                                    case "alwaysprogress": {
                                        if (alwaysProgress) continue block139;
                                        alwaysProgress = true;
                                        flags = flags + ", Always Progresses";
                                        continue block139;
                                    }
                                    case "isviolent": 
                                    case "violent": {
                                        if (isViolent) continue block139;
                                        isViolent = true;
                                        flags = flags + ", Violent Storm";
                                        continue block139;
                                    }
                                    case "isnatural": 
                                    case "natural": {
                                        if (isNatural) continue block139;
                                        isNatural = true;
                                        flags = flags + ", Starts Naturally";
                                        continue block139;
                                    }
                                    case "isfirenado": 
                                    case "firenado": {
                                        if (isFirenado) continue block139;
                                        isFirenado = true;
                                        flags = flags + ", Is A Firenado";
                                        continue block139;
                                    }
                                    case "neverdissipate": 
                                    case "neverdie": {
                                        if (neverDissipate) continue block139;
                                        neverDissipate = true;
                                        flags = flags + ", Never Dissipates";
                                        continue block139;
                                    }
                                    case "dontconvert": 
                                    case "noconvert": 
                                    case "convert": {
                                        if (!shouldConvert) continue block139;
                                        shouldConvert = false;
                                        flags = flags + ", Never Converts To Hurricane";
                                        continue block139;
                                    }
                                    case "ishailing": 
                                    case "hailing": 
                                    case "hail": {
                                        if (!isHailing) {
                                            isHailing = true;
                                            flags = flags + ", Storm Is Hailing";
                                        }
                                    }
                                    default: {
                                        if (flag.matches("revives\\=\\d+")) {
                                            if (revives >= 0) continue block139;
                                            revives = Integer.parseInt(flag.replaceAll("\\D*", ""));
                                            flags = flags + ", Will Revive " + revives + " time" + (revives > 1 ? "s" : "");
                                            continue block139;
                                        }
                                        if (flag.matches("(angle|direction)\\=(north|south|east|west|\\d+)")) {
                                            if (!(angle < 0.0f)) continue block139;
                                            angle = flag.contains("north") ? 180.0f : (flag.contains("east") ? 270.0f : (flag.contains("south") ? 0.0f : (flag.contains("west") ? 90.0f : Float.parseFloat(flag.replaceAll("[^\\d\\.]*", "")))));
                                            flags = flags + ", Aiming at " + angle + " degrees";
                                            continue block139;
                                        }
                                        if (flag.matches("speed\\=[\\d\\.]+")) {
                                            if (!(speed < 0.0f)) continue block139;
                                            speed = Float.parseFloat(flag.replaceAll("[^\\d\\.]*", "")) * 0.05f;
                                            flags = flags + ", Moving At " + speed * 20.0f + " M/s";
                                            continue block139;
                                        }
                                        if (flag.matches("size\\=[\\d\\.\\%]+")) {
                                            if (!(sizeMultiplier < 0.0f)) continue block139;
                                            sizeMultiplier = Float.parseFloat(flag.replaceAll("[^\\d\\.]*", "")) * 0.01f;
                                            flags = flags + ", Will Grow " + sizeMultiplier * 100.0f + "%" + (sizeMultiplier < 1.0f ? " Smaller Than Normal" : (sizeMultiplier == 1.0f ? "" : "Larger Than Normal"));
                                            continue block139;
                                        }
                                        if (!flag.matches("name\\=\\w+") || name != "") continue block139;
                                        name = args[i].replaceFirst("[nN][aA][mM][eE]\\=", "");
                                        flags = flags + ", Named " + name;
                                    }
                                }
                            }
                            WeatherManagerServer wm = ServerTickHandler.dimensionSystems.get(dimension);
                            if (wm == null || !EZConfigParser.isWeatherEnabled(dimension)) {
                                this.say(sender, "fail.nomanager", new Object[0]);
                                return;
                            }
                            StormObject so = new StormObject(wm.getGlobalFront());
                            so.layer = 0;
                            so.isNatural = isNatural;
                            so.temperature = 0.1f;
                            so.pos = new Maths.Vec3(pos.field_72450_a, (double)so.getLayerHeight(), pos.field_72449_c);
                            so.stageMax = so.stage = isRandom ? so.rollDiceOnMaxIntensity() : stage;
                            so.intensity = (float)so.stage - 0.99f;
                            float f = isRaining ? (isNatural ? 50.0f : (isHailing ? 200.0f : (float)so.stage * 50.0f)) + 1.0f : (so.rain = 0.0f);
                            so.hail = isHailing ? (isNatural ? 0.0f : 100.0f) : 0.0f;
                            so.hailRate = isHailing ? Math.min((float)ConfigStorm.hail_max_buildup_rate, 1.0f) : 0.0f;
                            so.sizeRate = sizeMultiplier;
                            if (angle >= 0.0f) {
                                so.setAngle(angle);
                            }
                            if (speed >= 0.0f) {
                                so.setSpeed(speed);
                            }
                            so.alwaysProgresses = alwaysProgress;
                            so.neverDissipate = neverDissipate;
                            so.isFirenado = isFirenado;
                            so.shouldConvert = shouldConvert;
                            so.isViolent = isViolent;
                            so.maxRevives = revives;
                            so.name = name;
                            so.shouldBuildHumidity = true;
                            if (isCyclone || isRandom && so.stage > 3 && Maths.chance(25)) {
                                so.stormType = StormObject.StormType.WATER.ordinal();
                            }
                            so.init();
                            if (so.rain > 0.0f && so.isNatural) {
                                so.initRealStorm();
                            } else {
                                so.canProgress = true;
                                if (so.sizeRate < 0.0f) {
                                    so.sizeRate = (float)Maths.random(ConfigStorm.min_size_growth, ConfigStorm.max_size_growth);
                                }
                                if (so.isViolent) {
                                    so.sizeRate = (float)((double)so.sizeRate + Maths.random(ConfigStorm.min_violent_size_growth, ConfigStorm.max_violent_size_growth));
                                    if (so.stageMax < 9) {
                                        ++so.stageMax;
                                    }
                                }
                            }
                            so.updateType();
                            wm.getGlobalFront().addWeatherObject(so);
                            PacketWeatherObject.create(wm.getDimension(), so);
                            this.say(sender, "create.success", so.getName(true), Math.round(pos.field_72450_a), Math.round(pos.field_72449_c), flags);
                            return;
                        }
                        this.say(sender, "create.usage", new Object[0]);
                        return;
                    }
                    this.say(sender, "create.usage", new Object[0]);
                    return;
                }
                case "kill": {
                    if (size > 1) {
                        switch (args[1].toLowerCase()) {
                            case "all": {
                                if (!this.hasPermission(sender, 4)) {
                                    this.say(sender, "nopermission", new Object[0]);
                                    return;
                                }
                                WeatherManagerServer wm = ServerTickHandler.dimensionSystems.get(world.field_73011_w.getDimension());
                                if (wm == null || !EZConfigParser.isWeatherEnabled(world.field_73011_w.getDimension())) {
                                    this.say(sender, "fail.nomanager", new Object[0]);
                                    return;
                                }
                                List<FrontObject> fronts = wm.getFronts();
                                size = wm.getWeatherObjects().size();
                                if (size > 0) {
                                    for (int i = 0; i < fronts.size(); ++i) {
                                        FrontObject front = fronts.get(i);
                                        Weather2.debug("Killing front " + front.getUUID());
                                        front.isDead = true;
                                    }
                                    this.say(sender, "kill.all.success", size);
                                    return;
                                }
                                this.say(sender, "kill.all.fail", new Object[0]);
                                return;
                            }
                            case "particle": 
                            case "particles": {
                                if (sender instanceof EntityPlayerMP) {
                                    PacketWeatherObject.clientCleanup((EntityPlayerMP)sender);
                                    this.say(sender, "kill.particles.success", new Object[0]);
                                    return;
                                }
                                this.say(sender, "kill.particles.fail", new Object[0]);
                                return;
                            }
                        }
                        this.say(sender, "kill.usage", new Object[0]);
                        return;
                    }
                    this.say(sender, "kill.usage", new Object[0]);
                    return;
                }
                case "view": {
                    if (size > 1) {
                        switch (args[1].toLowerCase()) {
                            default: 
                        }
                        this.say(sender, "view.fail", new Object[0]);
                        return;
                    }
                    this.say(sender, "view.fail", new Object[0]);
                    return;
                }
                case "test": {
                    if (!this.hasPermission(sender, 4)) {
                        this.say(sender, "nopermission", new Object[0]);
                        return;
                    }
                    if (size > 1) {
                        switch (args[1].toLowerCase()) {
                            case "volcano": {
                                WeatherManagerServer wm = ServerTickHandler.dimensionSystems.get(0);
                                if (wm == null || !EZConfigParser.isWeatherEnabled(0)) {
                                    this.say(sender, "fail.nomanager", new Object[0]);
                                    return;
                                }
                                VolcanoObject vo = new VolcanoObject(wm);
                                vo.pos = new Vec3(pos);
                                vo.init();
                                wm.addVolcanoObject(vo);
                                PacketVolcanoObject.create(wm.getDimension(), vo);
                                this.say(sender, "test.volcano.success", new Object[0]);
                                return;
                            }
                            case "class": {
                                if (size > 2) {
                                    List<String> found = ReflectionHelper.view(args[2]);
                                    for (String line : found) {
                                        this.say(sender, "test.class.success", line);
                                    }
                                    return;
                                }
                                this.say(sender, "test.class.usage", new Object[0]);
                                return;
                            }
                            default: {
                                this.say(sender, "test.usage", new Object[0]);
                                return;
                            }
                        }
                    }
                    this.say(sender, "test.usage", new Object[0]);
                    return;
                }
                default: {
                    this.say(sender, "usage", new Object[0]);
                }
            }
            return;
        }
        this.say(sender, "usage", new Object[0]);
    }

    public static BlockPos parseBlockPos2(ICommandSender sender, String[] args, int startIndex, boolean centerBlock) throws NumberInvalidException {
        BlockPos blockpos = sender.func_180425_c();
        return new BlockPos(CommandWeather2.func_175769_b((double)blockpos.func_177958_n(), (String)args[startIndex], (int)-30000000, (int)30000000, (boolean)centerBlock), 0.0, CommandWeather2.func_175769_b((double)blockpos.func_177952_p(), (String)args[startIndex + 1], (int)-30000000, (int)30000000, (boolean)centerBlock));
    }

    private void say(ICommandSender sender, String localizationID, Object ... args) {
        CommandWeather2.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("command." + this.func_71517_b() + "." + localizationID), (Object[])args);
    }
}

