/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.registry;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.registry.BlockRegistry;
import net.mrbt0907.weather2.registry.ItemRegistry;

public class RecipeRegistry {
    private static final ResourceLocation GROUP = new ResourceLocation("weather2remaster", "weather2_misc");

    public static void postInit() {
        Weather2.debug("Registering recipies...");
        RecipeRegistry.addShaped(ConfigMisc.disable_wind_vane, new ItemStack(BlockRegistry.wind_vane, 1), "X X,DXD,X X", ItemRegistry.itemWeatherRecipe, "dustRedstone");
        RecipeRegistry.addShaped(ConfigMisc.disable_anemometer, new ItemStack(BlockRegistry.anemometer, 1), "X X,XDX,X X", ItemRegistry.itemWeatherRecipe, "dustRedstone");
        RecipeRegistry.addShaped(ConfigMisc.disable_sand_layer, new ItemStack(ItemRegistry.itemSandLayer, 64), "DDD,DID,DDD", "sand", ItemRegistry.itemWeatherRecipe);
        RecipeRegistry.addShaped(ConfigMisc.disable_sand, new ItemStack((Block)Blocks.field_150354_m, 1), "DDD,D D,DDD", ItemRegistry.itemSandLayer);
        RecipeRegistry.addShaped(ConfigMisc.disable_pocket_sand, new ItemStack(ItemRegistry.itemPocketSand, 8), "DDD,DID,DDD", ItemRegistry.itemSandLayer, ItemRegistry.itemWeatherRecipe);
        RecipeRegistry.addShaped(false, new ItemStack(BlockRegistry.machineCase, 1), "ABA,BCB,ABA", "ingotIron", "blockGlass", "ingotGold");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemWeatherRecipe, 1), "ABA,ACA, B ", "ingotIron", "obsidian", "gemDiamond");
        RecipeRegistry.addShaped(ConfigMisc.disable_sensor, new ItemStack(BlockRegistry.tornado_sensor, 1), "ABA,CDE,AFA", "ingotIron", new ItemStack(ItemRegistry.itemCPU1), new ItemStack(BlockRegistry.humiditySensor), new ItemStack(BlockRegistry.machineCase), new ItemStack(BlockRegistry.temperatureSensor), new ItemStack(ItemRegistry.itemAntenna1, 1));
        RecipeRegistry.addShaped(ConfigMisc.disable_siren, new ItemStack(BlockRegistry.emergency_siren, 1), "ABA,CDC,ABA", "ingotIron", new ItemStack(ItemRegistry.itemCPU1), new ItemStack(BlockRegistry.tornado_sensor, 1), new ItemStack(BlockRegistry.emergency_siren_manual, 1));
        RecipeRegistry.addShaped(ConfigMisc.disable_manual_siren, new ItemStack(BlockRegistry.emergency_siren_manual, 1), "ABA,CDC,ABA", "ingotIron", "dustRedstone", new ItemStack(ItemRegistry.itemSpeaker), new ItemStack(BlockRegistry.machineCase));
        RecipeRegistry.addShaped(ConfigMisc.disable_weather_machine, new ItemStack(BlockRegistry.weather_constructor, 1), "ABA,CDC,CEC", new ItemStack(ItemRegistry.itemCPU2), new ItemStack(ItemRegistry.itemAntenna2, 1), "ingotIron", new ItemStack(BlockRegistry.machineCase, 1), new ItemStack(ItemRegistry.itemWeatherRecipe, 1));
        RecipeRegistry.addShaped(ConfigMisc.disable_weather_deflector, new ItemStack(BlockRegistry.weather_deflector, 1), "ABA,CDC,CEC", new ItemStack(ItemRegistry.itemAntenna2, 1), new ItemStack(ItemRegistry.itemCPU2), "ingotIron", new ItemStack(BlockRegistry.machineCase), new ItemStack(ItemRegistry.itemWeatherRecipe, 1));
        RecipeRegistry.addShaped(ConfigMisc.disable_weather_radar, new ItemStack(BlockRegistry.weather_radar, 1), "ABA,CDC,AEA", "ingotIron", new ItemStack(ItemRegistry.itemLCD1, 1), new ItemStack(ItemRegistry.itemAntenna0, 1), new ItemStack(BlockRegistry.machineCase), new ItemStack(ItemRegistry.itemCPU0, 1));
        RecipeRegistry.addShaped(ConfigMisc.disable_weather_radar, new ItemStack(BlockRegistry.weather_doppler_radar, 1), "AAA,BCB,DED", new ItemStack(ItemRegistry.itemLCD1, 1), new ItemStack(ItemRegistry.itemCPU1, 1), new ItemStack(BlockRegistry.weather_radar), "ingotIron", new ItemStack(ItemRegistry.itemAntenna1, 1));
        RecipeRegistry.addShaped(ConfigMisc.disable_weather_radar, new ItemStack(BlockRegistry.weather_pulse_radar, 1), "AAA,BCB,DED", new ItemStack(ItemRegistry.itemLCD1, 1), new ItemStack(ItemRegistry.itemCPU2, 1), new ItemStack(BlockRegistry.weather_doppler_radar), "obsidian", new ItemStack(ItemRegistry.itemAntenna2, 1));
        RecipeRegistry.addShaped(false, new ItemStack(BlockRegistry.stormSensor, 1), "ABA,CDC,ABA", "obsidian", new ItemStack(ItemRegistry.itemWeatherRecipe, 1), new ItemStack(ItemRegistry.itemCPU2, 1), new ItemStack(BlockRegistry.tornado_sensor, 1));
        RecipeRegistry.addShaped(false, new ItemStack(BlockRegistry.humiditySensor, 1), "ABA,CDE,AFA", "ingotIron", new ItemStack(Items.field_151133_ar), new ItemStack(ItemRegistry.itemDryBulb, 1), new ItemStack(BlockRegistry.rainSensor, 1), new ItemStack(ItemRegistry.itemWetBulb, 1), new ItemStack(ItemRegistry.itemCPU1, 1));
        RecipeRegistry.addShaped(false, new ItemStack(BlockRegistry.rainSensor, 1), "ABA,CDC,ACA", "ingotIron", new ItemStack(Items.field_151069_bo, 1), "dustRedstone", new ItemStack(BlockRegistry.machineCase, 1));
        RecipeRegistry.addShaped(false, new ItemStack(BlockRegistry.temperatureSensor, 1), "ABA,CDC,AEA", "ingotIron", new ItemStack(Items.field_151072_bj, 1), new ItemStack(ItemRegistry.itemBulb, 1), new ItemStack(BlockRegistry.machineCase, 1), "dustRedstone");
        RecipeRegistry.addShaped(false, new ItemStack(BlockRegistry.windSensor, 1), "ABA, C ,ADA", "ingotIron", new ItemStack(BlockRegistry.anemometer, 1), new ItemStack(BlockRegistry.machineCase, 1), "dustRedstone");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.thermometer, 1), " A ,BCB,BDB", new ItemStack(ItemRegistry.itemAntenna1, 1), "ingotIron", new ItemStack(Items.field_151072_bj, 1), "dustRedstone");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.hygrometer, 1), " A ,BCB,BDB", new ItemStack(ItemRegistry.itemAntenna1, 1), "ingotIron", new ItemStack(ItemRegistry.itemWetBulb, 1), "dustRedstone");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.anemometer, 1), " A ,BCB,BDB", new ItemStack(ItemRegistry.itemAntenna1, 1), "ingotIron", ItemRegistry.itemWeatherRecipe, "dustRedstone");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemMotor, 1), "ABA, C ,ABA", "ingotIron", "dustRedstone", "ingotGold");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemSpeaker, 2), "ABA,ACA, B ", "wool", "ingotIron", "dustRedstone");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemAntenna0, 1), " A ,BCB,DBD", "blockRedstone", "ingotIron", "dustRedstone", new ItemStack(ItemRegistry.itemMotor, 1));
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemAntenna1, 1), "ABA,CDC,ABA", "ingotIron", "dustRedstone", "gemDiamond", new ItemStack(ItemRegistry.itemAntenna0, 1));
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemAntenna2, 1), "ABA,CDC,ABA", "obsidian", "dustRedstone", new ItemStack(ItemRegistry.itemWeatherRecipe, 1), new ItemStack(ItemRegistry.itemAntenna1, 1));
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemCPU0, 1), "ABA,CDC,ABA", "ingotIron", "dustRedstone", "paneGlass", "ingotGold");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemCPU1, 1), "ABA,BCB,ABA", "ingotIron", "ingotGold", new ItemStack(ItemRegistry.itemCPU0, 1));
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemCPU2, 1), "ABA,BCB,ABA", "obsidian", "gemDiamond", new ItemStack(ItemRegistry.itemCPU1, 1));
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemBulb, 6), "A A,A A,AAA", "paneGlass");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemDryBulb, 1), " A , B , C ", "ingotIron", "sand", new ItemStack(ItemRegistry.itemBulb, 1));
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemWetBulb, 1), " A , B , C ", "ingotIron", "wool", new ItemStack(ItemRegistry.itemBulb, 1));
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemLCD0, 3), "ABA,BCB,ABA", "paneGlass", "dustRedstone", "dustGlowstone");
        RecipeRegistry.addShaped(false, new ItemStack(ItemRegistry.itemLCD1, 1), "AAA,AAA,AAA", new ItemStack(ItemRegistry.itemLCD0, 1));
        Weather2.debug("Finished registering recipies...");
    }

    private static void addShaped(boolean disabled, ItemStack output, String pattern, Object ... inputs) {
        if (output != null && pattern != null && pattern.length() > 0 && inputs.length > 0) {
            int i;
            if (disabled) {
                Weather2.debug("Recipe " + output.func_77973_b().getRegistryName().func_110624_b() + ":" + output.func_77973_b().getRegistryName().func_110623_a() + " is disabled. Skipping...");
                return;
            }
            Object[] args = null;
            ArrayList<Character> count = new ArrayList<Character>();
            int in = 0;
            int index = 0;
            String[] s = new String[]{"", null, null};
            for (int i2 = 0; i2 < pattern.length(); ++i2) {
                Character c = Character.valueOf(pattern.charAt(i2));
                if (c.equals(Character.valueOf(','))) {
                    in = 0;
                    s[++index] = "";
                    continue;
                }
                if (in >= 3) continue;
                int n = index;
                s[n] = s[n] + c;
                if (!c.equals(Character.valueOf(' ')) && !count.contains(c)) {
                    count.add(c);
                }
                ++in;
            }
            if (count.size() <= 0) {
                Weather2.error("Pattern returned null for recipe " + output.func_77973_b().getRegistryName().func_110624_b() + ":" + output.func_77973_b().getRegistryName().func_110623_a() + ".  Skipping recipe...");
                return;
            }
            in = 0;
            for (String str : s) {
                if (str == null) continue;
                ++in;
            }
            args = new Object[count.size() * 2 + in];
            for (i = 0; i < 3; ++i) {
                if (s[i] == null) continue;
                args[i] = s[i];
            }
            for (i = 0; i < inputs.length && i < count.size(); ++i) {
                args[in] = count.get(i);
                args[in + 1] = inputs[i] instanceof String ? new OreIngredient(inputs[i].toString()) : inputs[i];
                in += 2;
            }
            Weather2.debug("Adding shaped recipe for " + output.func_77973_b().getRegistryName().func_110624_b() + ":" + output.func_77973_b().getRegistryName().func_110623_a());
            GameRegistry.addShapedRecipe((ResourceLocation)output.func_77973_b().getRegistryName(), (ResourceLocation)GROUP, (ItemStack)output, (Object[])args);
        } else {
            Weather2.error("Recipe is missing parameters");
        }
    }
}

