/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.item.ItemPocketSand;
import net.mrbt0907.weather2.item.ItemSandLayer;
import net.mrbt0907.weather2.item.ItemSensor;
import net.mrbt0907.weather2.item.ItemWeatherRecipe;
import net.mrbt0907.weather2.registry.BlockRegistry;

public class ItemRegistry {
    private static RegistryEvent.Register<Item> registry;
    private static final List<Block> item_blocks;
    public static final Item sensor;
    public static final Item thermometer;
    public static final Item hygrometer;
    public static final Item anemometer;
    public static final Item radio;
    public static final Item itemMotor;
    public static final Item itemSpeaker;
    public static final Item itemAntenna0;
    public static final Item itemAntenna1;
    public static final Item itemAntenna2;
    public static final Item itemCPU0;
    public static final Item itemCPU1;
    public static final Item itemCPU2;
    public static final Item itemBulb;
    public static final Item itemDryBulb;
    public static final Item itemWetBulb;
    public static final Item itemLCD0;
    public static final Item itemLCD1;
    public static final Item itemSandLayer;
    public static final Item itemWeatherRecipe;
    public static final Item itemPocketSand;

    public static void add(Block block) {
        item_blocks.add(block);
    }

    public static void register(RegistryEvent.Register<Item> event) {
        Weather2.debug("Registering items...");
        registry = event;
        ItemRegistry.add("sand_layer_placeable", itemSandLayer);
        ItemRegistry.add("weather_item", itemWeatherRecipe);
        ItemRegistry.add("pocket_sand", itemPocketSand);
        ItemRegistry.add("handheld_thermometer", thermometer);
        ItemRegistry.add("handheld_hygrometer", hygrometer);
        ItemRegistry.add("handheld_anemometer", anemometer);
        ItemRegistry.add("motor", itemMotor);
        ItemRegistry.add("speaker", itemSpeaker);
        ItemRegistry.add("antenna_0", itemAntenna0);
        ItemRegistry.add("antenna_1", itemAntenna1);
        ItemRegistry.add("antenna_2", itemAntenna2);
        ItemRegistry.add("cpu_0", itemCPU0);
        ItemRegistry.add("cpu_1", itemCPU1);
        ItemRegistry.add("cpu_2", itemCPU2);
        ItemRegistry.add("bulb", itemBulb);
        ItemRegistry.add("bulb_dry", itemDryBulb);
        ItemRegistry.add("bulb_wet", itemWetBulb);
        ItemRegistry.add("lcd_0", itemLCD0);
        ItemRegistry.add("lcd_1", itemLCD1);
        for (Block block : item_blocks) {
            ItemRegistry.add(block.getRegistryName().func_110623_a(), (Item)new ItemBlock(block));
        }
        registry = null;
        Weather2.debug("Finished registering items");
    }

    public static void add(String name, Item item) {
        ItemRegistry.add(name, null, item);
    }

    public static void add(String name, String ore_dict_name, Item item) {
        if (registry != null) {
            item.setRegistryName(new ResourceLocation("weather2", name));
            item.func_77655_b(name);
            if (ore_dict_name != null) {
                OreDictionary.registerOre((String)ore_dict_name, (Item)item);
            }
            item.func_77637_a(Weather2.TAB);
            registry.getRegistry().register((IForgeRegistryEntry)item);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
            Weather2.debug("Registered item " + item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a());
            return;
        }
        Weather2.error("Registry event returned null");
    }

    static {
        item_blocks = new ArrayList<Block>();
        sensor = new ItemSensor(0);
        thermometer = new ItemSensor(1);
        hygrometer = new ItemSensor(2);
        anemometer = new ItemSensor(3);
        radio = new ItemPocketSand();
        itemMotor = new Item();
        itemSpeaker = new Item();
        itemAntenna0 = new Item();
        itemAntenna1 = new Item();
        itemAntenna2 = new Item();
        itemCPU0 = new Item();
        itemCPU1 = new Item();
        itemCPU2 = new Item();
        itemBulb = new Item();
        itemDryBulb = new Item();
        itemWetBulb = new Item();
        itemLCD0 = new Item();
        itemLCD1 = new Item();
        itemSandLayer = new ItemSandLayer(BlockRegistry.sand_layer);
        itemWeatherRecipe = new ItemWeatherRecipe();
        itemPocketSand = new ItemPocketSand();
    }
}

