/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.registry;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.block.BlockAnemometer;
import net.mrbt0907.weather2.block.BlockMachine;
import net.mrbt0907.weather2.block.BlockNewRadar;
import net.mrbt0907.weather2.block.BlockNewSensor;
import net.mrbt0907.weather2.block.BlockNewSiren;
import net.mrbt0907.weather2.block.BlockNewWeatherConstructor;
import net.mrbt0907.weather2.block.BlockNewWeatherDeflector;
import net.mrbt0907.weather2.block.BlockSandLayer;
import net.mrbt0907.weather2.block.BlockSensor;
import net.mrbt0907.weather2.block.BlockSiren;
import net.mrbt0907.weather2.block.BlockTSirenManual;
import net.mrbt0907.weather2.block.BlockWeatherConstructor;
import net.mrbt0907.weather2.block.BlockWeatherDeflector;
import net.mrbt0907.weather2.block.BlockWindVane;
import net.mrbt0907.weather2.block.TileAnemometer;
import net.mrbt0907.weather2.block.TileEntityTSirenManual;
import net.mrbt0907.weather2.block.TileMachine;
import net.mrbt0907.weather2.block.TileRadar;
import net.mrbt0907.weather2.block.TileSiren;
import net.mrbt0907.weather2.block.TileWeatherConstructor;
import net.mrbt0907.weather2.block.TileWeatherDeflector;
import net.mrbt0907.weather2.block.TileWindVane;
import net.mrbt0907.weather2.registry.ItemRegistry;

public class BlockRegistry {
    private static RegistryEvent.Register<Block> registry;
    public static final Block wire;
    public static final BlockMachine radio;
    public static final Block wind_chimes;
    public static final Block air_horn_siren;
    public static final Block emergency_siren_alt;
    public static final Block emergency_siren_alt_manual;
    public static final Block weather_doppler_radar;
    public static final Block weather_pulse_radar;
    public static final Block weather_humidifier;
    public static final Block weather_humidifier_2;
    public static final Block weather_conditioner;
    public static final Block weather_conditioner_2;
    public static final Block wind_vane;
    public static final Block anemometer;
    public static final Block machineCase;
    public static final Block stormSensor;
    public static final Block humiditySensor;
    public static final Block rainSensor;
    public static final Block temperatureSensor;
    public static final Block windSensor;
    public static final Block barometerSensor;
    public static final Block tornado_sensor;
    public static final Block emergency_siren_manual;
    public static final Block emergency_siren;
    public static final Block weather_radar;
    public static final Block weather_constructor;
    public static final Block weather_deflector;
    public static final Block sand_layer;

    public static void register(RegistryEvent.Register<Block> event) {
        Weather2.debug("Registering blocks...");
        registry = event;
        BlockRegistry.addBlock("tornado_sensor", tornado_sensor);
        BlockRegistry.addBlock("tornado_siren", emergency_siren);
        BlockRegistry.addBlock("tornado_siren_manual", emergency_siren_manual);
        BlockRegistry.addBlock("wind_vane", wind_vane);
        BlockRegistry.addBlock("weather_forecast", weather_radar);
        BlockRegistry.addBlock("weather_forecast_2", weather_doppler_radar);
        BlockRegistry.addBlock("weather_forecast_3", weather_pulse_radar);
        BlockRegistry.addBlock("weather_machine", weather_constructor);
        BlockRegistry.addBlock("weather_deflector", weather_deflector);
        BlockRegistry.addBlock("anemometer", anemometer);
        BlockRegistry.addBlock("sand_layer", sand_layer, false);
        BlockRegistry.addBlock("machine_case", machineCase);
        BlockRegistry.addBlock("storm_sensor", stormSensor);
        BlockRegistry.addBlock("humidity_sensor", humiditySensor);
        BlockRegistry.addBlock("rain_sensor", rainSensor);
        BlockRegistry.addBlock("temperature_sensor", temperatureSensor);
        BlockRegistry.addBlock("wind_sensor", windSensor);
        BlockRegistry.addBlock("barometer_sensor", barometerSensor);
        BlockRegistry.addTileEntity("tornado_siren", TileSiren.class);
        BlockRegistry.addTileEntity("tornado_siren_manual", TileEntityTSirenManual.class);
        BlockRegistry.addTileEntity("wind_vane", TileWindVane.class);
        BlockRegistry.addTileEntity("weather_forecast", TileRadar.class);
        BlockRegistry.addTileEntity("weather_machine", TileWeatherConstructor.class);
        BlockRegistry.addTileEntity("weather_deflector", TileWeatherDeflector.class);
        BlockRegistry.addTileEntity("anemometer", TileAnemometer.class);
        BlockRegistry.addTileEntity("machine_case", TileMachine.class);
        registry = null;
        Weather2.debug("Finished registering blocks");
    }

    private static void addTileEntity(String registry_name, Class<? extends TileEntity> tile) {
        if (tile != null) {
            GameRegistry.registerTileEntity(tile, (ResourceLocation)new ResourceLocation("weather2remaster", registry_name));
        }
    }

    private static void addBlock(String registry_name, Block block) {
        BlockRegistry.addBlock(registry_name, null, block, true);
    }

    private static void addBlock(String registry_name, Block block, boolean creative_tab) {
        BlockRegistry.addBlock(registry_name, null, block, creative_tab);
    }

    private static void addBlock(String registry_name, String ore_dict_name, Block block) {
        BlockRegistry.addBlock(registry_name, ore_dict_name, block, true);
    }

    private static void addBlock(String registry_name, String ore_dict_name, Block block, boolean creative_tab) {
        if (registry != null) {
            block.setRegistryName(new ResourceLocation("weather2", registry_name));
            block.func_149663_c(registry_name);
            if (ore_dict_name != null) {
                OreDictionary.registerOre((String)ore_dict_name, (Block)block);
            }
            if (creative_tab) {
                block.func_149647_a(Weather2.TAB);
            }
            registry.getRegistry().register((IForgeRegistryEntry)block);
            ItemRegistry.add(block);
            Weather2.debug("Registered block " + block.getRegistryName().func_110624_b() + ":" + block.getRegistryName().func_110623_a());
            return;
        }
        Weather2.error("Registry event returned null");
    }

    static {
        wire = new BlockSensor();
        radio = new BlockMachine(Material.field_151571_B);
        wind_chimes = new BlockNewSiren();
        air_horn_siren = new BlockNewSiren();
        emergency_siren_alt = new BlockNewSiren();
        emergency_siren_alt_manual = new BlockNewSiren();
        weather_doppler_radar = new BlockNewRadar(1);
        weather_pulse_radar = new BlockNewRadar(2);
        weather_humidifier = new BlockNewWeatherConstructor();
        weather_humidifier_2 = new BlockNewWeatherConstructor();
        weather_conditioner = new BlockNewWeatherDeflector();
        weather_conditioner_2 = new BlockNewWeatherDeflector();
        wind_vane = new BlockWindVane();
        anemometer = new BlockAnemometer();
        machineCase = new BlockMachine(Material.field_151571_B);
        stormSensor = new BlockNewSensor(Material.field_151571_B, 0);
        humiditySensor = new BlockNewSensor(Material.field_151571_B, 1);
        rainSensor = new BlockNewSensor(Material.field_151571_B, 2);
        temperatureSensor = new BlockNewSensor(Material.field_151571_B, 3);
        windSensor = new BlockNewSensor(Material.field_151571_B, 4);
        barometerSensor = new BlockNewSensor(Material.field_151571_B, 5);
        tornado_sensor = new BlockSensor();
        emergency_siren_manual = new BlockTSirenManual();
        emergency_siren = new BlockSiren();
        weather_radar = new BlockNewRadar();
        weather_constructor = new BlockWeatherConstructor();
        weather_deflector = new BlockWeatherDeflector();
        sand_layer = new BlockSandLayer();
    }
}

