/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.player;

import CoroUtil.util.CoroUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.mrbt0907.weather2.Weather2;

public class PlayerData {
    public static HashMap<UUID, NBTTagCompound> playerNBT = new HashMap();

    public static NBTTagCompound getPlayerNBT(UUID playerUUID) {
        if (!playerNBT.containsKey(playerUUID)) {
            PlayerData.tryLoadPlayerNBT(playerUUID);
        }
        return playerNBT.get(playerUUID);
    }

    public static void tryLoadPlayerNBT(UUID playerUUID) {
        NBTTagCompound nbt = new NBTTagCompound();
        try {
            String fileURL = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + File.separator + "weather2" + File.separator + "PlayerData" + File.separator + playerUUID.toString() + ".dat";
            if (new File(fileURL).exists()) {
                nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(fileURL));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        playerNBT.put(playerUUID, nbt);
    }

    public static void writeAllPlayerNBT(boolean resetData) {
        String fileURL = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + File.separator + "weather2" + File.separator + "PlayerData";
        if (!new File(fileURL).exists()) {
            new File(fileURL).mkdir();
        }
        playerNBT.forEach((uuid, nbt) -> PlayerData.writePlayerNBT(uuid, nbt));
        if (resetData) {
            playerNBT.clear();
        }
    }

    public static void writePlayerNBT(UUID playerUUID, NBTTagCompound nbt) {
        String fileURL = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + File.separator + "weather2" + File.separator + "PlayerData" + File.separator + playerUUID.toString() + ".dat";
        try {
            FileOutputStream fos = new FileOutputStream(fileURL);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Weather2.debug("Error writing Weather2 player data for " + playerUUID.toString());
        }
    }
}

