/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.event;

import CoroUtil.packet.PacketHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.client.NewSceneEnhancer;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.network.packets.PacketEZGUI;
import net.mrbt0907.weather2.server.event.ServerTickHandler;
import net.mrbt0907.weather2.util.WeatherUtilSound;

public class EventHandlerPacket {
    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound((ByteBuf)event.getPacket().payload());
            int command = nbt.func_74762_e("command");
            Minecraft.func_71410_x().func_152344_a(() -> {
                switch (command) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ClientTickHandler.checkClientWeather();
                        ClientTickHandler.weatherManager.nbtSyncFromServer(nbt);
                        break;
                    }
                    case 9: {
                        EZConfigParser.nbtReceiveClient(nbt);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        ClientTickHandler.checkClientWeather();
                        ClientTickHandler.weatherManager.nbtSyncFromServer(nbt);
                        break;
                    }
                    case 15: {
                        WeatherUtilSound.reset();
                        Weather2.debug("Refreshed weather2 sound system");
                        break;
                    }
                    case 17: {
                        NewSceneEnhancer.instance().reset();
                        NewSceneEnhancer.instance().enable();
                        break;
                    }
                    case 18: {
                        break;
                    }
                    default: {
                        Weather2.error("Recieved an invalid network packet from the server");
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPacketFromClient(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP entP = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound((ByteBuf)event.getPacket().payload());
            int command = nbt.func_74762_e("command");
            entP.field_71133_b.func_152344_a(() -> {
                switch (command) {
                    case 8: {
                        NBTTagCompound sendNBT = EZConfigParser.nbtServerData;
                        sendNBT.func_74768_a("command", 9);
                        sendNBT.func_74768_a("server", 1);
                        sendNBT.func_74757_a("op", FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H() || FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(entP.func_146103_bH()));
                        PacketEZGUI.syncResponse(sendNBT);
                        break;
                    }
                    case 11: {
                        ServerTickHandler.playerClientRequestsFullSync(entP);
                        break;
                    }
                    case 10: {
                        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H() && !FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(entP.func_146103_bH())) break;
                        EZConfigParser.nbtReceiveServer(nbt);
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

