/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.config.ConfigGrab;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.storm.StormObject;

public class EntityMovingBlock
extends Entity
implements IEntityAdditionalSpawnData {
    public Block block;
    public IBlockState state;
    public TileEntity tileentity;
    public Material material;
    public int metadata;
    public int mode = 1;
    public int age = 0;
    public boolean noCollision;
    public boolean collideFalling = false;
    public double vecX;
    public double vecY;
    public double vecZ;
    public int gravityDelay;

    public EntityMovingBlock(World var1) {
        super(var1);
        this.state = Blocks.field_150348_b.func_176223_P();
        this.block = this.state.func_177230_c();
        this.noCollision = true;
        this.gravityDelay = 60;
    }

    public EntityMovingBlock(World world, int x, int y, int z, IBlockState state, StormObject storm) {
        super(world);
        this.noCollision = false;
        this.gravityDelay = 60;
        this.func_70105_a(0.9f, 0.9f);
        this.func_70107_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = (float)x + 0.5f;
        this.field_70167_r = (float)y + 0.5f;
        this.field_70166_s = (float)z + 0.5f;
        this.metadata = state.func_177230_c().func_176201_c(state);
        this.material = state.func_185904_a();
        this.state = state;
        this.block = state.func_177230_c();
    }

    public boolean func_70112_a(double var1) {
        return var1 < 65536.0;
    }

    public boolean func_70041_e_() {
        return false;
    }

    public void func_70088_a() {
    }

    public boolean func_70104_M() {
        return !this.field_70128_L;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L && !this.noCollision;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_184137_a(this.field_70165_t, 50.0, this.field_70161_v, 512.0, false) == null) {
            this.func_70106_y();
        }
        if (this.block.equals(Blocks.field_150350_a)) {
            this.func_70106_y();
        } else {
            int var11;
            int var9;
            ++this.age;
            if (this.age > this.gravityDelay) {
                this.mode = 0;
                if (this.tileentity == null && ConfigGrab.Storm_Tornado_rarityOfDisintegrate != -1 && this.field_70146_Z.nextInt((ConfigGrab.Storm_Tornado_rarityOfDisintegrate + 1) * 20) == 0) {
                    this.func_70106_y();
                }
            }
            this.vecX += 1.0;
            this.vecY += 1.0;
            this.vecZ += 1.0;
            if (this.mode == 1) {
                this.field_70143_R = 0.0f;
                this.field_70123_F = false;
            }
            if (!this.field_70170_p.field_72995_K) {
                Maths.Vec3 thing = new Maths.Vec3(this.func_180425_c());
                thing.addVector(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (!this.field_70170_p.func_175668_a(thing.toBlockPos(), true)) {
                    this.func_70106_y();
                }
            }
            Vec3d var1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d var2 = new Vec3d(this.field_70165_t + this.field_70159_w * 1.3, this.field_70163_u + this.field_70181_x * 1.3, this.field_70161_v + this.field_70179_y * 1.3);
            RayTraceResult var3 = this.field_70170_p.func_72933_a(var1, var2);
            var2 = new Vec3d(this.field_70165_t + this.field_70159_w * 1.3, this.field_70163_u + this.field_70181_x * 1.3, this.field_70161_v + this.field_70179_y * 1.3);
            if (var3 != null) {
                var2 = new Vec3d(var3.field_72307_f.field_72450_a, var3.field_72307_f.field_72448_b, var3.field_72307_f.field_72449_c);
            }
            Entity var4 = null;
            ArrayList<Entity> var5 = new ArrayList<Entity>();
            ArrayList entities = new ArrayList();
            if (this.age > this.gravityDelay / 4) {
                for (Entity entity : entities) {
                    if (entity.equals((Object)this) || !(entity.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) < (double)(this.field_70131_O * 2.0f))) continue;
                    var5.add(entity);
                }
            }
            double var6 = 0.0;
            for (Entity var10 : var5) {
                double var14;
                if (!(var10 instanceof EntityMovingBlock) && var10.func_70067_L() && this.canEntityBeSeen(var10)) {
                    if (!(var10 instanceof EntityPlayer) || !((EntityPlayer)var10).field_71075_bZ.field_75098_d) {
                        var10.field_70159_w = this.field_70159_w / 1.5;
                        var10.field_70181_x = this.field_70181_x / 1.5;
                        var10.field_70179_y = this.field_70179_y / 1.5;
                    }
                    if (ConfigGrab.grabbed_blocks_hurt && Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) > (double)0.4f) {
                        DamageSource ds = DamageSource.func_76356_a((Entity)this, (Entity)this);
                        ds.field_76373_n = "wm.movingblock";
                        try {
                            var10.func_70097_a(ds, 4.0f);
                        }
                        catch (Exception e) {
                            Weather2.error(e);
                        }
                    }
                }
                if (!var10.func_70067_L() || this.noCollision) continue;
                if (var10.func_70104_M()) {
                    var10.func_70068_e((Entity)this);
                    if (this.func_70027_ad()) {
                        var10.func_70015_d(15);
                    }
                    if (this.block == Blocks.field_150434_aF) {
                        try {
                            var10.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this), 1.0f);
                        }
                        catch (Exception e) {
                            Weather2.error(e);
                        }
                    } else if (this.material == Material.field_151587_i) {
                        var10.func_70015_d(15);
                    } else {
                        var9 = MathHelper.func_76128_c((double)this.field_70165_t);
                        var11 = MathHelper.func_76128_c((double)this.field_70163_u);
                        int var12 = MathHelper.func_76128_c((double)this.field_70161_v);
                        BlockPos pos = new BlockPos(var9, var11, var12);
                        IBlockState state = this.field_70170_p.func_180495_p(pos);
                        this.block.func_180634_a(this.field_70170_p, pos, state, var10);
                    }
                }
                float var16 = 0.3f;
                AxisAlignedBB var19 = var10.func_174813_aQ().func_72314_b((double)var16, (double)var16, (double)var16);
                RayTraceResult var13 = var19.func_72327_a(var1, var2);
                if (var13 == null || !((var14 = var1.func_72438_d(var13.field_72307_f)) < var6) && var6 != 0.0) continue;
                var4 = var10;
                var6 = var14;
            }
            if (var4 != null) {
                var3 = new RayTraceResult(var4);
            }
            if (var3 != null && var3.field_72308_g == null && this.mode == 0) {
                int var8 = var3.func_178782_a().func_177958_n();
                int var17 = var3.func_178782_a().func_177956_o();
                var9 = var3.func_178782_a().func_177952_p();
                if (var3.field_178784_b == EnumFacing.DOWN) {
                    --var17;
                }
                if (var3.field_178784_b == EnumFacing.UP) {
                    ++var17;
                }
                if (var3.field_178784_b == EnumFacing.SOUTH) {
                    --var9;
                }
                if (var3.field_178784_b == EnumFacing.NORTH) {
                    ++var9;
                }
                if (var3.field_178784_b == EnumFacing.WEST) {
                    --var8;
                }
                if (var3.field_178784_b == EnumFacing.EAST) {
                    ++var8;
                }
                if (var3.field_178784_b != EnumFacing.DOWN && !this.collideFalling) {
                    if (!this.collideFalling) {
                        this.collideFalling = true;
                        this.field_70165_t = MathHelper.func_76128_c((double)this.field_70165_t);
                        this.field_70161_v = MathHelper.func_76128_c((double)this.field_70161_v);
                        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                    }
                } else {
                    this.blockify(var8, var17, var9, var3.field_178784_b);
                }
                return;
            }
            float var18 = 0.98f;
            this.field_70181_x -= (double)0.05f;
            this.field_70159_w *= (double)var18;
            this.field_70181_x *= (double)var18;
            this.field_70179_y *= (double)var18;
            var11 = (int)(this.field_70165_t + this.field_70159_w * 5.0);
            int var20 = 50;
            int var21 = (int)(this.field_70161_v + this.field_70179_y * 5.0);
            if (!this.field_70170_p.func_175667_e(new BlockPos(var11, var20, var21))) {
                this.func_70106_y();
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public boolean canEntityBeSeen(Entity par1Entity) {
        return this.field_70170_p.func_72933_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(par1Entity.field_70165_t, par1Entity.field_70163_u + (double)par1Entity.func_70047_e(), par1Entity.field_70161_v)) == null;
    }

    private void blockify(int x, int y, int z, EnumFacing var4) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_70106_y();
        try {
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = Weather2.getChunkUtil(this.field_70170_p).getBlockState(this.field_70170_p, pos);
            if ((this.tileentity != null || ConfigGrab.Storm_Tornado_rarityOfBreakOnFall > 0 && this.field_70146_Z.nextInt(ConfigGrab.Storm_Tornado_rarityOfBreakOnFall + 1) != 0) && !state.func_185904_a().func_76224_d() && Weather2.getChunkUtil(this.field_70170_p).isValidPos(this.field_70170_p, y)) {
                Weather2.getChunkUtil(this.field_70170_p).setBlockState(this.field_70170_p, x, y, z, this.state);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74778_a("Tile", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
        nbt.func_74774_a("Metadata", (byte)this.metadata);
        NBTTagCompound var2 = new NBTTagCompound();
        if (this.tileentity != null) {
            this.tileentity.func_189515_b(var2);
        }
        nbt.func_74782_a("TileEntity", (NBTBase)var2);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("Tile")));
        this.metadata = nbt.func_74771_c("Metadata") & 0xF;
        this.state = this.block.func_176203_a(this.metadata);
        this.tileentity = null;
        if (this.block instanceof BlockContainer) {
            this.tileentity = ((BlockContainer)this.block).func_149915_a(this.field_70170_p, this.metadata);
            NBTTagCompound var2 = nbt.func_74775_l("TileEntity");
            this.tileentity.func_145839_a(var2);
        }
    }

    public void writeSpawnData(ByteBuf data) {
        String str = "blank";
        if (this.block != null && Block.field_149771_c.func_177774_c((Object)this.block) != null) {
            str = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString();
        }
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)str);
        data.writeInt(this.metadata);
    }

    public void readSpawnData(ByteBuf data) {
        String str = ByteBufUtils.readUTF8String((ByteBuf)data);
        if (!str.equals("blank")) {
            this.block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(str));
            this.metadata = data.readInt();
        } else {
            this.block = Blocks.field_150348_b;
            this.metadata = 0;
        }
        this.state = this.block.func_176203_a(this.metadata);
        this.material = this.state.func_185904_a();
    }
}

