/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.config;

import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.util.CoroUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import modconfig.ConfigMod;
import modconfig.ModConfigData;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.EZGuiAPI;
import net.mrbt0907.weather2.api.event.EventEZGuiData;
import net.mrbt0907.weather2.config.ConfigFront;
import net.mrbt0907.weather2.config.ConfigGrab;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.config.ConfigSand;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.util.TriMapEx;

public class EZConfigParser {
    public static final String version = "2.5";
    public static final Map<String, Integer> CLIENT_DEFAULTS = new HashMap<String, Integer>();
    public static final Map<String, Integer> SERVER_DEFAULTS = new HashMap<String, Integer>();
    private static List<Integer> weatherList = new ArrayList<Integer>();
    private static List<Integer> effectList = new ArrayList<Integer>();
    public static final Map<Integer, String> dimNames = new HashMap<Integer, String>();
    public static NBTTagCompound nbtServerData = new NBTTagCompound();
    public static NBTTagCompound nbtRealServerData = new NBTTagCompound();
    public static NBTTagCompound nbtClientData = new NBTTagCompound();

    public static void processServerData(NBTTagCompound cache) {
        for (String key : cache.func_150296_c()) {
            int value = cache.func_74762_e(key);
            switch (key) {
                case "b_global": {
                    ConfigMisc.overcast_mode = value == 1;
                    break;
                }
                case "c_tornado": {
                    ConfigStorm.disable_tornados = value == 0;
                    break;
                }
                case "c_cyclone": {
                    ConfigStorm.disable_cyclones = value == 0;
                    break;
                }
                case "c_sandstorm": {
                    ConfigSand.disable_sandstorms = value == 0;
                    break;
                }
                case "c_frequency": {
                    switch (value) {
                        case 0: {
                            ConfigFront.max_front_objects = 3;
                            ConfigStorm.max_weather_objects = 30;
                            ConfigStorm.storm_spawn_chance = 5;
                            ConfigStorm.storm_spawn_delay = 2000;
                            ConfigSand.sandstorm_spawn_1_in_x = 300;
                            ConfigSand.sandstorm_spawn_delay = 8000;
                            break;
                        }
                        case 1: {
                            ConfigFront.max_front_objects = 3;
                            ConfigStorm.max_weather_objects = 30;
                            ConfigStorm.storm_spawn_chance = 10;
                            ConfigStorm.storm_spawn_delay = 1250;
                            ConfigSand.sandstorm_spawn_1_in_x = 200;
                            ConfigSand.sandstorm_spawn_delay = 8000;
                            break;
                        }
                        case 2: {
                            ConfigFront.max_front_objects = 3;
                            ConfigStorm.max_weather_objects = 30;
                            ConfigStorm.storm_spawn_chance = 15;
                            ConfigStorm.storm_spawn_delay = 1000;
                            ConfigSand.sandstorm_spawn_1_in_x = 100;
                            ConfigSand.sandstorm_spawn_delay = 4000;
                            break;
                        }
                        case 3: {
                            ConfigFront.max_front_objects = 3;
                            ConfigStorm.max_weather_objects = 30;
                            ConfigStorm.storm_spawn_chance = 30;
                            ConfigStorm.storm_spawn_delay = 750;
                            ConfigSand.sandstorm_spawn_1_in_x = 60;
                            ConfigSand.sandstorm_spawn_delay = 2000;
                            break;
                        }
                        case 4: {
                            ConfigFront.max_front_objects = 4;
                            ConfigStorm.max_weather_objects = 40;
                            ConfigStorm.storm_spawn_chance = 35;
                            ConfigStorm.storm_spawn_delay = 650;
                            ConfigSand.sandstorm_spawn_1_in_x = 40;
                            ConfigSand.sandstorm_spawn_delay = 1500;
                            break;
                        }
                        case 5: {
                            ConfigFront.max_front_objects = 5;
                            ConfigStorm.max_weather_objects = 50;
                            ConfigStorm.storm_spawn_chance = 50;
                            ConfigStorm.storm_spawn_delay = 500;
                            ConfigSand.sandstorm_spawn_1_in_x = 25;
                            ConfigSand.sandstorm_spawn_delay = 1200;
                            break;
                        }
                        case 6: {
                            ConfigFront.max_front_objects = 5;
                            ConfigStorm.max_weather_objects = 100;
                            ConfigStorm.storm_spawn_chance = 100;
                            ConfigStorm.storm_spawn_delay = 200;
                            ConfigStorm.storms_aim_at_player = true;
                            ConfigStorm.storm_aim_accuracy_in_angle = 0;
                            ConfigSand.sandstorm_spawn_1_in_x = 3;
                            ConfigSand.sandstorm_spawn_delay = 1000;
                        }
                    }
                    break;
                }
                case "c_grab_block": {
                    ConfigGrab.grab_blocks = value == 1;
                    break;
                }
                case "c_grab_item": {
                    ConfigGrab.grab_items = value == 1;
                    break;
                }
                case "c_grab_mob": {
                    ConfigGrab.grab_villagers = value == 1;
                    ConfigGrab.grab_animals = value == 1;
                    ConfigGrab.grab_mobs = value == 1;
                    break;
                }
                case "c_grab_player": {
                    ConfigGrab.grab_players = value == 1;
                    break;
                }
                case "c_storm_per_player": {
                    ConfigStorm.enable_spawn_per_player = value == 0;
                    boolean bl = ConfigSand.enable_global_rates_for_sandstorms = value == 0;
                }
            }
            if (key.equals("dimData")) continue;
            EventEZGuiData event = new EventEZGuiData(key, nbtClientData.func_74762_e(key), value);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
        if (cache.func_74764_b("dimData")) {
            for (String key : cache.func_74775_l("dimData").func_150296_c()) {
                int keyN;
                if (key.contains("dimb_")) {
                    keyN = Integer.parseInt(key.replaceFirst("dimb_", ""));
                    if (cache.func_74775_l("dimData").func_74762_e(key) == 1) {
                        weatherList.add(keyN);
                        continue;
                    }
                    if (!weatherList.contains(keyN)) continue;
                    weatherList.remove(weatherList.indexOf(keyN));
                    continue;
                }
                if (!key.contains("dimc_")) continue;
                keyN = Integer.parseInt(key.replaceFirst("dimc_", ""));
                if (cache.func_74775_l("dimData").func_74762_e(key) == 1) {
                    effectList.add(keyN);
                    continue;
                }
                if (!effectList.contains(keyN)) continue;
                effectList.remove(effectList.indexOf(keyN));
            }
            String list = "";
            for (int dimension : weatherList) {
                if (list.length() == 0) {
                    list = dimension + "";
                    continue;
                }
                list = list + ", " + dimension;
            }
            ConfigMisc.dimensions_weather = list;
            list = "";
            for (int dimension : effectList) {
                if (list.length() == 0) {
                    list = dimension + "";
                    continue;
                }
                list = list + ", " + dimension;
            }
            ConfigMisc.dimensions_effects = list;
            EZConfigParser.refreshDimensionRules();
        }
        EZConfigParser.nbtSaveDataServer();
        ConfigManager.save();
    }

    public static void processClientData(NBTTagCompound cache) {
        for (String key : cache.func_150296_c()) {
            int value = cache.func_74762_e(key);
            switch (key) {
                case "a_cloud": {
                    switch (value) {
                        case 0: {
                            ConfigParticle.max_cloud_coverage_perc = 0.0;
                            ConfigParticle.min_cloud_coverage_perc = 0.0;
                            ConfigParticle.cloud_particle_delay = 666999;
                            break;
                        }
                        case 1: {
                            ConfigParticle.max_cloud_coverage_perc = 15.0;
                            ConfigParticle.min_cloud_coverage_perc = 0.0;
                            ConfigParticle.cloud_particle_delay = 10;
                            break;
                        }
                        case 2: {
                            ConfigParticle.max_cloud_coverage_perc = 25.0;
                            ConfigParticle.min_cloud_coverage_perc = 10.0;
                            ConfigParticle.cloud_particle_delay = 5;
                            break;
                        }
                        case 3: {
                            ConfigParticle.max_cloud_coverage_perc = 50.0;
                            ConfigParticle.min_cloud_coverage_perc = 20.0;
                            ConfigParticle.cloud_particle_delay = 3;
                            break;
                        }
                        case 4: {
                            ConfigParticle.max_cloud_coverage_perc = 80.0;
                            ConfigParticle.min_cloud_coverage_perc = 250.0;
                            ConfigParticle.cloud_particle_delay = 2;
                            break;
                        }
                        case 5: {
                            ConfigParticle.max_cloud_coverage_perc = 100.0;
                            ConfigParticle.min_cloud_coverage_perc = 50.0;
                            ConfigParticle.cloud_particle_delay = 1;
                            break;
                        }
                        case 6: {
                            ConfigParticle.max_cloud_coverage_perc = 200.0;
                            ConfigParticle.min_cloud_coverage_perc = 50.0;
                            ConfigParticle.cloud_particle_delay = 0;
                        }
                    }
                    break;
                }
                case "a_funnel": {
                    switch (value) {
                        case 0: {
                            ConfigParticle.sandstorm_debris_particle_rate = 0.0;
                            ConfigParticle.sandstorm_dust_particle_rate = 0.0;
                            ConfigParticle.funnel_particle_delay = 666999;
                            ConfigParticle.ground_debris_particle_delay = 666999;
                            ConfigParticle.enable_tornado_block_colors = false;
                            ConfigParticle.enable_tornado_debris = false;
                            break;
                        }
                        case 1: {
                            ConfigParticle.sandstorm_debris_particle_rate = 0.025;
                            ConfigParticle.sandstorm_dust_particle_rate = 0.05;
                            ConfigParticle.funnel_particle_delay = 45;
                            ConfigParticle.ground_debris_particle_delay = 20;
                            ConfigParticle.enable_tornado_block_colors = false;
                            ConfigParticle.enable_tornado_debris = false;
                            break;
                        }
                        case 2: {
                            ConfigParticle.sandstorm_debris_particle_rate = 0.05;
                            ConfigParticle.sandstorm_dust_particle_rate = 0.1;
                            ConfigParticle.funnel_particle_delay = 20;
                            ConfigParticle.ground_debris_particle_delay = 10;
                            ConfigParticle.enable_tornado_block_colors = false;
                            ConfigParticle.enable_tornado_debris = false;
                            break;
                        }
                        case 3: {
                            ConfigParticle.sandstorm_debris_particle_rate = 0.1;
                            ConfigParticle.sandstorm_dust_particle_rate = 0.15;
                            ConfigParticle.funnel_particle_delay = 10;
                            ConfigParticle.ground_debris_particle_delay = 5;
                            ConfigParticle.enable_tornado_block_colors = false;
                            ConfigParticle.enable_tornado_debris = false;
                            break;
                        }
                        case 4: {
                            ConfigParticle.sandstorm_debris_particle_rate = 0.15;
                            ConfigParticle.sandstorm_dust_particle_rate = 0.4;
                            ConfigParticle.funnel_particle_delay = 5;
                            ConfigParticle.ground_debris_particle_delay = 5;
                            ConfigParticle.enable_tornado_block_colors = true;
                            ConfigParticle.enable_tornado_debris = false;
                            break;
                        }
                        case 5: {
                            ConfigParticle.sandstorm_debris_particle_rate = 0.25;
                            ConfigParticle.sandstorm_dust_particle_rate = 0.6;
                            ConfigParticle.funnel_particle_delay = 2;
                            ConfigParticle.ground_debris_particle_delay = 3;
                            ConfigParticle.enable_tornado_block_colors = true;
                            ConfigParticle.enable_tornado_debris = true;
                            break;
                        }
                        case 6: {
                            ConfigParticle.sandstorm_debris_particle_rate = 0.5;
                            ConfigParticle.sandstorm_dust_particle_rate = 1.0;
                            ConfigParticle.funnel_particle_delay = 0;
                            ConfigParticle.ground_debris_particle_delay = 0;
                            ConfigParticle.enable_tornado_block_colors = true;
                            ConfigParticle.enable_tornado_debris = true;
                        }
                    }
                    break;
                }
                case "a_precipitation": {
                    switch (value) {
                        case 0: {
                            ConfigParticle.enable_precipitation = true;
                            ConfigParticle.enable_precipitation_splash = false;
                            ConfigParticle.enable_heavy_precipitation = false;
                            ConfigParticle.enable_vanilla_rain = false;
                            ConfigParticle.precipitation_particle_rate = 0.0;
                            ConfigParticle.enable_distant_downfall = false;
                            ConfigParticle.distant_downfall_particle_rate = 0.0;
                            break;
                        }
                        case 1: {
                            ConfigParticle.enable_precipitation = false;
                            ConfigParticle.enable_precipitation_splash = false;
                            ConfigParticle.enable_heavy_precipitation = false;
                            ConfigParticle.enable_vanilla_rain = true;
                            ConfigParticle.precipitation_particle_rate = 0.05;
                            ConfigParticle.enable_distant_downfall = false;
                            ConfigParticle.distant_downfall_particle_rate = 0.4f;
                            break;
                        }
                        case 2: {
                            ConfigParticle.enable_precipitation = true;
                            ConfigParticle.enable_precipitation_splash = false;
                            ConfigParticle.enable_heavy_precipitation = false;
                            ConfigParticle.enable_vanilla_rain = false;
                            ConfigParticle.precipitation_particle_rate = 0.2;
                            ConfigParticle.enable_distant_downfall = false;
                            ConfigParticle.distant_downfall_particle_rate = 0.2f;
                            break;
                        }
                        case 3: {
                            ConfigParticle.enable_precipitation = true;
                            ConfigParticle.enable_precipitation_splash = true;
                            ConfigParticle.enable_heavy_precipitation = false;
                            ConfigParticle.enable_vanilla_rain = false;
                            ConfigParticle.precipitation_particle_rate = 0.4;
                            ConfigParticle.enable_distant_downfall = false;
                            ConfigParticle.distant_downfall_particle_rate = 0.2f;
                            break;
                        }
                        case 4: {
                            ConfigParticle.enable_precipitation = true;
                            ConfigParticle.enable_precipitation_splash = true;
                            ConfigParticle.enable_heavy_precipitation = true;
                            ConfigParticle.enable_vanilla_rain = false;
                            ConfigParticle.precipitation_particle_rate = 0.65;
                            ConfigParticle.enable_distant_downfall = true;
                            ConfigParticle.distant_downfall_particle_rate = 0.4f;
                            break;
                        }
                        case 5: {
                            ConfigParticle.enable_precipitation = true;
                            ConfigParticle.enable_precipitation_splash = true;
                            ConfigParticle.enable_heavy_precipitation = true;
                            ConfigParticle.enable_vanilla_rain = false;
                            ConfigParticle.precipitation_particle_rate = 1.0;
                            ConfigParticle.enable_distant_downfall = true;
                            ConfigParticle.distant_downfall_particle_rate = 0.6f;
                            break;
                        }
                        case 6: {
                            ConfigParticle.enable_precipitation = true;
                            ConfigParticle.enable_precipitation_splash = true;
                            ConfigParticle.enable_heavy_precipitation = true;
                            ConfigParticle.enable_vanilla_rain = false;
                            ConfigParticle.precipitation_particle_rate = 1.4;
                            ConfigParticle.enable_distant_downfall = true;
                            ConfigParticle.distant_downfall_particle_rate = 1.0;
                            break;
                        }
                        case 7: {
                            ConfigParticle.enable_precipitation = true;
                            ConfigParticle.enable_precipitation_splash = true;
                            ConfigParticle.enable_heavy_precipitation = true;
                            ConfigParticle.enable_vanilla_rain = false;
                            ConfigParticle.precipitation_particle_rate = 2.0;
                            ConfigParticle.enable_distant_downfall = true;
                            ConfigParticle.distant_downfall_particle_rate = 2.0;
                        }
                    }
                    break;
                }
                case "a_effect": {
                    switch (value) {
                        case 0: {
                            ConfigParticle.enable_falling_leaves = false;
                            ConfigParticle.enable_fire_particle = false;
                            ConfigParticle.enable_waterfall_splash = false;
                            ConfigParticle.enable_wind_particle = false;
                            ConfigParticle.wind_particle_rate = 0.0;
                            ConfigParticle.ambient_particle_rate = 0.0;
                            ConfigParticle.fog_mult = 0.0;
                            ConfigParticle.camera_shake_mult = 0.0;
                            break;
                        }
                        case 1: {
                            ConfigParticle.enable_falling_leaves = true;
                            ConfigParticle.enable_fire_particle = false;
                            ConfigParticle.enable_waterfall_splash = false;
                            ConfigParticle.enable_wind_particle = false;
                            ConfigParticle.wind_particle_rate = 0.0;
                            ConfigParticle.ambient_particle_rate = 0.1;
                            ConfigParticle.fog_mult = 0.0;
                            ConfigParticle.camera_shake_mult = 0.0;
                            break;
                        }
                        case 2: {
                            ConfigParticle.enable_falling_leaves = true;
                            ConfigParticle.enable_fire_particle = true;
                            ConfigParticle.enable_waterfall_splash = false;
                            ConfigParticle.enable_wind_particle = false;
                            ConfigParticle.wind_particle_rate = 0.0;
                            ConfigParticle.ambient_particle_rate = 0.2;
                            ConfigParticle.fog_mult = 0.0;
                            ConfigParticle.camera_shake_mult = 0.0;
                            break;
                        }
                        case 3: {
                            ConfigParticle.enable_falling_leaves = true;
                            ConfigParticle.enable_fire_particle = true;
                            ConfigParticle.enable_waterfall_splash = true;
                            ConfigParticle.enable_wind_particle = true;
                            ConfigParticle.wind_particle_rate = 0.1;
                            ConfigParticle.ambient_particle_rate = 0.35;
                            ConfigParticle.fog_mult = 0.15;
                            ConfigParticle.camera_shake_mult = 0.25;
                            break;
                        }
                        case 4: {
                            ConfigParticle.enable_falling_leaves = true;
                            ConfigParticle.enable_fire_particle = true;
                            ConfigParticle.enable_waterfall_splash = true;
                            ConfigParticle.enable_wind_particle = true;
                            ConfigParticle.wind_particle_rate = 0.2;
                            ConfigParticle.ambient_particle_rate = 0.6;
                            ConfigParticle.fog_mult = 0.25;
                            ConfigParticle.camera_shake_mult = 0.5;
                            break;
                        }
                        case 5: {
                            ConfigParticle.enable_falling_leaves = true;
                            ConfigParticle.enable_fire_particle = true;
                            ConfigParticle.enable_waterfall_splash = true;
                            ConfigParticle.enable_wind_particle = true;
                            ConfigParticle.wind_particle_rate = 0.25;
                            ConfigParticle.ambient_particle_rate = 1.0;
                            ConfigParticle.fog_mult = 0.6;
                            ConfigParticle.camera_shake_mult = 1.0;
                            break;
                        }
                        case 6: {
                            ConfigParticle.enable_falling_leaves = true;
                            ConfigParticle.enable_fire_particle = true;
                            ConfigParticle.enable_waterfall_splash = true;
                            ConfigParticle.enable_wind_particle = true;
                            ConfigParticle.wind_particle_rate = 0.3;
                            ConfigParticle.ambient_particle_rate = 2.0;
                            ConfigParticle.fog_mult = 1.0;
                            ConfigParticle.camera_shake_mult = 1.0;
                            break;
                        }
                        case 7: {
                            ConfigParticle.enable_falling_leaves = true;
                            ConfigParticle.enable_fire_particle = true;
                            ConfigParticle.enable_waterfall_splash = true;
                            ConfigParticle.enable_wind_particle = true;
                            ConfigParticle.wind_particle_rate = 0.5;
                            ConfigParticle.ambient_particle_rate = 4.0;
                            ConfigParticle.fog_mult = 1.0;
                            ConfigParticle.camera_shake_mult = 1.0;
                        }
                    }
                    break;
                }
                case "a_ef": {
                    ConfigStorm.enable_ef_scale = value == 1;
                    break;
                }
                case "a_shader": {
                    switch (value) {
                        case 0: {
                            ConfigCoroUtil.particleShaders = true;
                            ConfigCoroUtil.useEntityRenderHookForShaders = true;
                            ConfigMisc.proxy_render_override = true;
                            break;
                        }
                        case 1: {
                            ConfigCoroUtil.particleShaders = false;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = true;
                            break;
                        }
                        case 2: {
                            ConfigCoroUtil.particleShaders = false;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = true;
                            break;
                        }
                        case 3: {
                            ConfigCoroUtil.particleShaders = true;
                            ConfigCoroUtil.useEntityRenderHookForShaders = true;
                            ConfigMisc.proxy_render_override = true;
                            break;
                        }
                        case 4: {
                            ConfigCoroUtil.particleShaders = true;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = false;
                            break;
                        }
                        case 5: {
                            ConfigCoroUtil.particleShaders = true;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = false;
                            break;
                        }
                        case 6: {
                            ConfigCoroUtil.particleShaders = true;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = true;
                            break;
                        }
                        case 7: {
                            ConfigCoroUtil.particleShaders = true;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = false;
                            break;
                        }
                        case 8: {
                            ConfigCoroUtil.particleShaders = true;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = false;
                            break;
                        }
                        case 9: {
                            ConfigCoroUtil.particleShaders = true;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = false;
                            break;
                        }
                        case 10: {
                            ConfigCoroUtil.particleShaders = true;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = false;
                            break;
                        }
                        case 11: {
                            ConfigCoroUtil.particleShaders = false;
                            ConfigCoroUtil.useEntityRenderHookForShaders = false;
                            ConfigMisc.proxy_render_override = false;
                        }
                    }
                    ((ModConfigData)ConfigMod.configLookup.get("coroutil_general")).updateField("particleShaders", (Object)ConfigCoroUtil.particleShaders);
                    ((ModConfigData)ConfigMod.configLookup.get("coroutil_general")).updateField("useEntityRenderHookForShaders", (Object)ConfigCoroUtil.useEntityRenderHookForShaders);
                    break;
                }
                case "a_foliage": {
                    ConfigCoroUtil.foliageShaders = value == 1;
                    break;
                }
                case "a_render_distance": {
                    switch (value) {
                        case 0: {
                            ConfigParticle.enable_extended_render_distance = false;
                            ConfigParticle.extended_render_distance = 128.0;
                            ConfigParticle.max_particles = 3000;
                            break;
                        }
                        case 1: {
                            ConfigParticle.enable_extended_render_distance = true;
                            ConfigParticle.extended_render_distance = 128.0;
                            ConfigParticle.max_particles = 3000;
                            break;
                        }
                        case 2: {
                            ConfigParticle.enable_extended_render_distance = true;
                            ConfigParticle.extended_render_distance = 256.0;
                            ConfigParticle.max_particles = 4000;
                            break;
                        }
                        case 3: {
                            ConfigParticle.enable_extended_render_distance = true;
                            ConfigParticle.extended_render_distance = 370.0;
                            ConfigParticle.max_particles = 5000;
                            break;
                        }
                        case 4: {
                            ConfigParticle.enable_extended_render_distance = true;
                            ConfigParticle.extended_render_distance = 512.0;
                            ConfigParticle.max_particles = -1;
                            break;
                        }
                        case 5: {
                            ConfigParticle.enable_extended_render_distance = true;
                            ConfigParticle.extended_render_distance = 750.0;
                            ConfigParticle.max_particles = -1;
                            break;
                        }
                        case 6: {
                            ConfigParticle.enable_extended_render_distance = true;
                            ConfigParticle.extended_render_distance = 1028.0;
                            ConfigParticle.max_particles = -1;
                            break;
                        }
                        case 7: {
                            ConfigParticle.enable_extended_render_distance = true;
                            ConfigParticle.extended_render_distance = 2300.0;
                            ConfigParticle.max_particles = -1;
                        }
                    }
                }
                case "a_fancy_rendering": {
                    ConfigParticle.enable_legacy_rendering = value == 0;
                    break;
                }
                case "a_radar": {
                    boolean bl = ConfigMisc.debug_mode_radar = value == 1;
                }
            }
            if (key.equals("dimData")) continue;
            EventEZGuiData event = new EventEZGuiData(key, nbtClientData.func_74762_e(key), value);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
        EZConfigParser.nbtSaveDataClient();
        ConfigManager.save();
    }

    public static void nbtReceiveServer(NBTTagCompound parNBT) {
        NBTTagCompound cache = new NBTTagCompound();
        for (String key : parNBT.func_150296_c()) {
            if (!key.matches("^btn_.+")) continue;
            String newKey = key.replaceFirst("^btn_", "");
            cache.func_74768_a(newKey, parNBT.func_74762_e(key));
            nbtServerData.func_74768_a(newKey, parNBT.func_74762_e(key));
        }
        cache.func_74782_a("dimData", (NBTBase)parNBT.func_74775_l("dimData"));
        nbtServerData.func_74782_a("dimData", (NBTBase)parNBT.func_74775_l("dimData"));
        Weather2.debug("Received server data from a client: " + parNBT);
        EZConfigParser.processServerData(cache);
    }

    public static void nbtReceiveClient(NBTTagCompound parNBT) {
        if (parNBT.func_74764_b("server")) {
            if (parNBT.func_74762_e("server") == 1) {
                nbtClientData.func_74757_a("op", parNBT.func_74767_n("op"));
                for (String key : parNBT.func_150296_c()) {
                    if (key.matches("^btn_.+")) {
                        String newKey = key.replaceFirst("^btn_", "");
                        nbtRealServerData.func_74768_a(newKey, parNBT.func_74762_e(key));
                        continue;
                    }
                    if (!nbtServerData.func_74764_b(key)) continue;
                    nbtRealServerData.func_74768_a(key, parNBT.func_74762_e(key));
                }
                NBTTagCompound dimensions = parNBT.func_74775_l("dimData");
                if (dimensions != null) {
                    weatherList.clear();
                    effectList.clear();
                    for (String name : dimensions.func_150296_c()) {
                        if (name.contains("dima_")) {
                            dimNames.put(Integer.parseInt(name.replaceFirst("dima_", "")), dimensions.func_74779_i(name));
                            continue;
                        }
                        if (name.contains("dimb_")) {
                            weatherList.add(Integer.parseInt(name.replaceFirst("dimb_", "")));
                            continue;
                        }
                        if (!name.contains("dimc_")) continue;
                        effectList.add(Integer.parseInt(name.replaceFirst("dimc_", "")));
                    }
                }
                Weather2.debug("Received server data from the server: " + parNBT);
            } else {
                NBTTagCompound cache = new NBTTagCompound();
                for (String key : parNBT.func_150296_c()) {
                    if (!key.matches("^btn_.+")) continue;
                    String newKey = key.replaceFirst("^btn_", "");
                    cache.func_74768_a(newKey, parNBT.func_74762_e(key));
                    nbtClientData.func_74768_a(newKey, parNBT.func_74762_e(key));
                }
                Weather2.debug("Received client data from self: " + parNBT);
                EZConfigParser.processClientData(cache);
            }
        }
    }

    public static boolean isOp() {
        return nbtClientData.func_74767_n("op");
    }

    public static void nbtSaveDataClient() {
        EZConfigParser.nbtWriteNBTToDisk(nbtClientData, true);
    }

    public static void nbtSaveDataServer() {
        EZConfigParser.nbtWriteNBTToDisk(nbtServerData, false);
    }

    public static void loadNBT() {
        EZGuiAPI.refreshOptions();
        nbtClientData = EZConfigParser.nbtReadNBTFromDisk(true);
        nbtServerData = EZConfigParser.nbtReadNBTFromDisk(false);
        EZConfigParser.checkVersion();
        TriMapEx<String, List<String>, Integer> options = EZGuiAPI.getOptions();
        Map<String, Integer> optionCategories = EZGuiAPI.getOptionCategories();
        for (Map.Entry<String, Integer> entry : optionCategories.entrySet()) {
            String index = entry.getKey();
            if (entry.getValue() == 0) {
                CLIENT_DEFAULTS.put(index, options.getB(index));
                continue;
            }
            SERVER_DEFAULTS.put(index, options.getB(index));
        }
        for (String key : CLIENT_DEFAULTS.keySet()) {
            if (nbtClientData.func_74764_b(key)) continue;
            nbtClientData.func_74768_a(key, CLIENT_DEFAULTS.get(key).intValue());
        }
        for (String key : SERVER_DEFAULTS.keySet()) {
            if (nbtServerData.func_74764_b(key)) continue;
            nbtServerData.func_74768_a(key, SERVER_DEFAULTS.get(key).intValue());
        }
    }

    public static int getConfigValue(String buttonID) {
        if (nbtClientData.func_74764_b(buttonID)) {
            return nbtClientData.func_74762_e(buttonID);
        }
        if (nbtRealServerData.func_74764_b(buttonID)) {
            return nbtRealServerData.func_74762_e(buttonID);
        }
        if (nbtServerData.func_74764_b(buttonID)) {
            return nbtServerData.func_74762_e(buttonID);
        }
        return 0;
    }

    public static List<Integer> parseList(String intList) {
        String[] arrStr = intList.split("[\\s\\,]+");
        ArrayList<Integer> arrInt = new ArrayList<Integer>();
        for (int i = 0; i < arrStr.length; ++i) {
            try {
                arrInt.add(Integer.parseInt(arrStr[i]));
                continue;
            }
            catch (Exception ex) {
                Weather2.debug("Entry was not an integer: " + arrStr[i]);
            }
        }
        return arrInt;
    }

    private static void checkVersion() {
        if (!nbtServerData.func_74764_b("version") || !nbtServerData.func_74779_i("version").equalsIgnoreCase(version)) {
            Weather2.debug("Detected old EZ server data, reseting everything to default...");
            nbtServerData = new NBTTagCompound();
            nbtServerData.func_74778_a("version", version);
            EZConfigParser.nbtSaveDataServer();
        }
        if (!nbtClientData.func_74764_b("version") || !nbtClientData.func_74779_i("version").equalsIgnoreCase(version)) {
            Weather2.debug("Detected old EZ client data, reseting everything to default...");
            nbtClientData = new NBTTagCompound();
            nbtClientData.func_74778_a("version", version);
            EZConfigParser.nbtSaveDataClient();
        }
    }

    public static void nbtWriteNBTToDisk(NBTTagCompound parData, boolean saveForClient) {
        Weather2.debug("Saving EZ Gui " + (saveForClient ? "client" : "server") + " data...");
        String fileURL = null;
        fileURL = saveForClient ? CoroUtilFile.getMinecraftSaveFolderPath() + File.separator + "weather2remaster" + File.separator + "EZGUIConfigClientData.dat" : CoroUtilFile.getMinecraftSaveFolderPath() + File.separator + "weather2remaster" + File.separator + "EZGUIConfigServerData.dat";
        try {
            FileOutputStream fos = new FileOutputStream(fileURL);
            CompressedStreamTools.func_74799_a((NBTTagCompound)parData, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Weather2.debug("Error writing Weather2 EZ GUI data, unable to save data");
        }
    }

    public static NBTTagCompound nbtReadNBTFromDisk(boolean loadForClient) {
        Weather2.debug("Loading EZ Gui " + (loadForClient ? "client" : "server") + " data...");
        NBTTagCompound data = new NBTTagCompound();
        String fileURL = null;
        fileURL = loadForClient ? CoroUtilFile.getMinecraftSaveFolderPath() + File.separator + "weather2remaster" + File.separator + "EZGUIConfigClientData.dat" : CoroUtilFile.getMinecraftSaveFolderPath() + File.separator + "weather2remaster" + File.separator + "EZGUIConfigServerData.dat";
        try {
            if (new File(fileURL).exists()) {
                data = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(fileURL));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Weather2.debug("Error reading Weather2 EZ GUI data, resetting data to default...");
        }
        return data;
    }

    public static void setOvercastModeServerSide(boolean val) {
        EZConfigParser.nbtSaveDataServer();
    }

    public static boolean isWeatherEnabled(int dimension) {
        return weatherList.contains(dimension);
    }

    public static boolean isEffectsEnabled(int dimension) {
        return effectList.contains(dimension);
    }

    public static void refreshDimensionRules() {
        weatherList = EZConfigParser.parseList(ConfigMisc.dimensions_weather);
        effectList = EZConfigParser.parseList(ConfigMisc.dimensions_effects);
        nbtServerData.func_74782_a("dimData", (NBTBase)new NBTTagCompound());
        String list = "Dimension Rules have been refreshed\nWeather:";
        for (int dim : weatherList) {
            nbtServerData.func_74775_l("dimData").func_74768_a("dimb_" + dim, 1);
            list = list + " " + dim;
        }
        list = list + "\nEffects:";
        for (int dim : effectList) {
            nbtServerData.func_74775_l("dimData").func_74768_a("dimc_" + dim, 1);
            list = list + " " + dim;
        }
        Weather2.debug(list);
    }
}

