/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.config;

import java.io.File;
import net.mrbt0907.configex.api.ConfigAnnotations;
import net.mrbt0907.configex.api.IConfigEX;

public class ConfigWind
implements IConfigEX {
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Enables the entire wind systen"})
    public static boolean enable = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Enables the ability for wind to push entities."})
    public static boolean enableWindAffectsEntities = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"The multiplier for players weight while being pushed by wind. Lower values makes the player lighter."})
    public static double windPlayerWeightMult = 1.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"The multiplier for entities other than players weight while being pushed by wind. Lower values makes the player lighter."})
    public static double windEntityWeightMult = 1.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"The multiplier for all entities weight while being pushed by wind while swimming. Lower values makes all entities lighter while in liquid. Stacks ontop of the other two multipliers"})
    public static double windSwimmingWeightMult = 1.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0, max=360.0)
    @ConfigAnnotations.Comment(value={"The maximum angle in degrees that wind angle can change with."})
    public static double windAngleChangeMax = 30.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"The multiplier for how smooth wind can change. Lower values increases the smoothness."})
    public static double windChangeMult = 1.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"Min wind speed to maintain for storms and clouds. Higher means faster storms."})
    public static double windSpeedMin = 0.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"Max wind speed to maintain for storms and clouds. Higher means faster storms."})
    public static double windSpeedMax = 2.5;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Comment(value={"The minimum amount of time in ticks it can take for wind to change speed and direction."})
    public static int windRefreshMin = 100;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Comment(value={"The maximum amount of time in ticks it can take for wind to change speed and direction."})
    public static int windRefreshMax = 400;

    @Override
    public String getName() {
        return "Weather2 Remastered - Wind";
    }

    @Override
    public String getSaveLocation() {
        return "weather2remaster" + File.separator + "ConfigWind";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void onConfigChanged(IConfigEX.Phase phase, int variables) {
    }

    @Override
    public void onValueChanged(String variable, Object oldValue, Object newValue) {
    }
}

