/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.config;

import java.io.File;
import net.mrbt0907.configex.api.ConfigAnnotations;
import net.mrbt0907.configex.api.IConfigEX;

public class ConfigSand
implements IConfigEX {
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Takes the sand out of sandwiches"})
    public static boolean disable_sandstorms = false;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Use Server Storm Deadly Time instead of Sandstorm Rates"})
    public static boolean enable_global_rates_for_sandstorms = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=1)
    @ConfigAnnotations.Comment(value={"A Sandstorm has a 1 in x chance to spawn"})
    public static int sandstorm_spawn_1_in_x = 30;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Comment(value={"Time between sandstorms for either each player or entire server depending on if global rate is on, default: 3 mc days"})
    public static int sandstorm_spawn_delay = 72000;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Comment(value={"Amount of game ticks between sand buildup iterations, keep it high to prevent client side chunk update spam that destroys FPS"})
    public static int buildup_tick_delay = 40;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Comment(value={"Base amount of loops done per iteration, scaled by the sandstorms intensity (value given here is the max possible)"})
    public static int max_buildup_loop_ammount = 800;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Allow layered sand blocks to buildup outside deserty biomes where sandstorm is"})
    public static boolean enable_buildup_outside_desert = true;
    @ConfigAnnotations.Permission(value=0)
    @ConfigAnnotations.Comment(value={"Enables sirens near sandstorms to play \\\"Darude - Sandstorm\". Meme content"})
    public static boolean disable_darude_sandstorm_plz = false;

    @Override
    public String getName() {
        return "Weather2 Remastered - Sand";
    }

    @Override
    public String getSaveLocation() {
        return "weather2remaster" + File.separator + "ConfigSand";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void onConfigChanged(IConfigEX.Phase phase, int variables) {
    }

    @Override
    public void onValueChanged(String variable, Object oldValue, Object newValue) {
    }
}

