/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.config;

import java.io.File;
import net.mrbt0907.configex.api.ConfigAnnotations;
import net.mrbt0907.configex.api.IConfigEX;
import net.mrbt0907.weather2.api.WeatherAPI;

public class ConfigMisc
implements IConfigEX {
    @ConfigAnnotations.Permission(value=0)
    @ConfigAnnotations.Comment(value={"Disabling this will fix particles not rendering over water"})
    public static boolean proxy_render_override = true;
    @ConfigAnnotations.Permission(value=0)
    @ConfigAnnotations.Comment(value={"Enables the mod to turn vanilla clouds off"})
    public static boolean enable_forced_clouds_off = true;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=1)
    @ConfigAnnotations.Comment(value={"How often does the mod save storms in ticks?"})
    public static int auto_save_interval = 36000;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Comment(value={"Enables the mod to output data into the console for debugging"})
    public static boolean debug_mode = false;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Comment(value={"Enables the mod to output data into all radars about storms"})
    public static boolean debug_mode_radar = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"How far do Radars sense storms?"})
    public static double radar_range = 512.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"How far do Doppler Radars sense storms?"})
    public static double doppler_radar_range = 1024.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"How far do Pulse Doppler Radars sense storms?"})
    public static double pulse_doppler_radar_range = 2048.0;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=1)
    @ConfigAnnotations.Comment(value={"How often does the mod sync storms in ticks? Fixes desync when ran"})
    public static int sync_interval = 2400;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"If true, storms are removed when no players are in the dimension"})
    public static boolean remove_storms_if_no_players = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"If true, lets server side do vanilla weather rules, weather2 will only make storms when server side says 'rain' is on"})
    public static boolean overcast_mode = false;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=-1, max=1)
    @ConfigAnnotations.Comment(value={"Used if overcastMode is off, 1 = lock weather on, 0 = lock weather off, -1 = dont lock anything, let server do whatever"})
    public static int server_weather_mode = 0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"How far can sirens detect a storm"})
    public static double siren_scan_range = 256.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Comment(value={"How far can sensors detect a storm"})
    public static double sensor_scan_range = 512.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Weather Machine's ability to create tornados or hurricanes"})
    public static boolean disable_weather_machine_cyclones = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Weather Machine's recipe"})
    public static boolean disable_weather_machine = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Tornado Sensor's recipe"})
    public static boolean disable_sensor = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Tornado Siren's recipe"})
    public static boolean disable_siren = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Manual Tornado Siren's recipe"})
    public static boolean disable_manual_siren = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Wind Vane's recipe"})
    public static boolean disable_wind_vane = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Anemometer's recipe"})
    public static boolean disable_anemometer = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Weather Forcast's recipe"})
    public static boolean disable_weather_radar = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Weather Deflector's recipe"})
    public static boolean disable_weather_deflector = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Sand Layer's recipe"})
    public static boolean disable_sand_layer = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables Sand's recipe"})
    public static boolean disable_sand = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disables the Pocket Sand item's recipe"})
    public static boolean disable_pocket_sand = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Disabling this recipe will keep them from using other recipes since it depends on this item"})
    public static boolean disable_weather_item = false;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"List of dimensions the mod can use for weather"})
    public static String dimensions_weather = "0, -127";
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"List of dimensions the mod can use for effects"})
    public static String dimensions_effects = "0, -127";
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"With repair mode on, enabling this will allow blocks to instantly repair when a tornado is not damaging it"})
    public static boolean block_instant_repair = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"If true, will cancel vanilla behavior of setting clear weather when the player sleeps, for global overcast mode"})
    public static boolean disable_rain_reset_upon_sleep = true;
    @ConfigAnnotations.Permission(value=0)
    @ConfigAnnotations.Comment(value={"Use if you are on a server with weather but want it ALL off client side for performance reasons, overrides basically every client based setting"})
    public static boolean toaster_pc_mode = false;
    @ConfigAnnotations.Permission(value=0)
    @ConfigAnnotations.Comment(value={"Server and client side, Locks down the mod to only do wind, leaves, foliage shader if on, etc. No weather systems, turns overcast mode on"})
    public static boolean aesthetic_mode = false;

    @Override
    public String getName() {
        return "Weather2 Remastered - Misc";
    }

    @Override
    public String getSaveLocation() {
        return "weather2remaster" + File.separator + "ConfigMisc";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void onConfigChanged(IConfigEX.Phase phase, int variables) {
        if (phase.equals((Object)IConfigEX.Phase.END)) {
            WeatherAPI.refreshDimensionRules();
        }
    }

    @Override
    public void onValueChanged(String variable, Object oldValue, Object newValue) {
    }
}

