/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.config;

import java.io.File;
import net.mrbt0907.configex.api.ConfigAnnotations;
import net.mrbt0907.configex.api.IConfigEX;
import net.mrbt0907.weather2.api.WeatherAPI;

public class ConfigGrab
implements IConfigEX {
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Ignore
    @ConfigAnnotations.Comment(value={"Should weather2 use the old getters and setters for blocks?"})
    public static boolean disableGrabOptimizations = true;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Ignore
    @ConfigAnnotations.Comment(value={"Should weather2 use the old getters and setters for blocks?"})
    public static boolean disableCheapOptimizations = false;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Ignore
    @ConfigAnnotations.Comment(value={"How long should the internal chunk cache keep a chunk in memory? Lower values may decrease memory usage at the cost of performance with grab optimizations enabled"})
    public static int chunk_cache_lifetime = 200;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should storms grab players?"})
    public static boolean grab_players = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should storms grab mobs?"})
    public static boolean grab_mobs = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should storms grab animals?"})
    public static boolean grab_animals = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should storms grab villagers?"})
    public static boolean grab_villagers = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should storms grab blocks?"})
    public static boolean grab_blocks = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should storms grab items?"})
    public static boolean grab_items = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should storms grab blocks based on a block list?"})
    public static boolean enable_grab_list = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should the grab list act as a blacklist?"})
    public static boolean grab_list_blacklist = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should the grab list also find similarly named items?"})
    public static boolean grab_list_partial_matches = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should storms grab blocks based on wind resistance? Will follow grab lists if enabled."})
    public static boolean grab_list_strength_match = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"See config file for examples. A list of blocks to be grabbed by storms. Use commas and/or spaces to separate each entry. Do not use quotation marks. \"!\" Will remove entries set by other mods. Accepted formats - modid:name, name"})
    public static String grab_list_entries = "planks, minecraft:leaves, cobblestone";
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should similar entries from both lists be used?"})
    public static boolean enable_list_sharing = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should tornados replace blocks with other blocks based on a list?"})
    public static boolean enable_replace_list = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should the replace list act as a blacklist?"})
    public static boolean replace_list_blacklist = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should the replace list also find similarly named items?"})
    public static boolean replace_list_partial_matches = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should storms replace blocks based on wind resistance? Will follow grab lists if enabled."})
    public static boolean replace_list_strength_matches = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"See config file for examples. A list of blocks to be replaced by storms. Use commas and/or spaces to separate each entry. Do not use quotation marks. \"!\" Will remove entries set by other mods. Use = without spaces to indicate the replacement block. Accepted formats - modid:name=modid:replacement, name=replacement, modid:name=replacement, name=modid:replacement"})
    public static String replace_list_entries = "leaves=minecraft:air, leaves2=minecraft:air, minecraft:grass=dirt, minecraft:red_flower=minecraft:air, minecraft:double_plant=minecraft:air, minecraft:tallgrass=minecraft:air";
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should the entity grab list also find similarly named entities?"})
    public static boolean entity_blacklist_partial_matches = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"See config file for examples. A list of entities that cannot be moved by storms. Use commas and/or spaces to separate each entry. Do not use quotation marks. \"!\" Will remove entries set by other mods. Accepted formats - modid:name, name"})
    public static String entity_blacklist_entries = "";
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should the wind resistance list also find similarly named items?"})
    public static boolean wind_resistance_partial_matches = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"See config file for examples. A list of blocks to register wind resistances to. The numbers are measured in MPH. 65=EF0, 92=EF1, 119=EF2, 146=EF3, 173=EF4, 200=EF5, and so on. Use commas and/or spaces to separate each entry. Do not use quotation marks. \"!\" Will remove entries set by other mods. Use \"=\" without spaces to indicate the wind resistance of the block. Accepted formats - modid:name=number, name=number"})
    public static String wind_resistance_entries = "obsidian=512, iron_bar=200";
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Experimental idea, places the WIP repairing block where a tornado\ndoes damage instead of removing the block, causes tornado damage to self repair, recommend setting Storm_Tornado_rarityOfBreakOnFall to 0 to avoid duplicated blocks"})
    public static boolean enable_repair_block_mode = false;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=-1)
    @ConfigAnnotations.Comment(value={"How many flying blocks can all tornados have at a time?"})
    public static int max_flying_blocks = 120;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=-1)
    @ConfigAnnotations.Comment(value={"How many blocks can all tornados replace at a time?"})
    public static int max_replaced_blocks = 1280;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.Comment(value={"Should blocks picked up by storms damage other entities and players?"})
    public static boolean grabbed_blocks_hurt = true;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Comment(value={"Used if Storm_Tornado_grabbedBlocksRepairOverTime is true,\nminimum of 600 ticks (30 seconds) required"})
    public static int Storm_Tornado_TicksToRepairBlock = 6000;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0, max=100)
    @ConfigAnnotations.Comment(value={"Percent of how rarely a block will be removed while spinning around a tornado"})
    public static int Storm_Tornado_rarityOfBreakOnFall = 5;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0, max=100)
    @ConfigAnnotations.Comment(value={"Percent of how rarely a block will be removed while spinning around a tornado"})
    public static int Storm_Tornado_rarityOfDisintegrate = 15;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Comment(value={"How many blocks can be grabbed per tick"})
    public static int max_grabbed_blocks_per_tick = 12;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Comment(value={"How many blocks can be grabbed per tick"})
    public static int max_replaced_blocks_per_tick = 256;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=1)
    @ConfigAnnotations.Comment(value={"How often do storms process grabbed blocks in ticks?"})
    public static int grab_process_delay = 10;

    @Override
    public String getName() {
        return "Weather2 Remastered - Grab";
    }

    @Override
    public String getSaveLocation() {
        return "weather2remaster" + File.separator + "ConfigGrab";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void onConfigChanged(IConfigEX.Phase phase, int variables) {
        if (phase.equals((Object)IConfigEX.Phase.END)) {
            WeatherAPI.refreshGrabRules();
        }
    }

    @Override
    public void onValueChanged(String variable, Object oldValue, Object newValue) {
    }
}

