/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.config;

import java.io.File;
import net.mrbt0907.configex.api.ConfigAnnotations;
import net.mrbt0907.configex.api.IConfigEX;

public class ConfigFront
implements IConfigEX {
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Name(value="Max Fronts")
    @ConfigAnnotations.Comment(value={"How many front objects can develop in a dimension?"})
    public static int max_front_objects = 3;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=0)
    @ConfigAnnotations.Name(value="Max Front Size")
    @ConfigAnnotations.Comment(value={"How large can fronts become? Higher values will spread storms out more."})
    public static int max_front_size = 1500;
    @ConfigAnnotations.Hidden
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.IntegerRange(min=1)
    @ConfigAnnotations.Name(value="Front Tickrate")
    @ConfigAnnotations.Comment(value={"How many ticks it takes for fronts to tick once.\nLower numbers will increase lag."})
    public static int tick_rate = 20;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Name(value="Speed Change Multiplier")
    @ConfigAnnotations.Comment(value={"How fast fronts can change speeds. Higher numbers allow for faster acceleration and decceleration of fronts."})
    public static double speed_change_mult = 1.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Name(value="Angle Change Multiplier")
    @ConfigAnnotations.Comment(value={"How fast fronts can change direction. Higher numbers allow for faster direction changes."})
    public static double angle_change_mult = 1.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0)
    @ConfigAnnotations.Name(value="Environment Change Mult")
    @ConfigAnnotations.Comment(value={"How fast fronts update their internal varaiables like temperature. Higher numbers make fronts change faster."})
    public static double environment_change_mult = 1.0;
    @ConfigAnnotations.Enforce
    @ConfigAnnotations.DoubleRange(min=0.0, max=100.0)
    @ConfigAnnotations.Name(value="Chance To Spawn In Front")
    @ConfigAnnotations.Comment(value={"Percent chance for a storm to spawn in a front"})
    public static double chance_to_spawn_storm_in_front = 20.0;

    @Override
    public String getName() {
        return "Weather2 Remastered - Front";
    }

    @Override
    public String getSaveLocation() {
        return "weather2remaster" + File.separator + "ConfigFront";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void onConfigChanged(IConfigEX.Phase phase, int variables) {
    }

    @Override
    public void onValueChanged(String variable, Object oldValue, Object newValue) {
    }
}

