/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.weather;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityWeatherEffect;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.client.NewSceneEnhancer;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.config.ConfigVolume;
import net.mrbt0907.weather2.entity.EntityLightningBolt;
import net.mrbt0907.weather2.entity.EntityLightningBoltCustom;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.WeatherManager;
import net.mrbt0907.weather2.weather.storm.FrontObject;
import net.mrbt0907.weather2.weather.storm.SandstormObject;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;
import net.mrbt0907.weather2.weather.volcano.VolcanoObject;

@SideOnly(value=Side.CLIENT)
public class WeatherManagerClient
extends WeatherManager {
    public List<Particle> effectedParticles = new ArrayList<Particle>();
    public List<Particle> weatherParticles = new ArrayList<Particle>();
    public static StormObject closestStormCached;
    public int weatherID = 0;
    public int weatherRainTime = 0;
    private int particleLimit = 0;

    public WeatherManagerClient(World world) {
        super(world);
    }

    @Override
    public World getWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public void tick() {
        super.tick();
        for (int i = 0; i < this.weatherParticles.size(); ++i) {
            Particle particle = this.weatherParticles.get(i);
            if (particle.func_187113_k()) continue;
            this.weatherParticles.remove(i);
            --i;
        }
    }

    public void tickRender(float partialTick) {
        if (this.world != null) {
            this.getWeatherObjects().forEach(wo -> wo.tickRender(partialTick));
        }
    }

    public void nbtSyncFromServer(NBTTagCompound mainNBT) {
        int command = mainNBT.func_74762_e("command");
        switch (command) {
            case 0: {
                this.weatherID = mainNBT.func_74762_e("weatherID");
                this.weatherRainTime = mainNBT.func_74762_e("weatherRainTime");
                break;
            }
            case 1: {
                NBTTagCompound nbt = mainNBT.func_74775_l("weatherObject");
                FrontObject front2 = this.getFront(nbt.func_186857_a("frontUUID"));
                UUID uuid2 = nbt.func_186857_a("ID");
                WeatherEnum.Type weatherObjectType = WeatherEnum.Type.get(nbt.func_74762_e("weatherType"));
                WeatherObject wo = null;
                if (weatherObjectType.ordinal() < WeatherEnum.Type.SANDSTORM.ordinal()) {
                    Weather2.debug("Creating a new storm: " + uuid2.toString());
                    wo = new StormObject(front2);
                } else {
                    Weather2.debug("Creating a new sandstorm: " + uuid2.toString());
                    wo = new SandstormObject(this);
                }
                wo.nbt.setNewNBT(nbt);
                wo.nbt.updateCacheFromNew();
                wo.readFromNBT();
                front2.addWeatherObject(wo);
                this.refreshParticleLimit();
                break;
            }
            case 2: {
                WeatherObject wo;
                NBTTagCompound nbt = mainNBT.func_74775_l("weatherObject");
                FrontObject front3 = this.getFront(nbt.func_186857_a("frontUUID"));
                if (front3 == null || (wo = front3.getWeatherObject(nbt.func_186857_a("ID"))) == null) break;
                wo.nbt.setNewNBT(nbt);
                wo.readFromNBT();
                wo.nbt.updateCacheFromNew();
                break;
            }
            case 3: {
                UUID uuidA = mainNBT.func_186857_a("weatherObject");
                UUID uuidB = mainNBT.func_186857_a("frontObject");
                FrontObject front4 = this.getFront(uuidB);
                if (front4 != null) {
                    front4.removeWeatherObject(uuidA);
                } else {
                    this.removeWeatherObject(uuidA);
                }
                this.refreshParticleLimit();
                break;
            }
            case 4: {
                NBTTagCompound nbt = mainNBT.func_74775_l("volcanoObject");
                VolcanoObject vo = new VolcanoObject(this);
                Weather2.debug("Creating a new volcano: " + nbt.func_186857_a("ID"));
                vo.nbtSyncFromServer(nbt);
                this.addVolcanoObject(vo);
                break;
            }
            case 5: {
                NBTTagCompound stormNBT = mainNBT.func_74775_l("volcanoObject");
                UUID uuid3 = stormNBT.func_186857_a("ID");
                if (!this.volcanoUUIDS.contains(uuid3)) break;
                this.getVolcanoObjectByID(uuid3).nbtSyncFromServer(stormNBT);
                break;
            }
            case 6: {
                NBTTagCompound nbt = mainNBT.func_74775_l("manager");
                this.windManager.nbtSyncFromServer(nbt);
                break;
            }
            case 7: {
                int posXS = mainNBT.func_74762_e("posX");
                int posYS = mainNBT.func_74762_e("posY");
                int posZS = mainNBT.func_74762_e("posZ");
                if (mainNBT.func_74764_b("entityID")) {
                    boolean custom = mainNBT.func_74767_n("useCustomLightning");
                    double posX = posXS;
                    double posY = posYS;
                    double posZ = posZS;
                    EntityWeatherEffect ent = null;
                    ent = !custom ? new EntityLightningBolt(this.getWorld(), posX, posY, posZ) : new EntityLightningBoltCustom(this.getWorld(), posX, posY, posZ);
                    ent.field_70118_ct = posXS;
                    ent.field_70117_cu = posYS;
                    ent.field_70116_cv = posZS;
                    ent.field_70177_z = 0.0f;
                    ent.field_70125_A = 0.0f;
                    ent.func_145769_d(mainNBT.func_74762_e("entityID"));
                    this.getWorld().func_72942_c((Entity)ent);
                    break;
                }
                if (!ConfigParticle.enable_sky_lightning) break;
                Minecraft mc = Minecraft.func_71410_x();
                int x = mainNBT.func_74762_e("posX");
                int y = mainNBT.func_74762_e("posY");
                int z = mainNBT.func_74762_e("posZ");
                if (mc.field_71439_g == null || !(Maths.distanceSq(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v, x, y, z) <= (double)ConfigStorm.max_lightning_bolt_distance)) break;
                this.world.func_175702_c(4);
                this.world.func_184134_a((double)x, (double)y, (double)z, SoundEvents.field_187754_de, SoundCategory.WEATHER, 64.0f * (float)ConfigVolume.lightning, Maths.random(0.65f, 0.75f), false);
                break;
            }
            case 11: {
                NBTTagCompound nbt = mainNBT.func_74775_l("frontObject");
                UUID uuid4 = mainNBT.func_186857_a("uuid");
                if (nbt.func_74764_b("posX")) {
                    Weather2.debug("Creating a new front: " + uuid4.toString());
                    FrontObject front5 = this.createFront(nbt.func_74762_e("layer"), nbt.func_74769_h("posX"), nbt.func_74769_h("posZ"));
                    front5.readNBT(nbt);
                    this.fronts.put(uuid4, front5);
                    break;
                }
                Weather2.debug("Creating a new global front: " + uuid4.toString());
                this.globalFront = new FrontObject(this, null, 0);
                this.globalFront.readNBT(nbt);
                this.fronts.put(uuid4, this.globalFront);
                break;
            }
            case 12: {
                NBTTagCompound nbt = mainNBT.func_74775_l("frontObject");
                FrontObject front6 = this.getFront(nbt.func_186857_a("uuid"));
                if (front6 == null) break;
                front6.readNBT(nbt);
                break;
            }
            case 13: {
                UUID uuid5 = mainNBT.func_186857_a("frontUUID");
                FrontObject front7 = this.getFront(uuid5);
                if (front7 != null) {
                    if (this.globalFront.equals(front7)) {
                        this.globalFront.reset();
                        break;
                    }
                    front7.reset();
                    this.removeFront(front7);
                    break;
                }
                Weather2.error("error removing front, cant find by ID: " + uuid5.toString());
                break;
            }
            case 14: {
                this.fronts.forEach((uuid, front) -> front.cleanupClient(false));
                this.weatherParticles.forEach(particle -> particle.func_187112_i());
                this.weatherParticles.clear();
                Weather2.debug("Cleaned up client particles");
                break;
            }
            default: {
                Weather2.error("Server sent an invalid network packet");
            }
        }
    }

    public void addWeatherParticle(Particle particle) {
        this.weatherParticles.add(particle);
    }

    public void addEffectedParticle(Particle particle) {
        this.effectedParticles.add(particle);
    }

    public int getParticleCount() {
        return this.weatherParticles.size();
    }

    public void refreshParticleLimit() {
        int systems = 0;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        for (WeatherObject system2 : this.systems.values()) {
            if (!(system2.pos.distanceSq(player.field_70165_t, system2.pos.posY, player.field_70161_v) < (double)NewSceneEnhancer.instance().renderDistance)) continue;
            ++systems;
        }
        if (systems == 0) {
            systems = 1;
        }
        this.particleLimit = ConfigParticle.max_particles > 0 ? ConfigParticle.max_particles / systems : Integer.MAX_VALUE;
        this.systems.forEach((uuid, system) -> {
            if (system instanceof StormObject && ((StormObject)system).particleRenderer != null) {
                ((StormObject)system).particleRenderer.refreshParticleLimit();
            }
        });
    }

    public int getParticleLimit() {
        return this.particleLimit;
    }

    @Override
    public void reset(boolean fullReset) {
        super.reset(fullReset);
        this.effectedParticles.clear();
        closestStormCached = null;
    }
}

