/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class MovingSoundEX
extends MovingSound {
    public long ticksExisted;
    private Object obj;
    private float maxVolume;
    private float range;
    private boolean useY;

    public MovingSoundEX(SoundEvent event, SoundCategory category, float volume, float pitch) {
        this(null, event, category, volume, pitch, -1.0f, false);
    }

    public MovingSoundEX(Object obj, SoundEvent event, SoundCategory category, float volume, float range) {
        this(obj, event, category, volume, 1.0f, range, true);
    }

    public MovingSoundEX(Object obj, SoundEvent event, SoundCategory category, float volume, float pitch, float range) {
        this(obj, event, category, volume, pitch, range, true);
    }

    public MovingSoundEX(Object obj, SoundEvent event, SoundCategory category, float volume, float pitch, float range, boolean useY) {
        super(event, category);
        this.obj = obj;
        this.field_147662_b = volume = Maths.clamp(volume, 0.0f, 1.0f);
        this.maxVolume = volume;
        this.field_147663_c = pitch;
        this.range = range;
        this.useY = useY;
        this.field_147666_i = ISound.AttenuationType.NONE;
        this.field_147665_h = 0;
        this.func_73660_a();
    }

    public void func_73660_a() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        this.field_147660_d = (float)mc.field_71439_g.field_70165_t;
        this.field_147661_e = (float)mc.field_71439_g.field_70163_u;
        this.field_147658_f = (float)mc.field_71439_g.field_70161_v;
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            this.field_147668_j = true;
            Weather2.error("Unable to play sound " + this.func_147650_b().toString() + " as the world is null");
            return;
        }
        if (this.obj != null) {
            Maths.Vec3 pos;
            if (this.obj instanceof Maths.Vec3) {
                pos = (Maths.Vec3)this.obj;
            } else if (this.obj instanceof WeatherObject) {
                pos = ((WeatherObject)this.obj).pos;
            } else if (this.obj instanceof Entity) {
                Entity entity = (Entity)this.obj;
                pos = new Maths.Vec3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            } else {
                this.field_147668_j = true;
                Weather2.error("Unable to play sound " + this.func_147650_b().toString() + " as the provided object is not supported");
                return;
            }
            if (this.useY) {
                pos.posY = 0.0;
            }
            if (this.range > 0.0f) {
                float multiplier = (float)Maths.clamp(((double)this.range - pos.distanceSq(mc.field_71439_g.field_70165_t, this.useY ? mc.field_71439_g.field_70163_u : pos.posY, mc.field_71439_g.field_70161_v)) / (double)this.range, 0.0, 1.0);
                this.field_147662_b = this.maxVolume * multiplier;
                this.field_147660_d = (float)Maths.clamp(pos.posX, mc.field_71439_g.field_70165_t - 6.0, mc.field_71439_g.field_70165_t + 6.0);
                this.field_147661_e = (float)Maths.clamp(pos.posY, mc.field_71439_g.field_70163_u - 6.0, mc.field_71439_g.field_70163_u + 6.0);
                this.field_147658_f = (float)Maths.clamp(pos.posZ, mc.field_71439_g.field_70161_v - 6.0, mc.field_71439_g.field_70161_v + 6.0);
            }
        }
        ++this.ticksExisted;
    }

    public void setRepeat(boolean shouldRepeat) {
        this.field_147659_g = shouldRepeat;
    }

    public void adjustVolume(float volume) {
        this.maxVolume = Maths.clamp(volume, 0.0f, 1.0f);
    }

    public void adjustPitch(float pitch) {
        this.field_147663_c = Maths.clamp(pitch, 0.0f, 1.0f);
    }

    public void setDone() {
        this.field_147668_j = true;
    }
}

