/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.rendering;

import CoroUtil.config.ConfigCoroUtil;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.ShaderManager;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.render.RotatingParticleManager;
import extendedrenderer.shader.InstancedMeshParticle;
import extendedrenderer.shader.Matrix4fe;
import extendedrenderer.shader.MeshBufferManagerParticle;
import extendedrenderer.shader.ShaderEngine;
import extendedrenderer.shader.ShaderProgram;
import extendedrenderer.shader.Transformation;
import java.nio.FloatBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.util.Maths;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ParticleManagerEX
extends RotatingParticleManager {
    protected static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    protected final TextureManager renderer;
    private final Minecraft mc = Minecraft.func_71410_x();
    public final Comparator<? super Particle> COMPARE_DISTANCE = (pA, pB) -> {
        double b;
        if (pA == null) {
            return 0;
        }
        if (pB == null) {
            return 0;
        }
        double a = Maths.distance(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70161_v, pA.field_187126_f, pA.field_187128_h);
        return a > (b = Maths.distance(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70161_v, pB.field_187126_f, pB.field_187128_h)) ? -1 : (a == b ? 0 : 1);
    };

    public ParticleManagerEX(World worldIn, TextureManager rendererIn) {
        super(worldIn, rendererIn);
        this.renderer = rendererIn;
    }

    private void render(Entity entityIn, float partialTicks, Matrix4fe viewMatrix, Transformation transformation, List<Particle> particles, Map<Particle, InstancedMeshParticle> meshes, boolean useParticleShaders) {
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        if (useParticleShaders) {
            for (Particle particle : particles) {
                InstancedMeshParticle mesh = meshes.get(particle);
                if (mesh == null) continue;
                mesh.initRender();
                mesh.initRenderVBO1();
                mesh.instanceDataBuffer.clear();
                mesh.curBufferPos = 0;
                if (particle instanceof EntityRotFX) {
                    EntityRotFX part = (EntityRotFX)particle;
                    part.renderParticleForShader(mesh, transformation, viewMatrix, entityIn, partialTicks, f, f4, f1, f2, f3);
                }
                mesh.instanceDataBuffer.limit(mesh.curBufferPos * 21);
                OpenGlHelper.func_176072_g((int)34962, (int)mesh.instanceDataVBO);
                ShaderManager.glBufferData((int)34962, (FloatBuffer)mesh.instanceDataBuffer, (int)35048);
                ShaderManager.glDrawElementsInstanced((int)4, (int)mesh.getVertexCount(), (int)5125, (long)0L, (int)mesh.curBufferPos);
                OpenGlHelper.func_176072_g((int)34962, (int)0);
                mesh.endRenderVBO1();
                mesh.endRender();
            }
        } else {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : particles) {
                particle.func_180434_a(vertexbuffer, entityIn, partialTicks, f, f4, f1, f2, f3);
                ++debugParticleRenderCount;
            }
            tessellator.func_78381_a();
        }
    }

    public void renderParticles(Entity entityIn, float partialTicks) {
        if (ConfigParticle.enable_legacy_rendering) {
            super.renderParticles(entityIn, partialTicks);
            return;
        }
        boolean useParticleShaders = useShaders && ConfigCoroUtil.particleShaders;
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        debugParticleRenderCount = 0;
        if (useParticleShaders) {
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.cloud256_test);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.cloud256_fire);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.cloud256);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.downfall3);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.cloud256_6);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.rain_white);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.snow);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.leaf);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.debris_1);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.debris_2);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.debris_3);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing((TextureAtlasSprite)ParticleRegistry.tumbleweed);
        }
        Transformation transformation = null;
        Matrix4fe viewMatrix = null;
        int glCalls = 0;
        int trueRenderCount = 0;
        int particles = 0;
        if (useParticleShaders) {
            ShaderProgram shaderProgram = ShaderEngine.renderer.getShaderProgram("particle");
            transformation = ShaderEngine.renderer.transformation;
            shaderProgram.bind();
            Matrix4fe projectionMatrix = new Matrix4fe();
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2983, (FloatBuffer)buf);
            buf.rewind();
            Matrix4fe.get((Matrix4f)projectionMatrix, (int)0, (FloatBuffer)buf);
            boolean alternateCameraCapture = true;
            if (alternateCameraCapture) {
                viewMatrix = new Matrix4fe();
                FloatBuffer buf2 = BufferUtils.createFloatBuffer((int)16);
                GL11.glGetFloat((int)2982, (FloatBuffer)buf2);
                buf2.rewind();
                Matrix4fe.get((Matrix4f)viewMatrix, (int)0, (FloatBuffer)buf2);
            }
            Matrix4fe modelViewMatrix = projectionMatrix.mul(viewMatrix);
            shaderProgram.setUniformEfficient("modelViewMatrixCamera", modelViewMatrix, viewMatrixBuffer);
            shaderProgram.setUniform("texture_sampler", 0);
            int glFogMode = GL11.glGetInteger((int)2917);
            int modeIndex = glFogMode == 2049 ? 0 : (glFogMode == 2048 ? 1 : 0);
            shaderProgram.setUniform("fogmode", modeIndex);
        }
        ArrayList<Particle> layerA = new ArrayList<Particle>();
        ArrayList<Particle> layerB = new ArrayList<Particle>();
        ArrayList<Particle> layerC = new ArrayList<Particle>();
        ArrayList<Particle> layerD = new ArrayList<Particle>();
        HashMap<Particle, InstancedMeshParticle> layerMesh = new HashMap<Particle, InstancedMeshParticle>();
        for (Map.Entry entry1 : this.fxLayers.entrySet()) {
            if (entry1.getKey() == null) continue;
            InstancedMeshParticle mesh = null;
            if (useParticleShaders && (mesh = MeshBufferManagerParticle.getMesh((TextureAtlasSprite)((TextureAtlasSprite)entry1.getKey()))) == null) {
                MeshBufferManagerParticle.setupMeshForParticle((TextureAtlasSprite)((TextureAtlasSprite)entry1.getKey()));
                mesh = MeshBufferManagerParticle.getMesh((TextureAtlasSprite)((TextureAtlasSprite)entry1.getKey()));
            }
            if (mesh == null && useParticleShaders) continue;
            for (ArrayDeque[][] entry : (List)entry1.getValue()) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        if (entry[i][j].isEmpty()) continue;
                        for (Particle particle : entry[i][j]) {
                            if (i != 1) {
                                if (j == 1) {
                                    layerA.add(particle);
                                } else {
                                    layerC.add(particle);
                                }
                            } else if (j == 1) {
                                layerB.add(particle);
                            } else {
                                layerD.add(particle);
                            }
                            if (mesh == null) continue;
                            layerMesh.put(particle, mesh);
                        }
                    }
                }
            }
        }
        GlStateManager.func_179094_E();
        if (!layerA.isEmpty()) {
            GlStateManager.func_179132_a((boolean)true);
            this.renderer.func_110577_a(PARTICLE_TEXTURES);
            layerA.sort(this.COMPARE_DISTANCE);
            this.render(entityIn, partialTicks, viewMatrix, transformation, layerA, layerMesh, useParticleShaders);
        }
        if (!layerB.isEmpty()) {
            GlStateManager.func_179132_a((boolean)true);
            this.renderer.func_110577_a(TextureMap.field_110575_b);
            layerB.sort(this.COMPARE_DISTANCE);
            this.render(entityIn, partialTicks, viewMatrix, transformation, layerB, layerMesh, useParticleShaders);
        }
        if (!layerC.isEmpty()) {
            GlStateManager.func_179132_a((boolean)false);
            this.renderer.func_110577_a(PARTICLE_TEXTURES);
            layerC.sort(this.COMPARE_DISTANCE);
            this.render(entityIn, partialTicks, viewMatrix, transformation, layerC, layerMesh, useParticleShaders);
        }
        if (!layerD.isEmpty()) {
            GlStateManager.func_179132_a((boolean)false);
            this.renderer.func_110577_a(TextureMap.field_110575_b);
            layerD.sort(this.COMPARE_DISTANCE);
            this.render(entityIn, partialTicks, viewMatrix, transformation, layerD, layerMesh, useParticleShaders);
        }
        GlStateManager.func_179121_F();
        if (useParticleShaders) {
            ShaderEngine.renderer.getShaderProgram("particle").unbind();
        }
        if (ConfigCoroUtil.debugShaders && this.world.func_82737_E() % 60L == 0L) {
            System.out.println("particles: " + particles);
            System.out.println("debugParticleRenderCount: " + debugParticleRenderCount);
            System.out.println("trueRenderCount: " + trueRenderCount);
            System.out.println("glCalls: " + glCalls);
        }
    }
}

