/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.rendering;

import extendedrenderer.particle.entity.EntityRotFX;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.weather.AbstractWeatherRenderer;
import net.mrbt0907.weather2.client.entity.particle.ExtendedEntityRotFX;
import net.mrbt0907.weather2.client.weather.WeatherManagerClient;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.registry.ParticleRegistry;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class LegacyStormRenderer
extends AbstractWeatherRenderer {
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesCloud;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesFunnel = new ArrayList<EntityRotFX>();

    public LegacyStormRenderer(WeatherObject system) {
        super(system);
        this.listParticlesCloud = new ArrayList<EntityRotFX>();
    }

    @Override
    public void onTick(WeatherManagerClient manager) {
        if (!(this.system instanceof StormObject)) {
            return;
        }
        StormObject storm = (StormObject)this.system;
        if (manager.getWorld().func_82737_E() % ((long)ConfigParticle.cloud_particle_delay + 1L) == 0L) {
            for (int i = 0; i < 1; ++i) {
                double x = storm.pos.posX + (double)(Maths.random(storm.size) - Maths.random(storm.size)) * 0.3;
                double z = storm.pos.posZ + (double)(Maths.random(storm.size) - Maths.random(storm.size)) * 0.3;
                ExtendedEntityRotFX particle = this.spawnParticle(x, storm.getLayerHeight(), z, 0, ParticleRegistry.cloud_legacy);
                if (storm.isFirenado) {
                    particle.setColor(0.9f, 0.5f, 0.2f);
                } else {
                    particle.setColor(0.7f, 0.7f, 0.7f);
                }
                particle.field_70544_f = 600.0f;
                particle.func_187114_a(140);
                this.listParticlesCloud.add(particle);
            }
        }
        if (storm.isDeadly()) {
            double var16;
            int itCount = 6;
            if (storm.isSpout) {
                itCount = 4;
            }
            if (manager.getWorld().func_82737_E() % ((long)ConfigParticle.funnel_particle_delay + 1L) == 0L) {
                for (int i = 0; i < itCount; ++i) {
                    double tryX2 = storm.pos_funnel_base.posX + (double)Maths.random(storm.tornadoHelper.getTornadoBaseSize() * 2.0f) - (double)storm.tornadoHelper.getTornadoBaseSize();
                    double tryZ2 = storm.pos_funnel_base.posZ + (double)Maths.random(storm.tornadoHelper.getTornadoBaseSize() * 2.0f) - (double)storm.tornadoHelper.getTornadoBaseSize();
                    Block blockID = Weather2.clientChunkUtil.getBlockState(manager.getWorld(), (int)tryX2, (int)storm.pos_funnel_base.posY - 1, (int)tryZ2).func_177230_c();
                    Block blockIDUp = Weather2.clientChunkUtil.getBlockState(manager.getWorld(), (int)tryX2, (int)storm.pos_funnel_base.posY, (int)tryZ2).func_177230_c();
                    Block blockIDDown = Weather2.clientChunkUtil.getBlockState(manager.getWorld(), (int)tryX2, (int)storm.pos_funnel_base.posY - 2, (int)tryZ2).func_177230_c();
                    int colorID = 0;
                    if (ConfigParticle.enable_tornado_block_colors) {
                        if (storm.isFirenado) {
                            colorID = 7;
                        } else if (storm.isSpout) {
                            colorID = 3;
                        } else if (blockID == Blocks.field_150358_i || blockID == Blocks.field_150355_j || blockIDUp == Blocks.field_150358_i || blockIDUp == Blocks.field_150355_j || blockIDDown == Blocks.field_150358_i || blockIDDown == Blocks.field_150355_j) {
                            colorID = 3;
                        } else if (blockID == Blocks.field_150354_m || blockID == Blocks.field_150322_A) {
                            colorID = 2;
                        } else if (blockID == Blocks.field_150346_d) {
                            colorID = 1;
                        } else if (blockID == Blocks.field_150433_aE) {
                            colorID = 4;
                        } else if (blockID == Blocks.field_150362_t || blockID == Blocks.field_150361_u || blockID == Blocks.field_150349_c) {
                            colorID = 6;
                        }
                    }
                    float r = -1.0f;
                    float g = -1.0f;
                    float b = -1.0f;
                    Color color = null;
                    switch (colorID) {
                        case 1: {
                            color = new Color(7951674);
                            break;
                        }
                        case 2: {
                            color = new Color(14077848);
                            break;
                        }
                        case 3: {
                            color = new Color(10973);
                            break;
                        }
                        case 4: {
                            color = new Color(0xEEFFFF);
                            break;
                        }
                        case 5: {
                            color = new Color(0xFFFFFF);
                            break;
                        }
                        case 6: {
                            color = Color.GREEN;
                            break;
                        }
                        case 7: {
                            color = new Color(0xFF7722);
                        }
                    }
                    if (color == null) {
                        r = 0.7f;
                        g = 0.7f;
                        b = 0.7f;
                    } else {
                        r = (float)color.getRed() / 255.0f;
                        g = (float)color.getGreen() / 255.0f;
                        b = (float)color.getBlue() / 255.0f;
                    }
                    ExtendedEntityRotFX particle = this.spawnParticle(tryX2, storm.pos_funnel_base.posY, tryZ2, 2, ParticleRegistry.cloud_legacy);
                    particle.setColor(r, g, b);
                    particle.field_70544_f = 200.0f;
                    particle.func_187114_a(140);
                    this.listParticlesFunnel.add(particle);
                }
            }
            if (storm.strength != 120.0f) {
                storm.strength = 120.0f;
            }
            if (this.listParticlesFunnel.size() > 0) {
                for (int var9 = 0; var9 < this.listParticlesFunnel.size(); ++var9) {
                    Particle var30 = (Particle)this.listParticlesFunnel.get(var9);
                    if (var30 instanceof EntityRotFX) {
                        var16 = storm.pos_funnel_base.posX - var30.field_187126_f;
                        double var18 = storm.pos_funnel_base.posZ - var30.field_187128_h;
                        ((EntityRotFX)var30).rotationYaw = (float)(Maths.fastATan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
                        ((EntityRotFX)var30).rotationPitch = -30.0f;
                    }
                    if (!var30.func_187113_k()) {
                        var30.func_187112_i();
                        this.listParticlesFunnel.remove(var30);
                        continue;
                    }
                    storm.spinEntity(var30);
                }
            }
            if (this.listParticlesCloud.size() > 0) {
                for (int var9 = 0; var9 < this.listParticlesCloud.size(); ++var9) {
                    Particle var30 = (Particle)this.listParticlesCloud.get(var9);
                    if (var30 instanceof EntityRotFX) {
                        var16 = storm.pos_funnel_base.posX - var30.field_187126_f;
                        double var18 = storm.pos_funnel_base.posZ - var30.field_187128_h;
                        ((EntityRotFX)var30).rotationYaw = (float)(Maths.fastATan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
                        ((EntityRotFX)var30).rotationPitch = 90.0f;
                    }
                    if (!var30.func_187113_k()) {
                        var30.func_187112_i();
                        this.listParticlesCloud.remove(var30);
                        continue;
                    }
                    storm.spinEntity(var30);
                }
            }
        }
    }

    @Override
    public void cleanupRenderer() {
        this.listParticlesFunnel.clear();
        this.listParticlesCloud.clear();
    }

    @Override
    public void onParticleLimitRefresh(WeatherManagerClient manager, int newParticleLimit) {
    }

    @Override
    public List<String> onDebugInfo() {
        ArrayList<String> debugInfo = new ArrayList<String>();
        debugInfo.add("Legacy Renderer - Version 1.0");
        return debugInfo;
    }
}

